/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.parse;

import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.enums.WsdlDataTypeEnum;
import com.jxdinfo.hussar.eai.webservice.common.util.DOMUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WAWsdlUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WADOMUtil {
    private static Logger log = LoggerFactory.getLogger(WADOMUtil.class);

    public static void getInputParams(List<WsdlParams> inputParamList, Document document, String typeName, String xPath, WsdlParams parentParam, List<String> types, boolean isSelfDefinition, String appCode, Boolean hasSaved) throws Exception {
        boolean canAddParam = true;
        WsdlParams param = new WsdlParams();
        param.setName(typeName);
        String elementXPath = WADOMUtil.getElementXPath(xPath, typeName);
        Node elementNode = WADOMUtil.findNode(document, elementXPath);
        if (elementNode != null && isSelfDefinition) {
            if (DOMUtil.assertNodeAttributeExist((Node)elementNode, (String)"type")) {
                String type = DOMUtil.getNodeType((Node)elementNode);
                param.setRequired(DOMUtil.isRequired((Node)elementNode));
                param.setMaxOccurs(DOMUtil.getNodeMaxOccurs((Node)elementNode));
                param.setMinOccurs(DOMUtil.getNodeMinOccurs((Node)elementNode));
                param.setForm(DOMUtil.getNodeForm((Node)elementNode));
                if (DOMUtil.isArray((Node)elementNode)) {
                    param.setType(WsdlDataTypeEnum.WSDL_LIST.getType());
                    param.setChildType(type);
                    if (!DOMUtil.isDefaultType((Node)elementNode)) {
                        if (WADOMUtil.contentTypes(types, type).booleanValue()) {
                            if (canAddParam) {
                                if (parentParam == null) {
                                    inputParamList.add(param);
                                } else {
                                    parentParam.addChild(param);
                                }
                            }
                            return;
                        }
                        WADOMUtil.getInputParams(inputParamList, document, type, xPath, param, types, false, appCode, hasSaved);
                    } else {
                        param.setValue("");
                    }
                } else {
                    param.setType(type);
                    if (!DOMUtil.isDefaultType((Node)elementNode)) {
                        if (WADOMUtil.contentTypes(types, type).booleanValue()) {
                            if (canAddParam) {
                                if (parentParam == null) {
                                    inputParamList.add(param);
                                } else {
                                    parentParam.addChild(param);
                                }
                            }
                            return;
                        }
                        WADOMUtil.getInputParams(inputParamList, document, type, "//*[local-name()='schema']", param, types, false, appCode, hasSaved);
                    } else {
                        param.setValue("");
                    }
                }
            } else {
                Node simpleTypeNode;
                if (DOMUtil.isArray((Node)elementNode)) {
                    param.setType(WsdlDataTypeEnum.WSDL_LIST.getType());
                }
                if ((simpleTypeNode = WADOMUtil.getSimpleTypeNode(document, typeName, elementXPath, true)) != null) {
                    String type = DOMUtil.getNodeBase((Node)simpleTypeNode);
                    if (DOMUtil.isArray((Node)elementNode)) {
                        param.setChildType(type);
                    } else {
                        param.setType(type);
                    }
                    param.setRequired(DOMUtil.isRequired((Node)simpleTypeNode));
                    param.setMaxOccurs(DOMUtil.getNodeMaxOccurs((Node)simpleTypeNode));
                    param.setMinOccurs(DOMUtil.getNodeMinOccurs((Node)simpleTypeNode));
                    param.setValue("");
                } else {
                    List<Node> nodeList = WADOMUtil.getComplexTypeSequenceElement(document, typeName, elementXPath, true);
                    if (nodeList.size() != 0) {
                        for (Node tempNode : nodeList) {
                            String elementName = DOMUtil.getNodeName((Node)tempNode);
                            String sequenceXPath = WADOMUtil.getSequenceXPathByName(document, typeName, elementXPath, true, elementName);
                            WADOMUtil.getInputParams(inputParamList, document, elementName, sequenceXPath, param, types, true, appCode, hasSaved);
                        }
                    } else {
                        log.warn("unknown type " + typeName + ",please check your document");
                    }
                }
            }
        } else {
            canAddParam = false;
            Node simpleTypeNode = WADOMUtil.getSimpleTypeNode(document, typeName, xPath, false);
            if (simpleTypeNode != null) {
                String type = DOMUtil.getNodeBase((Node)simpleTypeNode);
                parentParam.setType(type);
                parentParam.setRequired(DOMUtil.isRequired((Node)simpleTypeNode));
                parentParam.setValue("");
            } else {
                List<Node> nodeList = WADOMUtil.getComplexTypeSequenceElement(document, typeName, elementXPath, false);
                if (nodeList.size() != 0) {
                    for (Node tempNode : nodeList) {
                        String elementName = DOMUtil.getNodeName((Node)tempNode);
                        String sequenceXPath = WADOMUtil.getSequenceXPathByName(document, typeName, elementXPath, false, elementName);
                        WADOMUtil.getInputParams(inputParamList, document, elementName, sequenceXPath, parentParam, types, true, appCode, hasSaved);
                    }
                } else {
                    log.warn("unknown type " + typeName + ",please check your document");
                }
            }
        }
        if (canAddParam) {
            if (parentParam == null) {
                inputParamList.add(param);
            } else {
                parentParam.addChild(param);
            }
        }
    }

    private static String getElementXPath(String xPath, String typeName) {
        String elementXPath = xPath + "/*[local-name()='element' and @name='" + typeName + "']";
        return elementXPath;
    }

    private static Boolean contentTypes(List<String> types, String type) {
        if (HussarUtils.isNotEmpty((Object)type)) {
            if (types.contains(type)) {
                return true;
            }
            types.add(type);
        }
        return false;
    }

    private static Node getSimpleTypeNode(Document document, String simpleTypeName, String elementXPath, boolean isSelfDefinition) throws Exception {
        String simpleTypeXPath = isSelfDefinition ? elementXPath + "/*[local-name()='simpleType']/*[local-name()='restriction']" : "//*[local-name()='schema']/*[local-name()='simpleType' and @name='" + simpleTypeName + "']/*[local-name()='restriction']";
        Node node = WADOMUtil.findNode(document, simpleTypeXPath);
        return node;
    }

    private static List<Node> getComplexTypeSequenceElement(Document document, String complexTypeName, String elementXPath, boolean isSelfDefinition) throws Exception {
        ArrayList<Node> nodeList = new ArrayList();
        String extensionXpath = isSelfDefinition ? elementXPath + "/*[local-name()='complexType']/*[local-name()='complexContent']/*[local-name()='extension']" : "//*[local-name()='schema']/*[local-name()='complexType' and @name='" + complexTypeName + "']/*[local-name()='complexContent']/*[local-name()='extension']";
        Node extension = WADOMUtil.findNode(document, extensionXpath);
        if (extension != null) {
            String selfXpath;
            NodeList selfList;
            String parentTypeName = DOMUtil.getAttributeValue((Node)extension, (String)"base").split(":")[1];
            List<Node> parentElements = WADOMUtil.getComplexTypeSequenceElement(document, parentTypeName, elementXPath, false);
            if (parentElements != null && parentElements.size() > 0) {
                nodeList.addAll(parentElements);
            }
            if ((selfList = WADOMUtil.findNodeList(document, selfXpath = extensionXpath + "/*[local-name()='sequence']/*[local-name()='element']")) != null && selfList.getLength() > 0) {
                nodeList.addAll(DOMUtil.covertNodeListToList((NodeList)selfList));
            }
        } else {
            String elementsOfSequenceXpath = isSelfDefinition ? elementXPath + "/*[local-name()='complexType']/*[local-name()='sequence']/*[local-name()='element']" : "//*[local-name()='schema']/*[local-name()='complexType' and @name='" + complexTypeName + "']/*[local-name()='sequence']/*[local-name()='element']";
            NodeList elementsOfSequence = WADOMUtil.findNodeList(document, elementsOfSequenceXpath);
            nodeList = DOMUtil.covertNodeListToList((NodeList)elementsOfSequence);
        }
        return nodeList;
    }

    private static String getSequenceXPathByName(Document document, String complexTypeName, String elementXPath, boolean isSelfDefinition, String elementName) throws Exception {
        String result = "";
        String extensionXpath = isSelfDefinition ? elementXPath + "/*[local-name()='complexType']/*[local-name()='complexContent']/*[local-name()='extension']" : "//*[local-name()='schema']/*[local-name()='complexType' and @name='" + complexTypeName + "']/*[local-name()='complexContent']/*[local-name()='extension']";
        Node extension = WADOMUtil.findNode(document, extensionXpath);
        if (extension != null) {
            String parentTypeName = DOMUtil.getAttributeValue((Node)extension, (String)"base").split(":")[1];
            result = WADOMUtil.getSequenceXPathByName(document, parentTypeName, elementXPath, false, elementName);
            String sequenceXPath = extensionXpath + "/*[local-name()='sequence']";
            String eleXPath = sequenceXPath + "/*[local-name()='element' and @name='" + elementName + "']";
            Node selfNode = WADOMUtil.findNode(document, eleXPath);
            if (selfNode != null) {
                result = sequenceXPath;
            }
        } else {
            String sequenceXPath = isSelfDefinition ? elementXPath + "/*[local-name()='complexType']/*[local-name()='sequence']" : "//*[local-name()='schema']/*[local-name()='complexType' and @name='" + complexTypeName + "']/*[local-name()='sequence']";
            String eleXpath = sequenceXPath + "/*[local-name()='element' and @name='" + elementName + "']";
            Node selfNode = WADOMUtil.findNode(document, eleXpath);
            if (selfNode != null) {
                result = sequenceXPath;
            }
        }
        return result;
    }

    public static Node findNode(Document document, String xpathStr) throws Exception {
        XPath xpath = WAWsdlUtil.getXPath();
        Node node = (Node)xpath.evaluate(xpathStr, document, XPathConstants.NODE);
        if (node == null) {
            List<Document> importDocumentList = WAWsdlUtil.getImportDocumentList(document, xpath);
            for (Document importDoucment : importDocumentList) {
                node = WADOMUtil.findNode(importDoucment, xpathStr);
                if (node == null) continue;
                return node;
            }
        }
        return node;
    }

    public static NodeList findNodeList(Document document, String xpathStr) throws Exception {
        XPath xpath = WAWsdlUtil.getXPath();
        NodeList nodeList = (NodeList)xpath.evaluate(xpathStr, document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            List<Document> importDocumentList = WAWsdlUtil.getImportDocumentList(document, xpath);
            for (Document importDoucment : importDocumentList) {
                nodeList = WADOMUtil.findNodeList(importDoucment, xpathStr);
                if (nodeList.getLength() <= 0) continue;
                return nodeList;
            }
        }
        return nodeList;
    }
}

