/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.service.IWsdlConnService;
import com.jxdinfo.hussar.eai.webservice.common.service.IWsdlSaveService;
import com.jxdinfo.hussar.eai.webservice.common.vo.LocalWSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.common.vo.WSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IWsdlApiInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.wsdlApiInfoServiceImpl")
public class WsdlApiInfoServiceImpl
implements IWsdlApiInfoService {
    @Resource
    IWsdlConnService wsdlConnService;
    @Resource
    IWsdlSaveService iWsdlSaveService;
    @Resource
    IWsdlInfoService wsdlInfoService;

    public List<LocalWSDLServiceVo> getWsdlInfoByAppCode(String applicatonCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdl::getApplicationCode, (Object)applicatonCode);
        List eaiAppWsdls = this.wsdlInfoService.list((Wrapper)queryWrapper);
        ArrayList<LocalWSDLServiceVo> list = new ArrayList<LocalWSDLServiceVo>();
        if (HussarUtils.isNotEmpty((Object)eaiAppWsdls)) {
            for (EaiAppWsdl eaiAppWsdl : eaiAppWsdls) {
                LocalWSDLServiceVo localWSDLServiceVo = new LocalWSDLServiceVo();
                WSDLinfo wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)eaiAppWsdl.getWsdlContent(), WSDLinfo.class);
                List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
                List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
                localWSDLServiceVo.setWsdlServiceVos(wsdlServiceVos);
                localWSDLServiceVo.setWsdlId(eaiAppWsdl.getId());
                localWSDLServiceVo.setApplicationCode(applicatonCode);
                localWSDLServiceVo.setWsdlPath(eaiAppWsdl.getWsdlPath());
                list.add(localWSDLServiceVo);
            }
        }
        return list;
    }

    public List<WSDLServiceVo> getWsdlInfo(String wsdlPath) {
        WSDLinfo wsdLinfoDto = this.wsdlConnService.conn(null, wsdlPath);
        List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
        List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
        return wsdlServiceVos;
    }

    public List<WSDLServiceVo> getWsdlInfo(String appCode, String wsdlPath) {
        WSDLinfo wsdLinfoDto = this.wsdlConnService.conn(appCode, wsdlPath);
        List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
        List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
        return wsdlServiceVos;
    }

    public LocalWSDLServiceVo getAndSaveWsdlInfo(String appCode, String wsdlPath) {
        LocalWSDLServiceVo wsdLinfoDto = this.wsdlConnService.connAndSave(appCode, wsdlPath);
        List wsdlServiceDtos = wsdLinfoDto.getWsdLinfoDto().getWsdlServiceDtos();
        List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
        wsdLinfoDto.setWsdlServiceVos(wsdlServiceVos);
        wsdLinfoDto.setWsdLinfoDto(null);
        return wsdLinfoDto;
    }

    public LocalWSDLServiceVo getLocalWsdlInfo(String appCode, String wsdlPath) {
        EaiAppWsdl eaiAppWsdl = this.iWsdlSaveService.getWsdlContent(appCode, wsdlPath);
        WSDLinfo wsdLinfoDto = null;
        Long id = null;
        if (HussarUtils.isEmpty((Object)eaiAppWsdl)) {
            LocalWSDLServiceVo localWSDLServiceVo = this.wsdlConnService.connAndSave(appCode, wsdlPath);
            wsdLinfoDto = localWSDLServiceVo.getWsdLinfoDto();
            id = localWSDLServiceVo.getWsdlId();
        } else {
            wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)eaiAppWsdl.getWsdlContent(), WSDLinfo.class);
            id = eaiAppWsdl.getId();
        }
        List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
        List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
        LocalWSDLServiceVo localWSDLServiceVo = new LocalWSDLServiceVo();
        localWSDLServiceVo.setWsdlServiceVos(wsdlServiceVos);
        localWSDLServiceVo.setWsdlId(id);
        return localWSDLServiceVo;
    }

    public Boolean checkWsdlPath(String appCode, String wsdlPath) {
        WSDLinfo wsdLinfoDto;
        EaiAppWsdl eaiAppWsdl = this.iWsdlSaveService.getWsdlContent(appCode, wsdlPath);
        if (HussarUtils.isNotEmpty((Object)eaiAppWsdl) && HussarUtils.isNotEmpty((Object)(wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)eaiAppWsdl.getWsdlContent(), WSDLinfo.class)))) {
            return true;
        }
        return false;
    }
}

