/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.CheckApiCodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.EditApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoEditVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureItemsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.ApiCanvasInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CommonStructureDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.GenerateCanvasCommonInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.IEaiGenerateCanvasTemplateService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiDataCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsTestConvertDto;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.eai.webservice.info.api.dto.WebserviceApiInfoDto;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IReleaseWebserviceApiService;
import com.jxdinfo.hussar.eai.webservice.info.api.vo.WebserviceApiInfoVo;
import com.jxdinfo.hussar.eai.webservice.info.server.dto.WebServiceGenerateCanvasInfoDto;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.releaseWebserviceApiServiceImpl")
public class ReleaseWebserviceApiServiceImpl
implements IReleaseWebserviceApiService {
    private static final String ERROR = "\u4fdd\u5b58\u5931\u8d25";
    private static final String STRUCTURENAME_PREFIX = "copy_";
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    @Resource
    private IReleaseApiService releaseApiService;
    @Resource
    private EaiApiProperties eaiApiProperties;
    @Resource
    private IEaiCanvaParamsConvertService canvaParamsConvertService;
    @Resource
    private IEaiApiInfoService apiInfoService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private EaiCanvasInfoService eaiCanvasInfoService;
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Resource
    private EaiCommonStructureService eaiCommonStructureService;
    @Resource
    protected IEaiGenerateCanvasTemplateService generateCanvasTemplateService;
    @Resource
    private EaiConvertService eaiConvertService;
    @Resource
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;

    @HussarTransactional
    public Boolean saveApiInfo(WebserviceApiInfoDto addApiInfoDto) {
        boolean edit;
        boolean api;
        addApiInfoDto.setId(String.valueOf(EngineUtil.getId()));
        AddApiInfoDto apiInfoDto = new AddApiInfoDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)apiInfoDto);
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)addApiInfoDto.getId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)checkApiCodeDto);
        if (!this.releaseApiService.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        if (!this.releaseApiService.checkUniqueClassifyName(addApiInfoDto.getApplicationCode(), addApiInfoDto.getClassifyName(), addApiInfoDto.getClassificId()).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        ApiInfo apiInfo = new ApiInfo();
        if (null != addApiInfoDto.getInParams() && null != addApiInfoDto.getInParams().getBody()) {
            this.createNewStruct(addApiInfoDto, addApiInfoDto.getInParams().getBody());
        }
        if (null != addApiInfoDto.getOutParams() && null != addApiInfoDto.getOutParams().getBody()) {
            this.createNewStruct(addApiInfoDto, addApiInfoDto.getOutParams().getBody());
        }
        if (!(api = this.fillApiInfo(addApiInfoDto, apiInfo))) {
            throw new BaseException(ERROR);
        }
        this.saveCallInfo(addApiInfoDto, apiInfo);
        EditApi editApi = this.fillEditApiAndWs(addApiInfoDto);
        if (1 == this.eaiApiProperties.getLogicType()) {
            if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
                editApi.setCanvasId(EngineUtil.getId());
            }
            ArrayList paramsConvertList = Lists.newArrayListWithCapacity((int)5);
            if (null != addApiInfoDto.getInParams()) {
                if (CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getInParams().getHeader())) {
                    paramsConvertList.addAll(addApiInfoDto.getInParams().getHeader());
                }
                if (CollectionUtil.isNotEmpty((Collection)addApiInfoDto.getInParams().getQuery())) {
                    paramsConvertList.addAll(addApiInfoDto.getInParams().getQuery());
                }
                if (null != addApiInfoDto.getInParams().getBody()) {
                    paramsConvertList.add(addApiInfoDto.getInParams().getBody());
                }
            }
            if (CollectionUtil.isNotEmpty((Collection)paramsConvertList)) {
                for (EaiParamsItems param : paramsConvertList) {
                    param.setMapping(Integer.valueOf(1));
                }
                String inParams = this.canvaParamsConvertService.convertInParamsStr(addApiInfoDto.getApplicationCode(), addApiInfoDto.getApiCode(), (List)paramsConvertList);
                ApiInfo updateApiInfo = new ApiInfo();
                updateApiInfo.setId(Long.valueOf(addApiInfoDto.getId()));
                updateApiInfo.setInParams(inParams);
                this.apiInfoService.updateById((Object)updateApiInfo);
                EditApi editApiquery = new EditApi();
                editApiquery.setContentType(EaiContentType.APPLICATION_JSON.getTypeStr());
                editApiquery.setId(editApi.getId());
                editApiquery.setInParams(this.canvaParamsConvertService.convertEditOutBodyParamsStr(inParams));
                this.iEaiEditApiService.updateById((Object)editApiquery);
            }
            this.convertCanvasHandle(editApi, addApiInfoDto);
        }
        if (!(edit = this.iEaiEditApiService.save((Object)editApi))) {
            throw new BaseException(ERROR);
        }
        return true;
    }

    private void convertCanvasHandle(EditApi editApi, WebserviceApiInfoDto addApiInfoDto) {
        WebServiceGenerateCanvasInfoDto generateCanvasInfo = new WebServiceGenerateCanvasInfoDto();
        BeanUtil.copy((Object)addApiInfoDto, (Object)((Object)generateCanvasInfo));
        ApiCanvasInfo apiCanvasInfo = this.generateCanvasTemplateService.convertCanvasInfo((GenerateCanvasCommonInfoDto)generateCanvasInfo, "1");
        this.saveCanvas(editApi, addApiInfoDto, apiCanvasInfo);
    }

    private void createNewStruct(WebserviceApiInfoDto addApiInfoDto, EaiParamsItems paramsItems) {
        if (this.checkCreateStruct(paramsItems).booleanValue()) {
            HashMap oldNewStructureMap = Maps.newHashMapWithExpectedSize((int)5);
            HashMap newStructIdAndCodeMap = Maps.newHashMapWithExpectedSize((int)5);
            ArrayList newAddCommonStructureList = Lists.newArrayListWithCapacity((int)5);
            ArrayList newCommonStructureList = Lists.newArrayListWithCapacity((int)5);
            CommonStructureDto structureDto = new CommonStructureDto();
            Long quoteStructureId = IdWorker.getId((Object)new CommonStructureDto());
            String parmasName = this.getnewStructureNameById(STRUCTURENAME_PREFIX + paramsItems.getMappingName(), paramsItems);
            this.copyNewCommonStructure(addApiInfoDto, oldNewStructureMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDto, quoteStructureId, parmasName, paramsItems);
            if (CollectionUtil.isNotEmpty((Collection)newAddCommonStructureList)) {
                newAddCommonStructureList.forEach(c -> {
                    CommonStructure commonStructure = new CommonStructure();
                    BeanUtil.copy((Object)c, (Object)commonStructure);
                    commonStructure.setStructureValues(JSON.toJSONString((Object)c.getStructureList()));
                    newCommonStructureList.add(commonStructure);
                });
                this.eaiCommonStructureService.saveOrUpdateBatch((List)newCommonStructureList);
            }
            this.converEaiParamsItemsByNewStruct(paramsItems, oldNewStructureMap, newStructIdAndCodeMap);
        }
    }

    private void converEaiParamsItemsByNewStruct(EaiParamsItems paramsItems, Map<String, String> oldNewStructureMap, Map<String, String> newStructIdAndCodeMap) {
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            paramsItems.setQuoteStructureId(oldNewStructureMap.get(paramsItems.getQuoteStructureId()));
            paramsItems.setValue(newStructIdAndCodeMap.get(paramsItems.getQuoteStructureId()));
            List items = paramsItems.getItems();
            if (CollectionUtil.isNotEmpty((Collection)items)) {
                for (EaiParamsItems itemsT : items) {
                    this.converEaiParamsItemsByNewStruct(itemsT, oldNewStructureMap, newStructIdAndCodeMap);
                }
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue() && null == EaiDataType.getBaseModelType((Integer)paramsItems.getItemType())) {
            this.converEaiParamsItemsByNewStruct((EaiParamsItems)paramsItems.getItems().get(0), oldNewStructureMap, newStructIdAndCodeMap);
        }
    }

    public void copyNewCommonStructure(WebserviceApiInfoDto addApiInfoDto, Map<String, String> oldNewStructMap, Map<String, String> newStructIdAndCodeMap, List<CommonStructureDto> newAddCommonStructureList, CommonStructureDto structureDtoT, Long quoteStructureId, String paramsName, EaiParamsItems paramsItems) {
        structureDtoT.setId(quoteStructureId);
        structureDtoT.setParamsType(paramsItems.getType().toString());
        structureDtoT.setApplicationCode(addApiInfoDto.getApplicationCode());
        structureDtoT.setRemark(paramsItems.getRemark());
        structureDtoT.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
        ArrayList structureValues = Lists.newArrayListWithCapacity((int)5);
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            paramsName = this.getnewStructureNamefromList(paramsName, paramsItems);
            structureDtoT.setStructureName(paramsName + Long.toString(structureDtoT.getId()).substring(Long.toString(structureDtoT.getId()).length() - 4));
            structureDtoT.setStructureCode(structureDtoT.getStructureName());
            if (!CollectionUtil.isEmpty((Collection)paramsItems.getItems())) {
                this.getParamsItems(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDtoT, structureValues, paramsItems.getItems());
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue()) {
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue()) {
                this.getParamsItems(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDtoT, structureValues, paramsItems.getItems());
            } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getItemType().intValue()) {
                this.copyNewCommonStructure(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDtoT, quoteStructureId, paramsName, (EaiParamsItems)paramsItems.getItems().get(0));
            }
        }
        structureDtoT.setStructureList((List)structureValues);
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == Integer.parseInt(structureDtoT.getParamsType()) && CollectionUtil.isNotEmpty((Collection)paramsItems.getItems())) {
            oldNewStructMap.put(String.valueOf(paramsItems.getQuoteStructureId()), String.valueOf(quoteStructureId));
            newStructIdAndCodeMap.put(String.valueOf(quoteStructureId), structureDtoT.getStructureCode());
            newAddCommonStructureList.add(structureDtoT);
        }
    }

    private String getnewStructureNamefromList(String paramsName, EaiParamsItems paramsItems) {
        if ("items".equals(paramsItems.getName()) && StringUtil.isNotEmpty((Object)paramsItems.getQuoteStructureId())) {
            CommonStructureVo commonStructure = this.eaiCommonStructureService.getById(paramsItems.getQuoteStructureId());
            paramsName = STRUCTURENAME_PREFIX + commonStructure.getStructureCode();
        }
        return paramsName;
    }

    private void getParamsItems(WebserviceApiInfoDto addApiInfoDto, Map<String, String> oldNewStructMap, Map<String, String> newStructIdAndCodeMap, List<CommonStructureDto> newAddCommonStructureList, CommonStructureDto structureDtoT, List<StructureItems> structureValues, List<EaiParamsItems> items) {
        if (CollectionUtil.isNotEmpty(items)) {
            items.forEach(item -> {
                StructureItems structure = new StructureItems();
                structure.setName(item.getMappingName());
                structure.setNickName(item.getMappingName());
                structure.setType(item.getType());
                structure.setItemType(item.getItemType());
                structure.setMark(item.getMark());
                structure.setQuoteStructureId("");
                structure.setItems((List)Lists.newArrayListWithCapacity((int)0));
                Long quoteStructureIdT = IdWorker.getId((Object)new CommonStructureDto());
                CommonStructureDto structureDto = new CommonStructureDto();
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == item.getType().intValue()) {
                    if (CollectionUtil.isEmpty((Collection)item.getItems())) {
                        structure.setQuoteStructureId(String.valueOf(structureDtoT.getId()));
                    } else {
                        structure.setQuoteStructureId(String.valueOf(quoteStructureIdT));
                        this.copyNewCommonStructure(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDto, quoteStructureIdT, structure.getName(), (EaiParamsItems)item);
                    }
                } else if (EaiDataType.DATA_TYPE_LIST.getType() == item.getType().intValue()) {
                    StructureItems itemsT = new StructureItems();
                    itemsT.setName(item.getMappingName());
                    itemsT.setNickName(item.getMappingName());
                    itemsT.setMark("");
                    itemsT.setItems((List)Lists.newArrayListWithCapacity((int)0));
                    if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == item.getItemType().intValue()) {
                        structureDto.setStructureName(structure.getName());
                        itemsT.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        if (CollectionUtil.isEmpty((Collection)((EaiParamsItems)item.getItems().get(0)).getItems())) {
                            itemsT.setQuoteStructureId(String.valueOf(structureDtoT.getId()));
                        } else {
                            itemsT.setQuoteStructureId(String.valueOf(quoteStructureIdT));
                            this.copyNewCommonStructure(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDto, quoteStructureIdT, structure.getName(), (EaiParamsItems)item.getItems().get(0));
                        }
                        structure.setItems(Arrays.asList(itemsT));
                    } else if (EaiDataType.DATA_TYPE_LIST.getType() == item.getItemType().intValue()) {
                        ArrayList structureValuesT = Lists.newArrayListWithCapacity((int)5);
                        this.getParamsItems(addApiInfoDto, oldNewStructMap, newStructIdAndCodeMap, newAddCommonStructureList, structureDtoT, structureValuesT, item.getItems());
                        structure.setItems((List)structureValuesT);
                    } else {
                        itemsT.setType(item.getItemType());
                        structure.setItems(Arrays.asList(itemsT));
                    }
                }
                if (StringUtil.isNotEmpty((Object)structure.getType())) {
                    structureValues.add(structure);
                }
            });
        }
    }

    private String getnewStructureNameById(String paramsName, EaiParamsItems paramsItems) {
        if (StringUtil.isNotEmpty((Object)paramsItems.getQuoteStructureId())) {
            CommonStructureVo commonStructure = this.eaiCommonStructureService.getById(paramsItems.getQuoteStructureId());
            paramsName = STRUCTURENAME_PREFIX + commonStructure.getStructureCode();
        }
        return paramsName;
    }

    private Boolean checkCreateStruct(EaiParamsItems paramsItems) {
        Boolean checkCreateFlag;
        if (HussarUtils.isEmpty((Object)paramsItems)) {
            return false;
        }
        if (HussarUtils.isEmpty((Object)paramsItems.getType())) {
            return false;
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            CommonStructureVo structOld = this.eaiCommonStructureService.getByCommonStructureId(paramsItems.getQuoteStructureId());
            if (!structOld.getParamsType().equals(String.valueOf(paramsItems.getType()))) {
                return true;
            }
            List structureValues = structOld.getStructureValues();
            Map<Object, Object> codeAndStructureItems = Maps.newHashMapWithExpectedSize((int)5);
            List items = paramsItems.getItems();
            Set<Object> oldName = Sets.newHashSetWithExpectedSize((int)5);
            Set<Object> nowName = Sets.newHashSetWithExpectedSize((int)5);
            if (CollectionUtil.isEmpty((Collection)structureValues) && CollectionUtil.isNotEmpty((Collection)items)) {
                return true;
            }
            if (CollectionUtil.isEmpty((Collection)items) && CollectionUtil.isNotEmpty((Collection)structureValues)) {
                return true;
            }
            if (CollectionUtil.isNotEmpty((Collection)items) && CollectionUtil.isNotEmpty((Collection)structureValues)) {
                oldName = structureValues.stream().map(StructureItemsVo::getName).collect(Collectors.toSet());
                nowName = items.stream().map(EaiParamsItems::getMappingName).collect(Collectors.toSet());
                Sets.SetView difference1 = Sets.difference((Set)oldName, (Set)nowName);
                Sets.SetView difference2 = Sets.difference((Set)nowName, (Set)oldName);
                if (CollectionUtil.isNotEmpty((Collection)difference1) || CollectionUtil.isNotEmpty((Collection)difference2)) {
                    return true;
                }
            }
            codeAndStructureItems = structureValues.stream().collect(Collectors.toMap(StructureItemsVo::getName, Function.identity()));
            if (CollectionUtil.isNotEmpty((Collection)items)) {
                for (EaiParamsItems itemsT : items) {
                    Boolean checkCreateFlag2;
                    if (StringUtil.isNotEmpty((Object)codeAndStructureItems.get(itemsT.getName())) && !itemsT.getType().equals(((StructureItemsVo)codeAndStructureItems.get(itemsT.getName())).getType())) {
                        return true;
                    }
                    if (!(EaiDataType.DATA_TYPE_STRUCTURE.getType() == itemsT.getType().intValue() ? (checkCreateFlag2 = this.checkCreateStruct(itemsT)) != false : (EaiDataType.DATA_TYPE_LIST.getType() == itemsT.getType().intValue() && null == EaiDataType.getBaseModelType((Integer)itemsT.getItemType()) ? (checkCreateFlag2 = this.checkCreateStruct((EaiParamsItems)itemsT.getItems().get(0))) != false : !oldName.contains(itemsT.getMappingName())))) continue;
                    return true;
                }
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue() && null == EaiDataType.getBaseModelType((Integer)paramsItems.getItemType()) && (checkCreateFlag = this.checkCreateStruct((EaiParamsItems)paramsItems.getItems().get(0))).booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean deleteById(String id) {
        this.releaseApiService.deleteById(id);
        LambdaQueryWrapper wsdlWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)id);
        this.eaiEditApiWsdlService.remove((Wrapper)wsdlWrapper);
        return true;
    }

    public Boolean updateById(WebserviceApiInfoDto updateApiInfoDto) {
        EditApiInfoDto apiInfoDto = new EditApiInfoDto();
        BeanUtil.copyProperties((Object)updateApiInfoDto, (Object)apiInfoDto);
        apiInfoDto.setInParams(ReleaseWebserviceApiServiceImpl.getParams(updateApiInfoDto.getInParams()));
        apiInfoDto.setInParams(ReleaseWebserviceApiServiceImpl.getParams(updateApiInfoDto.getOutParams()));
        this.releaseApiService.updateById(apiInfoDto);
        return this.eaiEditApiWsdlService.updateById((Object)updateApiInfoDto.getEaiEditApiWsdl());
    }

    private static EaiParamsTestConvertDto getParams(EaiParamsConvertDto eaiParamsConvertDto) {
        if (eaiParamsConvertDto == null) {
            return null;
        }
        EaiParamsTestConvertDto eaiParamsTestConvertDto = new EaiParamsTestConvertDto();
        eaiParamsTestConvertDto.setHeader(eaiParamsConvertDto.getHeader());
        eaiParamsTestConvertDto.setQuery(eaiParamsConvertDto.getQuery());
        EaiParamsItems eaiParamsItems = eaiParamsConvertDto.getBody();
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto.getBody())) {
            ArrayList<EaiParamsItems> eaiParamsItems1 = new ArrayList<EaiParamsItems>(1);
            eaiParamsItems1.add(eaiParamsItems);
            eaiParamsTestConvertDto.setBody(eaiParamsItems1);
        }
        return eaiParamsTestConvertDto;
    }

    public WebserviceApiInfoDto getById(String id) {
        ApiInfoEditVo apiInfoDetailVo = this.releaseApiService.getById(id);
        WebserviceApiInfoDto webserviceApiInfoDto = new WebserviceApiInfoDto();
        BeanUtil.copyProperties((Object)apiInfoDetailVo, (Object)webserviceApiInfoDto);
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)id);
        EaiEditApiWsdl wsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getOne((Wrapper)lambdaQueryWrapper);
        webserviceApiInfoDto.setEaiEditApiWsdl(wsdl);
        return webserviceApiInfoDto;
    }

    public WebserviceApiInfoVo getBaseInfoById(String id) {
        ApiInfoEditVo editVo = this.releaseApiService.getBaseInfoById(id);
        WebserviceApiInfoVo webserviceApiInfoVo = new WebserviceApiInfoVo();
        BeanUtil.copyProperties((Object)editVo, (Object)webserviceApiInfoVo);
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)id);
        EaiEditApiWsdl wsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getOne((Wrapper)lambdaQueryWrapper);
        webserviceApiInfoVo.setEaiEditApiWsdl(wsdl);
        return webserviceApiInfoVo;
    }

    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appCode);
        List apiInfos = this.apiInfoService.list((Wrapper)apiWrapper);
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            this.apiInfoService.remove((Wrapper)apiWrapper);
            List ids = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
            LambdaQueryWrapper editWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids);
            List editApis = this.iEaiEditApiService.list((Wrapper)editWrapper);
            if (HussarUtils.isNotEmpty((Object)editApis)) {
                this.iEaiEditApiService.remove((Wrapper)editWrapper);
                this.eaiCanvasInfoService.deleteApiCanvasInfos(editApis);
            }
            LambdaQueryWrapper editWsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiEditApiWsdl::getApiId, ids);
            this.eaiEditApiWsdlService.remove((Wrapper)editWsWrapper);
        }
        return true;
    }

    public Long saveApiBaseInfo(WebserviceApiInfoDto addApiInfoDto) {
        AddApiInfoDto apiInfoDto = new AddApiInfoDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)apiInfoDto);
        Long apiId = this.releaseApiService.saveApiBaseInfo(apiInfoDto);
        EaiEditApiWsdl eaiEditApiWsdl = addApiInfoDto.getEaiEditApiWsdl();
        eaiEditApiWsdl.setId(EngineUtil.getId());
        this.eaiEditApiWsdlService.save((Object)eaiEditApiWsdl);
        return apiId;
    }

    private EditApi fillEditApiAndWs(WebserviceApiInfoDto addApiInfoDto) {
        UserDetails userDetails;
        EaiEditApiWsdl eaiEditApiWsdl = addApiInfoDto.getEaiEditApiWsdl();
        eaiEditApiWsdl.setId(EngineUtil.getId());
        EditApi editApi = new EditApi();
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getId())) {
            eaiEditApiWsdl.setApiId(Long.valueOf(addApiInfoDto.getId()));
            editApi.setApiId(Long.valueOf(addApiInfoDto.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getInParams())) {
            editApi.setInParams(ReleaseWebserviceApiServiceImpl.toJSONString(addApiInfoDto.getInParams()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getOutParams())) {
            editApi.setOutParams(ReleaseWebserviceApiServiceImpl.toJSONString(addApiInfoDto.getOutParams()));
        }
        if (HussarUtils.isNotEmpty((Object)(userDetails = HussarSecurityUtils.getLoginUserDetails()))) {
            editApi.setCreateBy(userDetails.getUserName());
        }
        this.eaiEditApiWsdlService.save((Object)eaiEditApiWsdl);
        return editApi;
    }

    private void saveCanvas(EditApi editApi, WebserviceApiInfoDto addApiInfoDto, ApiCanvasInfo apiCanvasInfo) {
        boolean canvas;
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        this.eaiCanvasInfoService.deleteApiCanvasInfo(editApi);
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(editApi.getCanvasId());
        if (HussarUtils.isNotEmpty((Object)apiCanvasInfo)) {
            canvasInfo.setCanvasContent(JSON.toJSONString((Object)apiCanvasInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect}));
            canvasInfo.setCanvasResources(ReleaseWebserviceApiServiceImpl.toJSONString(apiCanvasInfo.getRelateFiles()));
        }
        if (StringUtil.isNotEmpty((Object)addApiInfoDto.getApiEventrelates())) {
            canvasInfo.setApiCodes(ReleaseWebserviceApiServiceImpl.toJSONString(addApiInfoDto.getApiEventrelates()));
        }
        if (!(canvas = this.canvasInfoService.save((Object)canvasInfo))) {
            throw new BaseException(ERROR);
        }
    }

    private static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    private boolean fillApiInfo(WebserviceApiInfoDto addApiInfoDto, ApiInfo apiInfo) {
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)apiInfo);
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getId())) {
            apiInfo.setId(Long.valueOf(addApiInfoDto.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getInParams())) {
            apiInfo.setInParams(this.eaiConvertService.toStringDefault(addApiInfoDto.getInParams()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getOutParams())) {
            EaiParamsConvertDto eaiOutParamDto = addApiInfoDto.getOutParams();
            apiInfo.setOutParams(this.eaiConvertService.toStringDefault(eaiOutParamDto));
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getDataFormat())) {
            apiInfo.setDataFormat(EaiDataCategoryEnum.JSON.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getEncodingType())) {
            apiInfo.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getRequestType())) {
            apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getTestState())) {
            apiInfo.setTestState("0");
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getPublicState())) {
            apiInfo.setPublicState("0");
        }
        apiInfo.setApiState("0");
        apiInfo.setDraftState("0");
        return this.apiInfoService.save((Object)apiInfo);
    }

    private boolean saveCallInfo(WebserviceApiInfoDto addApiInfoDto, ApiInfo apiInfo) {
        this.apiCallSpecificationInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)apiInfo.getId()));
        List specificaList = addApiInfoDto.getCallSpecificaList();
        if (CollectionUtil.isNotEmpty((Collection)specificaList)) {
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)10);
            specificaList.forEach(s -> {
                s.setApiId(apiInfo.getId());
                s.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
                ApiCallSpecificationInfo callSpecificationInfo = new ApiCallSpecificationInfo();
                BeanUtil.copy((Object)s, (Object)callSpecificationInfo);
                infoList.add(callSpecificationInfo);
            });
            return this.apiCallSpecificationInfoService.saveBatch((Collection)infoList);
        }
        return true;
    }
}

