/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiWsApiInvokeParams;
import com.jxdinfo.hussar.eai.api.canvas.runtime.dto.EaiWsApiInvokeResultType;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiWsApiInvokeService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceAuthenticationService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.eai.webservice.common.service.ISoapBuilder;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.type.TypeReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import jdk.nashorn.api.scripting.JSObject;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.EaiWsApiInvokeServiceImpl")
public class EaiWsApiInvokeServiceImpl
implements EaiWsApiInvokeService {
    @Resource
    private IWebServiceAuthenticationService webServiceAuthenticationService;
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private IStructureVersionService structureVersionService;
    private static final Integer BODY = 1;
    private static final String DEBUG = "debug:";
    private static final Pattern NAME_SUFFIX = Pattern.compile("_WSDL_\\d{18}");
    private static final String NAME_PREFIX = "copy_";
    private static final String TARGET_NAME_PREFIX = "targetVar_";
    @Resource
    private ISoapBuilder soapBuilder;
    private static final String RESP_BODY = "body";

    public ApiResponse<Object> getResponse(EaiWsApiInvokeParams eaiWsApiParams) throws Exception {
        WebServiceAuthVerfiyDto webServiceAuthVerfiyDto = new WebServiceAuthVerfiyDto();
        webServiceAuthVerfiyDto.setApplicationCode(eaiWsApiParams.getApplicationCode());
        webServiceAuthVerfiyDto.setHasCache(false);
        if (HussarUtils.isNotEmpty((Object)TempHttpCode.getAllParams())) {
            String key;
            Map map = TempHttpCode.getAllParams();
            if (eaiWsApiParams.getDebug().booleanValue() && map.containsKey(key = String.format("eai:api:debug:token:%s", eaiWsApiParams.getApplicationCode()))) {
                webServiceAuthVerfiyDto.setDebugCacheKey(String.valueOf(map.get(key)));
                map.remove(key);
            }
            webServiceAuthVerfiyDto.setTokenVerifys(this.toAuthParams(map));
        }
        webServiceAuthVerfiyDto.setHttpBody(this.toParams(eaiWsApiParams.getHttpBody()));
        webServiceAuthVerfiyDto.setHttpHeader(this.toParams(eaiWsApiParams.getHttpHeader()));
        EaiWsApiParams eaiWsApiTestParam = new EaiWsApiParams();
        eaiWsApiTestParam.setId(String.valueOf(eaiWsApiParams.getId()));
        eaiWsApiTestParam.setWsdlPath(eaiWsApiParams.getWsdlPath());
        eaiWsApiTestParam.setServiceName(eaiWsApiParams.getServiceName());
        eaiWsApiTestParam.setPortName(eaiWsApiParams.getPortName());
        eaiWsApiTestParam.setOperationName(eaiWsApiParams.getOperationName());
        eaiWsApiTestParam.setAddress(eaiWsApiParams.getAddress());
        webServiceAuthVerfiyDto.setWsApiParams(eaiWsApiTestParam);
        List<EaiParamsItems> outParamsMapping = this.getOutParamsMapping(eaiWsApiParams.getResultType(), eaiWsApiParams.getDebug(), BODY);
        webServiceAuthVerfiyDto.setOutMapping(outParamsMapping);
        if (eaiWsApiParams.getDebug().booleanValue()) {
            webServiceAuthVerfiyDto.setHasCache(true);
            ApiResponse resp = this.webServiceAuthenticationService.apiAuthVerify(webServiceAuthVerfiyDto);
            return this.getResp((ApiResponse<EaiApiResponseVo>)resp);
        }
        ApiResponse resp = this.webServiceAuthenticationService.apiInvoke(webServiceAuthVerfiyDto);
        return this.getResp((ApiResponse<EaiApiResponseVo>)resp);
    }

    private List<EaiHttpParamsDto> toAuthParams(Map<String, Object> data) {
        if (HussarUtils.isNotEmpty(data)) {
            ArrayList<EaiHttpParamsDto> dtos = new ArrayList<EaiHttpParamsDto>(data.size());
            data.forEach((k, v) -> {
                EaiHttpParamsDto dto = new EaiHttpParamsDto();
                dto.setParamsNameEn(k);
                dto.setKeyValue(v);
                dtos.add(dto);
            });
            return dtos;
        }
        return null;
    }

    private List<AuthWSDLParams> toParams(Object obj) {
        ArrayList<AuthWSDLParams> params = new ArrayList<AuthWSDLParams>();
        if (obj instanceof Map) {
            return this.toEaiHttpParamsDtos((Map)obj);
        }
        if (obj instanceof CharSequence) {
            AuthWSDLParams eaiHttpParamsDto = new AuthWSDLParams();
            eaiHttpParamsDto.setKeyValue(obj);
            eaiHttpParamsDto.setName(null);
            params.add(eaiHttpParamsDto);
            return params;
        }
        if (obj instanceof List) {
            for (Object child : (List)obj) {
                List<AuthWSDLParams> list = this.toParams(child);
                params.addAll(list);
            }
            return params;
        }
        Map<String, Object> map = EaiWsApiInvokeServiceImpl.structureToMap(obj);
        return this.toEaiHttpParamsDtos(map);
    }

    private static Map<String, Object> structureToMap(Object data) {
        HashMap<String, Object> map = new HashMap();
        if (data instanceof JSObject) {
            for (String key : ((JSObject)data).keySet()) {
                Object value = ((JSObject)data).getMember(key);
                map.put(key, value);
            }
        } else {
            map = (Map)HussarIntegrationJsonUtils.Contextual.convert((Object)data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return map;
    }

    private String getCacheKey(EaiWsApiInvokeParams invokeParams) {
        return String.format("%s:%s:%s:%s:%s", invokeParams.getApplicationCode(), invokeParams.getServiceName(), invokeParams.getPortName(), invokeParams.getOperationName(), invokeParams.getAddress());
    }

    private List<AuthWSDLParams> toEaiHttpParamsDtos(Map data) {
        if (HussarUtils.isNotEmpty((Object)data)) {
            ArrayList<AuthWSDLParams> dtos = new ArrayList<AuthWSDLParams>(data.size());
            data.forEach((k, v) -> {
                AuthWSDLParams dto = new AuthWSDLParams();
                dto.setName(k == null ? null : String.valueOf(k));
                dto.setKeyValue(v);
                dtos.add(dto);
            });
            return dtos;
        }
        return null;
    }

    private List<EaiParamsItems> getOutParamsMapping(EaiWsApiInvokeResultType resultType, Boolean debug, Integer mapping) {
        if (resultType == null) {
            throw new BaseException("\u7ec4\u4ef6\u8fd4\u56de\u503c\u914d\u7f6e\u5f02\u5e38");
        }
        ArrayList<EaiParamsItems> list = new ArrayList<EaiParamsItems>();
        int listLvl = resultType.getListLevel();
        if (listLvl == 0) {
            List<EaiParamsItems> eaiParamsItems = this.getStructure(resultType.getItemStruct(), debug, mapping);
            list.addAll(eaiParamsItems);
            return list;
        }
        EaiParamsItems eaiParamsItems = new EaiParamsItems();
        eaiParamsItems = this.getList(eaiParamsItems, listLvl, resultType, debug, mapping);
        list.add(eaiParamsItems);
        return list;
    }

    private EaiParamsItems getList(EaiParamsItems parent, int lvl, EaiWsApiInvokeResultType resultType, Boolean debug, Integer mapping) {
        ArrayList<EaiParamsItems> out = new ArrayList<EaiParamsItems>(1);
        EaiParamsItems children = new EaiParamsItems();
        children.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
        ArrayList<EaiParamsItems> item = new ArrayList<EaiParamsItems>(1);
        if (lvl > 0) {
            children.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
            EaiParamsItems child = this.getList(children, --lvl, resultType, debug, mapping);
            item.add(child);
        } else {
            List<EaiParamsItems> eaiParamsItem = this.getStructure(resultType.getItemStruct(), debug, mapping);
            if (CollectionUtil.isNotEmpty(eaiParamsItem) && HussarUtils.isNotEmpty((Object)eaiParamsItem.get(0))) {
                children.setQuoteStructureId(eaiParamsItem.get(0).getQuoteStructureId());
                item.addAll(eaiParamsItem);
            }
        }
        children.setItems(item);
        out.add(children);
        parent.setItems(out);
        return parent;
    }

    private List<EaiParamsItems> getStructure(String structureId, Boolean debug, Integer mapping) {
        if (HussarUtils.isNotEmpty((Object)structureId)) {
            String id = structureId.substring(10, structureId.length());
            ArrayList<String> ids = new ArrayList<String>();
            return this.getStructureItem(id, debug, ids, mapping);
        }
        return null;
    }

    private List<EaiParamsItems> getStructureItem(String id, Boolean debug, List<String> ids, Integer mapping) {
        List<EaiParamsItems> childItems;
        ArrayList<EaiParamsItems> list = new ArrayList<EaiParamsItems>();
        EaiParamsItems child = new EaiParamsItems();
        child.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
        child.setMapping(mapping);
        Long structureId = null;
        try {
            structureId = Long.valueOf(id);
        }
        catch (Exception e) {
            throw new BaseException("\u8fd4\u56de\u503c\u7c7b\u578b\u5f02\u5e38\uff0c\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b", (Throwable)e);
        }
        if (ids.contains(String.valueOf(structureId))) {
            return null;
        }
        ids.add(String.valueOf(structureId));
        List structureItems = null;
        if (debug.booleanValue()) {
            CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)structureId);
            String name = EaiWsApiInvokeServiceImpl.getName(commonStructure.getStructureCode());
            child.setName(name);
            child.setMappingName(name);
            child.setQuoteStructureId(String.valueOf(commonStructure.getId()));
            structureItems = JSON.parseArray((String)commonStructure.getStructureValues(), StructureItems.class);
        } else {
            StructureVersion structureVersion = (StructureVersion)this.structureVersionService.getById((Serializable)structureId);
            String name = EaiWsApiInvokeServiceImpl.getName(structureVersion.getStructureCode());
            child.setName(name);
            child.setMappingName(name);
            child.setQuoteStructureId(String.valueOf(structureVersion.getId()));
            structureItems = JSON.parseArray((String)structureVersion.getStructureValues(), StructureItems.class);
        }
        if (HussarUtils.isNotEmpty((Object)structureItems) && HussarUtils.isNotEmpty(childItems = this.toEaiParamsItems(structureItems, debug, ids, mapping))) {
            child.setItems(childItems);
        }
        list.add(child);
        return list;
    }

    private static String getName(String name) {
        Matcher matcher;
        String copyName = name;
        while (copyName.startsWith(TARGET_NAME_PREFIX)) {
            copyName = copyName.substring(10, copyName.length());
            while (copyName.startsWith(NAME_PREFIX)) {
                copyName = copyName.substring(5, copyName.length());
            }
        }
        while (copyName.startsWith(NAME_PREFIX)) {
            copyName = copyName.substring(5, copyName.length());
        }
        if (HussarUtils.isNotEmpty((Object)copyName) && (matcher = NAME_SUFFIX.matcher(copyName)).find()) {
            copyName = copyName.substring(0, matcher.start());
            return copyName;
        }
        return name;
    }

    private List<EaiParamsItems> toEaiParamsItems(List<StructureItems> structureItems, Boolean debug, List<String> ids, Integer mapping) {
        ArrayList<EaiParamsItems> list = new ArrayList<EaiParamsItems>(structureItems.size());
        for (StructureItems structureItem : structureItems) {
            List<EaiParamsItems> childList;
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            String name = EaiWsApiInvokeServiceImpl.getName(structureItem.getName());
            eaiParamsItems.setName(name);
            eaiParamsItems.setType(structureItem.getType());
            eaiParamsItems.setItemType(structureItem.getItemType());
            eaiParamsItems.setMappingName(name);
            eaiParamsItems.setMapping(mapping);
            List childs = structureItem.getItems();
            if (HussarUtils.isNotEmpty((Object)childs)) {
                childList = this.toEaiParamsItems(childs, debug, ids, mapping);
                eaiParamsItems.setItems(childList);
            } else if (HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId())) {
                if (ids.contains(structureItem.getQuoteStructureId())) {
                    eaiParamsItems.setQuoteStructureId(structureItem.getQuoteStructureId());
                    list.add(eaiParamsItems);
                    return list;
                }
                childList = this.getStructureItem(structureItem.getQuoteStructureId(), debug, ids, mapping);
                if (HussarUtils.isNotEmpty(childList)) {
                    eaiParamsItems.setItems(childList.get(0).getItems());
                }
                eaiParamsItems.setQuoteStructureId(structureItem.getQuoteStructureId());
            }
            list.add(eaiParamsItems);
        }
        return list;
    }

    private ApiResponse<Object> getResp(ApiResponse<EaiApiResponseVo> response) {
        EaiApiResponseVo vo;
        if (HussarUtils.isEmpty(response)) {
            throw new BaseException("\u8bf7\u6c42\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u54cd\u5e94\u4fe1\u606f");
        }
        ApiResponse result = ApiResponse.success();
        if (!response.isSuccess()) {
            String msg = null;
            if (HussarUtils.isNotEmpty((Object)response.getData())) {
                try {
                    msg = JSON.toJSONString((Object)((EaiApiResponseVo)response.getData()).getEscapeResponse());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result = ApiResponse.fail((String)(msg == null ? response.getMsg() : msg));
        }
        if (HussarUtils.isNotEmpty((Object)(vo = (EaiApiResponseVo)response.getData()))) {
            EaiApiResponse resp = vo.getOuturlResponse();
            Object escapeResp = vo.getEscapeResponse();
            if (HussarUtils.isNotEmpty((Object)resp) && escapeResp instanceof ApiResponse && ((ApiResponse)escapeResp).isSuccess()) {
                result = (ApiResponse)escapeResp;
                return result;
            }
            EaiApiResponse tokenResp = vo.getTokenResponse();
            if (HussarUtils.isNotEmpty((Object)resp)) {
                if (HussarUtils.isNotEmpty((Object)resp.getException())) {
                    result.setMsg(resp.getException());
                    result.setSuccess(false);
                    result.setCode(ResultCode.FAILURE.getCode());
                    return result;
                }
                Object respMsg = resp.getBody();
                if (HussarUtils.isNotEmpty((Object)respMsg) && String.valueOf(respMsg).startsWith("<")) {
                    try {
                        JSONObject object = this.soapBuilder.parseFullOutMessage(String.valueOf(respMsg));
                        if (HussarUtils.isNotEmpty((Object)object)) {
                            respMsg = object.get((Object)RESP_BODY);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                result.setData(respMsg);
            } else if (HussarUtils.isNotEmpty((Object)tokenResp)) {
                result.setData(tokenResp.getBody());
            }
            return result;
        }
        if (HussarUtils.isNotEmpty((Object)vo.getEscapeResponse())) {
            ApiResponse resp = (ApiResponse)JSON.parseObject((String)JSON.toJSONString((Object)vo.getEscapeResponse()), ApiResponse.class);
            Object data = resp.getData();
            result.setData(data);
        }
        return result;
    }
}

