/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiParamItem;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.common.util.WebSocketUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceTestDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IEaiWebServiceConvertService;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceAuthenticationService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLPort;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlOperation;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsParamsChangeUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.eaiWebServiceConvertServiceImpl")
public class EaiWebServiceConvertServiceImpl
implements IEaiWebServiceConvertService {
    private static Logger LOGGER = LoggerFactory.getLogger(EaiWebServiceConvertServiceImpl.class);
    private static final String RESULT_STR = "result";
    private static final String LEVEL_STR = "level";
    private static final String ERROR_STR = "error";
    private static final String LOGS_STR = "logs";
    private static final String MESSAGE_STR = "message";
    private static final String BODY_STR = "body";
    private static final String EXCEPTION_MESSAGE_STR = "exceptionMessage";
    @Resource
    IEaiApiInfoService eaiApiInfoService;
    @Resource
    EaiCanvasRuntimeService canvasRuntimeService;
    @Resource
    private IWebServiceAuthenticationService webServiceAuthenticationService;
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    private final ExecutorService threadPoolExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newSingleThreadExecutor());
    @Resource
    private ICanvasInfoService eaiCanvasInfoService;
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Resource
    private IWsdlInfoService wsdlInfoService;

    public WebServiceInvokeParamsDto convertWsdlParams(Long apiId, Object inParams) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiId);
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
        EaiApiParams eaiApiParams = ParamsConvertUtil.webServiceEaiParamsItems((Object)inParams, (String)editApi.getInParams());
        EaiEditApiWsdl editApiWsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getById((Serializable)apiId);
        Long wsdlId = editApiWsdl.getWsdlId();
        EaiAppWsdl wsdl = (EaiAppWsdl)this.wsdlInfoService.getById((Serializable)wsdlId);
        return this.getParams(wsdl, editApiWsdl, eaiApiParams);
    }

    public Map<String, List<WsdlParams>> convertInParams(Long apiId, Object inParams) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiId);
        EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
        EaiApiParams eaiApiParams = ParamsConvertUtil.oEaiParamsItems((Object)inParams, (String)editApi.getInParams(), (boolean)true);
        EaiEditApiWsdl editApiWsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getById((Serializable)apiId);
        Long wsdlId = editApiWsdl.getWsdlId();
        EaiAppWsdl wsdl = (EaiAppWsdl)this.wsdlInfoService.getById((Serializable)wsdlId);
        WSDLinfo infoDto = (WSDLinfo)JSON.parseObject((String)wsdl.getWsdlContent(), WSDLinfo.class);
        List list = infoDto.getWsdlServiceDtos();
        WSDLService wsdlServiceDto = list.stream().filter(f -> f.getServiceName().equals(editApiWsdl.getWsdlService())).findFirst().orElse(null);
        AssertUtil.isNotNull((Object)wsdlServiceDto, (String)"wsdl\u5f02\u5e38\uff01");
        WSDLPort wsdlPortDto = wsdlServiceDto.getPorts().stream().filter(f -> f.getPortName().equals(editApiWsdl.getServicePort())).findFirst().orElseGet(WSDLPort::new);
        WsdlOperation wsdlOperation = wsdlPortDto.getOperations().stream().filter(f -> f.getOperationName().equals(editApiWsdl.getWsdlOperation())).findFirst().orElseGet(WsdlOperation::new);
        Map<String, List<WsdlParams>> params = wsdlOperation.getInWsParams();
        wsdlServiceDto.setPorts(null);
        wsdlPortDto.setOperations(null);
        wsdlOperation.setInParams(null);
        wsdlOperation.setOutParams(null);
        params = WsParamsChangeUtil.callParams(eaiApiParams, params);
        return params;
    }

    public List<WsdlParams> convertOutParams(Long apiId, Object outParams) {
        return null;
    }

    public List<WsdlParams> convertFaultsParams(Long apiId, Object faultParams) {
        return null;
    }

    private CanvasDebugDto convetTestParams(WebServiceTestDto apiTestDto, ApiInfo apiInfo, EditApi editApi) {
        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)editApi.getCanvasId());
        CanvasDebugDto canvasDebugDto = new CanvasDebugDto();
        canvasDebugDto.setCode(apiInfo.getApiCode());
        canvasDebugDto.setCanvas(canvasInfo.getCanvasContent());
        canvasDebugDto.setResourceEnum(EaiResourcesEnum.API);
        canvasDebugDto.setName(apiInfo.getApiName());
        canvasDebugDto.setApplicationCode(apiInfo.getApplicationCode());
        Map<String, Object> map = this.headerToMap(apiTestDto.getHeader());
        canvasDebugDto.setHttpHeader(map);
        canvasDebugDto.setHttpBody(apiTestDto.getBody());
        canvasDebugDto.setId(apiInfo.getId());
        return canvasDebugDto;
    }

    public ApiResponse<EaiApiResponseVo> convertTest(WebServiceTestDto apiTestDto, WebServiceAuthVerfiyDto webServiceAuthVerfiyDto) {
        ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getById((Serializable)apiTestDto.getApiId());
        if (HussarUtils.isNotEmpty((Object)apiInfo)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EditApi::getApiId, (Object)apiTestDto.getApiId());
            EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)editApi.getCanvasId())) {
                AssertUtil.isNotEmpty((String)apiTestDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                TempHttpCode.removeAll();
                return this.webServiceAuthenticationService.apiAuthVerify(webServiceAuthVerfiyDto);
            }
            CanvasDebugDto canvasDebugDto = this.convetTestParams(apiTestDto, apiInfo, editApi);
            ApiResponse apiResponse = null;
            try {
                apiResponse = this.canvasRuntimeService.runWithDebug(canvasDebugDto);
            }
            catch (BaseException e) {
                LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), e});
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Exception ex) {
                LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), ex});
                throw new BaseException("\u9a8c\u8bc1\u5931\u8d25", (Throwable)ex);
            }
            finally {
                TempHttpCode.removeAll();
            }
            if (apiResponse.isSuccess()) {
                if (HussarUtils.isNotEmpty((Object)apiResponse.getData())) {
                    DebugResult debugResult = (DebugResult)apiResponse.getData();
                    EaiApiResponseVo apiResponseVo = new EaiApiResponseVo();
                    EaiApiResponse apiResponse1 = new EaiApiResponse();
                    Object obj = debugResult.getResult();
                    apiResponse1.setBody(obj);
                    if (HussarUtils.isNotEmpty((Object)apiTestDto.getServiceId()) && HussarUtils.isNotEmpty((Object)debugResult.getLogs())) {
                        List logs = debugResult.getLogs();
                        this.threadPoolExecutor.execute(() -> logs.forEach(log -> {
                            String level = log.getLevel().toString();
                            WebSocketUtil.senMsg((String)apiTestDto.getServiceId(), (String)log.getMessage(), (String)level, null);
                        }));
                    }
                    if (HussarUtils.isNotEmpty((Object)debugResult.getError())) {
                        LOGGER.error("\u63a5\u53e3\u9a8c\u8bc1\uff1a\u4ee3\u7801\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)debugResult.getError());
                        apiResponse1.setException(debugResult.getError().getExceptionMessage());
                        apiResponseVo.setEscapeResponse(obj);
                        apiResponseVo.setOuturlResponse(apiResponse1);
                        apiResponseVo.setOuturlRequestParams(this.requestParamsPackage(webServiceAuthVerfiyDto));
                        return ApiResponse.success((Object)apiResponseVo, (String)"\u9a8c\u8bc1\u5931\u8d25");
                    }
                    apiResponseVo.setOuturlResponse(apiResponse1);
                    apiResponseVo.setOuturlRequestParams(this.requestParamsPackage(webServiceAuthVerfiyDto));
                    apiResponseVo.setEscapeResponse(obj);
                    return ApiResponse.success((Object)apiResponseVo);
                }
                return ApiResponse.success((Object)new EaiApiResponseVo());
            }
            throw new BaseException(apiResponse.getMsg());
        }
        throw new BaseException("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38,\u672a\u77e5\u53c2\u6570\u5f02\u5e38");
    }

    private Map<String, Object> headerToMap(List<ApiParamItem> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> map.put(apiParamItem.getName(), apiParamItem.getValue()));
        return map;
    }

    private Map<String, Object> dtoHeaderToMap(List<AuthWSDLParams> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> map.put(apiParamItem.getName(), apiParamItem.getKeyValue()));
        return map;
    }

    public Map<String, Object> requestParamsPackage(WebServiceAuthVerfiyDto authVerifyDto) {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put(EaiApiParamMappingEnum.HEADER.getKey(), this.dtoHeaderToMap(authVerifyDto.getHttpHeader()));
        List list = authVerifyDto.getHttpBody();
        if (HussarUtils.isNotEmpty((Object)list) && HussarUtils.isEmpty((Object)((AuthWSDLParams)list.get(0)).getName())) {
            List str = list.stream().map(AuthWSDLParams::getKeyValue).collect(Collectors.toList());
            requestMap.put(EaiApiParamMappingEnum.BODY.getKey(), str);
        } else {
            requestMap.put(EaiApiParamMappingEnum.BODY.getKey(), this.dtoHeaderToMap(list));
        }
        return requestMap;
    }

    private WebServiceInvokeParamsDto getTestParams(EaiAppWsdl wsdl, EaiEditApiWsdl editApiWsdl, Map<String, List<EaiHttpParamsDto>> map) {
        WSDLinfo infoDto = (WSDLinfo)JSON.parseObject((String)wsdl.getWsdlContent(), WSDLinfo.class);
        WebServiceInvokeParamsDto reqParams = new WebServiceInvokeParamsDto();
        reqParams.setAddress(editApiWsdl.getWsdlAddress());
        List list = infoDto.getWsdlServiceDtos();
        WSDLService wsdlServiceDto = list.stream().filter(f -> f.getServiceName().equals(editApiWsdl.getWsdlService())).findFirst().orElse(null);
        AssertUtil.isNotNull((Object)wsdlServiceDto, (String)"wsdl\u5f02\u5e38\uff01");
        WSDLPort wsdlPortDto = wsdlServiceDto.getPorts().stream().filter(f -> f.getPortName().equals(editApiWsdl.getServicePort())).findFirst().orElseGet(WSDLPort::new);
        WsdlOperation wsdlOperation = wsdlPortDto.getOperations().stream().filter(f -> f.getOperationName().equals(editApiWsdl.getWsdlOperation())).findFirst().orElseGet(WsdlOperation::new);
        Map<String, List<WsdlParams>> params = wsdlOperation.getInWsParams();
        wsdlServiceDto.setPorts(null);
        wsdlPortDto.setOperations(null);
        wsdlOperation.setInParams(null);
        wsdlOperation.setOutParams(null);
        reqParams.setWsdlServiceDto(wsdlServiceDto);
        reqParams.setWsdlPortDto(wsdlPortDto);
        reqParams.setWsdlOperation(wsdlOperation);
        params = WsParamsChangeUtil.callParams(map, params);
        reqParams.setInParams(params);
        reqParams.setInParams(params);
        return reqParams;
    }

    private WebServiceInvokeParamsDto getParams(EaiAppWsdl wsdl, EaiEditApiWsdl editApiWsdl, EaiApiParams eaiApiParams) {
        WSDLinfo infoDto = (WSDLinfo)JSON.parseObject((String)wsdl.getWsdlContent(), WSDLinfo.class);
        WebServiceInvokeParamsDto reqParams = new WebServiceInvokeParamsDto();
        reqParams.setAddress(editApiWsdl.getWsdlAddress());
        List list = infoDto.getWsdlServiceDtos();
        WSDLService wsdlServiceDto = list.stream().filter(f -> f.getServiceName().equals(editApiWsdl.getWsdlService())).findFirst().orElse(null);
        AssertUtil.isNotNull((Object)wsdlServiceDto, (String)"wsdl\u5f02\u5e38\uff01");
        WSDLPort wsdlPortDto = wsdlServiceDto.getPorts().stream().filter(f -> f.getPortName().equals(editApiWsdl.getServicePort())).findFirst().orElseGet(WSDLPort::new);
        WsdlOperation wsdlOperation = wsdlPortDto.getOperations().stream().filter(f -> f.getOperationName().equals(editApiWsdl.getWsdlOperation())).findFirst().orElseGet(WsdlOperation::new);
        Map<String, List<WsdlParams>> params = wsdlOperation.getInWsParams();
        wsdlServiceDto.setPorts(null);
        wsdlPortDto.setOperations(null);
        wsdlOperation.setInParams(null);
        wsdlOperation.setOutParams(null);
        reqParams.setWsdlServiceDto(wsdlServiceDto);
        reqParams.setWsdlPortDto(wsdlPortDto);
        reqParams.setWsdlOperation(wsdlOperation);
        params = WsParamsChangeUtil.callParams(eaiApiParams, params);
        reqParams.setInParams(params);
        return reqParams;
    }
}

