/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ibm.wsdl.BindingOperationImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12OperationImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLPort;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlOperation;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.service.IWsdlConnService;
import com.jxdinfo.hussar.eai.webservice.common.vo.LocalWSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IEaiWsdlFileService;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WAWsdlUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsParamsChangeUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl.wsdlConnServiceImpl")
public class WsdlConnServiceImpl
implements IWsdlConnService {
    private static final Logger log = LoggerFactory.getLogger(WsdlConnServiceImpl.class);
    @Resource
    IWsdlInfoService wsdlInfoService;
    @Resource
    IEaiWsdlFileService eaiWsdlFileService;
    @Resource
    IEaiAppWsdlVersionService eaiAppWsdlVersionService;
    @Resource
    ICommonStructureService commonStructureService;
    private static final String SOURCE_TYPE = "2";

    public WSDLinfo conn(String wsdlPath) {
        return this.conn(null, wsdlPath);
    }

    @HussarTransactional
    public WSDLinfo conn(String appCode, String wsdlPath) {
        String wsdlId;
        WSDLinfo wsdLinfoDto = new WSDLinfo();
        wsdLinfoDto.setHasSaved(Boolean.valueOf(false));
        String suffixId = wsdlId = String.valueOf(EngineUtil.getId());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdl::getApplicationCode, (Object)appCode)).eq(EaiAppWsdl::getWsdlPath, (Object)wsdlPath);
        EaiAppWsdl eaiAppWsdl = (EaiAppWsdl)this.wsdlInfoService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiAppWsdl)) {
            wsdlId = String.valueOf(eaiAppWsdl.getId());
            wsdLinfoDto.setHasSaved(Boolean.valueOf(true));
            LambdaQueryWrapper countWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdlVersion::getFileId, (Object)eaiAppWsdl.getFileId());
            if (this.eaiAppWsdlVersionService.count((Wrapper)countWrapper) <= 0L) {
                this.eaiWsdlFileService.deleteWsdlFileById(eaiAppWsdl.getFileId());
            }
        }
        wsdLinfoDto.setWsdlId(wsdlId);
        Definition definition = null;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            definition = wsdlReader.readWSDL(wsdlPath);
        }
        catch (Exception e) {
            log.error("failed to init WSDLReader", (Throwable)e);
            throw new BaseException("\u521d\u59cb\u5316\u5931\u8d25");
        }
        try {
            org.w3c.dom.Document document = WAWsdlUtil.getDefinitionDocument(definition);
            Long fileId = this.eaiWsdlFileService.saveWsdlFile(document, appCode, wsdlId);
            wsdLinfoDto.setFileId(fileId);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u539f\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        wsdLinfoDto.setDocumentBaseUri(definition.getDocumentBaseURI());
        wsdLinfoDto.setTargetNameSpace(definition.getTargetNamespace());
        HashMap<QName, WSDLService> wsdlInfoMap = new HashMap<QName, WSDLService>();
        Map map = definition.getServices();
        if (HussarUtils.isNotEmpty((Object)map)) {
            boolean b;
            List<CommonStructure> allStructures = new ArrayList<CommonStructure>();
            HashMap<String, CommonStructure> inMap = new HashMap<String, CommonStructure>();
            for (Map.Entry entry : map.entrySet()) {
                WSDLService serviceDto = new WSDLService();
                QName k = (QName)entry.getKey();
                serviceDto.setServiceName(k.getLocalPart());
                serviceDto.setPrefix(k.getPrefix());
                serviceDto.setServiceUrl(k.getNamespaceURI());
                ServiceImpl v = (ServiceImpl)entry.getValue();
                k.getLocalPart();
                Map ports = v.getPorts();
                ArrayList<WSDLPort> wsdlPortDtos = new ArrayList<WSDLPort>();
                for (Map.Entry portTypeEntry : ports.entrySet()) {
                    Binding binding;
                    List operations;
                    WSDLPort portDto = new WSDLPort();
                    portDto.setPortName((String)portTypeEntry.getKey());
                    PortImpl portType = (PortImpl)portTypeEntry.getValue();
                    String nameSpace = portType.getBinding().getQName().getNamespaceURI();
                    portDto.setPortNameSpace(nameSpace);
                    List addresses = portType.getExtensibilityElements();
                    if (HussarUtils.isNotEmpty((Object)addresses)) {
                        ArrayList<String> address = new ArrayList<String>();
                        for (Object obj : addresses) {
                            address.add(JSON.parseObject((String)JSON.toJSONString(obj)).getString("locationURI"));
                        }
                        portDto.setAddress(address);
                    }
                    if (HussarUtils.isNotEmpty((Object)(operations = (binding = portType.getBinding()).getBindingOperations()))) {
                        ArrayList<WsdlOperation> wsdlOperations = new ArrayList<WsdlOperation>();
                        for (BindingOperationImpl operation : operations) {
                            WsdlOperation wsdlOperation = new WsdlOperation();
                            wsdlOperation.setOperationName(operation.getName());
                            wsdlOperation.setOperationNameSpace(definition.getTargetNamespace());
                            List extElements = operation.getExtensibilityElements();
                            Iterator iterator = extElements.iterator();
                            if (iterator.hasNext()) {
                                Object object = iterator.next();
                                if (object instanceof SOAP12OperationImpl) {
                                    wsdlOperation.setSoapVersion("SOAP 1.2 Protocol");
                                } else {
                                    wsdlOperation.setSoapVersion("SOAP 1.1 Protocol");
                                }
                            }
                            try {
                                ArrayList<CommonStructure> inStructures = new ArrayList<CommonStructure>();
                                ArrayList<CommonStructure> outStructures = new ArrayList<CommonStructure>();
                                ArrayList<CommonStructure> faultStructures = new ArrayList<CommonStructure>();
                                Map<String, List<WsdlParams>> in = WAWsdlUtil.getMethodParams(inStructures, definition, operation.getName(), appCode, suffixId, inMap, wsdLinfoDto.getHasSaved());
                                Map<String, List<WsdlParams>> out = WAWsdlUtil.getMethodReturn(outStructures, definition, operation.getName(), appCode, suffixId, inMap, wsdLinfoDto.getHasSaved());
                                Map<String, List<WsdlParams>> fault = WAWsdlUtil.getMethodFaults(faultStructures, definition, operation.getName(), appCode, suffixId, inMap, wsdLinfoDto.getHasSaved());
                                wsdlOperation.setInWsParams(in);
                                this.addCommonStructures(allStructures, inStructures, outStructures, faultStructures);
                                Map<String, Long> structureMap = new HashMap<String, Long>();
                                if (HussarUtils.isNotEmpty(allStructures)) {
                                    allStructures = WsdlConnServiceImpl.allStructures(allStructures);
                                    structureMap = allStructures.stream().collect(Collectors.toMap(CommonStructure::getStructureCode, CommonStructure::getId));
                                }
                                wsdlOperation.setInParams(WsParamsChangeUtil.toParamsItems(in, allStructures, structureMap, appCode, suffixId));
                                wsdlOperation.setOutWsParams(out);
                                wsdlOperation.setOutParams(WsParamsChangeUtil.toParamsItems(out, allStructures, structureMap, appCode, suffixId));
                                if (HussarUtils.isNotEmpty(fault)) {
                                    wsdlOperation.setFaultsWsParams(fault);
                                    wsdlOperation.setFaults(WsParamsChangeUtil.toParamsItems(fault, allStructures, structureMap, appCode, suffixId));
                                }
                            }
                            catch (WSDLException e) {
                                log.error("\u51fa\u5165\u53c2\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                                throw new BaseException("\u51fa\u5165\u53c2\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
                            }
                            wsdlOperations.add(wsdlOperation);
                        }
                        portDto.setOperations(wsdlOperations);
                    }
                    wsdlPortDtos.add(portDto);
                }
                serviceDto.setPorts(wsdlPortDtos);
                wsdlInfoMap.put(k, serviceDto);
            }
            if (null != appCode && !(b = this.saveCommonStructures(definition, allStructures, appCode, suffixId).booleanValue())) {
                throw new BaseException("\u4fdd\u5b58\u6570\u636e\u7ed3\u6784\u5931\u8d25");
            }
        }
        if (HussarUtils.isNotEmpty(wsdlInfoMap.values())) {
            wsdLinfoDto.setWsdlServiceDtos(new ArrayList(wsdlInfoMap.values()));
            return wsdLinfoDto;
        }
        return null;
    }

    private Boolean saveCommonStructures(Definition definition, List<CommonStructure> allStructures, String appCode, String wsdlId) {
        if (HussarUtils.isNotEmpty(allStructures)) {
            Document document = WAWsdlUtil.getDom4JDocument(definition);
            allStructures = WsdlConnServiceImpl.allStructures(allStructures);
            List<String> list = WAWsdlUtil.getAllCodeNames(document);
            List structureCodes = allStructures.stream().map(CommonStructure::getStructureCode).collect(Collectors.toList());
            ArrayList<String> correct = new ArrayList<String>();
            block0: for (String str : list) {
                for (String structureCode : structureCodes) {
                    if (!structureCode.contains(str)) continue;
                    correct.add(str);
                    continue block0;
                }
            }
            if (HussarUtils.isNotEmpty(correct)) {
                list.removeAll(correct);
                if (HussarUtils.isNotEmpty(list)) {
                    List<WsdlParams> wsdlParams = WAWsdlUtil.getWsdlParams(list, document);
                    HashMap<String, List<WsdlParams>> listMap = new HashMap<String, List<WsdlParams>>();
                    listMap.put("body", wsdlParams);
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    WsParamsChangeUtil.toParamsItems(listMap, allStructures, map, appCode, wsdlId);
                }
            }
            allStructures = WsdlConnServiceImpl.allStructures(allStructures);
            for (CommonStructure commonStructure : allStructures) {
                String str = commonStructure.getStructureValues();
                if (!HussarUtils.isNotEmpty((Object)str)) continue;
                List structureItems = JSON.parseArray((String)str, StructureItems.class);
                for (StructureItems structureItem : structureItems) {
                    if (!HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId())) continue;
                    structureItem.setItems(new ArrayList(0));
                }
                commonStructure.setStructureValues(JSON.toJSONString((Object)structureItems));
            }
            if (HussarUtils.isNotEmpty(allStructures)) {
                return this.commonStructureService.saveBatch(allStructures);
            }
        }
        return true;
    }

    private void addCommonStructures(List<CommonStructure> allStructures, List<CommonStructure> inStructures, List<CommonStructure> outStructures, List<CommonStructure> faultStructures) {
        if (HussarUtils.isNotEmpty(inStructures)) {
            allStructures.addAll(inStructures);
        }
        if (HussarUtils.isNotEmpty(outStructures)) {
            allStructures.addAll(outStructures);
        }
        if (HussarUtils.isNotEmpty(faultStructures)) {
            allStructures.addAll(faultStructures);
        }
    }

    @HussarTransactional
    public LocalWSDLServiceVo connAndSave(String appCode, String wsdlPath) {
        LocalWSDLServiceVo wsdlServiceVo = new LocalWSDLServiceVo();
        WSDLinfo wsdLinfoDto = this.conn(appCode, wsdlPath);
        EaiAppWsdl eaiAppWsdl = new EaiAppWsdl();
        eaiAppWsdl.setApplicationCode(appCode);
        eaiAppWsdl.setId(Long.valueOf(wsdLinfoDto.getWsdlId()));
        eaiAppWsdl.setFileId(wsdLinfoDto.getFileId());
        wsdlServiceVo.setWsdlId(eaiAppWsdl.getId());
        eaiAppWsdl.setWsdlSourceType(SOURCE_TYPE);
        eaiAppWsdl.setWsdlPath(wsdlPath);
        eaiAppWsdl.setWsdlContent(JSON.toJSONString((Object)wsdLinfoDto));
        eaiAppWsdl.setWsdlVersion(wsdLinfoDto.getWsdlVersion());
        if (wsdLinfoDto.getHasSaved().booleanValue()) {
            this.wsdlInfoService.updateById((Object)eaiAppWsdl);
        } else {
            this.wsdlInfoService.save((Object)eaiAppWsdl);
        }
        wsdlServiceVo.setApplicationCode(appCode);
        wsdlServiceVo.setWsdLinfoDto(wsdLinfoDto);
        wsdlServiceVo.setWsdlSourceType(SOURCE_TYPE);
        return wsdlServiceVo;
    }

    private static List<CommonStructure> allStructures(List<CommonStructure> allStructures) {
        ArrayList<CommonStructure> structures = new ArrayList<CommonStructure>();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(allStructures)) {
            for (CommonStructure allStructure : allStructures) {
                if (ids.contains(allStructure.getId())) continue;
                ids.add(allStructure.getId());
                structures.add(allStructure);
            }
        }
        return structures;
    }
}

