/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlOperation;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.service.ISoapBuilder;
import com.jxdinfo.hussar.eai.webservice.common.util.SoapMessageUtil;
import com.jxdinfo.hussar.eai.webservice.common.util.TypeUtil;
import com.jxdinfo.hussar.eai.webservice.common.util.XmlUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.w3c.dom.Node;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl.soapBuilderImpl")
public class SoapBuilderImpl
implements ISoapBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapBuilderImpl.class);

    public SOAPMessage buildInputMessage(WebServiceInvokeParamsDto context) {
        try {
            String soapVersion = context.getWsdlOperation().getSoapVersion();
            MessageFactory messageFactory = MessageFactory.newInstance((String)soapVersion);
            SOAPMessage message = messageFactory.createMessage();
            SOAPPart part = message.getSOAPPart();
            SOAPEnvelope envelope = part.getEnvelope();
            SOAPHeader header = envelope.getHeader();
            SOAPBody body = envelope.getBody();
            List headerParams = (List)context.getInParams().get("header");
            List bodyParams = (List)context.getInParams().get("body");
            WsdlOperation wsdlOperation = context.getWsdlOperation();
            this.builderHeader(header, headerParams, wsdlOperation);
            String operationName = wsdlOperation.getOperationName();
            this.builderBody(body, bodyParams, wsdlOperation);
            message.saveChanges();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            String str = baos.toString();
            LOGGER.info("\u6784\u5efaWebServie\u65b9\u6cd5{}\u7684\u8bf7\u6c42\u62a5\u6587:{}", (Object)operationName, (Object)str);
            return message;
        }
        catch (Exception e) {
            LOGGER.error("buildInputMessage error:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public JSONObject parseOutMessage(SOAPMessage soapMessage, List<EaiParamsItems> outMapping) throws Exception {
        if (HussarUtils.isEmpty(outMapping)) {
            throw new Exception("\u51fa\u53c2\u6620\u5c04\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)soapMessage)) {
            throw new Exception("\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource((Node)soapMessage.getSOAPPart());
        StreamResult streamResult = new StreamResult(new StringWriter());
        transformer.transform(source, streamResult);
        String xmlResponse = SoapMessageUtil.soapMessage2Xml((SOAPMessage)soapMessage);
        return this.parseOutMessageStr(xmlResponse, outMapping);
    }

    public Map<String, String> getTypes(String preifx, List<EaiParamsItems> eaiParamsItemsList, Map<String, String> map) {
        if (HussarUtils.isNotEmpty(eaiParamsItemsList)) {
            for (EaiParamsItems eaiParamsItems : eaiParamsItemsList) {
                String type = eaiParamsItems.getType() + "";
                String name = eaiParamsItems.getName();
                map.put(StringUtils.isNotBlank((CharSequence)preifx) ? preifx + ":" + name : name, type);
                this.getTypes(name, eaiParamsItems.getItems(), map);
            }
        }
        return map;
    }

    public JSONObject parseOutMessageStr(String xmlResponse, List<EaiParamsItems> outMapping) throws Exception {
        JSONObject result = new JSONObject();
        Document document = XmlUtil.getRootDocumentByContent((String)xmlResponse);
        HashMap<String, String> map = new HashMap<String, String>();
        this.getTypes("", outMapping, map);
        List all = document.selectNodes("/Envelope/*");
        for (Element element : all) {
            String name = element.getName();
            if (name.equalsIgnoreCase("body")) {
                result.put("body", (Object)this.elementToJSONObject(element, map));
            }
            if (!name.equalsIgnoreCase("header")) continue;
            result.put("header", (Object)this.elementToJSONObject(element, map));
        }
        return result;
    }

    public JSONObject parseOutMessage(SOAPMessage soapMessage) throws Exception {
        String xmlResponse = SoapMessageUtil.soapMessage2Xml((SOAPMessage)soapMessage);
        Document document = XmlUtil.getRootDocumentByContent((String)xmlResponse);
        List all = document.selectNodes("/Envelope/*");
        JSONObject result = new JSONObject();
        result.put("header", null);
        result.put("body", null);
        result.put("faults", null);
        for (Element element : all) {
            JSONObject faults;
            JSONObject body;
            JSONObject header = this.getMapResult(element, "header");
            if (HussarUtils.isNotEmpty((Object)header)) {
                result.put("header", (Object)header);
            }
            if (HussarUtils.isNotEmpty((Object)(body = this.getMapResult(element, "body")))) {
                result.put("body", (Object)body);
            }
            if (!HussarUtils.isNotEmpty((Object)(faults = this.getMapResult(element, "faults")))) continue;
            result.put("faults", (Object)faults);
        }
        return result;
    }

    private JSONObject getMapResult(Element element, String pos) {
        JSONObject body = null;
        String name = element.getName();
        if (name.equalsIgnoreCase(pos)) {
            Element returnEle = null;
            List children = element.elements();
            if (HussarUtils.isNotEmpty((Object)children)) {
                Element response = (Element)children.get(0);
                if (response != null) {
                    returnEle = (Element)response.elements().get(0);
                }
                body = returnEle != null ? this.elementToJSONObject(returnEle) : new JSONObject();
            }
        }
        return body;
    }

    public JSONObject elementToJSONObject(Element node) {
        JSONObject result = new JSONObject();
        List listElement = node.elements();
        if (!listElement.isEmpty()) {
            for (Element e : listElement) {
                if (e.attributes().isEmpty() && e.elements().isEmpty()) {
                    result.put(e.getName(), (Object)e.getTextTrim());
                    continue;
                }
                if (!result.containsKey((Object)e.getName())) {
                    result.put(e.getName(), (Object)new JSONArray());
                }
                ((JSONArray)result.get((Object)e.getName())).add((Object)this.elementToJSONObject(e));
            }
        } else {
            String text = node.getText();
            if (StringUtils.isNotBlank((CharSequence)text)) {
                result.put(node.getName(), (Object)text);
            }
        }
        return result;
    }

    public JSONObject elementToJSONObject(Element node, Map<String, String> map) {
        JSONObject result = new JSONObject();
        String pName = node.getName();
        List listElement = node.elements();
        if (!listElement.isEmpty()) {
            for (Element e : listElement) {
                if (e.attributes().isEmpty() && e.elements().isEmpty()) {
                    result.put(e.getName(), (Object)e.getTextTrim());
                    continue;
                }
                String eleName = e.getName();
                String type = map.get(pName + ":" + eleName);
                if (StringUtils.isNotBlank((CharSequence)type) && type.equals("6")) {
                    if (!result.containsKey((Object)e.getName())) {
                        result.put(e.getName(), (Object)new JSONArray());
                    }
                    ((JSONArray)result.get((Object)e.getName())).add((Object)this.elementToJSONObject(e, map));
                    continue;
                }
                if (result.containsKey((Object)e.getName())) continue;
                result.put(e.getName(), (Object)this.elementToJSONObject(e, map));
            }
        } else {
            String text = node.getText();
            if (StringUtils.isNotBlank((CharSequence)text)) {
                result.put(node.getName(), (Object)text);
            }
        }
        return result;
    }

    private void builderBody(SOAPBody body, List<WsdlParams> bodyParams, WsdlOperation wsdlOperation) throws Exception {
        String operationName = wsdlOperation.getOperationName();
        String operationNameSpace = wsdlOperation.getOperationNameSpace();
        QName qname = new QName(operationNameSpace, operationName, "ns2");
        SOAPBodyElement ele = body.addBodyElement(qname);
        this.builderBody(ele, bodyParams);
    }

    private void builderBody(SOAPBodyElement ele, List<WsdlParams> bodyParams) throws Exception {
        if (CollectionUtils.isNotEmpty(bodyParams)) {
            for (WsdlParams bodyParam : bodyParams) {
                String name = bodyParam.getName();
                String value = bodyParam.getValue();
                SOAPElement soapBodyElement = ele.addChildElement(name);
                String type = bodyParam.getType();
                if (TypeUtil.isSimleType((String)type) && StringUtils.isNotBlank((CharSequence)value)) {
                    soapBodyElement.setValue(value);
                    continue;
                }
                this.builderBodyElement(soapBodyElement, bodyParam.getChildren());
            }
        }
    }

    private boolean canAdd(WsdlParams param) {
        int i;
        List children = param.getChildren();
        if (HussarUtils.isNotEmpty((Object)children) && (i = 0) < children.size()) {
            WsdlParams temp = (WsdlParams)children.get(i);
            String value = temp.getValue();
            String type = temp.getType();
            if (StringUtils.isNotBlank((CharSequence)value) && TypeUtil.isSimleType((String)type)) {
                return true;
            }
            return this.canAdd(temp);
        }
        return false;
    }

    private void builderBodyElement(SOAPElement element, List<WsdlParams> params) throws Exception {
        if (CollectionUtils.isNotEmpty(params)) {
            for (WsdlParams bodyParam : params) {
                SOAPElement tempEle;
                String name = bodyParam.getName();
                String value = bodyParam.getValue();
                String type = bodyParam.getType();
                if (TypeUtil.isSimleType((String)type) && StringUtils.isNotBlank((CharSequence)value)) {
                    tempEle = element.addChildElement(name);
                    tempEle.setValue(value);
                    continue;
                }
                if (!this.canAdd(bodyParam)) continue;
                tempEle = element.addChildElement(name);
                this.builderBodyElement(tempEle, bodyParam.getChildren());
            }
        }
    }

    private void builderHeader(SOAPHeader header, List<WsdlParams> headerParams, WsdlOperation wsdlOperation) throws Exception {
        List headers = (List)wsdlOperation.getInWsParams().get("header");
        if (HussarUtils.isNotEmpty((Object)headers)) {
            String name = ((WsdlParams)headers.get(0)).getName();
            QName qname = new QName(wsdlOperation.getOperationNameSpace(), name, "ns1");
            SOAPHeaderElement ele = header.addHeaderElement(qname);
            this.builderHeader((SOAPElement)ele, headerParams);
        }
    }

    private void builderHeader(SOAPElement soapHeaderElement, List<WsdlParams> headerParams) throws Exception {
        if (CollectionUtils.isNotEmpty(headerParams)) {
            for (WsdlParams headerParam : headerParams) {
                String name = headerParam.getName();
                String value = headerParam.getValue();
                QName qName = new QName("", name);
                SOAPElement soapElement = soapHeaderElement.addChildElement(qName);
                if (value != null) {
                    soapElement.addTextNode(value);
                    continue;
                }
                this.builderHeader(soapElement, headerParam.getChildren());
            }
        }
    }
}

