/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IEaiWsdlFileService;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WAWsdlUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.wsdl.service.impl.EaiWsdlFileServiceImpl")
public class EaiWsdlFileServiceImpl
implements IEaiWsdlFileService {
    private static Logger LOGGER = LoggerFactory.getLogger(EaiWsdlFileServiceImpl.class);
    @Resource
    IWsdlInfoService wsdlInfoService;
    @Resource
    OssService eaiOssService;
    private static final String FILE_NAME = "%s_%s";

    public Long saveWsdlFile(String wsdlId, String appCode) {
        EaiAppWsdl eaiAppWsdl = (EaiAppWsdl)this.wsdlInfoService.getById((Serializable)((Object)wsdlId));
        String wsdlPath = eaiAppWsdl.getWsdlPath();
        Document document = null;
        try {
            document = WAWsdlUtil.getDefinitionDocument(wsdlPath);
        }
        catch (Exception e) {
            LOGGER.error("parse wsdl error:{}", (Object)e.getMessage(), (Object)e);
        }
        return this.saveWsdlFile(document, appCode, wsdlId);
    }

    public Long saveWsdlFile(Document document, String appCode, String wsdlId) {
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
            transformer.transform(source, result);
        }
        catch (Exception e) {
            LOGGER.error("saveWsdlFile error:{}", (Object)e.getMessage(), (Object)e);
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {
                    LOGGER.error("saveWsdlFile error:{}", (Object)ex.getMessage(), (Object)ex);
                }
            }
            throw new BaseException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        byte[] byteArray = out.toByteArray();
        ByteArrayMultipartFile multipartFile = EaiWsdlFileServiceImpl.getMultipartFile(String.format(FILE_NAME, appCode, wsdlId), byteArray);
        ApiResponse apiResponse = this.eaiOssService.backgroundUpload((MultipartFile)multipartFile);
        if (apiResponse.isSuccess()) {
            return (Long)apiResponse.getData();
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    public Document getWsdlFile(Long fileId) {
        ApiResponse file = this.eaiOssService.backgroundDownload(fileId);
        if (file.isSuccess()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])file.getData());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(inputStream);
                return document;
            }
            catch (Exception e) {
                LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                throw new BaseException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return null;
    }

    public Definition getWsdlDefinition(Long fileId, String baseUrl) {
        try {
            Document document = this.getWsdlFile(fileId);
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            return wsdlReader.readWSDL(baseUrl, document);
        }
        catch (Exception e) {
            throw new BaseException("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean deleteWsdlFileById(Long fileId) {
        if (HussarUtils.isNotEmpty((Object)fileId)) {
            ApiResponse apiResponse = this.eaiOssService.deleteFile(fileId);
            return apiResponse.isSuccess();
        }
        return true;
    }

    public static ByteArrayMultipartFile getMultipartFile(String name, byte[] data) {
        return new ByteArrayMultipartFile(name, data);
    }

    private static final class ByteArrayMultipartFile
    implements MultipartFile {
        private final String name;
        private final byte[] data;

        public ByteArrayMultipartFile(String name, byte[] data) {
            if (name == null || data == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.data = data;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public String getOriginalFilename() {
            return this.name;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public boolean isEmpty() {
            return this.getSize() == 0L;
        }

        public long getSize() {
            return this.data.length;
        }

        @NonNull
        public byte[] getBytes() throws IOException {
            return this.data;
        }

        @NonNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public void transferTo(@NonNull File file) throws IOException {
            FileUtils.writeByteArrayToFile((File)file, (byte[])this.data);
        }
    }
}

