/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.parse;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.util.DOMUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsDataTypeChangeUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WsdlStructureUtil {
    private static final String[] TYPE_NAME = new String[]{"array", "string", "int", "integer", "float", "double", "long", "boolean", "time", "date", "datetime", "localdatetime", "localdate", "decimal"};
    private static ICommonStructureService commonStructureService;
    private static final String STRUCTURE_CODE = "%s_WSDL_%s";
    private static final String STRUCTURE_NAME = "p_%s_%s_%s";
    private static final Integer RANDOM_BOND;
    private static final Integer RANDOM_LIMIT;
    private static SecureRandom rand;

    @Autowired
    public void setICommonStructureService(ICommonStructureService commonStructureService) {
        WsdlStructureUtil.commonStructureService = commonStructureService;
    }

    public static String getStructureCode(String name, String wsdlId) {
        return String.format(STRUCTURE_CODE, name, wsdlId);
    }

    public static String getStructureName(String name, String wsdlId) {
        Integer randNum = rand.nextInt(RANDOM_BOND) + RANDOM_LIMIT;
        return String.format(STRUCTURE_NAME, name, wsdlId, randNum);
    }

    public static List<CommonStructure> generatedCommonStructure(String appCode, Map<String, CommonStructure> commonStructureMap, List<WsdlParams> paramsList, String wsdlId, Boolean hasSaved) {
        ArrayList<CommonStructure> commonStructures = new ArrayList<CommonStructure>();
        for (WsdlParams wsdlParam : paramsList) {
            if (WsdlStructureUtil.isStructureType(wsdlParam.getType()).booleanValue()) {
                String structureCode = WsdlStructureUtil.getStructureCode(wsdlParam.getType(), wsdlId);
                CommonStructure commonStructure = null;
                if (commonStructureMap.containsKey(structureCode)) {
                    commonStructure = commonStructureMap.get(structureCode);
                }
                if (HussarUtils.isEmpty(commonStructure)) {
                    commonStructure = WsdlStructureUtil.createCommonStructure(appCode, wsdlParam, commonStructureMap, commonStructures, wsdlId);
                }
                if (!commonStructureMap.containsKey(commonStructure.getStructureCode())) {
                    commonStructures.add(commonStructure);
                    commonStructureMap.put(commonStructure.getStructureCode(), commonStructure);
                }
            }
            List child = wsdlParam.getChildren();
            if (!WsdlStructureUtil.isListType(wsdlParam.getType(), wsdlParam.getMaxOccurs()).booleanValue() || !HussarUtils.isNotEmpty((Object)child) || !WsdlStructureUtil.isStructureType(wsdlParam.getChildType()).booleanValue()) continue;
            List<CommonStructure> list = WsdlStructureUtil.generatedCommonStructure(appCode, commonStructureMap, child, wsdlId, hasSaved);
            commonStructures.addAll(list);
        }
        return commonStructures;
    }

    private static Boolean updateCommonStructure(CommonStructure commonStructure) {
        return commonStructureService.updateById((Object)commonStructure);
    }

    private static CommonStructure createCommonStructure(String appCode, WsdlParams wsdlParam, Map<String, CommonStructure> commonStructureMap, List<CommonStructure> commonStructures, String wsdlId) {
        if (WsdlStructureUtil.isStructureType(wsdlParam.getType()).booleanValue()) {
            String code = WsdlStructureUtil.getStructureCode(wsdlParam.getType(), wsdlId);
            if (commonStructureMap.containsKey(code)) {
                return commonStructureMap.get(code);
            }
            CommonStructure dbStructure = WsdlStructureUtil.getCommonStructure(appCode, code);
            if (HussarUtils.isNotEmpty((Object)dbStructure)) {
                if (!commonStructures.contains(dbStructure)) {
                    commonStructures.add(dbStructure);
                    commonStructureMap.put(dbStructure.getStructureCode(), dbStructure);
                }
                return dbStructure;
            }
            CommonStructure commonStructure = new CommonStructure();
            commonStructure.setId(EngineUtil.getId());
            commonStructure.setStructureName(WsdlStructureUtil.getStructureName(wsdlParam.getName(), wsdlId));
            commonStructure.setStructureCode(code);
            commonStructure.setApplicationCode(appCode);
            commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
            commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
            commonStructureMap.put(commonStructure.getStructureCode(), commonStructure);
            List child = wsdlParam.getChildren();
            if (HussarUtils.isNotEmpty((Object)child)) {
                List<StructureItems> structureItems = WsdlStructureUtil.generatedStructureItems(appCode, child, commonStructureMap, commonStructures, wsdlId);
                commonStructure.setStructureValues(JSON.toJSONString(structureItems));
            }
            if (!commonStructures.contains(commonStructure)) {
                commonStructures.add(commonStructure);
                commonStructureMap.put(commonStructure.getStructureCode(), commonStructure);
            }
            return commonStructure;
        }
        return null;
    }

    private static final Boolean isEnyType(String type) {
        if (HussarUtils.isNotEmpty((Object)type) && "anytype".equals(type.toLowerCase())) {
            return true;
        }
        return false;
    }

    private static List<StructureItems> generatedStructureItems(String appCode, List<WsdlParams> child, Map<String, CommonStructure> commonStructureMap, List<CommonStructure> commonStructures, String wsdlId) {
        ArrayList<StructureItems> structureItems = new ArrayList<StructureItems>();
        for (WsdlParams childParam : child) {
            StructureItems structureItem = new StructureItems();
            structureItem.setName(childParam.getName());
            structureItem.setNickName(childParam.getName());
            structureItem.setType(WsDataTypeChangeUtil.getEaiDataType(childParam.getType()));
            List childItems = childParam.getChildren();
            if (WsdlStructureUtil.isListType(childParam.getType(), childParam.getMaxOccurs()).booleanValue()) {
                String type;
                structureItem.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                StructureItems items = new StructureItems();
                items.setName("items");
                items.setNickName("items");
                structureItem.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                String string = type = HussarUtils.isEmpty((Object)childParam.getChildType()) ? childParam.getType() : childParam.getChildType();
                if (WsdlStructureUtil.isStructureType(type).booleanValue()) {
                    structureItem.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                    WsdlParams ns = new WsdlParams();
                    BeanUtil.copyProperties((Object)childParam, (Object)ns);
                    ns.setType(WsdlStructureUtil.getStructureCode(type, wsdlId));
                    ns.setName(WsdlStructureUtil.getStructureCode(type, wsdlId));
                    String id = null;
                    String key = WsdlStructureUtil.getStructureCode(childParam.getChildType(), wsdlId);
                    if (commonStructureMap.containsKey(key)) {
                        id = String.valueOf(commonStructureMap.get(key).getId());
                    } else {
                        CommonStructure commonStructure = WsdlStructureUtil.createCommonStructure(appCode, ns, commonStructureMap, commonStructures, wsdlId);
                        id = String.valueOf(commonStructure.getId());
                    }
                    ArrayList<StructureItems> childItem = new ArrayList<StructureItems>(1);
                    items.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                    items.setQuoteStructureId(id);
                    childItem.add(items);
                    structureItem.setItems(childItem);
                } else if (HussarUtils.isNotEmpty((Object)childItems)) {
                    List<StructureItems> childItem = WsdlStructureUtil.generatedStructureItems(appCode, childItems, commonStructureMap, commonStructures, wsdlId);
                    ArrayList<StructureItems> item = new ArrayList<StructureItems>(1);
                    items.setItems(childItem);
                    items.setType(childItem.get(0).getType());
                    item.add(items);
                    structureItem.setItemType(childItem.get(0).getType());
                    structureItem.setItems(item);
                }
            } else if (WsdlStructureUtil.isStructureType(childParam.getType()).booleanValue()) {
                CommonStructure commonStructure;
                String id = null;
                String key = WsdlStructureUtil.getStructureCode(childParam.getType(), wsdlId);
                if (commonStructureMap.containsKey(key)) {
                    commonStructure = commonStructureMap.get(key);
                    id = String.valueOf(commonStructure.getId());
                    if (HussarUtils.isNotEmpty((Object)commonStructure.getStructureValues())) {
                        structureItem.setItems(JSON.parseArray((String)commonStructure.getStructureValues(), StructureItems.class));
                    }
                } else {
                    commonStructure = WsdlStructureUtil.createCommonStructure(appCode, childParam, commonStructureMap, commonStructures, wsdlId);
                    id = String.valueOf(commonStructure.getId());
                    String val = commonStructure.getStructureValues();
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        structureItem.setItems(JSON.parseArray((String)val, StructureItems.class));
                    }
                }
                structureItem.setQuoteStructureId(id);
            } else if (HussarUtils.isNotEmpty((Object)childItems)) {
                List<StructureItems> childItem = WsdlStructureUtil.generatedStructureItems(appCode, childItems, commonStructureMap, commonStructures, wsdlId);
                structureItem.setItemType(childItem.get(0).getType());
                structureItem.setItems(childItem);
            }
            structureItems.add(structureItem);
        }
        return structureItems;
    }

    public static CommonStructure createNewCommonStructure(String appCode, WsdlParams wsdlParams, String wsdlId, List<CommonStructure> allStructures) {
        if (null == appCode) {
            return null;
        }
        Long id = EngineUtil.getId();
        String structureCode = WsdlStructureUtil.getStructureCode(wsdlParams.getType(), wsdlId);
        CommonStructure commonStructure = new CommonStructure();
        commonStructure.setId(id);
        commonStructure.setStructureName(WsdlStructureUtil.getStructureName(wsdlParams.getName(), wsdlId));
        commonStructure.setStructureCode(structureCode);
        commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
        commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
        commonStructure.setApplicationCode(appCode);
        commonStructure.setRemark("wsdl\u89e3\u6790\u81ea\u52a8\u751f\u6210");
        allStructures.add(commonStructure);
        return commonStructure;
    }

    public static CommonStructure getCommonStructure(String appCode, String name) {
        if (null == appCode) {
            return null;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appCode)).eq(CommonStructure::getStructureCode, (Object)name);
        return (CommonStructure)commonStructureService.getOne((Wrapper)wrapper);
    }

    public static Boolean isListType(String type) {
        return "array".equals(type);
    }

    public static Boolean isListType(String type, String maxOurs) {
        return "array".equals(type) || DOMUtil.isArray((String)maxOurs);
    }

    public static Boolean isStructureType(String type) {
        boolean isStructure = true;
        if (HussarUtils.isNotEmpty((Object)type)) {
            for (int i = 0; i < TYPE_NAME.length; ++i) {
                if (!TYPE_NAME[i].equals(type.toLowerCase())) continue;
                isStructure = false;
                break;
            }
        }
        return isStructure;
    }

    static {
        RANDOM_BOND = 9000;
        RANDOM_LIMIT = 1000;
        rand = RandomUtil.getSecureRandom();
    }
}

