/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.parse;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.enums.WsdlDataTypeEnum;
import com.jxdinfo.hussar.eai.webservice.common.util.WordUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsDataTypeChangeUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsdlStructureUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class WsParamsChangeUtil {
    private static List<EaiParamsItems> toWsParamsItems(Map<String, Long> map, List<CommonStructure> allStructures, List<WsdlParams> wsParams, List<String> structureIds, Integer mapping, String appCode, String wsdlId) {
        ArrayList<EaiParamsItems> list = new ArrayList<EaiParamsItems>();
        for (WsdlParams wsParam : wsParams) {
            ArrayList<EaiParamsItems> items;
            String itemType;
            EaiParamsItems eaiParamsItem = new EaiParamsItems();
            eaiParamsItem.setName(wsParam.getName());
            eaiParamsItem.setRequired(Integer.valueOf(wsParam.getRequired() == null ? 0 : Integer.valueOf(wsParam.getRequired())));
            eaiParamsItem.setMapping(mapping);
            eaiParamsItem.setMappingName(WordUtil.convertKeyWord((String)wsParam.getName()));
            Integer type = WsDataTypeChangeUtil.getEaiDataType(wsParam.getType());
            Boolean isList = WsdlStructureUtil.isListType(wsParam.getType(), wsParam.getMaxOccurs());
            EaiParamsItems item = null;
            if (isList.booleanValue()) {
                type = EaiDataType.DATA_TYPE_LIST.getType();
                item = WsParamsChangeUtil.initListItems(mapping);
                ArrayList<EaiParamsItems> items2 = new ArrayList<EaiParamsItems>();
                items2.add(item);
                eaiParamsItem.setItems(items2);
            }
            eaiParamsItem.setType(type);
            eaiParamsItem.setValue(type == null ? null : String.valueOf(type));
            List child = wsParam.getChildren();
            if (HussarUtils.isNotEmpty((Object)type) && type.intValue() == EaiDataType.DATA_TYPE_STRUCTURE.getType()) {
                Object commonStructure;
                String structureCode = WsdlStructureUtil.getStructureCode(wsParam.getType(), wsdlId);
                eaiParamsItem.setValue(structureCode);
                if (structureIds.contains(structureCode)) {
                    eaiParamsItem.setQuoteStructureId(map.get(structureCode) == null ? null : String.valueOf(map.get(structureCode)));
                    commonStructure = allStructures.stream().filter(s -> structureCode.equals(s.getStructureCode())).findFirst();
                    if (((Optional)commonStructure).isPresent()) {
                        String value = ((CommonStructure)((Optional)commonStructure).get()).getStructureValues();
                        eaiParamsItem.setItems(ParamsConvertUtil.toEaiParamsItems((String)value));
                    }
                    list.add(eaiParamsItem);
                    return list;
                }
                if (map.containsKey(structureCode)) {
                    String id = map.get(structureCode) == null ? null : String.valueOf(map.get(structureCode));
                    eaiParamsItem.setQuoteStructureId(id);
                    structureIds.add(structureCode);
                } else {
                    commonStructure = WsdlStructureUtil.getCommonStructure(appCode, structureCode);
                    if (HussarUtils.isEmpty((Object)commonStructure)) {
                        commonStructure = WsdlStructureUtil.createNewCommonStructure(appCode, wsParam, wsdlId, allStructures);
                    }
                    eaiParamsItem.setQuoteStructureId(commonStructure.getId() == null ? null : String.valueOf(commonStructure.getId()));
                    map.put(commonStructure.getStructureCode(), commonStructure.getId());
                    structureIds.add(commonStructure.getStructureCode());
                    eaiParamsItem.setValue(commonStructure.getStructureCode());
                }
            }
            Integer childType = null;
            childType = HussarUtils.isEmpty((Object)wsParam.getChildType()) && isList != false ? WsDataTypeChangeUtil.getEaiDataType(wsParam.getType()) : WsDataTypeChangeUtil.getEaiDataType(wsParam.getChildType());
            String string = itemType = HussarUtils.isEmpty((Object)wsParam.getChildType()) ? wsParam.getType() : wsParam.getChildType();
            if (HussarUtils.isNotEmpty((Object)child)) {
                eaiParamsItem.setItemType(childType);
                List<EaiParamsItems> eaiParamsItemsList = WsParamsChangeUtil.toWsParamsItems(map, allStructures, child, structureIds, mapping, appCode, wsdlId);
                if (isList.booleanValue()) {
                    items = new ArrayList<EaiParamsItems>();
                    item.setItems(eaiParamsItemsList);
                    if (WsdlStructureUtil.isStructureType(itemType).booleanValue()) {
                        eaiParamsItem.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        String itemCode = WsdlStructureUtil.getStructureCode(itemType, wsdlId);
                        if (structureIds.contains(itemCode)) {
                            item.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                            item.setQuoteStructureId(map.get(itemCode) == null ? null : String.valueOf(map.get(itemCode)));
                            item.setValue(WsdlStructureUtil.getStructureCode(itemType, wsdlId));
                            items.add(item);
                            eaiParamsItem.setItems(items);
                            return list;
                        }
                        CommonStructure commonStructure = null;
                        if (map.containsKey(itemCode)) {
                            Optional<CommonStructure> commonStructureOption = allStructures.stream().filter(f -> itemCode.equals(f.getStructureCode())).findFirst();
                            if (commonStructureOption.isPresent()) {
                                commonStructure = commonStructureOption.get();
                            }
                        } else {
                            commonStructure = WsdlStructureUtil.getCommonStructure(appCode, itemType);
                        }
                        if (HussarUtils.isEmpty((Object)commonStructure)) {
                            WsdlParams copyWsdlParam = new WsdlParams();
                            BeanUtil.copyProperties((Object)wsParam, (Object)copyWsdlParam);
                            copyWsdlParam.setType(itemType);
                            commonStructure = WsdlStructureUtil.createNewCommonStructure(appCode, copyWsdlParam, wsdlId, allStructures);
                        }
                        item.setQuoteStructureId(commonStructure.getId() == null ? null : String.valueOf(commonStructure.getId()));
                        if (!map.containsKey(commonStructure.getStructureCode())) {
                            map.put(commonStructure.getStructureCode(), commonStructure.getId());
                            structureIds.add(commonStructure.getStructureCode());
                            allStructures.add(commonStructure);
                        }
                        item.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        item.setValue(WsdlStructureUtil.getStructureCode(itemType, wsdlId));
                    } else if (WsdlStructureUtil.isListType(itemType).booleanValue()) {
                        eaiParamsItem.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                        item.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                        List<EaiParamsItems> childItem = WsParamsChangeUtil.toWsParamsItems(map, allStructures, wsParam.getChildren(), structureIds, mapping, appCode, wsdlId);
                        item.setItems(childItem);
                    }
                    items.add(item);
                    eaiParamsItem.setItems(items);
                } else {
                    eaiParamsItem.setItems(eaiParamsItemsList);
                }
            } else if (isList.booleanValue() && WsdlStructureUtil.isStructureType(itemType).booleanValue()) {
                String itemCode = WsdlStructureUtil.getStructureCode(itemType, wsdlId);
                item.setType(childType);
                item.setQuoteStructureId(map.get(itemCode) == null ? null : String.valueOf(map.get(itemCode)));
                item.setValue(itemCode);
                eaiParamsItem.setItemType(childType);
                items = new ArrayList();
                items.add(item);
                eaiParamsItem.setItems(items);
            }
            list.add(eaiParamsItem);
        }
        return list;
    }

    private static List<EaiParamsItems> toWsParamsItems(Map<String, Long> map, List<CommonStructure> allStructures, List<WsdlParams> wsParams, Integer mapping, String appCode, String wsdlId) {
        ArrayList<EaiParamsItems> list = new ArrayList<EaiParamsItems>();
        for (WsdlParams wsParam : wsParams) {
            ArrayList<EaiParamsItems> items;
            String itemType;
            ArrayList<String> structureIds = new ArrayList<String>();
            EaiParamsItems eaiParamsItem = new EaiParamsItems();
            eaiParamsItem.setName(wsParam.getName());
            eaiParamsItem.setRequired(Integer.valueOf(wsParam.getRequired() == null ? 0 : Integer.valueOf(wsParam.getRequired())));
            eaiParamsItem.setMapping(mapping);
            eaiParamsItem.setMappingName(WordUtil.convertKeyWord((String)wsParam.getName()));
            Integer type = WsDataTypeChangeUtil.getEaiDataType(wsParam.getType());
            Boolean isList = WsdlStructureUtil.isListType(wsParam.getType(), wsParam.getMaxOccurs());
            EaiParamsItems item = null;
            if (isList.booleanValue()) {
                type = EaiDataType.DATA_TYPE_LIST.getType();
                item = WsParamsChangeUtil.initListItems(mapping);
                ArrayList<EaiParamsItems> items2 = new ArrayList<EaiParamsItems>();
                items2.add(item);
                eaiParamsItem.setItems(items2);
            }
            eaiParamsItem.setType(type);
            eaiParamsItem.setValue(type == null ? null : String.valueOf(type));
            List child = wsParam.getChildren();
            if (HussarUtils.isNotEmpty((Object)type) && type.intValue() == EaiDataType.DATA_TYPE_STRUCTURE.getType()) {
                String structureCode = WsdlStructureUtil.getStructureCode(wsParam.getType(), wsdlId);
                eaiParamsItem.setValue(structureCode);
                if (map.containsKey(structureCode)) {
                    eaiParamsItem.setQuoteStructureId(map.get(structureCode) == null ? null : String.valueOf(map.get(structureCode)));
                    structureIds.add(structureCode);
                } else {
                    CommonStructure commonStructure = WsdlStructureUtil.getCommonStructure(appCode, structureCode);
                    if (HussarUtils.isEmpty((Object)commonStructure)) {
                        commonStructure = WsdlStructureUtil.createNewCommonStructure(appCode, wsParam, wsdlId, allStructures);
                    }
                    eaiParamsItem.setQuoteStructureId(commonStructure.getId() == null ? null : String.valueOf(commonStructure.getId()));
                    map.put(commonStructure.getStructureCode(), commonStructure.getId());
                    structureIds.add(commonStructure.getStructureCode());
                    eaiParamsItem.setValue(commonStructure.getStructureCode());
                }
            }
            Integer childType = null;
            childType = HussarUtils.isEmpty((Object)wsParam.getChildType()) && isList != false ? WsDataTypeChangeUtil.getEaiDataType(wsParam.getType()) : WsDataTypeChangeUtil.getEaiDataType(wsParam.getChildType());
            String string = itemType = HussarUtils.isEmpty((Object)wsParam.getChildType()) ? wsParam.getType() : wsParam.getChildType();
            if (HussarUtils.isNotEmpty((Object)child)) {
                eaiParamsItem.setItemType(childType);
                List<EaiParamsItems> eaiParamsItemsList = WsParamsChangeUtil.toWsParamsItems(map, allStructures, child, structureIds, mapping, appCode, wsdlId);
                if (isList.booleanValue()) {
                    items = new ArrayList<EaiParamsItems>();
                    item.setItems(eaiParamsItemsList);
                    if (WsdlStructureUtil.isStructureType(itemType).booleanValue()) {
                        String itemCode = WsdlStructureUtil.getStructureCode(itemType, wsdlId);
                        eaiParamsItem.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        CommonStructure commonStructure = null;
                        if (map.containsKey(itemCode)) {
                            Optional<CommonStructure> commonStructureOption = allStructures.stream().filter(f -> itemCode.equals(f.getStructureCode())).findFirst();
                            if (commonStructureOption.isPresent()) {
                                commonStructure = commonStructureOption.get();
                            }
                        } else {
                            commonStructure = WsdlStructureUtil.getCommonStructure(appCode, itemType);
                        }
                        if (HussarUtils.isEmpty((Object)commonStructure)) {
                            WsdlParams copyWsdlParam = new WsdlParams();
                            BeanUtil.copyProperties((Object)wsParam, (Object)copyWsdlParam);
                            copyWsdlParam.setType(itemType);
                            commonStructure = WsdlStructureUtil.createNewCommonStructure(appCode, copyWsdlParam, wsdlId, allStructures);
                        }
                        item.setQuoteStructureId(commonStructure.getId() == null ? null : String.valueOf(commonStructure.getId()));
                        if (!map.containsKey(commonStructure.getStructureCode())) {
                            map.put(commonStructure.getStructureCode(), commonStructure.getId());
                            structureIds.add(commonStructure.getStructureCode());
                            allStructures.add(commonStructure);
                        }
                        item.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        item.setValue(WsdlStructureUtil.getStructureCode(itemType, wsdlId));
                    } else if (WsdlStructureUtil.isListType(itemType).booleanValue()) {
                        eaiParamsItem.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                        item.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                        List<EaiParamsItems> childItem = WsParamsChangeUtil.toWsParamsItems(map, allStructures, wsParam.getChildren(), structureIds, mapping, appCode, wsdlId);
                        item.setItems(childItem);
                    }
                    items.add(item);
                    eaiParamsItem.setItems(items);
                } else {
                    eaiParamsItem.setItems(eaiParamsItemsList);
                }
            } else if (isList.booleanValue() && WsdlStructureUtil.isStructureType(itemType).booleanValue()) {
                String itemCode = WsdlStructureUtil.getStructureCode(itemType, wsdlId);
                item.setType(childType);
                item.setQuoteStructureId(map.get(itemCode) == null ? null : String.valueOf(map.get(itemCode)));
                eaiParamsItem.setItemType(childType);
                items = new ArrayList();
                items.add(item);
                eaiParamsItem.setItems(items);
            }
            list.add(eaiParamsItem);
        }
        return list;
    }

    private static final EaiParamsItems initListItems(Integer mapping) {
        EaiParamsItems item = new EaiParamsItems();
        item.setName("items");
        item.setMapping(mapping);
        item.setMappingName("items");
        item.setRequired(Integer.valueOf(0));
        return item;
    }

    public static EaiParamsConvertDto toParamsItems(Map<String, List<WsdlParams>> wsParams, List<CommonStructure> allStructures, Map<String, Long> map, String appCode, String wsdlId) {
        EaiParamsConvertDto paramsConvertDto = new EaiParamsConvertDto();
        List<WsdlParams> bodyList = wsParams.get("body");
        List<WsdlParams> headerList = wsParams.get("header");
        if (HussarUtils.isNotEmpty(bodyList)) {
            WsdlParams parent = bodyList.get(0);
            List<EaiParamsItems> body = WsParamsChangeUtil.toWsParamsItems(map, allStructures, bodyList.get(0).getChildren(), 1, appCode, wsdlId);
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            eaiParamsItems.setName(parent.getName());
            eaiParamsItems.setMappingName(WordUtil.convertKeyWord((String)parent.getName()));
            eaiParamsItems.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
            String code = WsdlStructureUtil.getStructureCode(parent.getType(), wsdlId);
            String id = null;
            if (map.containsKey(code)) {
                id = map.get(code) == null ? null : String.valueOf(map.get(code));
            } else {
                CommonStructure commonStructure = WsdlStructureUtil.getCommonStructure(appCode, code);
                if (HussarUtils.isEmpty((Object)commonStructure)) {
                    commonStructure = WsdlStructureUtil.createNewCommonStructure(appCode, parent, wsdlId, allStructures);
                }
                map.put(code, commonStructure.getId());
                if (HussarUtils.isNotEmpty((Object)commonStructure)) {
                    id = commonStructure.getId() == null ? null : String.valueOf(commonStructure.getId());
                }
            }
            eaiParamsItems.setQuoteStructureId(id);
            eaiParamsItems.setItems(body);
            eaiParamsItems.setValue(code);
            eaiParamsItems.setRequired(Integer.valueOf(1));
            paramsConvertDto.setBody(eaiParamsItems);
        }
        if (HussarUtils.isNotEmpty(headerList)) {
            List<EaiParamsItems> header = WsParamsChangeUtil.toWsParamsItems(map, allStructures, headerList.get(0).getChildren(), 0, appCode, wsdlId);
            paramsConvertDto.setHeader(header);
        }
        return paramsConvertDto;
    }

    public static List<WsdlParams> callDataParams(Object body, List<WsdlParams> headerList) {
        if (HussarUtils.isNotEmpty(headerList)) {
            return WsParamsChangeUtil.callWsParams(body, headerList, true);
        }
        return null;
    }

    public static Map<String, List<WsdlParams>> callParams(Map<String, List<EaiHttpParamsDto>> map, Map<String, List<WsdlParams>> wsParams) {
        List<EaiHttpParamsDto> header = map.get("header");
        List<EaiHttpParamsDto> body = map.get("body");
        HashMap<String, List<WsdlParams>> returnMap = new HashMap<String, List<WsdlParams>>();
        if (HussarUtils.isNotEmpty(header)) {
            List<WsdlParams> headerList = wsParams.get("header");
            HashMap<String, Object> soapHeaderMap = new HashMap<String, Object>();
            for (EaiHttpParamsDto eaiHttpParamsDto : header) {
                soapHeaderMap.put(eaiHttpParamsDto.getParamsNameEn(), eaiHttpParamsDto.getKeyValue());
            }
            List<WsdlParams> headerParams = WsParamsChangeUtil.callWsParams(soapHeaderMap, headerList, true);
            returnMap.put("header", headerParams);
        }
        if (HussarUtils.isNotEmpty(body)) {
            HashMap<String, Object> soapBodyMap = new HashMap<String, Object>();
            List<WsdlParams> bodyList = wsParams.get("body");
            for (EaiHttpParamsDto eaiHttpParamsDto : header) {
                soapBodyMap.put(eaiHttpParamsDto.getParamsNameEn(), eaiHttpParamsDto.getKeyValue());
            }
            List<WsdlParams> bodyParams = WsParamsChangeUtil.callWsParams(soapBodyMap, bodyList, true);
            returnMap.put("body", bodyParams);
        }
        return returnMap;
    }

    public static Map<String, List<WsdlParams>> callParams(Object body, Map<String, List<WsdlParams>> params) {
        List<WsdlParams> headerList;
        HashMap<String, List<WsdlParams>> map = new HashMap<String, List<WsdlParams>>();
        List<WsdlParams> bodyList = params.get("body");
        if (HussarUtils.isNotEmpty(bodyList)) {
            List<WsdlParams> bodyParams = WsParamsChangeUtil.callWsParams(body, bodyList, true);
            map.put("body", bodyParams);
        }
        if (HussarUtils.isNotEmpty(headerList = params.get("header"))) {
            List<WsdlParams> headerParams = WsParamsChangeUtil.callWsParams(body, headerList, true);
            map.put("header", headerParams);
        }
        return map;
    }

    private static List<WsdlParams> callWsParams(Object body, List<WsdlParams> params, Boolean isParent) {
        if (HussarUtils.isEmpty((Object)body)) {
            return null;
        }
        ArrayList<WsdlParams> paramList = new ArrayList<WsdlParams>();
        if (body instanceof Collection) {
            List list = JSON.parseArray((String)JSON.toJSONString((Object)body), JSONObject.class);
            for (JSONObject obj : list) {
                for (WsdlParams wsdlParam : params) {
                    if (!obj.containsKey((Object)wsdlParam.getName())) continue;
                    if (HussarUtils.isNotEmpty((Object)wsdlParam.getChildren())) {
                        Object childObj = obj.get((Object)wsdlParam.getName());
                        if (HussarUtils.isNotEmpty((Object)childObj)) {
                            List<WsdlParams> child = WsParamsChangeUtil.callWsParams(childObj, wsdlParam.getChildren(), isParent);
                            wsdlParam.setChildren(child);
                        } else {
                            wsdlParam.setChildren(null);
                        }
                    } else {
                        wsdlParam.setValue(obj.get((Object)wsdlParam.getName()) == null ? null : String.valueOf(obj.get((Object)wsdlParam.getName())));
                    }
                    paramList.add(wsdlParam);
                }
            }
        } else if (body instanceof Map) {
            JSONObject obj = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)body), JSONObject.class);
            for (Map.Entry map : obj.entrySet()) {
                for (WsdlParams wsdlParam : params) {
                    if (!wsdlParam.getName().equals(map.getKey())) continue;
                    if (HussarUtils.isNotEmpty((Object)wsdlParam.getChildren())) {
                        Object childObj = map.getValue();
                        if (HussarUtils.isNotEmpty(childObj)) {
                            List<WsdlParams> child = WsParamsChangeUtil.callWsParams(map.getValue(), wsdlParam.getChildren(), false);
                            wsdlParam.setChildren(child);
                        } else {
                            wsdlParam.setChildren(null);
                        }
                    } else {
                        String value = WsParamsChangeUtil.dateValue(map.getValue(), wsdlParam.getType());
                        wsdlParam.setValue(value);
                    }
                    paramList.add(wsdlParam);
                }
            }
        } else if (params.size() == 1 && HussarUtils.isEmpty((Object)params.get(0).getChildren()) && HussarUtils.isNotEmpty((Object)body)) {
            WsdlParams wsdlParams = params.get(0);
            wsdlParams.setValue(body == null ? null : String.valueOf(body));
            paramList.add(wsdlParams);
        }
        return paramList;
    }

    private static String dateValue(Object val, String type) {
        String value;
        String string = value = val == null ? null : String.valueOf(val);
        if (HussarUtils.isNotEmpty((Object)value)) {
            if (WsdlDataTypeEnum.WSDL_TIME.getType().equals(type)) {
                value = DateFormat.getTimeInstance().format(value);
            }
            if (WsdlDataTypeEnum.WSDL_DATE_TIME.getType().equals(type)) {
                value = DateFormat.getDateTimeInstance().format(value);
            }
            if (WsdlDataTypeEnum.WSDL_DATE.getType().equals(type)) {
                value = DateFormat.getDateInstance().format(value);
            }
        }
        return value;
    }
}

