/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.parse;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.util.DOMUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WADOMUtil;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsdlStructureUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WAWsdlUtil {
    private static Logger log = LoggerFactory.getLogger(WAWsdlUtil.class);
    private static WSDLFactory wsdlFactory;
    private static WSDLReader wsdlReader;
    private static DocumentBuilder documentBuilder;
    private XPath xPath;
    private static WAWsdlUtilInstance waWsdlUtilInstance;
    private static final String xpathExp = "//*[local-name()='schema']/*[local-name()='complexType']";
    private static final String NODE_XPATH = "//*[local-name()='schema']/*[local-name()='complexType' and @name='%s']/*[local-name()='sequence']/*[local-name()='element']";

    private static WSDLFactory getWsdlFactory() throws WSDLException {
        if (wsdlFactory == null) {
            wsdlFactory = WSDLFactory.newInstance();
        }
        return wsdlFactory;
    }

    private static WSDLReader getWsdlReader() throws WSDLException {
        if (wsdlReader == null) {
            wsdlReader = WAWsdlUtil.getWsdlFactory().newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", true);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        }
        return wsdlReader;
    }

    public static DocumentBuilder getDBBuilder() throws ParserConfigurationException {
        if (documentBuilder == null) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilder = dbFactory.newDocumentBuilder();
        }
        return documentBuilder;
    }

    public static org.w3c.dom.Document getDefinitionDocument(Definition def) throws WSDLException {
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        org.w3c.dom.Document document = writer.getDocument(def);
        return document;
    }

    public static org.w3c.dom.Document getDefinitionDocument(String path) throws WSDLException {
        Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(path);
        WSDLWriter writer = WAWsdlUtil.getWsdlFactory().newWSDLWriter();
        org.w3c.dom.Document document = writer.getDocument(def);
        return document;
    }

    public static XPath getXPath() {
        return WAWsdlUtil.waWsdlUtilInstance.waWsdlUtil.getXPathInstance();
    }

    public XPath getXPathInstance() {
        if (this.xPath == null) {
            this.xPath = XPathFactory.newInstance().newXPath();
        }
        return this.xPath;
    }

    public static void getOperationList(String wsdlUrl, List<String> operationList) throws WSDLException {
        Definition def = WAWsdlUtil.getWsdlReader().readWSDL(wsdlUrl);
        Map bindings = def.getBindings();
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            String namespaceUri;
            ExtensibilityElement extensibilityElement;
            List extEles;
            Binding binding = (Binding)iterator.next().getValue();
            if (binding == null || (extEles = binding.getExtensibilityElements()) == null || extEles.size() <= 0 || (extensibilityElement = (ExtensibilityElement)extEles.get(0)) == null || !"http://schemas.xmlsoap.org/wsdl/soap/".equals(namespaceUri = extensibilityElement.getElementType().getNamespaceURI()) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(namespaceUri)) continue;
            List operations = binding.getPortType().getOperations();
            for (Operation operation : operations) {
                operationList.add(operation.getName());
            }
        }
    }

    public static Operation getOperationByName(Definition def, String operationName) throws WSDLException {
        Operation targetOp = null;
        Map bindings = def.getBindings();
        Iterator iterator = bindings.entrySet().iterator();
        block0: while (iterator.hasNext()) {
            List operations;
            ExtensibilityElement extensibilityElement;
            List extEles;
            Binding binding = (Binding)iterator.next().getValue();
            if (binding == null || (extEles = binding.getExtensibilityElements()) == null || extEles.size() <= 0 || (extensibilityElement = (ExtensibilityElement)extEles.get(0)) == null) continue;
            String namespaceUri = extensibilityElement.getElementType().getNamespaceURI();
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(namespaceUri)) {
                operations = binding.getPortType().getOperations();
                for (Operation operation : operations) {
                    if (!operation.getName().equals(operationName)) continue;
                    targetOp = operation;
                    break block0;
                }
                break;
            }
            if (!"http://schemas.xmlsoap.org/wsdl/soap12/".equals(namespaceUri)) continue;
            operations = binding.getPortType().getOperations();
            for (Operation operation : operations) {
                if (!operation.getName().equals(operationName)) continue;
                targetOp = operation;
                continue block0;
            }
        }
        return targetOp;
    }

    public static Map<String, List<WsdlParams>> getMethodParams(List<CommonStructure> commonStructures, Definition definition, String operationName, String appCode, String wsdlId, Map<String, CommonStructure> inMap, Boolean hasSaved) throws WSDLException {
        Operation operation = WAWsdlUtil.getOperation(definition, operationName);
        Map inputParts = operation.getInput().getMessage().getParts();
        return WAWsdlUtil.findParamsByOperation(commonStructures, definition, inputParts, appCode, wsdlId, inMap, hasSaved);
    }

    public static Operation getOperation(Definition definition, String operationName) throws WSDLException {
        Operation operation = WAWsdlUtil.getOperationByName(definition, operationName);
        if (operation == null) {
            log.error("can not find operation " + operationName + " , please check again");
            throw new RuntimeException("can not find operation " + operationName + " , please check again");
        }
        return operation;
    }

    public static Map<String, List<WsdlParams>> getMethodReturn(List<CommonStructure> commonStructures, Definition definition, String operationName, String appCode, String wsdlId, Map<String, CommonStructure> inMap, Boolean hasSaved) throws WSDLException {
        Operation operation = WAWsdlUtil.getOperation(definition, operationName);
        Map outputParts = operation.getOutput().getMessage().getParts();
        return WAWsdlUtil.findParamsByOperation(commonStructures, definition, outputParts, appCode, wsdlId, inMap, hasSaved);
    }

    public static Map<String, List<WsdlParams>> getMethodFaults(List<CommonStructure> commonStructures, Definition definition, String operationName, String appCode, String wsdlId, Map<String, CommonStructure> inMap, Boolean hasSaved) throws WSDLException {
        Operation operation = WAWsdlUtil.getOperation(definition, operationName);
        Map outputParts = operation.getFaults();
        return WAWsdlUtil.findParamsByOperation(commonStructures, definition, outputParts, appCode, wsdlId, inMap, hasSaved);
    }

    @Deprecated
    public static String getSchemaPrefix(String wsdlUrl) throws WSDLException {
        String prefix = "";
        Definition def = WAWsdlUtil.getWsdlReader().readWSDL(wsdlUrl);
        Types types = def.getTypes();
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)types.getExtensibilityElements().get(0);
        Schema schema = (Schema)extensibilityElement;
        prefix = schema.getElement().getPrefix();
        prefix = !StringUtils.isBlank((CharSequence)prefix) ? prefix + ":" : "";
        return prefix;
    }

    public static List<org.w3c.dom.Document> getImportDocumentList(org.w3c.dom.Document document, XPath xpath) throws Exception {
        NodeList importSchemaNodeList;
        ArrayList<org.w3c.dom.Document> importDocumentList = new ArrayList<org.w3c.dom.Document>();
        NodeList importNodeList = (NodeList)xpath.evaluate("//*[local-name()='definitions']/*[local-name()='import']", document, XPathConstants.NODESET);
        if (importNodeList != null) {
            for (int i = 0; i < importNodeList.getLength(); ++i) {
                Node importNode = importNodeList.item(i);
                String location = DOMUtil.getAttributeValue((Node)importNode, (String)"location");
                if (StringUtils.isBlank((CharSequence)location)) continue;
                org.w3c.dom.Document importDocument = WAWsdlUtil.getDefinitionDocument(location);
                importDocumentList.add(importDocument);
            }
        }
        if ((importSchemaNodeList = (NodeList)xpath.evaluate("//*[local-name()='schema']/*[local-name()='import']", document, XPathConstants.NODESET)) != null) {
            for (int i = 0; i < importSchemaNodeList.getLength(); ++i) {
                Node importNode = importSchemaNodeList.item(i);
                String location = DOMUtil.getAttributeValue((Node)importNode, (String)"schemaLocation");
                if (StringUtils.isBlank((CharSequence)location)) continue;
                org.w3c.dom.Document importDocument = WAWsdlUtil.getDBBuilder().parse(location);
                importDocumentList.add(importDocument);
            }
        }
        return importDocumentList;
    }

    private static void findImport(Definition definition, List<String> operationList) throws WSDLException {
        Map imports = definition.getImports();
        Iterator iterator = imports.entrySet().iterator();
        while (iterator.hasNext()) {
            Import anImport = (Import)iterator.next().getValue();
            log.info("import nameSpace:" + anImport.getNamespaceURI() + ",location:" + anImport.getLocationURI());
            WAWsdlUtil.getOperationList(anImport.getLocationURI(), operationList);
        }
    }

    private static Map<String, List<WsdlParams>> findParamsByOperation(List<CommonStructure> commonStructures, Definition definition, Map parts, String appCode, String wsdlId, Map<String, CommonStructure> commonStructureMap, Boolean hasSaved) throws WSDLException {
        org.w3c.dom.Document document = WAWsdlUtil.getDefinitionDocument(definition);
        HashMap<String, List<WsdlParams>> listMap = new HashMap<String, List<WsdlParams>>();
        String schemaXPath = "//*[local-name()='schema']";
        ArrayList<WsdlParams> headerList = new ArrayList<WsdlParams>();
        ArrayList<WsdlParams> bodyList = new ArrayList<WsdlParams>();
        Iterator entryIterator = parts.entrySet().iterator();
        while (entryIterator.hasNext()) {
            ArrayList<WsdlParams> paramsList = new ArrayList<WsdlParams>();
            Map.Entry entry = entryIterator.next();
            Part part = (Part)entry.getValue();
            String key = String.valueOf(entry.getKey());
            if (part.getTypeName() != null) {
                String string = part.getTypeName().getLocalPart();
            }
            if (part.getElementName() == null) continue;
            String typeName = part.getElementName().getLocalPart();
            try {
                List<CommonStructure> structures;
                ArrayList<String> types = new ArrayList<String>();
                WADOMUtil.getInputParams(paramsList, document, typeName, schemaXPath, null, types, true, appCode, hasSaved);
                if (!HussarUtils.isNotEmpty(paramsList)) continue;
                if ("header".equals(key)) {
                    headerList.addAll(paramsList);
                } else {
                    bodyList.addAll(paramsList);
                }
                if (!HussarUtils.isNotEmpty(structures = WsdlStructureUtil.generatedCommonStructure(appCode, commonStructureMap, paramsList, wsdlId, hasSaved))) continue;
                commonStructures.addAll(structures);
            }
            catch (Exception e) {
                log.error("findParamsByOperation error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        listMap.put("header", headerList);
        listMap.put("body", bodyList);
        return listMap;
    }

    @Deprecated
    public static void testXpath(String wsdlUrl, String path) throws ParserConfigurationException, XPathExpressionException, IOException, SAXException, WSDLException {
        org.w3c.dom.Document document = WAWsdlUtil.getDefinitionDocument(wsdlUrl);
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node node = (Node)xpath.evaluate(path, document, XPathConstants.NODE);
        if (node != null) {
            System.out.println("ok");
        }
    }

    public static Document getDom4JDocument(Definition definition) throws BaseException {
        Document document = null;
        try {
            org.w3c.dom.Document wsdlDocument = WAWsdlUtil.getDefinitionDocument(definition);
            DOMReader xmlReader = new DOMReader();
            document = xmlReader.read(wsdlDocument);
        }
        catch (Exception e) {
            throw new BaseException("\u8bfb\u53d6document\u5931\u8d25");
        }
        return document;
    }

    public static List<String> getAllCodeNames(Document document) throws BaseException {
        List nodeList = document.selectNodes(xpathExp);
        ArrayList<String> allObejectName = new ArrayList<String>();
        for (Element el : nodeList) {
            String name = el.attributeValue("name");
            if (null == name) continue;
            allObejectName.add(name);
        }
        return allObejectName;
    }

    public static List<WsdlParams> getWsdlParams(List<String> allCodeNames, Document document) {
        ArrayList<WsdlParams> list = new ArrayList<WsdlParams>();
        for (String code : allCodeNames) {
            String node_xpath = String.format(NODE_XPATH, code);
            List nodeList = document.selectNodes(node_xpath);
            WsdlParams parentParams = new WsdlParams();
            parentParams.setName(code);
            if (nodeList != null) {
                ArrayList<WsdlParams> childlist = new ArrayList<WsdlParams>();
                for (Object o : nodeList) {
                    WsdlParams wsdlParams = new WsdlParams();
                    Element el = (Element)o;
                    String name = el.attributeValue("name");
                    wsdlParams.setName(name);
                    String minOccurs = el.attributeValue("minOccurs");
                    wsdlParams.setMinOccurs(minOccurs);
                    String maxOccurs = el.attributeValue("maxOccurs");
                    wsdlParams.setMaxOccurs(maxOccurs);
                    String type = el.attributeValue("type");
                    if (null != type && type.contains(":")) {
                        type = type.split(":")[1];
                    }
                    wsdlParams.setType(type);
                    wsdlParams.setRequired("1");
                    String childType = el.attributeValue("childType");
                    wsdlParams.setChildType(childType);
                    childlist.add(wsdlParams);
                }
                parentParams.setChildren(childlist);
            }
            list.add(parentParams);
        }
        return list;
    }

    static {
        waWsdlUtilInstance = new WAWsdlUtilInstance();
    }

    private static class WAWsdlUtilInstance {
        WAWsdlUtil waWsdlUtil = new WAWsdlUtil();

        private WAWsdlUtilInstance() {
        }
    }
}

