/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.factory.ApiVerifyFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.ApiVerifyService;
import com.jxdinfo.hussar.eai.common.util.EaiOutParamDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceTestDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceAuthenticationService;
import com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.WebServiceVerifyCommonManager;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.WebserviceVerifyServiceImpl")
public class WebserviceVerifyServiceImpl
extends WebServiceVerifyCommonManager
implements ApiVerifyService<WebServiceTestDto> {
    @Resource
    private IWebServiceAuthenticationService webServiceAuthenticationService;
    @Resource
    private IEaiApiInfoService eaiApiInfoService;
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;

    public ApiResponse<EaiApiResponseVo> verifyApi(WebServiceTestDto apiTestDto) {
        WebServiceAuthVerfiyDto webServiceAuthVerfiyDto = null;
        try {
            webServiceAuthVerfiyDto = this.fillAuthVerify(apiTestDto);
        }
        catch (Exception e) {
            EaiApiResponseVo eaiApiResponseVo = new EaiApiResponseVo();
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)e.getMessage()));
            return ApiResponse.success((Object)eaiApiResponseVo);
        }
        AssertUtil.isNotEmpty((String)apiTestDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        TempHttpCode.removeAll();
        ApiResponse response = this.webServiceAuthenticationService.apiAuthVerify(webServiceAuthVerfiyDto);
        if (HussarCacheUtil.containKey((String)webServiceAuthVerfiyDto.getDebugCacheKey(), (Object)webServiceAuthVerfiyDto.getDebugCacheKey())) {
            HussarCacheUtil.evict((String)webServiceAuthVerfiyDto.getDebugCacheKey(), (Object)webServiceAuthVerfiyDto.getDebugCacheKey());
        }
        return response;
    }

    public ApiResponse verifySavedApi(WebServiceTestDto apiTestDto) {
        ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getById((Serializable)apiTestDto.getApiId());
        if (HussarUtils.isNotEmpty((Object)apiInfo)) {
            WebServiceAuthVerfiyDto authVerifyDto;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EditApi::getApiId, (Object)apiTestDto.getApiId());
            apiTestDto.setApplicationCode(apiInfo.getApplicationCode());
            LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)apiInfo.getId());
            EaiEditApiWsdl wsdl = (EaiEditApiWsdl)this.eaiEditApiWsdlService.getOne((Wrapper)lambdaQueryWrapper);
            apiTestDto.setRealInParams(ParamsConvertUtil.toEaiParamsConvertDto((String)apiInfo.getInParams()));
            EaiOutParamDto outParamDto = new EaiOutParamDto();
            outParamDto.setBody(ParamsConvertUtil.toEaiParamsItems((String)apiInfo.getOutParams()));
            apiTestDto.setOutParams(outParamDto);
            EaiWsApiParams wsApiParams = this.wsdlParams(wsdl);
            apiTestDto.setWsApiParams(wsApiParams);
            try {
                authVerifyDto = this.fillAuthVerify(apiTestDto);
            }
            catch (Exception e) {
                EaiApiResponseVo eaiApiResponseVo = new EaiApiResponseVo();
                eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)e.getMessage()));
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
            authVerifyDto.setOutMapping(ParamsConvertUtil.toEaiParamsItems((String)apiInfo.getOutParams()));
            TempHttpCode.removeAll();
            return this.webServiceAuthenticationService.apiAuthVerify(authVerifyDto);
        }
        throw new BaseException("\u672a\u67e5\u8be2\u5230\u63a5\u53e3\u4fe1\u606f");
    }

    private EaiWsApiParams wsdlParams(EaiEditApiWsdl wsdl) {
        EaiWsApiParams wsApiParams = new EaiWsApiParams();
        wsApiParams.setId(String.valueOf(wsdl.getWsdlId()));
        wsApiParams.setAddress(wsdl.getWsdlAddress());
        wsApiParams.setServiceName(wsdl.getWsdlService());
        wsApiParams.setOperationName(wsdl.getWsdlOperation());
        wsApiParams.setPortName(wsdl.getServicePort());
        wsApiParams.setAddress(wsdl.getWsdlAddress());
        return wsApiParams;
    }

    public void afterPropertiesSet() throws Exception {
        ApiVerifyFactory.register((String)"1", (ApiVerifyService)this);
    }
}

