/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceTestDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class WebServiceVerifyCommonManager {
    protected WebServiceAuthVerfiyDto fillAuthVerify(WebServiceTestDto apiTestDto) {
        EaiParamsConvertDto eaiParamsConvertDto = new EaiParamsConvertDto();
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getInParams())) {
            if (HussarUtils.isNotEmpty((Object)apiTestDto.getInParams().getBody())) {
                eaiParamsConvertDto.setBody((EaiParamsItems)apiTestDto.getInParams().getBody().get(0));
            }
            eaiParamsConvertDto.setHeader(apiTestDto.getInParams().getHeader());
            eaiParamsConvertDto.setQuery(apiTestDto.getInParams().getQuery());
        }
        apiTestDto.setRealInParams(eaiParamsConvertDto);
        WebServiceAuthVerfiyDto authVerifyDto = (WebServiceAuthVerfiyDto)BeanUtil.copyProperties((Object)apiTestDto, WebServiceAuthVerfiyDto.class);
        if (HussarUtils.isNotEmpty((Object)authVerifyDto)) {
            authVerifyDto.setInParams(apiTestDto.getRealInParams());
        }
        Object body = apiTestDto.getBody();
        if (HussarUtils.isEmpty((Object)apiTestDto.getInParams())) {
            throw new BaseException("\u5165\u53c2\u7ed3\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> httpHeader = Collections.emptyList();
        List<Object> httpBody = Collections.emptyList();
        if (HussarUtils.isNotEmpty((Object)body)) {
            EaiApiParams obj = ParamsConvertUtil.oEaiParamsItems((Object)body, (String)JSON.toJSONString((Object)apiTestDto.getRealInParams()));
            httpHeader = this.fillParams(obj, EaiApiParamMappingEnum.HEADER.getCodeStr());
            httpBody = this.fillParams(obj, EaiApiParamMappingEnum.BODY.getCodeStr());
        } else {
            httpBody = this.fillParams(null, EaiApiParamMappingEnum.BODY.getCodeStr());
        }
        authVerifyDto.setHttpHeader(httpHeader);
        authVerifyDto.setHttpBody(httpBody);
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getOutParams())) {
            authVerifyDto.setOutMapping(apiTestDto.getOutParams().getBody());
        }
        return authVerifyDto;
    }

    private List<AuthWSDLParams> fillParams(EaiApiParams obj, String type) {
        ArrayList<AuthWSDLParams> params = new ArrayList<AuthWSDLParams>();
        if (HussarUtils.isNotEmpty((Object)obj)) {
            Object real = null;
            if (EaiApiParamMappingEnum.BODY.getCodeStr().equals(type)) {
                real = obj.getBody();
            } else if (EaiApiParamMappingEnum.HEADER.getCodeStr().equals(type)) {
                real = obj.getHeader();
            } else if (EaiApiParamMappingEnum.QUERY.getCodeStr().equals(type)) {
                real = obj.getQuery();
            }
            if (HussarUtils.isNotEmpty((Object)real)) {
                if (real instanceof Map) {
                    this.filMap((Map)real, params);
                } else {
                    AuthWSDLParams eaiHttpParamsDto = new AuthWSDLParams();
                    eaiHttpParamsDto.setName(null);
                    eaiHttpParamsDto.setKeyValue(real);
                    params.add(eaiHttpParamsDto);
                }
            }
        }
        return params;
    }

    private void filMap(Map<String, Object> map, List<AuthWSDLParams> params) {
        map.forEach((k, v) -> {
            AuthWSDLParams eaiHttpParamsDto = new AuthWSDLParams();
            eaiHttpParamsDto.setName(k);
            eaiHttpParamsDto.setKeyValue(v);
            params.add(eaiHttpParamsDto);
        });
    }
}

