/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceRequestService;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLPort;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlOperation;
import com.jxdinfo.hussar.eai.webservice.common.entity.WsdlParams;
import com.jxdinfo.hussar.eai.webservice.common.service.ISoapBuilder;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IDispatchSoapService;
import com.jxdinfo.hussar.eai.webservice.info.server.parse.WsParamsChangeUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.webServiceRequestServiceImpl")
public class WebServiceRequestServiceImpl
implements IWebServiceRequestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServiceRequestServiceImpl.class);
    @Resource
    private ISoapBuilder soapBuilder;
    @Resource
    private IWsdlInfoService wsdlInfoService;
    @Resource
    IDispatchSoapService dispatchSoapService;
    @Resource
    private IEaiAppWsdlVersionService eaiAppWsdlVersionService;

    public JSONObject getWebserviceResp(SOAPMessage soapMessage) {
        if (HussarUtils.isEmpty((Object)soapMessage)) {
            return null;
        }
        try {
            return this.soapBuilder.parseOutMessage(soapMessage);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u65e0\u6cd5\u89e3\u6790SOAP\u8fd4\u56de\u503c");
        }
    }

    public JSONObject getWebserviceResp(SOAPMessage soapMessage, List<EaiParamsItems> outMapping) {
        if (HussarUtils.isEmpty((Object)soapMessage)) {
            return null;
        }
        try {
            return this.soapBuilder.parseOutMessage(soapMessage, outMapping);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BaseException("\u65e0\u6cd5\u89e3\u6790SOAP\u8fd4\u56de\u503c");
        }
    }

    public SOAPMessage getWebserviceResp(SOAPMessage soapMessage, EaiWsApiParams wsdlParams, Boolean debug) {
        SOAPMessage result = this.dispatchSoapService.dispatchSOAP(wsdlParams, soapMessage, debug);
        if (result != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                result.writeTo((OutputStream)baos);
                String str = baos.toString();
                LOGGER.info("WebServie\u65b9\u6cd5{}\u7684\u54cd\u5e94\u62a5\u6587:{}", (Object)wsdlParams.getOperationName(), (Object)str);
                result.writeTo((OutputStream)System.out);
            }
            catch (Exception e) {
                LOGGER.error("getWebserviceResp error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return result;
    }

    public SOAPMessage getWebserviceResp(WebServiceInvokeParamsDto reqParams, EaiWsApiParams wsdlParams, Boolean debug) {
        SOAPMessage soapMessage = this.soapBuilder.buildInputMessage(reqParams);
        return this.getWebserviceResp(soapMessage, wsdlParams, debug);
    }

    public WebServiceInvokeParamsDto getWebserviceRequestParams(Map<String, List<EaiHttpParamsDto>> inParams, EaiWsApiParams wsdlParams, Boolean isPublished) {
        return this.getWebserviceRequestParams(inParams, wsdlParams, isPublished, true, false);
    }

    public WebServiceInvokeParamsDto getWebserviceRequestParams(Map<String, List<EaiHttpParamsDto>> inParams, EaiWsApiParams wsdlParams, Boolean isPublished, Boolean isApi, Boolean isToken) {
        Object obj;
        Optional<WsdlOperation> wsdlOperationOption;
        Optional<WSDLPort> wsdlPortDtoOption;
        Optional<WSDLService> wsdlServiceDtoOption;
        AssertUtil.isNotNull((Object)wsdlParams.getId(), (String)"wsdlId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)wsdlParams.getServiceName(), (String)"Service\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)wsdlParams.getPortName(), (String)"Port\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)wsdlParams.getOperationName(), (String)"Operation\u4e0d\u80fd\u4e3a\u7a7a");
        EaiAppWsdl wsdl = new EaiAppWsdl();
        if (!isPublished.booleanValue()) {
            wsdl = (EaiAppWsdl)this.wsdlInfoService.getById((Serializable)((Object)wsdlParams.getId()));
        } else {
            EaiAppWsdlVersion eaiAppWsdlVersion = (EaiAppWsdlVersion)this.eaiAppWsdlVersionService.getById((Serializable)((Object)wsdlParams.getId()));
            BeanUtil.copyProperties((Object)eaiAppWsdlVersion, (Object)wsdl);
            wsdl.setId(eaiAppWsdlVersion.getWsdlId());
        }
        WSDLinfo infoDto = (WSDLinfo)JSON.parseObject((String)wsdl.getWsdlContent(), WSDLinfo.class);
        WebServiceInvokeParamsDto reqParams = new WebServiceInvokeParamsDto();
        reqParams.setAddress(wsdlParams.getAddress());
        List list = infoDto.getWsdlServiceDtos();
        WSDLService wsdlServiceDto = null;
        if (CollectionUtil.isNotEmpty((Collection)list) && (wsdlServiceDtoOption = list.stream().filter(f -> f.getServiceName().equals(wsdlParams.getServiceName())).findFirst()).isPresent()) {
            wsdlServiceDto = wsdlServiceDtoOption.get();
        }
        WSDLPort wsdlPortDto = null;
        if (HussarUtils.isNotEmpty(wsdlServiceDto) && (wsdlPortDtoOption = wsdlServiceDto.getPorts().stream().filter(f -> f.getPortName().equals(wsdlParams.getPortName())).findFirst()).isPresent()) {
            wsdlPortDto = wsdlPortDtoOption.get();
        }
        WsdlOperation wsdlOperation = null;
        if (HussarUtils.isNotEmpty(wsdlPortDto) && (wsdlOperationOption = wsdlPortDto.getOperations().stream().filter(f -> f.getOperationName().equals(wsdlParams.getOperationName())).findFirst()).isPresent()) {
            wsdlOperation = wsdlOperationOption.get();
        }
        Map params = wsdlOperation.getInWsParams();
        wsdlServiceDto.setPorts(null);
        wsdlPortDto.setOperations(null);
        wsdlOperation.setInParams(null);
        wsdlOperation.setOutParams(null);
        reqParams.setWsdlServiceDto(wsdlServiceDto);
        reqParams.setWsdlPortDto(wsdlPortDto);
        reqParams.setWsdlOperation(wsdlOperation);
        reqParams.setSoapVersion(HussarUtils.isEmpty((Object)wsdlOperation.getSoapVersion()) ? "SOAP 1.1 Protocol" : wsdlOperation.getSoapVersion());
        HashMap<String, List<WsdlParams>> soapParams = new HashMap<String, List<WsdlParams>>();
        String paramsHeader = "header";
        if (HussarUtils.isNotEmpty(inParams.get("header"))) {
            List<EaiHttpParamsDto> headerList = null;
            if (HussarUtils.isNotEmpty(params.get(paramsHeader))) {
                List<WsdlParams> header = null;
                if (isApi.booleanValue()) {
                    headerList = inParams.get("header");
                    header = WsParamsChangeUtil.callDataParams(this.parseToMapOrList(headerList), ((WsdlParams)((List)params.get(paramsHeader)).get(0)).getChildren());
                } else {
                    obj = inParams.get("header").get(0).getKeyValue();
                    header = WsParamsChangeUtil.callDataParams(obj, ((WsdlParams)((List)params.get(paramsHeader)).get(0)).getChildren());
                }
                if (HussarUtils.isNotEmpty(header)) {
                    soapParams.put("header", header);
                }
            }
        }
        if (HussarUtils.isNotEmpty(inParams.get("body")) && HussarUtils.isNotEmpty(params.get("body"))) {
            List<EaiHttpParamsDto> bodyList = null;
            List<WsdlParams> body = null;
            if (isApi.booleanValue()) {
                bodyList = inParams.get("body");
                body = WsParamsChangeUtil.callDataParams(this.parseToMapOrList(bodyList), ((WsdlParams)((List)params.get("body")).get(0)).getChildren());
            } else {
                obj = inParams.get("body").get(0).getKeyValue();
                body = WsParamsChangeUtil.callDataParams(obj, ((WsdlParams)((List)params.get("body")).get(0)).getChildren());
            }
            if (HussarUtils.isNotEmpty(body)) {
                soapParams.put("body", body);
            }
        }
        reqParams.setInParams(soapParams);
        return reqParams;
    }

    private Object parseToMapOrList(List<EaiHttpParamsDto> headerList) {
        if (headerList.size() == 1 && HussarUtils.isEmpty((Object)headerList.get(0).getParamsNameEn())) {
            return headerList.get(0).getKeyValue();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (EaiHttpParamsDto header : headerList) {
            map.put(header.getParamsNameEn(), header.getKeyValue());
        }
        return map;
    }
}

