/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLPort;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLService;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.info.api.service.IDispatchSoapService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdlVersion;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAppWsdlVersionService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.info.server.api.service.impl.dispatchSoapServiceImpl")
public class DispatchSoapServiceImpl
implements IDispatchSoapService {
    private static final Logger LOG = LoggerFactory.getLogger(DispatchSoapServiceImpl.class);
    @Resource
    IWsdlInfoService wsdlInfoService;
    @Resource
    IEaiAppWsdlVersionService eaiAppWsdlVersionService;
    private static final String URL_ERROR = "wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a";
    private static final String SERVICE_ERROR = "wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a";
    private static final String RESPONSE_ERROR = "\u83b7\u53d6\u8fd4\u56de\u503c\u5931\u8d25:";
    private static final String PORT_ERROR = "\u672a\u627e\u5230\u6307\u5b9aPORT:";
    private static final String WSDL_ERROR = "wsdl\u89e3\u6790\u5f02\u5e38\uff01";

    public SOAPMessage dispatchSOAP(EaiWsApiParams wsdlParams, SOAPMessage soapMessage, Boolean debug) {
        EaiAppWsdl eaiAppWsdl;
        String content = null;
        String wsdlPath = null;
        if (debug.booleanValue()) {
            eaiAppWsdl = (EaiAppWsdl)this.wsdlInfoService.getById((Serializable)((Object)wsdlParams.getId()));
            content = eaiAppWsdl.getWsdlContent();
            wsdlPath = eaiAppWsdl.getWsdlPath();
        } else {
            eaiAppWsdl = (EaiAppWsdlVersion)this.eaiAppWsdlVersionService.getById((Serializable)((Object)wsdlParams.getId()));
            content = eaiAppWsdl.getWsdlContent();
            wsdlPath = eaiAppWsdl.getWsdlPath();
        }
        WSDLinfo wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)content, WSDLinfo.class);
        List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
        WSDLService wsdlServiceDto = wsdlServiceDtos.stream().filter(dto -> wsdlParams.getServiceName().equals(dto.getServiceName())).findFirst().orElse(null);
        AssertUtil.isNotNull((Object)wsdlServiceDto, (String)WSDL_ERROR);
        List ports = wsdlServiceDto.getPorts();
        String nameSpace = wsdlServiceDto.getServiceUrl();
        URL url = null;
        try {
            url = new URL(wsdlPath);
        }
        catch (Exception e) {
            LOG.error("wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)e);
            throw new BaseException("wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a" + wsdlPath);
        }
        QName qName = new QName(nameSpace, wsdlParams.getServiceName());
        javax.xml.ws.Service service = null;
        try {
            service = javax.xml.ws.Service.create((URL)url, (QName)qName);
        }
        catch (Exception ex) {
            LOG.error("wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a", (Throwable)ex);
            throw new BaseException("wsdl\u5730\u5740\u6821\u9a8c\u5931\u8d25\uff1a" + wsdlPath);
        }
        WSDLPort port = null;
        if (HussarUtils.isNotEmpty((Object)ports) && HussarUtils.isNotEmpty((Object)service)) {
            Optional<WSDLPort> portO = ports.stream().filter(p -> wsdlParams.getPortName().equals(p.getPortName())).findFirst();
            if (!portO.isPresent()) {
                throw new BaseException(PORT_ERROR + wsdlParams.getPortName());
            }
            port = portO.get();
            QName portName = new QName(port.getPortNameSpace(), wsdlParams.getPortName());
            service.addPort(portName, null, wsdlParams.getAddress());
            Dispatch dispatch = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
            try {
                return (SOAPMessage)dispatch.invoke((Object)soapMessage);
            }
            catch (Exception e) {
                LOG.error(RESPONSE_ERROR, (Throwable)e);
                String errMsg = e.getMessage();
                if (HussarUtils.isEmpty((Object)errMsg) && null != e.getCause()) {
                    errMsg = e.getCause().getMessage();
                }
                throw new BaseException(RESPONSE_ERROR + errMsg, (Throwable)e);
            }
        }
        throw new BaseException(PORT_ERROR + wsdlParams.getPortName());
    }
}

