/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);
    private static final SAXReader reader = new SAXReader();
    public static final XmlMapper xmlMapper = new XmlMapper();

    private XmlUtil() {
    }

    public static Document getRootDocumentByContent(String xml) throws DocumentException {
        return reader.read((Reader)new StringReader(xml));
    }

    public static Document getRootDocumentByUrl(String url) throws DocumentException {
        return reader.read(url);
    }

    public static String document2Xml(Document document) throws Exception {
        String result = "";
        if (document != null) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            StringWriter out = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)out, format);
            writer.write(document);
            writer.flush();
            writer.close();
            result = out.toString();
        }
        return result;
    }

    public static JSONObject xmltoJson(String xml) throws Exception {
        JSONObject jsonObject = new JSONObject();
        Document document = DocumentHelper.parseText((String)xml);
        Element root = document.getRootElement();
        XmlUtil.iterateNodes(root, jsonObject);
        return jsonObject;
    }

    public static void iterateNodes(Element node, JSONObject json) {
        String nodeName = node.getName();
        if (json.containsKey((Object)nodeName)) {
            Object Object2 = json.get((Object)nodeName);
            JSONArray array = null;
            if (Object2 instanceof JSONArray) {
                array = (JSONArray)Object2;
            } else {
                array = new JSONArray();
                array.add(Object2);
            }
            List listElement = node.elements();
            if (listElement.isEmpty()) {
                String nodeValue = node.getTextTrim();
                array.add((Object)nodeValue);
                json.put(nodeName, (Object)array);
                return;
            }
            JSONObject newJson = new JSONObject();
            for (Element e : listElement) {
                XmlUtil.iterateNodes(e, newJson);
            }
            array.add((Object)newJson);
            json.put(nodeName, (Object)array);
            return;
        }
        List listElement = node.elements();
        if (listElement.isEmpty()) {
            String nodeValue = node.getTextTrim();
            json.put(nodeName, (Object)nodeValue);
            return;
        }
        JSONObject object = new JSONObject();
        for (Element e : listElement) {
            XmlUtil.iterateNodes(e, object);
        }
        json.put(nodeName, (Object)object);
    }

    public static <T> T xmlToBean(String input, Class<T> cls) throws IOException {
        return (T)xmlMapper.readValue(input, cls);
    }

    public static String beanToXmlStr(Object input) throws IOException {
        String xmlStr = xmlMapper.writeValueAsString(input);
        return xmlStr;
    }

    public static Map<String, Object> beanToXmlStrToMap(Object input) throws IOException {
        String xmlStr = xmlMapper.writeValueAsString(input);
        Map map = (Map)xmlMapper.readValue(xmlStr, Map.class);
        return map;
    }

    public static String xmlFileToString(String fileName) {
        try {
            SAXReader saxReader = new SAXReader();
            Document tempDocument = saxReader.read(fileName);
            return tempDocument.asXML();
        }
        catch (DocumentException e) {
            LOGGER.error("\u8f6cxml\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    static {
        xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        xmlMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        xmlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        xmlMapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
        xmlMapper.enable(new MapperFeature[]{MapperFeature.USE_STD_BEAN_NAMING});
    }
}

