/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.common.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XmlBuilder {
    public static <T> String convertToXml(T obj) {
        StringWriter sw = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(obj, (Writer)sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static <T> void convertToXml(T obj, String path) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            FileWriter fw = null;
            try {
                fw = new FileWriter(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            marshaller.marshal(obj, (Writer)fw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public static <T> T xmlFileToObject(Class<T> clazz, String fileName, String xsdFileName) throws Exception {
        Object xmlObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Schema schema = XmlBuilder.createSchema(clazz, xsdFileName);
            unmarshaller.setSchema(schema);
            String xmlStr = XmlBuilder.getXmlStr(fileName);
            StringReader sr = new StringReader(xmlStr);
            xmlObject = unmarshaller.unmarshal((Reader)sr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)xmlObject;
    }

    public static <T> T convertXmlFileToObject(Class<T> clazz, String xmlPath) {
        Object xmlObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            FileReader fr = null;
            try {
                fr = new FileReader(xmlPath);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            xmlObject = unmarshaller.unmarshal((Reader)fr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return (T)xmlObject;
    }

    public static String getXmlStr(String fileName) throws IOException {
        InputStream in = XmlBuilder.class.getResourceAsStream("/" + fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StringBuilder buffer = new StringBuilder();
        String line = "";
        while ((line = br.readLine()) != null) {
            buffer.append(line);
        }
        br.close();
        return buffer.toString();
    }

    public static Schema createSchema(Class type, String xsdFileName) throws SAXException {
        URL schemaUrl = type.getClassLoader().getResource(xsdFileName);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(schemaUrl);
    }

    public static void getFileContent(Object fileInPath) throws IOException {
        String line;
        BufferedReader br = null;
        if (fileInPath == null) {
            return;
        }
        if (fileInPath instanceof String) {
            br = new BufferedReader(new FileReader((String)fileInPath));
        } else if (fileInPath instanceof InputStream) {
            br = new BufferedReader(new InputStreamReader((InputStream)fileInPath));
        }
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        br.close();
    }
}

