/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.common.util;

import com.jxdinfo.hussar.eai.webservice.common.enums.WsdlDataTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static String serialize(NodeList nodeList) throws DOMException {
        return DOMUtil.serialize(nodeList, false);
    }

    public static String serialize(Node node, boolean format) throws DOMException {
        StringWriter writer = new StringWriter();
        DOMUtil.serialize(node, format, (Writer)writer);
        return writer.toString();
    }

    public static void serialize(final Node node, boolean format, Writer writer) throws DOMException {
        if (node.getNodeType() == 9) {
            DOMUtil.serialize(node.getChildNodes(), format, writer);
        } else {
            DOMUtil.serialize(new NodeList(){

                @Override
                public Node item(int index) {
                    return node;
                }

                @Override
                public int getLength() {
                    return 1;
                }
            }, format, writer);
        }
    }

    public static String serialize(NodeList nodeList, boolean format) throws DOMException {
        StringWriter writer = new StringWriter();
        DOMUtil.serialize(nodeList, format, (Writer)writer);
        return writer.toString();
    }

    public static void serialize(NodeList nodeList, boolean format, Writer writer) throws DOMException {
        try {
            if (nodeList == null) {
                throw new IllegalArgumentException("XmlUtil.serialize(NodeList nodeList, boolean format, Writer writer)\u4e2d\u53c2\u6570nodeList\u4e3a");
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            if (format) {
                try {
                    factory.setAttribute("indent-number", new Integer(4));
                }
                catch (Exception e) {
                    throw new RuntimeException("\u8bbe\u7f6eTransformerFactory\u7684\u7f29\u8fdb\u91cf\u4e3a4\u5931\u8d25:" + e.getMessage());
                }
            }
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (DOMUtil.isTextNode(node)) {
                    writer.write(node.getNodeValue());
                    continue;
                }
                if (node.getNodeType() == 2) {
                    writer.write(((Attr)node).getValue());
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
        }
        catch (Exception e) {
            DOMException domExcep = new DOMException(15, "Unable to serailise DOM subtree.");
            domExcep.initCause(e);
            throw domExcep;
        }
    }

    public static boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public static boolean assertNodeAttributeExist(Node node, String attributeName) {
        NamedNodeMap attributeMap;
        Node attributeNode;
        boolean result = false;
        if (node != null && (attributeNode = (attributeMap = node.getAttributes()).getNamedItem(attributeName)) != null && StringUtils.isNotEmpty((CharSequence)attributeNode.getNodeValue())) {
            result = true;
        }
        return result;
    }

    public static List<Node> covertNodeListToList(NodeList nodeList) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                list.add(nodeList.item(i));
            }
        }
        return list;
    }

    public static String getAttributeValue(Node node, String attributeName) throws Exception {
        NamedNodeMap attributeMap;
        Node attributeNode;
        String attributeValue = "";
        if (node != null && (attributeNode = (attributeMap = node.getAttributes()).getNamedItem(attributeName)) != null) {
            attributeValue = attributeNode.getNodeValue();
        }
        return attributeValue;
    }

    public static String getNodeName(Node node) throws Exception {
        return DOMUtil.getAttributeValue(node, "name");
    }

    public static String getNodeType(Node node) throws Exception {
        String type = DOMUtil.getAttributeValue(node, "type");
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            if (type.indexOf(":") >= 0) {
                return type.split(":")[1];
            }
            return type;
        }
        return "";
    }

    public static String getNodeBase(Node node) throws Exception {
        String type = DOMUtil.getAttributeValue(node, "base");
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            if (type.indexOf(":") >= 0) {
                return type.split(":")[1];
            }
            return type;
        }
        return "";
    }

    public static String getNodeMaxOccurs(Node node) throws Exception {
        String val = DOMUtil.getAttributeValue(node, "maxOccurs");
        return HussarUtils.isEmpty((Object)val) ? "1" : val;
    }

    public static String getNodeMinOccurs(Node node) throws Exception {
        String val = DOMUtil.getAttributeValue(node, "minOccurs");
        return HussarUtils.isEmpty((Object)val) ? "1" : val;
    }

    public static boolean isDefaultType(Node node) throws Exception {
        boolean result = false;
        if (node != null) {
            String type = DOMUtil.getNodeType(node);
            WsdlDataTypeEnum[] defaultTypes = WsdlDataTypeEnum.values();
            for (int i = 0; i < defaultTypes.length; ++i) {
                WsdlDataTypeEnum defaultType = defaultTypes[i];
                if (!type.equals(defaultType.getType())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String isRequired(Node node) throws Exception {
        String result = "0";
        if (node != null) {
            String minOccurs = DOMUtil.getNodeMinOccurs(node);
            result = HussarUtils.isNotEmpty((Object)minOccurs) && !"unbounded".equals(minOccurs) && Integer.valueOf(minOccurs) > 1 ? "1" : "0";
        }
        return result;
    }

    public static boolean isArray(String max) {
        return max != null && !"".equals(max) && ("unbounded".equals(max) || Integer.valueOf(max) > 1);
    }

    public static boolean isArray(Node node) throws Exception {
        boolean result = false;
        if (node != null) {
            String maxOccurs = DOMUtil.getNodeMaxOccurs(node);
            result = maxOccurs != null && !"".equals(maxOccurs) && ("unbounded".equals(maxOccurs) || Integer.valueOf(maxOccurs) > 1);
        }
        return result;
    }

    public static void removeTextNode(Node root) {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int count = children.getLength();
            for (int i = count - 1; i >= 0; --i) {
                Node child = children.item(i);
                if (child.getNodeType() == 3 || child.getNodeType() == 8) {
                    child.getParentNode().removeChild(child);
                    continue;
                }
                DOMUtil.removeTextNode(child);
            }
        }
    }
}

