/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.sysapi.api.service.IApplicationImportService;
import com.jxdinfo.hussar.eai.sysapi.api.service.IApplictionManagementImportService;
import com.jxdinfo.hussar.support.secure.encrypt.utils.SM4CbcUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.sysapi.server.service.impl.ApplicationImportServiceImpl")
public class ApplicationImportServiceImpl
implements IApplicationImportService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationImportServiceImpl.class);
    @Resource
    IApplictionManagementImportService applictionManagementImportService;
    @Resource
    IHttpAuthenticationService httpAuthenticationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean eaiAppImport(byte[] content) throws IOException {
        List importEntityData;
        ByteArrayInputStream byteArrayInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String text;
            byteArrayInputStream = new ByteArrayInputStream(content);
            inputStreamReader = new InputStreamReader(byteArrayInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((text = bufferedReader.readLine()) != null) {
                stringBuilder.append(text);
            }
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        String fileContent = stringBuilder.toString();
        String decryptText = SM4CbcUtil.decrypt((String)fileContent, (String)"67828e05e5392958bf9110521b2dbf27", (String)"47f955758b3be8c31333ef6565c70115");
        if (ToolUtil.isNotEmpty((Object)decryptText)) {
            decryptText = decryptText.replaceAll("\\\\\"", "\"").replaceAll("\\\\\\\\", "\\\\");
            decryptText = decryptText.substring(1, decryptText.length() - 1);
        }
        if ((importEntityData = (List)JSON.parseObject((String)decryptText, List.class)) != null) {
            String appCode = "";
            List sysApplicationList = (List)((Map)importEntityData.get(0)).get("DATA");
            if (sysApplicationList.size() > 0) {
                appCode = ((JSONObject)sysApplicationList.get(0)).get((Object)"appCode").toString();
            }
            this.httpAuthenticationService.deleteAuthParamsByAppcode(appCode);
        }
        return this.applictionManagementImportService.importData(importEntityData);
    }
}

