/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.sysapi.api.service.IApplictionManagementImportService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractApplicationManagementImportService
implements IApplictionManagementImportService {
    public static final String TABLE_MODEL_NAME_KEY = "MODEL";
    public static final String TABLE_SERVICE_NAME_KEY = "SERVICE";
    public static final String TABLE_DATA_NAME_KEY = "DATA";

    protected Boolean importEntityData(List<Map<String, Object>> importData) {
        if (ToolUtil.isEmpty(importData)) {
            return false;
        }
        for (Map<String, Object> map : importData) {
            HussarService hussarService;
            Class<?> clazz;
            List data = (List)map.get(TABLE_DATA_NAME_KEY);
            String className = String.valueOf(map.get(TABLE_MODEL_NAME_KEY));
            try {
                clazz = Class.forName(className);
                hussarService = (HussarService)SpringContextUtil.getBean(Class.forName(map.get(TABLE_SERVICE_NAME_KEY).toString()));
            }
            catch (ClassNotFoundException e) {
                throw new HussarException("\u672a\u77e5\u7684\u6570\u636e\u7c7b\u578b\uff1a " + e.getMessage());
            }
            this.importDataList(data, clazz, hussarService);
        }
        return true;
    }

    private void importDataList(List data, Class clazz, HussarService hussarService) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : data) {
            if (obj == null) continue;
            list.add(JSONObject.parseObject((String)JSONObject.toJSONString(obj), (Class)clazz));
        }
        if (ToolUtil.isNotEmpty(list)) {
            hussarService.saveOrUpdateBatch(list);
        }
    }
}

