/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.sysapi.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.ApplicationResources;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationResourceService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IConnectionVersionService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.eai.sysapi.api.service.IApplictionManagementExportService;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;

public abstract class AbstractApplictionManagementExportService
implements IApplictionManagementExportService {
    public static final String TABLE_MODEL_NAME_KEY = "MODEL";
    public static final String TABLE_SERVICE_NAME_KEY = "SERVICE";
    public static final String TABLE_DATA_NAME_KEY = "DATA";
    public static final Integer LOGIC_TYPE_LOGIC = 1;
    @Resource
    private IHttpAuthenticationService httpAuthenticationService;
    @Resource
    private EaiApiProperties eaiApiProperties;

    protected List<Map<String, Object>> getBaseExportEntityData(List<Map<String, Object>> tableMapper, Long appId) throws ClassNotFoundException {
        if (HussarUtils.isEmpty(tableMapper)) {
            tableMapper = Lists.newArrayListWithCapacity((int)10);
        }
        HashMap app = Maps.newHashMapWithExpectedSize((int)3);
        app.put(TABLE_MODEL_NAME_KEY, SysApplication.class.getName());
        app.put(TABLE_SERVICE_NAME_KEY, ISysApplicationService.class.getName());
        HussarService applicationCommonService = (HussarService)SpringContextUtil.getBean(Class.forName(app.get(TABLE_SERVICE_NAME_KEY).toString()));
        SysApplication appModel = (SysApplication)applicationCommonService.getById((Serializable)appId);
        app.put(TABLE_DATA_NAME_KEY, ToolUtil.isEmpty((Object)appModel) ? new ArrayList() : Arrays.asList(appModel));
        HashMap appGroup = Maps.newHashMapWithExpectedSize((int)3);
        appGroup.put(TABLE_MODEL_NAME_KEY, SysAppGroup.class.getName());
        appGroup.put(TABLE_SERVICE_NAME_KEY, ISysAppGroupService.class.getName());
        HussarService sysAppGroupCommonService = (HussarService)SpringContextUtil.getBean(Class.forName(appGroup.get(TABLE_SERVICE_NAME_KEY).toString()));
        SysAppGroup sysAppGroup = (SysAppGroup)sysAppGroupCommonService.getById((Serializable)appModel.getAppGroupId());
        appGroup.put(TABLE_DATA_NAME_KEY, ToolUtil.isEmpty((Object)sysAppGroup) ? new ArrayList() : Arrays.asList(sysAppGroup));
        tableMapper.add(app);
        tableMapper.add(appGroup);
        this.assembleTeamAndClient(tableMapper, appModel);
        this.assembleHttpAuth(tableMapper, appModel);
        this.assembleCommonResource(tableMapper, appModel);
        this.assembleResourceMarket(tableMapper, appModel);
        this.assembleResourceOpen(tableMapper, appModel);
        return tableMapper;
    }

    private void assembleResourceOpen(List<Map<String, Object>> tableMapper, SysApplication appModel) throws ClassNotFoundException {
        HashMap eaiResourcesInfoMap = Maps.newHashMapWithExpectedSize((int)3);
        eaiResourcesInfoMap.put(TABLE_MODEL_NAME_KEY, EaiResourcesInfo.class.getName());
        eaiResourcesInfoMap.put(TABLE_SERVICE_NAME_KEY, IEaiResourcesInfoService.class.getName());
        HussarService eaiResourcesInfoService = (HussarService)SpringContextUtil.getBean(Class.forName(eaiResourcesInfoMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List eaiResourcesInfoList = eaiResourcesInfoService.list((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)appModel.getAppCode()));
        eaiResourcesInfoMap.put(TABLE_DATA_NAME_KEY, eaiResourcesInfoList);
        tableMapper.add(eaiResourcesInfoMap);
        HashMap apiInfoMap = Maps.newHashMapWithExpectedSize((int)3);
        apiInfoMap.put(TABLE_MODEL_NAME_KEY, ApiInfo.class.getName());
        apiInfoMap.put(TABLE_SERVICE_NAME_KEY, IEaiApiInfoService.class.getName());
        HussarService apiInfoService = (HussarService)SpringContextUtil.getBean(Class.forName(apiInfoMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List apiInfoList = apiInfoService.list((Wrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appModel.getAppCode()));
        apiInfoMap.put(TABLE_DATA_NAME_KEY, apiInfoList);
        if (HussarUtils.isNotEmpty((Object)apiInfoList)) {
            List appIds = apiInfoList.stream().map(ApiInfo::getId).collect(Collectors.toList());
            HashMap editApiMap = Maps.newHashMapWithExpectedSize((int)3);
            editApiMap.put(TABLE_MODEL_NAME_KEY, EditApi.class.getName());
            editApiMap.put(TABLE_SERVICE_NAME_KEY, IEaiEditApiService.class.getName());
            HussarService editApiService = (HussarService)SpringContextUtil.getBean(Class.forName(editApiMap.get(TABLE_SERVICE_NAME_KEY).toString()));
            List editApiList = editApiService.list((Wrapper)new LambdaQueryWrapper().in(EditApi::getApiId, appIds));
            editApiMap.put(TABLE_DATA_NAME_KEY, editApiList);
            tableMapper.add(editApiMap);
            if (LOGIC_TYPE_LOGIC.equals(this.eaiApiProperties.getLogicType())) {
                List canvasIds = editApiList.stream().map(EditApi::getCanvasId).collect(Collectors.toList());
                HashMap canvasInfoMap = Maps.newHashMapWithExpectedSize((int)3);
                canvasInfoMap.put(TABLE_MODEL_NAME_KEY, CanvasInfo.class.getName());
                canvasInfoMap.put(TABLE_SERVICE_NAME_KEY, ICanvasInfoService.class.getName());
                HussarService canvasInfoService = (HussarService)SpringContextUtil.getBean(Class.forName(canvasInfoMap.get(TABLE_SERVICE_NAME_KEY).toString()));
                List canvasInfoList = new ArrayList();
                if (ToolUtil.isNotEmpty(canvasIds)) {
                    canvasInfoList = canvasInfoService.listByIds(canvasIds);
                }
                canvasInfoMap.put(TABLE_DATA_NAME_KEY, canvasInfoList);
                tableMapper.add(canvasInfoMap);
            }
        }
        HashMap appResourceMap = Maps.newHashMapWithExpectedSize((int)3);
        appResourceMap.put(TABLE_MODEL_NAME_KEY, ApplicationResources.class.getName());
        appResourceMap.put(TABLE_SERVICE_NAME_KEY, IEaiApplicationResourceService.class.getName());
        HussarService appResourceService = (HussarService)SpringContextUtil.getBean(Class.forName(appResourceMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List appResourceList = appResourceService.list((Wrapper)new LambdaQueryWrapper().eq(ApplicationResources::getApplicationCode, (Object)appModel.getAppCode()));
        appResourceMap.put(TABLE_DATA_NAME_KEY, appResourceList);
        tableMapper.add(apiInfoMap);
        tableMapper.add(appResourceMap);
    }

    private void assembleResourceMarket(List<Map<String, Object>> tableMapper, SysApplication appModel) throws ClassNotFoundException {
        HashMap constantVersionMap = Maps.newHashMapWithExpectedSize((int)3);
        constantVersionMap.put(TABLE_MODEL_NAME_KEY, ConstantVersion.class.getName());
        constantVersionMap.put(TABLE_SERVICE_NAME_KEY, IConstantVersionService.class.getName());
        HussarService constantVersionService = (HussarService)SpringContextUtil.getBean(Class.forName(constantVersionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List constantVersionList = constantVersionService.list((Wrapper)new LambdaQueryWrapper().eq(ConstantVersion::getApplicationCode, (Object)appModel.getAppCode()));
        constantVersionMap.put(TABLE_DATA_NAME_KEY, constantVersionList);
        HashMap structureVersionMap = Maps.newHashMapWithExpectedSize((int)3);
        structureVersionMap.put(TABLE_MODEL_NAME_KEY, StructureVersion.class.getName());
        structureVersionMap.put(TABLE_SERVICE_NAME_KEY, IStructureVersionService.class.getName());
        HussarService structureVersionService = (HussarService)SpringContextUtil.getBean(Class.forName(structureVersionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List structureVersionList = structureVersionService.list((Wrapper)new LambdaQueryWrapper().eq(StructureVersion::getApplicationCode, (Object)appModel.getAppCode()));
        structureVersionMap.put(TABLE_DATA_NAME_KEY, structureVersionList);
        HashMap eaiApiVersionMap = Maps.newHashMapWithExpectedSize((int)3);
        eaiApiVersionMap.put(TABLE_MODEL_NAME_KEY, EaiApiVersion.class.getName());
        eaiApiVersionMap.put(TABLE_SERVICE_NAME_KEY, IApiVersionService.class.getName());
        HussarService eaiApiVersionService = (HussarService)SpringContextUtil.getBean(Class.forName(eaiApiVersionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List eaiApiVersionList = eaiApiVersionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApiVersion::getApplicationCode, (Object)appModel.getAppCode()));
        eaiApiVersionMap.put(TABLE_DATA_NAME_KEY, eaiApiVersionList);
        HashMap connVersionMap = Maps.newHashMapWithExpectedSize((int)3);
        connVersionMap.put(TABLE_MODEL_NAME_KEY, ConnectionVersion.class.getName());
        connVersionMap.put(TABLE_SERVICE_NAME_KEY, IConnectionVersionService.class.getName());
        HussarService connVersionService = (HussarService)SpringContextUtil.getBean(Class.forName(connVersionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List connVersionList = connVersionService.list((Wrapper)new LambdaQueryWrapper().eq(ConnectionVersion::getApplicationCode, (Object)appModel.getAppCode()));
        connVersionMap.put(TABLE_DATA_NAME_KEY, connVersionList);
        if (LOGIC_TYPE_LOGIC.equals(this.eaiApiProperties.getLogicType())) {
            HashMap logicVersionMap = Maps.newHashMapWithExpectedSize((int)3);
            logicVersionMap.put(TABLE_MODEL_NAME_KEY, LogicVersion.class.getName());
            logicVersionMap.put(TABLE_SERVICE_NAME_KEY, IEaiLogicVersionService.class.getName());
            HussarService logicVersionService = (HussarService)SpringContextUtil.getBean(Class.forName(logicVersionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
            List logicVersionList = logicVersionService.list((Wrapper)new LambdaQueryWrapper().eq(LogicVersion::getApplicationCode, (Object)appModel.getAppCode()));
            logicVersionMap.put(TABLE_DATA_NAME_KEY, logicVersionList);
            tableMapper.add(logicVersionMap);
        }
        tableMapper.add(constantVersionMap);
        tableMapper.add(structureVersionMap);
        tableMapper.add(eaiApiVersionMap);
        tableMapper.add(connVersionMap);
    }

    private void assembleCommonResource(List<Map<String, Object>> tableMapper, SysApplication appModel) throws ClassNotFoundException {
        HashMap commonConstantMap = Maps.newHashMapWithExpectedSize((int)3);
        commonConstantMap.put(TABLE_MODEL_NAME_KEY, CommonConstant.class.getName());
        commonConstantMap.put(TABLE_SERVICE_NAME_KEY, ICommonConstantService.class.getName());
        HussarService commonConstantService = (HussarService)SpringContextUtil.getBean(Class.forName(commonConstantMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List commonConstantList = commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)appModel.getAppCode()));
        commonConstantMap.put(TABLE_DATA_NAME_KEY, commonConstantList);
        HashMap commonStructureMap = Maps.newHashMapWithExpectedSize((int)3);
        commonStructureMap.put(TABLE_MODEL_NAME_KEY, CommonStructure.class.getName());
        commonStructureMap.put(TABLE_SERVICE_NAME_KEY, ICommonStructureService.class.getName());
        HussarService commonStructureService = (HussarService)SpringContextUtil.getBean(Class.forName(commonStructureMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List commonStructureList = commonStructureService.list((Wrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appModel.getAppCode()));
        commonStructureMap.put(TABLE_DATA_NAME_KEY, commonStructureList);
        HashMap commonConnectionMap = Maps.newHashMapWithExpectedSize((int)3);
        commonConnectionMap.put(TABLE_MODEL_NAME_KEY, CommonConnection.class.getName());
        commonConnectionMap.put(TABLE_SERVICE_NAME_KEY, ICommonConnectionService.class.getName());
        HussarService commonConnectionService = (HussarService)SpringContextUtil.getBean(Class.forName(commonConnectionMap.get(TABLE_SERVICE_NAME_KEY).toString()));
        List commonConnectionList = commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appModel.getAppCode()));
        commonConnectionMap.put(TABLE_DATA_NAME_KEY, commonConnectionList);
        Integer logicType = this.eaiApiProperties.getLogicType();
        if (LOGIC_TYPE_LOGIC.equals(logicType)) {
            HashMap commonLogicMap = Maps.newHashMapWithExpectedSize((int)3);
            commonLogicMap.put(TABLE_MODEL_NAME_KEY, CommonLogic.class.getName());
            commonLogicMap.put(TABLE_SERVICE_NAME_KEY, ICommonLogicService.class.getName());
            HussarService commonLogicService = (HussarService)SpringContextUtil.getBean(Class.forName(commonLogicMap.get(TABLE_SERVICE_NAME_KEY).toString()));
            List commonLogicList = commonLogicService.list((Wrapper)new LambdaQueryWrapper().eq(CommonLogic::getApplicationCode, (Object)appModel.getAppCode()));
            commonLogicMap.put(TABLE_DATA_NAME_KEY, commonLogicList);
            HashMap canvasInfoMap = Maps.newHashMapWithExpectedSize((int)3);
            List canvasIds = commonLogicList.stream().map(CommonLogic::getCanvasId).collect(Collectors.toList());
            List canvasInfoList = new ArrayList();
            canvasInfoMap.put(TABLE_MODEL_NAME_KEY, CanvasInfo.class.getName());
            canvasInfoMap.put(TABLE_SERVICE_NAME_KEY, ICanvasInfoService.class.getName());
            HussarService canvasInfoService = (HussarService)SpringContextUtil.getBean(Class.forName(canvasInfoMap.get(TABLE_SERVICE_NAME_KEY).toString()));
            if (ToolUtil.isNotEmpty(canvasIds)) {
                canvasInfoList = canvasInfoService.listByIds(canvasIds);
            }
            canvasInfoMap.put(TABLE_DATA_NAME_KEY, canvasInfoList);
            tableMapper.add(commonLogicMap);
            tableMapper.add(canvasInfoMap);
        }
        tableMapper.add(commonConstantMap);
        tableMapper.add(commonStructureMap);
        tableMapper.add(commonConnectionMap);
    }

    private void assembleTeamAndClient(List<Map<String, Object>> tableMapper, SysApplication appModel) throws ClassNotFoundException {
        HashMap appTeam = Maps.newHashMapWithExpectedSize((int)3);
        appTeam.put(TABLE_MODEL_NAME_KEY, SysAppDevelopTeam.class.getName());
        appTeam.put(TABLE_SERVICE_NAME_KEY, ISysAppDevelopTeamService.class.getName());
        HussarService sysAppDevelopTeamCommonService = (HussarService)SpringContextUtil.getBean(Class.forName(appTeam.get(TABLE_SERVICE_NAME_KEY).toString()));
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)sysAppDevelopTeamCommonService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appModel.getId()));
        appTeam.put(TABLE_DATA_NAME_KEY, ToolUtil.isEmpty((Object)sysAppDevelopTeam) ? new ArrayList() : Arrays.asList(sysAppDevelopTeam));
        HashMap appTeamMember = Maps.newHashMapWithExpectedSize((int)3);
        appTeamMember.put(TABLE_MODEL_NAME_KEY, SysAppDevelopTeamMember.class.getName());
        appTeamMember.put(TABLE_SERVICE_NAME_KEY, ISysAppDevelopTeamMemberService.class.getName());
        HussarService teamMemberCommonService = (HussarService)SpringContextUtil.getBean(Class.forName(appTeamMember.get(TABLE_SERVICE_NAME_KEY).toString()));
        List teamMemberVos = teamMemberCommonService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        appTeamMember.put(TABLE_DATA_NAME_KEY, teamMemberVos);
        HashMap appClient = Maps.newHashMapWithExpectedSize((int)3);
        appClient.put(TABLE_MODEL_NAME_KEY, SysAppClient.class.getName());
        appClient.put(TABLE_SERVICE_NAME_KEY, ISysAppClientService.class.getName());
        HussarService appClientService = (HussarService)SpringContextUtil.getBean(Class.forName(appClient.get(TABLE_SERVICE_NAME_KEY).toString()));
        List sysAppClients = appClientService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appModel.getId()));
        appClient.put(TABLE_DATA_NAME_KEY, sysAppClients);
        HashMap clientModel = Maps.newHashMapWithExpectedSize((int)3);
        List clientModelIds = sysAppClients.stream().map(SysAppClient::getClientModelId).collect(Collectors.toList());
        List clientModelList = new ArrayList();
        clientModel.put(TABLE_MODEL_NAME_KEY, SysClientModel.class.getName());
        clientModel.put(TABLE_SERVICE_NAME_KEY, ISysClientModelService.class.getName());
        HussarService clientModelService = (HussarService)SpringContextUtil.getBean(Class.forName(clientModel.get(TABLE_SERVICE_NAME_KEY).toString()));
        if (ToolUtil.isNotEmpty(clientModelIds)) {
            clientModelList = clientModelService.listByIds(clientModelIds);
        }
        clientModel.put(TABLE_DATA_NAME_KEY, clientModelList);
        HashMap authClient = Maps.newHashMapWithExpectedSize((int)3);
        List<Object> clientIds = new ArrayList();
        if (ToolUtil.isNotEmpty(clientModelList)) {
            clientIds = clientModelList.stream().map(SysClientModel::getClientId).collect(Collectors.toList());
        }
        List sysAuthClients = new ArrayList();
        authClient.put(TABLE_MODEL_NAME_KEY, SysAuthClientModel.class.getName());
        authClient.put(TABLE_SERVICE_NAME_KEY, SysAuthClientModelService.class.getName());
        HussarService authClientService = (HussarService)SpringContextUtil.getBean(Class.forName(authClient.get(TABLE_SERVICE_NAME_KEY).toString()));
        if (ToolUtil.isNotEmpty(clientIds)) {
            sysAuthClients = authClientService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysAuthClientModel::getClientId, clientIds));
        }
        authClient.put(TABLE_DATA_NAME_KEY, sysAuthClients);
        HashMap clientPermission = Maps.newHashMapWithExpectedSize((int)3);
        List clientPermissions = new ArrayList();
        clientPermission.put(TABLE_MODEL_NAME_KEY, SysClientPermission.class.getName());
        clientPermission.put(TABLE_SERVICE_NAME_KEY, ISysClientPermissionService.class.getName());
        HussarService clientPermissionService = (HussarService)SpringContextUtil.getBean(Class.forName(clientPermission.get(TABLE_SERVICE_NAME_KEY).toString()));
        if (ToolUtil.isNotEmpty(clientIds)) {
            clientPermissions = clientPermissionService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysClientPermission::getClientId, clientIds));
        }
        clientPermission.put(TABLE_DATA_NAME_KEY, clientPermissions);
        tableMapper.add(appTeam);
        tableMapper.add(appTeamMember);
        tableMapper.add(appClient);
        tableMapper.add(clientModel);
        tableMapper.add(authClient);
        tableMapper.add(clientPermission);
    }

    public void assembleHttpAuth(List<Map<String, Object>> tableMapper, SysApplication appModel) throws ClassNotFoundException {
        HashMap appAuth = Maps.newHashMapWithExpectedSize((int)3);
        appAuth.put(TABLE_MODEL_NAME_KEY, EaiApplicationAuth.class.getName());
        appAuth.put(TABLE_SERVICE_NAME_KEY, IEaiApplicationAuthService.class.getName());
        HussarService applicationAuthService = (HussarService)SpringContextUtil.getBean(Class.forName(appAuth.get(TABLE_SERVICE_NAME_KEY).toString()));
        List applicationAuthList = applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)appModel.getAppCode()));
        appAuth.put(TABLE_DATA_NAME_KEY, applicationAuthList);
        tableMapper.add(appAuth);
        ApiResponse authDtoPublished = this.httpAuthenticationService.selectHttpTemplateInfos(appModel.getAppCode(), true);
        ApiResponse authDtoNotPublished = this.httpAuthenticationService.selectHttpTemplateInfos(appModel.getAppCode(), false);
        ArrayList eaiHttpTemplates = Lists.newArrayListWithCapacity((int)2);
        ArrayList httpExtendAll = Lists.newArrayListWithCapacity((int)10);
        ArrayList eaiParamsPositionAll = Lists.newArrayListWithCapacity((int)10);
        ArrayList httpVerifyBaseListAll = Lists.newArrayListWithCapacity((int)10);
        ArrayList httpParamsListAll = Lists.newArrayListWithCapacity((int)10);
        this.getHttpAuthData(tableMapper, (ApiResponse<EaiHttpAuthDto>)authDtoPublished, eaiHttpTemplates, httpExtendAll, eaiParamsPositionAll, httpVerifyBaseListAll, httpParamsListAll);
        this.getHttpAuthData(tableMapper, (ApiResponse<EaiHttpAuthDto>)authDtoNotPublished, eaiHttpTemplates, httpExtendAll, eaiParamsPositionAll, httpVerifyBaseListAll, httpParamsListAll);
        HashMap eaiHttpTemplateMap = Maps.newHashMapWithExpectedSize((int)3);
        eaiHttpTemplateMap.put(TABLE_MODEL_NAME_KEY, EaiHttpTemplate.class.getName());
        eaiHttpTemplateMap.put(TABLE_SERVICE_NAME_KEY, IEaiHttpTemplateService.class.getName());
        eaiHttpTemplateMap.put(TABLE_DATA_NAME_KEY, eaiHttpTemplates);
        HashMap httpExtendMap = Maps.newHashMapWithExpectedSize((int)3);
        httpExtendMap.put(TABLE_MODEL_NAME_KEY, EaiHttpExtend.class.getName());
        httpExtendMap.put(TABLE_SERVICE_NAME_KEY, IEaiHttpExtendService.class.getName());
        httpExtendMap.put(TABLE_DATA_NAME_KEY, httpExtendAll);
        HashMap eaiParamsPositionMap = Maps.newHashMapWithExpectedSize((int)3);
        eaiParamsPositionMap.put(TABLE_MODEL_NAME_KEY, EaiParamsPosition.class.getName());
        eaiParamsPositionMap.put(TABLE_SERVICE_NAME_KEY, IEaiParamsPositionService.class.getName());
        eaiParamsPositionMap.put(TABLE_DATA_NAME_KEY, eaiParamsPositionAll);
        HashMap eaiHttpVerifyBaseMap = Maps.newHashMapWithExpectedSize((int)3);
        eaiHttpVerifyBaseMap.put(TABLE_MODEL_NAME_KEY, EaiHttpVerifyBase.class.getName());
        eaiHttpVerifyBaseMap.put(TABLE_SERVICE_NAME_KEY, IEaiHttpVerifyBaseService.class.getName());
        eaiHttpVerifyBaseMap.put(TABLE_DATA_NAME_KEY, httpVerifyBaseListAll);
        HashMap httpParamsMap = Maps.newHashMapWithExpectedSize((int)3);
        httpParamsMap.put(TABLE_MODEL_NAME_KEY, EaiHttpParams.class.getName());
        httpParamsMap.put(TABLE_SERVICE_NAME_KEY, IEaiHttpParamsService.class.getName());
        httpParamsMap.put(TABLE_DATA_NAME_KEY, httpParamsListAll);
        tableMapper.add(eaiHttpTemplateMap);
        tableMapper.add(httpExtendMap);
        tableMapper.add(eaiParamsPositionMap);
        tableMapper.add(eaiHttpVerifyBaseMap);
        tableMapper.add(httpParamsMap);
    }

    private void getHttpAuthData(List<Map<String, Object>> tableMapper, ApiResponse<EaiHttpAuthDto> authDtoPublished, List<EaiHttpTemplate> eaiHttpTemplates, List<EaiHttpExtend> httpExtendAll, List<EaiParamsPosition> eaiParamsPositionAll, List<EaiHttpVerifyBase> httpVerifyBaseListAll, List<EaiHttpParams> httpParamsListAll) {
        if (null != authDtoPublished.getData()) {
            eaiHttpTemplates.add(((EaiHttpAuthDto)authDtoPublished.getData()).getEaiHttpTemplate());
            if (ToolUtil.isNotEmpty((Object)((EaiHttpAuthDto)authDtoPublished.getData()).getHttpExtend())) {
                httpExtendAll.addAll(((EaiHttpAuthDto)authDtoPublished.getData()).getHttpExtend());
            }
            if (ToolUtil.isNotEmpty((Object)((EaiHttpAuthDto)authDtoPublished.getData()).getEaiParamsPosition())) {
                eaiParamsPositionAll.addAll(((EaiHttpAuthDto)authDtoPublished.getData()).getEaiParamsPosition());
            }
            if (HussarUtils.isNotEmpty((Object)((EaiHttpAuthDto)authDtoPublished.getData()).getEaiHttpVerifyDtos())) {
                for (EaiHttpVerifyDto verifyDto : ((EaiHttpAuthDto)authDtoPublished.getData()).getEaiHttpVerifyDtos()) {
                    httpVerifyBaseListAll.add(verifyDto.getHttpVerifyBase());
                    if (!ToolUtil.isNotEmpty((Object)verifyDto.getHttpParams())) continue;
                    httpParamsListAll.addAll(verifyDto.getHttpParams());
                }
            }
            if (HussarUtils.isNotEmpty((Object)((EaiHttpAuthDto)authDtoPublished.getData()).getExtendDto())) {
                Map mapperDomain = ((EaiHttpAuthDto)authDtoPublished.getData()).getMapperDomain();
                ((EaiHttpAuthDto)authDtoPublished.getData()).getExtendDto().forEach((k, v) -> {
                    HashMap extendMap = Maps.newHashMapWithExpectedSize((int)3);
                    extendMap.put(TABLE_MODEL_NAME_KEY, mapperDomain.get(k));
                    extendMap.put(TABLE_SERVICE_NAME_KEY, k);
                    extendMap.put(TABLE_DATA_NAME_KEY, v);
                    tableMapper.add(extendMap);
                });
            }
        }
    }
}

