/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.open.server.marketplace.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiSysApplicationService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApplyRecord;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.WordTemplateUtils;
import com.jxdinfo.hussar.eai.datapacket.business.api.enums.EaiDataPacketPublishStatusEnum;
import com.jxdinfo.hussar.eai.datapacket.manager.api.model.EaiDataPacketPublishInfo;
import com.jxdinfo.hussar.eai.datapacket.manager.api.service.IEaiDataPacketPublishInfoService;
import com.jxdinfo.hussar.eai.logs.api.publishlogs.service.EaiPublishLogService;
import com.jxdinfo.hussar.eai.logs.api.publishlogs.vo.PublishLogVo;
import com.jxdinfo.hussar.eai.open.api.dto.ResourceApplyDto;
import com.jxdinfo.hussar.eai.open.api.enums.ResourceTypeEnum;
import com.jxdinfo.hussar.eai.open.api.service.IEaiMarketService;
import com.jxdinfo.hussar.eai.open.api.vo.ApplicationDetailVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiApiVersionVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiDataPacketPublishInfoVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiEventVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationmarket.service.impl.EaiMarketServiceImpl")
public class EaiMarketServiceImpl
implements IEaiMarketService {
    @Value(value="${hussar.front-port:8081}")
    private int port;
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiMarketServiceImpl.class);
    @Resource
    private IApiVersionService eaiApiVersionService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IEaiApplyRecordService eaiApplyRecordService;
    @Resource
    private IEaiApplyService eaiApplyService;
    @Resource
    private EaiPublishLogService eaiPublishLogService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Autowired
    private Configuration configuration;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Resource
    private IReleaseApiService iEaiReleaseApiService;
    @Resource
    private IEaiSysApplicationService eaiSysApplicationService;
    @Autowired
    private IEaiDataPacketPublishInfoService eaiDataPacketPublishInfoService;
    private static final String ERR_MSG_DISABLED_DATA_PACKET = "";
    private static final String ERR_MSG_REPEAT_DATA_PACKET_APPLY = "\u8be5\u5e94\u7528\u5df2\u7ecf\u7533\u8bf7\u8fc7\u6b64\u6570\u636e\u5305\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7\uff01";
    private static final String ERR_MSG_REPEAT_API_APPLY = "\u8be5\u5e94\u7528\u5df2\u7ecf\u7533\u8bf7\u8fc7\u6b64\u63a5\u53e3\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7\uff01";
    private static final String BODY_STR = "body";

    public ApiResponse<ApplicationDetailVo> getApplicationDetail(String applicationCode, String resourceName) {
        ApplicationDetailVo detailVo = new ApplicationDetailVo();
        List eaiResourcesInfoBydApplyCode = this.eaiResourcesInfoService.getApplyInfoByNotDeleted(applicationCode);
        if (CollectionUtil.isEmpty((Collection)eaiResourcesInfoBydApplyCode)) {
            return ApiResponse.success((Object)detailVo);
        }
        List apiInfo = eaiResourcesInfoBydApplyCode.stream().filter(info -> "1".equals(info.getResourceType())).collect(Collectors.toList());
        List eventInfo = eaiResourcesInfoBydApplyCode.stream().filter(info -> "0".equals(info.getResourceType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(apiInfo)) {
            List eaiApiVersions;
            List eaiVersionId = apiInfo.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
            LambdaQueryWrapper apiWrapper = new LambdaQueryWrapper();
            apiWrapper.in(EaiApiVersion::getApiVersionId, eaiVersionId);
            if (StringUtil.isNotEmpty((Object)resourceName)) {
                apiWrapper.like(EaiApiVersion::getApiName, (Object)resourceName);
            }
            if (CollectionUtil.isNotEmpty((Collection)(eaiApiVersions = this.eaiApiVersionService.list((Wrapper)apiWrapper)))) {
                ArrayList eaiApiVersionVos = Lists.newArrayListWithExpectedSize((int)10);
                eaiApiVersions.forEach(e -> {
                    EaiApiVersionVo v = new EaiApiVersionVo();
                    BeanUtil.copy((Object)e, (Object)v);
                    eaiApiVersionVos.add(v);
                });
                detailVo.setEaiApiVersionList((List)eaiApiVersionVos);
            }
        }
        detailVo.setEaiDataPacketPublishInfoList(this.getDataPacketPublishInfos(applicationCode, resourceName));
        return ApiResponse.success((Object)detailVo);
    }

    private List<EaiDataPacketPublishInfoVo> getDataPacketPublishInfos(String applicationCode, String resourceName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(EaiDataPacketPublishInfo::getApplicationCode, (Object)applicationCode)).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(EaiDataPacketPublishInfo::getPublishInfoStatus, (Object)EaiDataPacketPublishStatusEnum.ENABLED.getStatus())).or()).eq(EaiDataPacketPublishInfo::getPublishInfoStatus, (Object)EaiDataPacketPublishStatusEnum.VIRTUAL_REFERENCE.getStatus());
        });
        if (HussarUtils.isNotEmpty((Object)resourceName)) {
            queryWrapper.like(EaiDataPacketPublishInfo::getPacketName, (Object)resourceName);
        }
        List publishInfoList = this.eaiDataPacketPublishInfoService.list((Wrapper)queryWrapper);
        ArrayList<EaiDataPacketPublishInfoVo> publishInfoVoList = new ArrayList<EaiDataPacketPublishInfoVo>();
        for (EaiDataPacketPublishInfo publishInfo : publishInfoList) {
            EaiDataPacketPublishInfoVo publishInfoVo = this.fillEaiDataPacketPublishInfoVo(publishInfo);
            publishInfoVoList.add(publishInfoVo);
        }
        return publishInfoVoList;
    }

    private EaiDataPacketPublishInfoVo fillEaiDataPacketPublishInfoVo(EaiDataPacketPublishInfo publishInfo) {
        EaiDataPacketPublishInfoVo publishInfoVo = new EaiDataPacketPublishInfoVo();
        publishInfoVo.setId(publishInfo.getId());
        publishInfoVo.setPacketCode(publishInfo.getPacketCode());
        publishInfoVo.setPacketName(publishInfo.getPacketName());
        publishInfoVo.setApplicationCode(publishInfo.getApplicationCode());
        publishInfoVo.setPacketDescription(publishInfo.getPacketDescription());
        publishInfoVo.setPacketScene(publishInfo.getPacketScene());
        publishInfoVo.setTableName(publishInfo.getTableName());
        return publishInfoVo;
    }

    public ApiResponse<EaiApiVersionVo> getApiDetail(Long apiVersionId) {
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.eaiApiVersionService.getById((Serializable)apiVersionId);
        EaiApiVersionVo apiVersionVo = new EaiApiVersionVo();
        BeanUtil.copy((Object)eaiApiVersion, (Object)apiVersionVo);
        List authList = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)eaiApiVersion.getApplicationCode()));
        apiVersionVo.setHeaderParamMaps(authList);
        if (StringUtil.isNotEmpty((Object)eaiApiVersion.getInParams())) {
            List itemsIn = ParamsConvertUtil.toEaiParamsItems((String)eaiApiVersion.getInParams());
            if (HussarUtils.isNotEmpty((Object)(itemsIn = this.iEaiReleaseApiService.fillValue(itemsIn))) && itemsIn.size() == 1) {
                EaiParamsItems body = (EaiParamsItems)itemsIn.get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && "Object".equals(body.getValue()) && body.getMapping() == 1) {
                    List realBody = body.getItems();
                    if (ToolUtil.isNotEmpty((Object)realBody)) {
                        apiVersionVo.setBodyParamItems(realBody);
                    }
                } else {
                    apiVersionVo.setBodyParamItems(itemsIn);
                }
            } else {
                apiVersionVo.setBodyParamItems(itemsIn);
            }
        }
        if (StringUtil.isNotEmpty((Object)eaiApiVersion.getOutParams())) {
            List out = ParamsConvertUtil.toEaiParamsItems((String)eaiApiVersion.getOutParams());
            List result = this.iEaiReleaseApiService.fillBaseOutInfo(out);
            apiVersionVo.setOutParamItems(result);
        }
        if (HussarUtils.isEmpty((Object)apiVersionVo.getContentType())) {
            apiVersionVo.setContentType(EaiContentType.APPLICATION_JSON.getName());
        } else {
            apiVersionVo.setContentType(EaiContentType.getByType((int)Integer.parseInt(apiVersionVo.getContentType())).getName());
        }
        return ApiResponse.success((Object)apiVersionVo);
    }

    public ApiResponse<EaiEventVersionVo> eventDetail(Long eventVersionId) {
        EaiEventVersionVo eaiApiVersionVo = new EaiEventVersionVo();
        return ApiResponse.success((Object)eaiApiVersionVo);
    }

    @HussarTransactional
    public ApiResponse<Boolean> resourceApply(ResourceApplyDto resourceApplyDto) {
        EaiApplyRecord applyRecord = new EaiApplyRecord();
        EaiApply apply = new EaiApply();
        Long recordId = IdWorker.getId((Object)new EaiApplyRecord());
        if (ResourceTypeEnum.DATA_PACKET.getType().equals(resourceApplyDto.getResourceType())) {
            EaiDataPacketPublishInfo publishInfo = (EaiDataPacketPublishInfo)this.eaiDataPacketPublishInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiDataPacketPublishInfo::getId, (Object)resourceApplyDto.getResourceVersionId()));
            if (EaiDataPacketPublishStatusEnum.DISABLED.getStatus() == publishInfo.getPublishInfoStatus().intValue()) {
                return ApiResponse.fail((String)ERR_MSG_DISABLED_DATA_PACKET);
            }
            if (this.checkApplyStatus(resourceApplyDto.getApplyCode(), publishInfo.getId()).booleanValue()) {
                return ApiResponse.fail((String)ERR_MSG_REPEAT_DATA_PACKET_APPLY);
            }
            applyRecord.setRecordId(recordId);
            applyRecord.setResourceId(String.valueOf(publishInfo.getId()));
            applyRecord.setResourceName(publishInfo.getPacketName());
            applyRecord.setResourceCode(publishInfo.getPacketCode());
            applyRecord.setApplicationCode(publishInfo.getApplicationCode());
            applyRecord.setApplicationName(this.applicationManagementService.getByAppCode(publishInfo.getApplicationCode()).getAppName());
            apply.setApplyType("09");
        } else {
            EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceVersionId, (Object)resourceApplyDto.getResourceVersionId()));
            if (this.checkApplyStatus(resourceApplyDto.getApplyCode(), eaiResourcesInfo.getResourceRelationId()).booleanValue()) {
                return ApiResponse.fail((String)ERR_MSG_REPEAT_API_APPLY);
            }
            applyRecord.setRecordId(recordId);
            applyRecord.setResourceId(String.valueOf(eaiResourcesInfo.getResourceRelationId()));
            applyRecord.setResourceName(eaiResourcesInfo.getResourceName());
            applyRecord.setResourceCode(eaiResourcesInfo.getResourceCode());
            applyRecord.setApplicationCode(eaiResourcesInfo.getApplicationCode());
            applyRecord.setLogVersion(resourceApplyDto.getLogVersion());
            applyRecord.setApplicationName(this.applicationManagementService.getByAppCode(eaiResourcesInfo.getApplicationCode()).getAppName());
            if ("1".equals(eaiResourcesInfo.getResourceType())) {
                apply.setApplyType("01");
            } else if ("0".equals(eaiResourcesInfo.getResourceType())) {
                apply.setApplyType("02");
            }
        }
        apply.setResourceId(String.valueOf(recordId));
        apply.setApplyCode(resourceApplyDto.getApplyCode());
        apply.setApplyName(resourceApplyDto.getApplyName());
        apply.setResourceStatus("0");
        apply.setRemark(resourceApplyDto.getApplyReason());
        apply.setApplyBy(HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getUserName() : null);
        this.eaiApplyRecordService.save((Object)applyRecord);
        this.eaiApplyService.save((Object)apply);
        return ApiResponse.success();
    }

    private Boolean checkApplyStatus(String appCode, Long resourceId) {
        List<String> resourceStatus = Arrays.asList("0", "1");
        List eaiApplyVos = this.eaiApplyService.getEaiApplyByAppCode(Collections.singletonList(appCode), String.valueOf(resourceId), resourceStatus);
        return CollectionUtil.isNotEmpty((Collection)eaiApplyVos);
    }

    public ApiResponse<List<PublishLogVo>> publishLog(String appCode) {
        return this.eaiPublishLogService.listPubLishLogDetail(appCode);
    }

    public void export(String applicationCode) {
        List eaiResourcesInfos = this.eaiResourcesInfoService.list((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)applicationCode));
        List apiVersionIds = eaiResourcesInfos.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
        List eaiApiVersions = this.eaiApiVersionService.list((Wrapper)new LambdaQueryWrapper().in(EaiApiVersion::getApiVersionId, apiVersionIds));
        if (CollectionUtil.isEmpty((Collection)eaiApiVersions)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u53d1\u5e03\u7684\u63a5\u53e3\u4fe1\u606f!");
        }
        LinkedHashMap totalMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        String applicationName = this.applicationManagementService.getByAppCode(applicationCode).getAppName();
        totalMap.put("appName", applicationName);
        List<Map<String, Object>> authMapList = this.getHeader(applicationCode);
        ArrayList apis = Lists.newArrayList();
        for (EaiApiVersion api : eaiApiVersions) {
            HashMap apiMap = Maps.newHashMapWithExpectedSize((int)10);
            apiMap.put("apiName", api.getApiName());
            apiMap.put("requestType", EaiRequestTypeEnum.getRequestTypeEnum((int)Integer.valueOf(api.getRequestType())).getType());
            apiMap.put("apiPath", api.getApiPath());
            apiMap.put("remark", api.getRemark());
            if (CollectionUtil.isNotEmpty(authMapList)) {
                apiMap.put("hParams", authMapList);
            }
            this.setParamsMapList(apiMap, "bParams", api.getInParams());
            this.setParamsMapList(apiMap, "oParams", api.getOutParams());
            apis.add(apiMap);
        }
        totalMap.put("apis", apis);
        Template template = null;
        String apiTemplate = "\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f.ftl";
        try {
            template = this.configuration.getTemplate(apiTemplate, "utf-8");
            WordTemplateUtils.export((Template)template, (Map)totalMap, (String)(applicationName + "\u63a5\u53e3\u6587\u6863"));
        }
        catch (IOException e) {
            throw new BaseException("\u83b7\u53d6\u63a5\u53e3\u6587\u6863\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    public String exportSwagger(String applicationCode) {
        String jsonStr;
        String hostAddress;
        List eaiResourcesInfos = this.eaiResourcesInfoService.list((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)applicationCode));
        List apiVersionIds = eaiResourcesInfos.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
        List eaiApiVersions = this.eaiApiVersionService.list((Wrapper)new LambdaQueryWrapper().in(EaiApiVersion::getApiVersionId, apiVersionIds));
        if (CollectionUtil.isEmpty((Collection)eaiApiVersions)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u53d1\u5e03\u7684\u63a5\u53e3\u4fe1\u606f!");
        }
        LinkedHashMap totalMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        List<Map<String, Object>> authMapList = this.getHeader(applicationCode);
        ApplicationManageVo application = this.applicationManagementService.getByAppCode(applicationCode);
        String applicationName = application.getAppName();
        totalMap.put("appName", applicationName);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode swagger = mapper.createObjectNode();
        swagger.put("swagger", "2.0");
        ObjectNode info = mapper.createObjectNode();
        info.put("title", applicationName);
        info.put("description", application.getAppDescribe());
        info.put("version", application.getAppVersion());
        swagger.set("info", (JsonNode)info);
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostAddress = localHost.getHostAddress();
        }
        catch (Exception e) {
            throw new HussarException("\u83b7\u53d6\u672c\u673aIP\u5931\u8d25", (Throwable)e);
        }
        hostAddress = hostAddress == null ? "127.0.0.1" : hostAddress;
        String host = hostAddress + ":" + this.port;
        swagger.put("host", host);
        ObjectNode paths = mapper.createObjectNode();
        LinkedHashMap<String, Object> definitionsMap = new LinkedHashMap<String, Object>();
        int i = 1;
        for (EaiApiVersion api : eaiApiVersions) {
            ObjectNode path = mapper.createObjectNode();
            ObjectNode post = mapper.createObjectNode();
            ArrayNode parameters = mapper.createArrayNode();
            post.put("summary", api.getApiName());
            post.put("description", api.getRemark());
            for (Map<String, Object> map : authMapList) {
                ObjectNode parameter = mapper.createObjectNode();
                parameter.put("in", "header");
                parameter.put("name", (String)map.get("name"));
                parameter.put("required", true);
                parameter.put("description", (String)map.get("mark"));
                parameter.put("type", EaiDataType.getEaiDataType((String)((String)map.get("type"))).getSwaggerCode());
                parameters.add((JsonNode)parameter);
            }
            if (HussarUtils.isNotEmpty((Object)api.getInParams())) {
                this.extractedBodyStructure(api, mapper, definitionsMap, parameters, i);
            }
            ObjectNode response = mapper.createObjectNode();
            ObjectNode success = mapper.createObjectNode();
            this.extractedResponseStructure(api, success, mapper, definitionsMap, i);
            response.set("200", (JsonNode)success);
            post.set("parameters", (JsonNode)parameters);
            post.set("responses", (JsonNode)response);
            path.set("post", (JsonNode)post);
            paths.set("/hussarApi" + api.getApiPath(), (JsonNode)path);
            ++i;
        }
        swagger.set("paths", (JsonNode)paths);
        swagger.set("definitions", mapper.valueToTree(definitionsMap));
        try {
            jsonStr = mapper.writeValueAsString((Object)swagger);
            System.out.println(jsonStr);
        }
        catch (JsonProcessingException e) {
            throw new HussarException(e.getMessage(), (Throwable)e);
        }
        return jsonStr;
    }

    private void extractedResponseStructure(EaiApiVersion api, ObjectNode success, ObjectMapper mapper, Map<String, Object> definitionsMap, Integer i) {
        success.put("description", "success");
        if (HussarUtils.isNotEmpty((Object)api.getOutParams())) {
            success.set("schema", (JsonNode)mapper.createObjectNode().put("$ref", "#/definitions/ResponseBody" + i));
            LinkedHashMap<String, Object> responseBody = new LinkedHashMap<String, Object>();
            LinkedHashMap properties = new LinkedHashMap();
            LinkedHashMap<String, Object> code = new LinkedHashMap<String, Object>();
            code.put("type", "integer");
            code.put("example", 10000);
            properties.put("code", code);
            LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
            message.put("type", "string");
            message.put("example", "\u64cd\u4f5c\u6210\u529f");
            message.put("description", "\u6210\u529f/\u5f02\u5e38\u63cf\u8ff0\u4fe1\u606f");
            properties.put("msg", message);
            LinkedHashMap<String, Object> successFlag = new LinkedHashMap<String, Object>();
            successFlag.put("type", "boolean");
            successFlag.put("example", true);
            successFlag.put("description", "\u64cd\u4f5c\u6210\u529f/\u5931\u8d25");
            properties.put("success", successFlag);
            if (HussarUtils.isNotEmpty((Object)api.getOutParams())) {
                LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                JSONArray dataArray = JSON.parseArray((String)api.getOutParams());
                if (!dataArray.isEmpty()) {
                    JSONObject dataObject = (JSONObject)dataArray.get(0);
                    JSONArray items = dataObject.getJSONArray("items");
                    if (items.isEmpty()) {
                        data.put("type", EaiDataType.getEaiDataType((Integer)Integer.parseInt(dataObject.getString("type"))).getSwaggerCode());
                        data.put("description", "\u8fd4\u56de\u6570\u636e");
                    } else {
                        JsonNode rootNode = null;
                        try {
                            rootNode = mapper.readTree(api.getOutParams());
                        }
                        catch (JsonProcessingException e) {
                            throw new HussarException("Swagger\u6587\u6863\u5bfc\u51fa\uff1a\u63a5\u53e3\u51fa\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                        }
                        if (rootNode.isArray()) {
                            for (JsonNode node : rootNode) {
                                definitionsMap.put("DATA" + i, this.generateDefinition(node, definitionsMap));
                            }
                        } else {
                            definitionsMap.put("DATA" + i, this.generateDefinition(rootNode, definitionsMap));
                        }
                        data.put("description", "\u8fd4\u56de\u6570\u636e");
                        data.put("$ref", "#/definitions/DATA" + i);
                    }
                    properties.put("data", data);
                }
            }
            responseBody.put("type", "object");
            responseBody.put("properties", properties);
            definitionsMap.put("ResponseBody" + i, responseBody);
        }
    }

    private void extractedBodyStructure(EaiApiVersion api, ObjectMapper mapper, Map<String, Object> definitionsMap, ArrayNode parameters, Integer i) {
        JsonNode rootNode = null;
        ObjectNode parameter = mapper.createObjectNode();
        try {
            rootNode = mapper.readTree(api.getInParams());
        }
        catch (JsonProcessingException e) {
            throw new HussarException("Swagger\u6587\u6863\u5bfc\u51fa\uff1a\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Throwable)e);
        }
        if (!rootNode.isEmpty()) {
            if (rootNode.isArray()) {
                String structureName = String.valueOf(rootNode.get(0).get("value"));
                structureName = structureName.replace("\"", ERR_MSG_DISABLED_DATA_PACKET);
                if ("7".equals(String.valueOf(rootNode.get(0).get("type"))) && !"Object".equals(structureName)) {
                    String variableName = String.valueOf(rootNode.get(0).get("name"));
                    variableName = variableName.replace("\"", ERR_MSG_DISABLED_DATA_PACKET);
                    LinkedHashMap<String, Object> wrappedDefinition = new LinkedHashMap<String, Object>();
                    LinkedHashMap properties = new LinkedHashMap();
                    LinkedHashMap<String, String> property = new LinkedHashMap<String, String>();
                    wrappedDefinition.put("type", "object");
                    property.put("$ref", "#/definitions/" + variableName);
                    properties.put(variableName, property);
                    wrappedDefinition.put("properties", properties);
                    definitionsMap.put(variableName, this.generateDefinition(rootNode.get(0), definitionsMap));
                    definitionsMap.put("BODY" + i, wrappedDefinition);
                } else {
                    for (JsonNode node : rootNode) {
                        definitionsMap.put("BODY" + i, this.generateDefinition(node, definitionsMap));
                    }
                }
            } else {
                definitionsMap.put("BODY" + i, this.generateDefinition(rootNode, definitionsMap));
            }
            parameter.put("in", BODY_STR);
            parameter.put("name", BODY_STR);
            parameter.put("required", true);
            parameter.set("schema", (JsonNode)mapper.createObjectNode().put("$ref", "#/definitions/BODY" + i));
            parameters.add((JsonNode)parameter);
        }
    }

    public Map<String, Object> generateDefinition(JsonNode node, Map<String, Object> definitions) {
        LinkedHashMap<String, Object> definition = new LinkedHashMap<String, Object>();
        definition.put("type", "object");
        if (node.has("items") && node.get("items").isArray()) {
            LinkedHashMap<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>();
            for (JsonNode item : node.get("items")) {
                if (!item.has("name")) continue;
                String name = item.path("name").asText(ERR_MSG_DISABLED_DATA_PACKET);
                int type = item.path("type").asInt(4);
                properties.put(name, this.getSwaggerType(type, item, definitions));
            }
            definition.put("properties", properties);
        }
        return definition;
    }

    private Map<String, Object> getSwaggerType(int type, JsonNode item, Map<String, Object> definitions) {
        LinkedHashMap<String, Object> typeMap = new LinkedHashMap<String, Object>();
        switch (type) {
            case 0: {
                typeMap.put("type", "boolean");
                break;
            }
            case 1: {
                typeMap.put("type", "integer");
                typeMap.put("format", "int32");
                break;
            }
            case 2: {
                typeMap.put("type", "integer");
                typeMap.put("format", "int64");
                break;
            }
            case 3: {
                typeMap.put("type", "number");
                typeMap.put("format", "double");
                break;
            }
            case 4: {
                typeMap.put("type", "string");
                break;
            }
            case 5: {
                typeMap.put("type", "string");
                typeMap.put("format", "date-time");
                break;
            }
            case 6: {
                typeMap.put("type", "array");
                JsonNode itemsNode = item.get("items");
                if (itemsNode != null && itemsNode.isArray() && itemsNode.size() > 0) {
                    typeMap.put("items", this.getSwaggerType(itemsNode.get(0).path("type").asInt(4), itemsNode.get(0), definitions));
                    break;
                }
                typeMap.put("items", new LinkedHashMap());
                break;
            }
            case 7: {
                String refType = item.path("value").asText(ERR_MSG_DISABLED_DATA_PACKET);
                if (!refType.isEmpty()) {
                    typeMap.put("$ref", "#/definitions/" + refType);
                    if (definitions.containsKey(refType)) break;
                    definitions.put(refType, this.generateDefinition(item, definitions));
                    break;
                }
                typeMap.put("type", "object");
                break;
            }
            case 8: {
                typeMap.put("type", "object");
                LinkedHashMap<String, Map<String, Object>> properties = new LinkedHashMap<String, Map<String, Object>>();
                properties.put("records", this.generateDefinition(item.get("items").get(0), definitions));
                properties.put("total", this.getSwaggerType(1, null, definitions));
                typeMap.put("properties", properties);
                break;
            }
            default: {
                typeMap.put("type", "string");
            }
        }
        return typeMap;
    }

    public ApiResponse<SysApplicationVo> appDetailNoVerification(Long appId) {
        return this.eaiSysApplicationService.getAppDetailNoVerification(appId);
    }

    private List<Map<String, Object>> getHeader(String applicationCode) {
        List authList = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode));
        ArrayList authMapList = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty((Collection)authList)) {
            for (EaiApplicationAuth auth : authList) {
                LinkedHashMap authMap = Maps.newLinkedHashMapWithExpectedSize((int)5);
                authMap.put("name", auth.getParamsNameEn());
                authMap.put("type", EaiDataType.getEaiDataType((Integer)Integer.parseInt(auth.getParamsType())).getCode());
                authMap.put("required", "\u662f");
                authMap.put("mark", auth.getRemark());
                authMapList.add(authMap);
            }
        }
        return authMapList;
    }

    private void setParamsMapList(Map<String, Object> apiMap, String mapKey, String paramsStr) {
        List itemsIn;
        if (HussarUtils.isNotEmpty((Object)paramsStr) && CollectionUtil.isNotEmpty((Collection)(itemsIn = ParamsConvertUtil.toEaiParamsItems((String)paramsStr)))) {
            ArrayList paramsMapList = Lists.newArrayListWithCapacity((int)10);
            this.getEaiParamsItemsMap(paramsMapList, new StringBuilder(), itemsIn);
            apiMap.put(mapKey, paramsMapList);
        }
    }

    public void getEaiParamsItemsMap(List<Map<String, Object>> bodyMapList, StringBuilder trimStr, List<EaiParamsItems> items) {
        for (EaiParamsItems itemChild : items) {
            String substring;
            if (null == itemChild.getType()) continue;
            LinkedHashMap itemChildMap = Maps.newLinkedHashMapWithExpectedSize((int)5);
            itemChildMap.put("name", trimStr.toString() + itemChild.getMappingName());
            String type = EaiDataType.getEaiDataType((Integer)itemChild.getType()).getCode();
            if (itemChild.getType().intValue() == EaiDataType.DATA_TYPE_LIST.getType()) {
                type = EaiDataType.DATA_TYPE_LIST.getCode() + "&lt;" + EaiDataType.getEaiDataType((Integer)itemChild.getItemType()).getCode() + "&gt;";
            }
            itemChildMap.put("type", type);
            String required = "\u5426";
            if (null != itemChild.getRequired() && itemChild.getRequired() == 0) {
                required = "\u662f";
            }
            itemChildMap.put("required", required);
            itemChildMap.put("mark", itemChild.getMark());
            bodyMapList.add(itemChildMap);
            if (itemChild.getType().intValue() == EaiDataType.DATA_TYPE_LIST.getType() && itemChild.getItemType().intValue() == EaiDataType.DATA_TYPE_STRUCTURE.getType()) {
                trimStr = trimStr.append("    ");
                this.getEaiParamsItemsMap(bodyMapList, trimStr, itemChild.getItems());
                substring = trimStr.toString().substring(0, trimStr.toString().length() - 4);
                trimStr.setLength(0);
                trimStr.append(substring);
                continue;
            }
            if (itemChild.getType().intValue() != EaiDataType.DATA_TYPE_STRUCTURE.getType()) continue;
            trimStr = trimStr.append("    ");
            this.getEaiParamsItemsMap(bodyMapList, trimStr, itemChild.getItems());
            substring = trimStr.toString().substring(0, trimStr.toString().length() - 4);
            trimStr.setLength(0);
            trimStr.append(substring);
        }
    }
}

