/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.open.server.marketplace.controller;

import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.eai.logs.api.publishlogs.vo.PublishLogVo;
import com.jxdinfo.hussar.eai.open.api.dto.ResourceApplyDto;
import com.jxdinfo.hussar.eai.open.api.service.IEaiMarketService;
import com.jxdinfo.hussar.eai.open.api.vo.ApplicationDetailVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiApiVersionVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiEventVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8d44\u6e90\u5e02\u573a"})
@RestController(value="com.jxdinfo.hussar.eai.server.applicationmarket.controller.EaiMarketController")
@RequestMapping(value={"/eai/application/market"})
public class EaiMarketController {
    @Resource
    private IEaiMarketService eaiMarketService;

    @ApiOperation(value="\u67e5\u770b\u5e94\u7528\u8be6\u60c5", notes="\u67e5\u770b\u5e94\u7528\u8be6\u60c5")
    @GetMapping(value={"/applicationDetail"})
    public ApiResponse<ApplicationDetailVo> getApplicationDetail(@ApiParam(value="\u5e94\u7528\u6807\u8bc6") @RequestParam(value="applicationCode") String applicationCode, @ApiParam(value="\u8d44\u6e90\u540d\u79f0") @RequestParam(value="resourceName") String resourceName) {
        return this.eaiMarketService.getApplicationDetail(applicationCode, resourceName);
    }

    @ApiOperation(value="\u67e5\u770b\u5e94\u7528\u57fa\u672c\u4fe1\u606f-\u65e0\u56e2\u961f\u6210\u5458\u6743\u9650\u9650\u5236", notes="\u67e5\u770b\u5e94\u7528\u57fa\u672c\u4fe1\u606f-\u65e0\u56e2\u961f\u6210\u5458\u6743\u9650\u9650\u5236")
    @GetMapping(value={"/applicationBaseInfoByAppId"})
    public ApiResponse<SysApplicationVo> applicationBaseInfoByAppId(@ApiParam(value="\u5e94\u7528ID") @RequestParam(value="appId") Long appId) {
        return this.eaiMarketService.appDetailNoVerification(appId);
    }

    @ApiOperation(value="\u5f00\u653e\u63a5\u53e3\u8be6\u60c5", notes="\u5f00\u653e\u63a5\u53e3\u8be6\u60c5")
    @GetMapping(value={"/apiDetail"})
    public ApiResponse<EaiApiVersionVo> getApiDetail(@ApiParam(value="\u63a5\u53e3\u7248\u672cID") @RequestParam(value="apiVersionId") Long apiVersionId) {
        return this.eaiMarketService.getApiDetail(apiVersionId);
    }

    @ApiOperation(value="\u5f00\u653e\u4e8b\u4ef6\u8be6\u60c5", notes="\u5f00\u653e\u4e8b\u4ef6\u8be6\u60c5")
    @GetMapping(value={"/eventDetail"})
    public ApiResponse<EaiEventVersionVo> eventDetail(@ApiParam(value="\u4e8b\u4ef6\u7248\u672cID") @RequestParam(value="apiVersionId") Long eventVersionId) {
        return this.eaiMarketService.eventDetail(eventVersionId);
    }

    @ApiOperation(value="\u8d44\u6e90\u7533\u8bf7", notes="\u8d44\u6e90\u7533\u8bf7")
    @PostMapping(value={"/resourceApply"})
    public ApiResponse<Boolean> resourceApply(@ApiParam(value="\u7533\u8bf7\u4f7f\u7528DTO") @RequestBody ResourceApplyDto resourceApplyDto) {
        return this.eaiMarketService.resourceApply(resourceApplyDto);
    }

    @ApiOperation(value="\u53d1\u5e03\u65e5\u5fd7\u67e5\u8be2", notes="\u53d1\u5e03\u65e5\u5fd7\u67e5\u8be2")
    @GetMapping(value={"/publishLog"})
    public ApiResponse<List<PublishLogVo>> publishLog(@ApiParam(value="\u5e94\u7528\u6807\u8bc6") @RequestParam(value="appCode") String appCode) {
        return this.eaiMarketService.publishLog(appCode);
    }

    @ApiOperation(value="\u63a5\u53e3\u6587\u6863\u5bfc\u51fa", notes="\u63a5\u53e3\u6587\u6863\u5bfc\u51fa")
    @GetMapping(value={"/export"})
    public void export(@ApiParam(value="applicationCode") String applicationCode) {
        this.eaiMarketService.export(applicationCode);
    }

    @ApiOperation(value="\u63a5\u53e3\u6587\u6863\u5bfc\u51faSwagger", notes="\u63a5\u53e3\u6587\u6863\u5bfc\u51faSwagger")
    @GetMapping(value={"/exportSwagger"})
    public String exportSwagger(@ApiParam(value="applicationCode") String applicationCode) {
        return this.eaiMarketService.exportSwagger(applicationCode);
    }
}

