/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.open.server.marketplace.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiSysApplicationService;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApplyRecord;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.WordTemplateUtils;
import com.jxdinfo.hussar.eai.logs.api.publishlogs.service.EaiPublishLogService;
import com.jxdinfo.hussar.eai.logs.api.publishlogs.vo.PublishLogVo;
import com.jxdinfo.hussar.eai.open.api.dto.ResourceApplyDto;
import com.jxdinfo.hussar.eai.open.api.service.IEaiMarketService;
import com.jxdinfo.hussar.eai.open.api.vo.ApplicationDetailVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiApiVersionVo;
import com.jxdinfo.hussar.eai.open.api.vo.EaiEventVersionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationmarket.service.impl.EaiMarketServiceImpl")
public class EaiMarketServiceImpl
implements IEaiMarketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiMarketServiceImpl.class);
    @Resource
    private IApiVersionService eaiApiVersionService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IEaiApplyRecordService eaiApplyRecordService;
    @Resource
    private IEaiApplyService eaiApplyService;
    @Resource
    private EaiPublishLogService eaiPublishLogService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Autowired
    private Configuration configuration;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Resource
    private IReleaseApiService iEaiReleaseApiService;
    @Resource
    private IEaiSysApplicationService eaiSysApplicationService;
    private static final String BODY_STR = "body";

    public ApiResponse<ApplicationDetailVo> getApplicationDetail(String applicationCode, String resourceName) {
        ApplicationDetailVo detailVo = new ApplicationDetailVo();
        List eaiResourcesInfoBydApplyCode = this.eaiResourcesInfoService.getApplyInfoByNotDeleted(applicationCode);
        if (CollectionUtil.isEmpty((Collection)eaiResourcesInfoBydApplyCode)) {
            return ApiResponse.success((Object)detailVo);
        }
        List apiInfo = eaiResourcesInfoBydApplyCode.stream().filter(info -> "1".equals(info.getResourceType())).collect(Collectors.toList());
        List eventInfo = eaiResourcesInfoBydApplyCode.stream().filter(info -> "0".equals(info.getResourceType())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(apiInfo)) {
            List eaiApiVersions;
            List eaiVersionId = apiInfo.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
            LambdaQueryWrapper apiWrapper = new LambdaQueryWrapper();
            apiWrapper.in(EaiApiVersion::getApiVersionId, eaiVersionId);
            if (StringUtil.isNotEmpty((Object)resourceName)) {
                apiWrapper.like(EaiApiVersion::getApiName, (Object)resourceName);
            }
            if (CollectionUtil.isNotEmpty((Collection)(eaiApiVersions = this.eaiApiVersionService.list((Wrapper)apiWrapper)))) {
                ArrayList eaiApiVersionVos = Lists.newArrayListWithExpectedSize((int)10);
                eaiApiVersions.forEach(e -> {
                    EaiApiVersionVo v = new EaiApiVersionVo();
                    BeanUtil.copy((Object)e, (Object)v);
                    eaiApiVersionVos.add(v);
                });
                detailVo.setEaiApiVersionList((List)eaiApiVersionVos);
            }
        }
        return ApiResponse.success((Object)detailVo);
    }

    public ApiResponse<EaiApiVersionVo> getApiDetail(Long apiVersionId) {
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.eaiApiVersionService.getById((Serializable)apiVersionId);
        EaiApiVersionVo apiVersionVo = new EaiApiVersionVo();
        BeanUtil.copy((Object)eaiApiVersion, (Object)apiVersionVo);
        List authList = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)eaiApiVersion.getApplicationCode()));
        apiVersionVo.setHeaderParamMaps(authList);
        if (StringUtil.isNotEmpty((Object)eaiApiVersion.getInParams())) {
            List itemsIn = ParamsConvertUtil.toEaiParamsItems((String)eaiApiVersion.getInParams());
            if (HussarUtils.isNotEmpty((Object)(itemsIn = this.iEaiReleaseApiService.fillValue(itemsIn))) && itemsIn.size() == 1) {
                EaiParamsItems body = (EaiParamsItems)itemsIn.get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && "Object".equals(body.getValue()) && body.getMapping() == 1) {
                    List realBody = body.getItems();
                    if (ToolUtil.isNotEmpty((Object)realBody)) {
                        apiVersionVo.setBodyParamItems(realBody);
                    }
                } else {
                    apiVersionVo.setBodyParamItems(itemsIn);
                }
            } else {
                apiVersionVo.setBodyParamItems(itemsIn);
            }
        }
        if (StringUtil.isNotEmpty((Object)eaiApiVersion.getOutParams())) {
            List out = ParamsConvertUtil.toEaiParamsItems((String)eaiApiVersion.getOutParams());
            List result = this.iEaiReleaseApiService.fillBaseOutInfo(out);
            apiVersionVo.setOutParamItems(result);
        }
        if (HussarUtils.isEmpty((Object)apiVersionVo.getContentType())) {
            apiVersionVo.setContentType(EaiContentType.APPLICATION_JSON.getName());
        } else {
            apiVersionVo.setContentType(EaiContentType.getByType((int)Integer.parseInt(apiVersionVo.getContentType())).getName());
        }
        return ApiResponse.success((Object)apiVersionVo);
    }

    public ApiResponse<EaiEventVersionVo> eventDetail(Long eventVersionId) {
        EaiEventVersionVo eaiApiVersionVo = new EaiEventVersionVo();
        return ApiResponse.success((Object)eaiApiVersionVo);
    }

    @HussarTransactional
    public ApiResponse<Boolean> resourceApply(ResourceApplyDto resourceApplyDto) {
        EaiApplyRecord applyRecord = new EaiApplyRecord();
        EaiApply apply = new EaiApply();
        EaiResourcesInfo eaiResourcesInfo = (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getResourceVersionId, (Object)resourceApplyDto.getResourceVersionId()));
        List<String> resourceStatus = Arrays.asList("0", "1");
        List eaiApplyVos = this.eaiApplyService.getEaiApplyByAppCode(Arrays.asList(resourceApplyDto.getApplyCode()), eaiResourcesInfo.getResourceRelationId(), resourceStatus);
        if (CollectionUtil.isNotEmpty((Collection)eaiApplyVos)) {
            return ApiResponse.fail((String)"\u8be5\u5e94\u7528\u5df2\u7ecf\u7533\u8bf7\u8fc7\u6b64\u63a5\u53e3\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7\uff01");
        }
        Long recordId = IdWorker.getId((Object)new EaiApplyRecord());
        applyRecord.setRecordId(recordId);
        applyRecord.setResourceId(String.valueOf(eaiResourcesInfo.getResourceRelationId()));
        applyRecord.setResourceName(eaiResourcesInfo.getResourceName());
        applyRecord.setResourceCode(eaiResourcesInfo.getResourceCode());
        applyRecord.setApplicationCode(eaiResourcesInfo.getApplicationCode());
        applyRecord.setLogVersion(resourceApplyDto.getLogVersion());
        applyRecord.setApplicationName(this.applicationManagementService.getByAppCode(eaiResourcesInfo.getApplicationCode()).getAppName());
        if ("1".equals(eaiResourcesInfo.getResourceType())) {
            apply.setApplyType("01");
        } else if ("0".equals(eaiResourcesInfo.getResourceType())) {
            apply.setApplyType("02");
        }
        apply.setResourceId(String.valueOf(recordId));
        apply.setApplyCode(resourceApplyDto.getApplyCode());
        apply.setApplyName(resourceApplyDto.getApplyName());
        apply.setResourceStatus("0");
        apply.setRemark(resourceApplyDto.getApplyReason());
        apply.setApplyBy(BaseSecurityUtil.getUser().getUserName());
        this.eaiApplyRecordService.save((Object)applyRecord);
        this.eaiApplyService.save((Object)apply);
        return ApiResponse.success();
    }

    public ApiResponse<List<PublishLogVo>> publishLog(String appCode) {
        return this.eaiPublishLogService.listPubLishLogDetail(appCode);
    }

    public void export(String applicationCode) {
        List eaiResourcesInfos = this.eaiResourcesInfoService.list((Wrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getApplicationCode, (Object)applicationCode));
        List apiVersionIds = eaiResourcesInfos.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList());
        List eaiApiVersions = this.eaiApiVersionService.list((Wrapper)new LambdaQueryWrapper().in(EaiApiVersion::getApiVersionId, apiVersionIds));
        if (CollectionUtil.isEmpty((Collection)eaiApiVersions)) {
            throw new BaseException("\u8be5\u5e94\u7528\u6ca1\u6709\u53d1\u5e03\u7684\u63a5\u53e3\u4fe1\u606f!");
        }
        LinkedHashMap totalMap = Maps.newLinkedHashMapWithExpectedSize((int)10);
        String applicationName = this.applicationManagementService.getByAppCode(applicationCode).getAppName();
        totalMap.put("appName", applicationName);
        List<Map<String, Object>> authMapList = this.getHeader(applicationCode);
        ArrayList apis = Lists.newArrayList();
        for (EaiApiVersion api : eaiApiVersions) {
            HashMap apiMap = Maps.newHashMapWithExpectedSize((int)10);
            apiMap.put("apiName", api.getApiName());
            apiMap.put("requestType", EaiRequestTypeEnum.getRequestTypeEnum((int)Integer.valueOf(api.getRequestType())).getType());
            apiMap.put("apiPath", api.getApiPath());
            apiMap.put("remark", api.getRemark());
            if (CollectionUtil.isNotEmpty(authMapList)) {
                apiMap.put("hParams", authMapList);
            }
            this.setParamsMapList(apiMap, "bParams", api.getInParams());
            this.setParamsMapList(apiMap, "oParams", api.getOutParams());
            apis.add(apiMap);
        }
        totalMap.put("apis", apis);
        Template template = null;
        String apiTemplate = "\u5e94\u7528\u63a5\u53e3\u8be6\u60c5\u6a21\u677f.ftl";
        try {
            template = this.configuration.getTemplate(apiTemplate, "utf-8");
            WordTemplateUtils.export((Template)template, (Map)totalMap, (String)(applicationName + "\u63a5\u53e3\u6587\u6863"));
        }
        catch (IOException e) {
            throw new BaseException("\u83b7\u53d6\u63a5\u53e3\u6587\u6863\u6a21\u677f\u5931\u8d25\uff01");
        }
    }

    public ApiResponse<SysApplicationVo> appDetailNoVerification(Long appId) {
        return this.eaiSysApplicationService.getAppDetailNoVerification(appId);
    }

    private List<Map<String, Object>> getHeader(String applicationCode) {
        List authList = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode));
        ArrayList authMapList = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty((Collection)authList)) {
            for (EaiApplicationAuth auth : authList) {
                LinkedHashMap authMap = Maps.newLinkedHashMapWithExpectedSize((int)5);
                authMap.put("name", auth.getParamsNameEn());
                authMap.put("type", EaiDataType.getEaiDataType((Integer)Integer.parseInt(auth.getParamsType())).getCode());
                authMap.put("required", "\u662f");
                authMap.put("mark", auth.getRemark());
                authMapList.add(authMap);
            }
        }
        return authMapList;
    }

    private void setParamsMapList(Map<String, Object> apiMap, String mapKey, String paramsStr) {
        List itemsIn;
        if (HussarUtils.isNotEmpty((Object)paramsStr) && CollectionUtil.isNotEmpty((Collection)(itemsIn = ParamsConvertUtil.toEaiParamsItems((String)paramsStr)))) {
            ArrayList paramsMapList = Lists.newArrayListWithCapacity((int)10);
            this.getEaiParamsItemsMap(paramsMapList, new StringBuilder(), itemsIn);
            apiMap.put(mapKey, paramsMapList);
        }
    }

    public void getEaiParamsItemsMap(List<Map<String, Object>> bodyMapList, StringBuilder trimStr, List<EaiParamsItems> items) {
        for (EaiParamsItems itemChild : items) {
            String substring;
            if (null == itemChild.getType()) continue;
            LinkedHashMap itemChildMap = Maps.newLinkedHashMapWithExpectedSize((int)5);
            itemChildMap.put("name", trimStr.toString() + itemChild.getMappingName());
            String type = EaiDataType.getEaiDataType((Integer)itemChild.getType()).getCode();
            if (itemChild.getType().intValue() == EaiDataType.DATA_TYPE_LIST.getType()) {
                type = EaiDataType.DATA_TYPE_LIST.getCode() + "&lt;" + EaiDataType.getEaiDataType((Integer)itemChild.getItemType()).getCode() + "&gt;";
            }
            itemChildMap.put("type", type);
            String required = "\u5426";
            if (null != itemChild.getRequired() && itemChild.getRequired() == 0) {
                required = "\u662f";
            }
            itemChildMap.put("required", required);
            itemChildMap.put("mark", itemChild.getMark());
            bodyMapList.add(itemChildMap);
            if (itemChild.getType().intValue() == EaiDataType.DATA_TYPE_LIST.getType() && itemChild.getItemType().intValue() == EaiDataType.DATA_TYPE_STRUCTURE.getType()) {
                trimStr = trimStr.append("    ");
                this.getEaiParamsItemsMap(bodyMapList, trimStr, itemChild.getItems());
                substring = trimStr.toString().substring(0, trimStr.toString().length() - 4);
                trimStr.setLength(0);
                trimStr.append(substring);
                continue;
            }
            if (itemChild.getType().intValue() != EaiDataType.DATA_TYPE_STRUCTURE.getType()) continue;
            trimStr = trimStr.append("    ");
            this.getEaiParamsItemsMap(bodyMapList, trimStr, itemChild.getItems());
            substring = trimStr.toString().substring(0, trimStr.toString().length() - 4);
            trimStr.setLength(0);
            trimStr.append(substring);
        }
    }
}

