/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.resourceenhancements.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.resourceenhancements.server.service.impl.EaiCanvaParamsConvertServiceImpl")
public class EaiCanvaParamsConvertServiceImpl
implements IEaiCanvaParamsConvertService {
    @Resource
    ICommonStructureService structureService;

    public String convertInParamsStr(String appCode, String code, List<EaiParamsItems> paramsConvertDto) {
        List<EaiParamsItems> list = this.convertInParams(appCode, code, paramsConvertDto);
        if (HussarUtils.isNotEmpty(list)) {
            return JSONObject.toJSONString((Object)JSON.toJSON(list));
        }
        return null;
    }

    public String convertEditOutBodyParamsStr(String bodyInParams) {
        List paramsItems = JSONObject.parseArray((String)bodyInParams, EaiParamsItems.class);
        EaiParamsConvertDto paramsConvertDto = new EaiParamsConvertDto();
        paramsConvertDto.setBody((EaiParamsItems)paramsItems.get(0));
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)paramsConvertDto));
    }

    public String convertEditInBodyParamsStr(String bodyInParams) {
        List paramsItems = JSONObject.parseArray((String)bodyInParams, EaiParamsItems.class);
        EaiParamsConvertDto paramsConvertDto = new EaiParamsConvertDto();
        paramsConvertDto.setBody((EaiParamsItems)paramsItems.get(0));
        paramsConvertDto.setHeader(new ArrayList(0));
        paramsConvertDto.setQuery(new ArrayList(0));
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)paramsConvertDto));
    }

    public List<EaiParamsItems> convertInParams(String appCode, String code, List<EaiParamsItems> paramsConvertDto) {
        if (null != paramsConvertDto && CollectionUtil.isNotEmpty(paramsConvertDto)) {
            paramsConvertDto.forEach(this::fillEaiParamsItemsMark);
            ArrayList<EaiParamsItems> bodyItems = new ArrayList<EaiParamsItems>();
            EaiParamsItems requestItemsBody = new EaiParamsItems();
            requestItemsBody.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
            requestItemsBody.setName(EaiApiParamMappingEnum.BODY.getKey());
            requestItemsBody.setMappingName(EaiApiParamMappingEnum.BODY.getKey());
            if (1 == paramsConvertDto.size()) {
                EaiParamsItems bodyItem = paramsConvertDto.get(0);
                requestItemsBody.setType(bodyItem.getType());
                if (Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()).equals(bodyItem.getType())) {
                    requestItemsBody.setQuoteStructureId(bodyItem.getQuoteStructureId());
                    List<EaiParamsItems> item = this.convertParams(bodyItem.getItems());
                    bodyItem.setItems(item);
                    requestItemsBody.setValue("\u6570\u636e\u7ed3\u6784");
                    paramsConvertDto.set(0, bodyItem);
                } else if (EaiDataType.DATA_TYPE_LIST.getType() == bodyItem.getType().intValue()) {
                    requestItemsBody.setItemType(((EaiParamsItems)bodyItem.getItems().get(0)).getType());
                    if (HussarUtils.isNotEmpty((Object)bodyItem.getItems())) {
                        List<EaiParamsItems> item = this.convertParams(bodyItem.getItems());
                        bodyItem.setItems(item);
                    }
                    requestItemsBody.setValue("6");
                    paramsConvertDto.set(0, bodyItem);
                } else {
                    this.createNewStruct(appCode, code, paramsConvertDto, requestItemsBody);
                }
            } else {
                this.createNewStruct(appCode, code, paramsConvertDto, requestItemsBody);
            }
            requestItemsBody.setItems(paramsConvertDto);
            bodyItems.add(requestItemsBody);
            return bodyItems;
        }
        return null;
    }

    private void createNewStruct(String appCode, String code, List<EaiParamsItems> paramsConvertDto, EaiParamsItems requestItemsBody) {
        Long id = this.addDefaultItem(appCode, code, paramsConvertDto);
        requestItemsBody.setQuoteStructureId(String.valueOf(id));
        requestItemsBody.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
        paramsConvertDto.forEach(paramsItems -> {
            if (HussarUtils.isNotEmpty((Object)paramsItems.getItems()) && 1 == paramsItems.getItems().size()) {
                EaiParamsItems bodyItem = (EaiParamsItems)paramsItems.getItems().get(0);
                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue()) {
                    paramsItems.setItemType(bodyItem.getType());
                    List<EaiParamsItems> item = this.convertParams(paramsItems.getItems());
                    paramsItems.setItems(item);
                }
            }
        });
        requestItemsBody.setValue("Object");
    }

    private void convertItems(List<EaiParamsItems> paramsConvertDto, List<StructureItems> structureItems) {
        paramsConvertDto.forEach(paramsItems -> {
            StructureItems structureItem = new StructureItems();
            structureItem.setItemType(paramsItems.getItemType());
            structureItem.setName(paramsItems.getMappingName());
            structureItem.setNickName(paramsItems.getMappingName());
            structureItem.setMark(paramsItems.getMark());
            structureItem.setType(paramsItems.getType());
            if (HussarUtils.isNotEmpty((Object)paramsItems.getItems())) {
                ArrayList<StructureItems> child = new ArrayList<StructureItems>();
                this.convertItems(paramsItems.getItems(), child);
                structureItem.setItems(child);
                structureItems.add(structureItem);
            }
        });
    }

    public Long addDefaultItem(String appCode, String code, List<EaiParamsItems> paramsConvertDto) {
        CommonStructure commonStructure = new CommonStructure();
        commonStructure.setApplicationCode(appCode);
        commonStructure.setStructureCode(String.format("2023canvas%s", code));
        Long id = IdGenerateUtils.getId();
        commonStructure.setId(id);
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        commonStructure.setCreateBy(userDetails.getUserName());
        commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
        commonStructure.setEditBy(userDetails.getUserName());
        commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
        commonStructure.setRemark("\u5165\u53c2");
        commonStructure.setName("\u5165\u53c2\u6570\u636e\u7ed3\u6784\uff08default\uff09");
        commonStructure.setDesc("\u753b\u5e03\u5165\u53c2\u7ed3\u6784");
        ArrayList<StructureItems> structureItems = new ArrayList<StructureItems>();
        this.convertItems(paramsConvertDto, structureItems);
        commonStructure.setStructureValues(JSONObject.toJSONString(structureItems));
        this.structureService.save((Object)commonStructure);
        return id;
    }

    private List<EaiParamsItems> convertParams(List<EaiParamsItems> paramsConvertDto) {
        if (null != paramsConvertDto && CollectionUtil.isNotEmpty(paramsConvertDto)) {
            paramsConvertDto.forEach(paramsItems -> {
                if (HussarUtils.isNotEmpty((Object)paramsItems.getItems()) && 1 == paramsItems.getItems().size()) {
                    EaiParamsItems bodyItem = (EaiParamsItems)paramsItems.getItems().get(0);
                    if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue()) {
                        paramsItems.setItemType(bodyItem.getType());
                        List<EaiParamsItems> item = this.convertParams(paramsItems.getItems());
                        paramsItems.setItems(item);
                    } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
                        List childs = paramsItems.getItems();
                        List<EaiParamsItems> item = this.convertParams(childs);
                        paramsItems.setItems(item);
                    }
                }
            });
            return paramsConvertDto;
        }
        return null;
    }

    public String convertOutParams(EaiParamsConvertDto params) {
        Integer type;
        String mappingName;
        ArrayList<EaiParamsItems> eaiParamsItems = new ArrayList<EaiParamsItems>();
        EaiParamsItems requestItemsBody = new EaiParamsItems();
        requestItemsBody.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
        requestItemsBody.setName("responseBody");
        List items = Lists.newArrayListWithCapacity((int)0);
        if (null != params && null != params.getBody()) {
            mappingName = params.getBody().getMappingName();
            type = params.getBody().getType();
            items = params.getBody().getItems();
        } else {
            mappingName = "responseBody";
            type = EaiDataType.DATA_TYPE_STRING.getType();
        }
        requestItemsBody.setMappingName(mappingName);
        requestItemsBody.setType(type);
        if (null != params && EaiDataType.DATA_TYPE_STRUCTURE.getType() == params.getBody().getType().intValue()) {
            requestItemsBody.setQuoteStructureId(params.getBody().getQuoteStructureId());
        }
        requestItemsBody.setItems(items);
        eaiParamsItems.add(requestItemsBody);
        return JSONObject.toJSONString((Object)JSON.toJSON(eaiParamsItems));
    }

    private void fillEaiParamsItemsMark(EaiParamsItems items) {
        if (HussarUtils.isNotEmpty((Object)items.getRemark())) {
            items.setMark(items.getRemark());
        }
        if (CollectionUtil.isNotEmpty((Collection)items.getItems())) {
            items.getItems().forEach(this::fillEaiParamsItemsMark);
        }
    }
}

