/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.application.vo.TeamMemberVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appinfo.api.dto.QueryAppDto;
import com.jxdinfo.hussar.eai.appinfo.api.service.IAppGroupService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.AppGroupVo;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationTreeVo;
import com.jxdinfo.hussar.eai.appinfo.server.dao.ApplicationManagementMapper;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.appinfo.server.service.impl.ApplicationManagementServiceImpl")
public class ApplicationManagementServiceImpl
implements IApplicationManagementService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationManagementServiceImpl.class);
    @Resource
    protected ApplicationManagementMapper applicationManagementMapper;
    @Resource
    protected ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    protected IAppGroupService iAppGroupService;

    public List<ApplicationTreeVo> getReleasedTree(String query, String releaseStatus) {
        List<ApplicationManageVo> apps = this.applicationManagementMapper.selectReleased(query, releaseStatus);
        if (HussarUtils.isEmpty(apps)) {
            return Collections.emptyList();
        }
        return this.fillAppGroupInfos(apps, null);
    }

    public List<ApplicationManageVo> getByCurrentUser(String query) {
        List<ApplicationManageVo> teamList = this.getIdAndTypeByCurrentUser();
        if (HussarUtils.isEmpty(teamList)) {
            return Collections.emptyList();
        }
        List ids = teamList.stream().map(ApplicationManageVo::getId).collect(Collectors.toList());
        ArrayList<Long> idsLong = new ArrayList<Long>();
        for (String id : ids) {
            idsLong.add(Long.valueOf(id));
        }
        List<ApplicationManageVo> result = this.applicationManagementMapper.selectByCurrentUser(idsLong, query);
        if (HussarUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        Map<String, String> map = teamList.stream().collect(Collectors.toMap(ApplicationManageVo::getId, ApplicationManageVo::getMemberType, (k1, k2) -> k1));
        for (ApplicationManageVo vo : result) {
            vo.setMemberType(map.get(vo.getId()));
        }
        return result;
    }

    public ApplicationManageVo getByAppCode(String appCode) {
        return this.applicationManagementMapper.selectByAppCode(appCode);
    }

    public List<ApplicationManageVo> getByAppCodeList(List<String> appCodes) {
        return this.applicationManagementMapper.selectByAppCodeList(appCodes);
    }

    public List<ApplicationTreeVo> getOpennessAppList(QueryAppDto query) {
        AssertUtil.isNotNull((Object)query, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        List<ApplicationManageVo> apps = this.applicationManagementMapper.selectOpennessAppList(query.getAppName());
        if (HussarUtils.isEmpty(apps)) {
            return Collections.emptyList();
        }
        return this.fillAppGroupInfos(apps, query.getAppGroupId());
    }

    public Boolean deleteApp(Long appId) {
        if (!this.OperPermissionCheck(appId)) {
            throw new HussarException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u6743\u9650\u505a\u6b64\u64cd\u4f5c!");
        }
        return null;
    }

    private List<ApplicationManageVo> getIdAndTypeByCurrentUser() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55");
        }
        return this.applicationManagementMapper.selectIdAndTypeByCurrentUser(user.getId());
    }

    protected List<ApplicationTreeVo> fillAppGroupInfos(List<ApplicationManageVo> apps, String groupId) {
        List groupIds = apps.stream().map(ApplicationManageVo::getAppGroupId).collect(Collectors.toList());
        List appGroupVos = this.iAppGroupService.listByGroupIds(groupIds);
        if (HussarUtils.isEmpty((Object)appGroupVos)) {
            return Collections.emptyList();
        }
        List<Object> result = new ArrayList<ApplicationTreeVo>();
        Map<String, List<ApplicationManageVo>> map = apps.stream().collect(Collectors.groupingBy(ApplicationManageVo::getAppGroupId));
        for (AppGroupVo appGroupVo : appGroupVos) {
            ApplicationTreeVo applicationTreeVo = new ApplicationTreeVo();
            applicationTreeVo.setGroupId(appGroupVo.getId());
            applicationTreeVo.setGroupName(appGroupVo.getGroupName());
            applicationTreeVo.setId(appGroupVo.getId());
            applicationTreeVo.setText(appGroupVo.getGroupName());
            applicationTreeVo.setGroupType(appGroupVo.getGroupType());
            applicationTreeVo.setGroupSeq(appGroupVo.getSeq());
            applicationTreeVo.setChildrenList(map.get(appGroupVo.getId()));
            result.add(applicationTreeVo);
        }
        for (ApplicationTreeVo applicationTreeVo : result) {
            applicationTreeVo.getChildrenList().forEach(app -> app.setParentName(applicationTreeVo.getGroupName()));
        }
        if (HussarUtils.isNotBlank((CharSequence)groupId)) {
            result = result.stream().filter(v -> StringUtil.equals((CharSequence)v.getGroupId(), (CharSequence)groupId)).collect(Collectors.toList());
        }
        return result;
    }

    public boolean OperPermissionCheck(Long appId) {
        ApiResponse appDevelopTeamDetail = this.sysAppDevelopTeamService.getAppDevelopTeamDetail(appId);
        if (!appDevelopTeamDetail.isSuccess()) {
            throw new HussarException("\u83b7\u53d6\u5e94\u7528\u56e2\u961f\u5931\u8d25\uff01");
        }
        if (HussarUtils.isEmpty((Object)appDevelopTeamDetail.getData())) {
            throw new HussarException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        List userList = ((AppDevelopTeamDetailVo)appDevelopTeamDetail.getData()).getUserList();
        if (HussarUtils.isEmpty((Object)userList)) {
            throw new HussarException("\u8be5\u5e94\u7528\u5f00\u53d1\u56e2\u961f\u4e0b\u6ca1\u6709\u56e2\u961f\u6210\u5458\uff01");
        }
        Long currentLoginUser = BaseSecurityUtil.getUser().getId();
        List collectUser = userList.stream().filter(t -> currentLoginUser.equals(t.getId())).collect(Collectors.toList());
        return !CollectionUtil.isEmpty(collectUser) && 1 == ((TeamMemberVo)collectUser.get(0)).getMemberType();
    }

    public void assembleType(EaiParamsItems param, List<Object> type) {
        if (null != EaiDataType.getBaseModelType((Integer)param.getType())) {
            type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
        } else if (7 == EaiDataType.getEaiDataType((Integer)param.getType()).getType()) {
            type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase() + ":" + param.getQuoteStructureId());
        } else {
            type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
            if (null != EaiDataType.getBaseModelType((Integer)param.getItemType())) {
                type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase());
            } else if (7 == EaiDataType.getEaiDataType((Integer)param.getItemType()).getType()) {
                type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase() + ":" + ((EaiParamsItems)param.getItems().get(0)).getQuoteStructureId());
            } else {
                ArrayList typeChild = Lists.newArrayListWithCapacity((int)10);
                EaiParamsItems inParamC = (EaiParamsItems)param.getItems().get(0);
                this.assembleType(inParamC, typeChild);
                type.add(typeChild);
            }
        }
    }
}

