/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamMemberService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiSysApplicationService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.appinfo.server.service.impl.EaiSysApplicationServiceImpl")
public class EaiSysApplicationServiceImpl
implements IEaiSysApplicationService {
    private static final String OPERATION_TYPE = "2";
    @Resource
    private ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    private ISysAppDevelopTeamMemberService sysAppDevelopTeamMemberService;
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;

    public Boolean checkAppAdministrator(Long appId) {
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.sysAppDevelopTeamService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)sysAppDevelopTeam)) {
            return false;
        }
        Long userId = BaseSecurityUtil.getUser().getId();
        Long teamId = sysAppDevelopTeam.getId();
        SysAppDevelopTeamMember sysAppDevelopTeamMember = (SysAppDevelopTeamMember)this.sysAppDevelopTeamMemberService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)teamId)).eq(SysAppDevelopTeamMember::getUserId, (Object)userId));
        return HussarUtils.isNotEmpty((Object)sysAppDevelopTeamMember) && sysAppDevelopTeamMember.getMemberType() == 1;
    }

    public ApiResponse<SysApplicationVo> getAppDetailNoVerification(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationCommonMapper.getAppDetail(appId);
        if (HussarUtils.isNotEmpty((Object)sysApplicationVo)) {
            ArrayList<SysApplicationVo> sysApplicationVoList = new ArrayList<SysApplicationVo>();
            sysApplicationVoList.add(sysApplicationVo);
            this.setUserInfo(sysApplicationVoList);
        }
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public Boolean updateApp(SysApplicationDto sysApplicationDto) {
        List appName;
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)sysApplicationDto.getId()));
        if (!Objects.equals(sysApplication.getAppName(), sysApplicationDto.getAppName()) && HussarUtils.isNotEmpty((Object)(appName = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)sysApplicationDto.getAppName()))))) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01(\u5e94\u7528\u540d\u79f0\u5df2\u5b58\u5728\uff01)");
        }
        boolean flag = this.sysApplicationService.updateById((Object)sysApplicationDto);
        this.sysAppOperationLogService.saveAppOperation(sysApplicationDto.getId());
        HussarApplicationCallBackFactory.updateApp((SysApplication)sysApplicationDto);
        return flag;
    }

    private void setUserInfo(List<SysApplicationVo> appList) {
        if (HussarUtils.isNotEmpty(appList)) {
            List userIdList = appList.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
            List usersList = new ArrayList();
            if (HussarUtils.isNotEmpty(userIdList)) {
                usersList = this.sysUsersService.listByIds(userIdList);
            }
            Map userMap = usersList.stream().collect(Collectors.toMap(SysUsers::getId, Function.identity()));
            for (SysApplicationVo item : appList) {
                SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setCreateUserName(sysUsers.getUserName());
            }
        }
    }
}

