/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.plugins;

import com.jxdinfo.hussar.eai.appinfo.api.dto.EaiApplicationJsonConfigDto;
import com.jxdinfo.hussar.eai.appinfo.api.plugin.AppExtendConfigDataPlugin;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.common.config.EaiJsonConfigProperties;
import com.jxdinfo.hussar.eai.common.enums.app.EaiDateFormatTypeEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.appinfo.server.plugins.JsonConfigDataPlugin")
public class JsonConfigDataPlugin
implements AppExtendConfigDataPlugin<EaiApplicationJsonConfigDto> {
    @Resource
    private EaiJsonConfigProperties eaiJsonConfigProperties;
    @Resource
    private IApplicationManagementService applicationManagementService;

    public String configType() {
        return "jsonFormat";
    }

    public EaiApplicationJsonConfigDto initConfigData() {
        EaiApplicationJsonConfigDto applicationJsonConfigDto = new EaiApplicationJsonConfigDto();
        applicationJsonConfigDto.setDateTimeFormat(this.eaiJsonConfigProperties.getDefaultDateTimeFormat());
        applicationJsonConfigDto.setDateFormat(this.eaiJsonConfigProperties.getDefaultDateFormat());
        applicationJsonConfigDto.setTimeFormat(this.eaiJsonConfigProperties.getDefaultTimeFormat());
        applicationJsonConfigDto.setAmbiguousQuote(Boolean.valueOf(this.eaiJsonConfigProperties.isAmbiguousQuote()));
        applicationJsonConfigDto.setPropertyIgnoreCase(Boolean.valueOf(this.eaiJsonConfigProperties.isPropertyIgnoreCase()));
        applicationJsonConfigDto.setIncludeNullProperties(Boolean.valueOf(this.eaiJsonConfigProperties.getIncludeNullProperties()));
        return applicationJsonConfigDto;
    }

    public boolean validate(EaiApplicationJsonConfigDto configData) {
        boolean isValid = this.applicationManagementService.validateDateFormat(configData.getDateTimeFormat(), EaiDateFormatTypeEnum.DATE_TIME.getType());
        isValid = isValid && this.applicationManagementService.validateDateFormat(configData.getDateFormat(), EaiDateFormatTypeEnum.DATE.getType());
        boolean bl = isValid = isValid && this.applicationManagementService.validateDateFormat(configData.getTimeFormat(), EaiDateFormatTypeEnum.TIME.getType());
        if (!isValid) {
            throw new HussarException("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u6821\u9a8c\u9519\u8bef");
        }
        return isValid;
    }
}

