/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.plugins;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.appinfo.api.plugin.AppExtendConfigDataPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class AppExtendConfigDataPluginHolder
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(AppExtendConfigDataPluginHolder.class);
    private static final ConcurrentHashMap<String, AppExtendConfigDataPlugin> services = new ConcurrentHashMap();

    public static void register(AppExtendConfigDataPlugin provider) {
        String type = Optional.ofNullable(provider).map(AppExtendConfigDataPlugin::configType).orElse(null);
        if (type == null) {
            throw new NullPointerException();
        }
        logger.debug("\u6ce8\u518c\u5e8f\u5217\u5316\u914d\u7f6e\u670d\u52a1: {} => {}", (Object)type, (Object)provider.getClass().getName());
        AppExtendConfigDataPlugin previous = services.putIfAbsent(type, provider);
        if (previous != null && provider != previous) {
            throw new IllegalStateException("conflicted config data service provider for " + type + ": " + provider.getClass().getName() + " != " + previous.getClass().getName());
        }
    }

    public static AppExtendConfigDataPlugin unregister(String type) {
        logger.debug("\u5378\u8f7d\u5e8f\u5217\u5316\u914d\u7f6e\u670d\u52a1: {}", (Object)type);
        return services.remove(type);
    }

    public static AppExtendConfigDataPlugin replace(AppExtendConfigDataPlugin provider) {
        String type = Optional.ofNullable(provider).map(AppExtendConfigDataPlugin::configType).orElse(null);
        if (type == null) {
            throw new NullPointerException();
        }
        logger.debug("\u66ff\u6362\u5e8f\u5217\u5316\u914d\u7f6e\u670d\u52a1: {} => {}", (Object)type, (Object)provider.getClass().getName());
        return services.put(type, provider);
    }

    public static AppExtendConfigDataPlugin lookup(String type) throws BaseException {
        AppExtendConfigDataPlugin provider = services.get(type);
        if (provider == null) {
            throw new BaseException("config data service type not registered: " + type);
        }
        return provider;
    }

    public static List<String> types() {
        return Collections.list(services.keys());
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        for (AppExtendConfigDataPlugin bean : applicationContext.getBeansOfType(AppExtendConfigDataPlugin.class).values()) {
            AppExtendConfigDataPluginHolder.register(bean);
        }
        logger.info("\u5e73\u53f0\u8fc1\u5165\u8fc1\u51fa\u63d2\u4ef6\u6ce8\u518c\u5b8c\u6210: " + String.join((CharSequence)", ", AppExtendConfigDataPluginHolder.types()));
    }
}

