/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppOperationLog;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.eai.appinfo.api.service.EaiAppLastEditTimeChangeService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EaiAppEditManager {
    private static EaiAppLastEditTimeChangeService eaiAppLastEditTimeChangeService;
    private static ISysApplicationService sysApplicationService;
    private static ISysAppOperationLogService sysAppOperationLogService;

    @Autowired
    private void setEaiAppLastEditTimeChangeService(EaiAppLastEditTimeChangeService eaiAppLastEditTimeChangeService) {
        EaiAppEditManager.eaiAppLastEditTimeChangeService = eaiAppLastEditTimeChangeService;
    }

    @Autowired
    private void setSysApplicationService(ISysApplicationService sysApplicationService) {
        EaiAppEditManager.sysApplicationService = sysApplicationService;
    }

    @Autowired
    private void setSysAppOperationLogService(ISysAppOperationLogService sysAppOperationLogService) {
        EaiAppEditManager.sysAppOperationLogService = sysAppOperationLogService;
    }

    public static EaiAppEditManager getInstance() {
        return INIT.e;
    }

    public void call(String appcode) {
        SysApplication sysApplication;
        if (HussarUtils.isNotEmpty((Object)appcode) && HussarUtils.isNotEmpty((Object)(sysApplication = (SysApplication)sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appcode))))) {
            eaiAppLastEditTimeChangeService.updateApplication(appcode);
            sysAppOperationLogService.saveAppOperation(sysApplication.getId(), "2");
        }
    }

    public void call(List<String> appcode) {
        if (HussarUtils.isNotEmpty(appcode)) {
            eaiAppLastEditTimeChangeService.updateApplication(appcode);
            List sysApplications = sysApplicationService.list((Wrapper)new LambdaQueryWrapper().in(SysApplication::getAppCode, appcode));
            ArrayList operationLogs = Lists.newArrayListWithCapacity((int)5);
            for (SysApplication sysApplication : sysApplications) {
                SysAppOperationLog log = new SysAppOperationLog();
                log.setAppId(sysApplication.getId());
                log.setOperationType("2");
                operationLogs.add(log);
            }
            sysAppOperationLogService.saveBatch((Collection)operationLogs);
        }
    }

    private static final class INIT {
        private static final EaiAppEditManager e = new EaiAppEditManager();

        private INIT() {
        }
    }
}

