/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.appinfo.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.AppDevelopTeamDetailVo;
import com.jxdinfo.hussar.application.vo.TeamMemberVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.eai.appinfo.api.dto.QueryAppDto;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationTreeVo;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.appinfo.server.service.impl.ApplicationManagementServiceImpl")
public class ApplicationManagementServiceImpl
implements IApplicationManagementService {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationManagementServiceImpl.class);
    @Resource
    protected ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    protected ISysAppGroupService sysAppGroupService;
    @Resource
    protected ISysApplicationService sysApplicationService;

    public List<ApplicationTreeVo> getReleasedTree(String query, String releaseStatus) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtil.isNotEmpty((Object)query)) {
            queryWrapper.like(SysApplication::getAppName, (Object)query);
        }
        if (StringUtil.isNotEmpty((Object)releaseStatus)) {
            queryWrapper.eq(SysApplication::getReleaseStatus, (Object)releaseStatus);
        }
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List sysApplications = this.sysApplicationService.list((Wrapper)queryWrapper);
        ArrayList apps = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty((Collection)sysApplications)) {
            for (SysApplication app : sysApplications) {
                ApplicationManageVo applicationManageVo = new ApplicationManageVo();
                BeanUtil.copy((Object)app, (Object)applicationManageVo);
                applicationManageVo.setText(app.getAppName());
                apps.add(applicationManageVo);
            }
        }
        if (HussarUtils.isEmpty((Object)apps)) {
            return Collections.emptyList();
        }
        return this.fillAppGroupInfos(apps, null);
    }

    public List<ApplicationManageVo> getByCurrentUser(String query) {
        List<ApplicationManageVo> teamList = this.getIdAndTypeByCurrentUser();
        if (HussarUtils.isEmpty(teamList)) {
            return Collections.emptyList();
        }
        List ids = teamList.stream().map(ApplicationManageVo::getId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysApplication::getId, ids);
        if (StringUtil.isNotEmpty((Object)query)) {
            queryWrapper.like(SysApplication::getAppName, (Object)query);
        }
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List sysApplications = this.sysApplicationService.list((Wrapper)queryWrapper);
        ArrayList result = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty((Collection)sysApplications)) {
            for (SysApplication app : sysApplications) {
                ApplicationManageVo applicationManageVo = new ApplicationManageVo();
                BeanUtil.copy((Object)app, (Object)applicationManageVo);
                applicationManageVo.setText(app.getAppName());
                result.add(applicationManageVo);
            }
        }
        if (HussarUtils.isEmpty((Object)result)) {
            return Collections.emptyList();
        }
        return result;
    }

    public ApplicationManageVo getByAppCode(String appCode) {
        ApplicationManageVo applicationManageVo = new ApplicationManageVo();
        SysApplication applicationService = (SysApplication)this.sysApplicationService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (StringUtil.isNotEmpty((Object)applicationService)) {
            BeanUtil.copy((Object)applicationService, (Object)applicationManageVo);
        }
        return applicationManageVo;
    }

    public List<ApplicationManageVo> getByAppCodeList(List<String> appCodes) {
        List sysApplicationList = this.sysApplicationService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysApplication::getAppCode, appCodes).orderByDesc(HussarBaseEntity::getCreateTime));
        ArrayList applicationManageVoList = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty((Collection)sysApplicationList)) {
            for (SysApplication sysApplication : sysApplicationList) {
                ApplicationManageVo vo = new ApplicationManageVo();
                BeanUtil.copy((Object)sysApplication, (Object)vo);
                applicationManageVoList.add(vo);
            }
        }
        return applicationManageVoList;
    }

    public List<ApplicationTreeVo> getOpennessAppList(QueryAppDto query) {
        AssertUtil.isNotNull((Object)query, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysApplication::getAppStatus, Arrays.asList("1", "2"))).eq(SysApplication::getReleaseStatus, (Object)"1")).eq(SysApplication::getAppType, (Object)"6");
        if (null != query && StringUtil.isNotEmpty((Object)query.getAppName())) {
            queryWrapper.like(SysApplication::getAppName, (Object)query.getAppName());
        }
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List sysApplicationList = this.sysApplicationService.list((Wrapper)queryWrapper);
        ArrayList apps = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty((Collection)sysApplicationList)) {
            for (SysApplication sysApplication : sysApplicationList) {
                ApplicationManageVo vo = new ApplicationManageVo();
                BeanUtil.copy((Object)sysApplication, (Object)vo);
                apps.add(vo);
            }
        }
        if (HussarUtils.isEmpty((Object)apps)) {
            return Collections.emptyList();
        }
        return this.fillAppGroupInfos(apps, query.getAppGroupId());
    }

    public Boolean deleteApp(Long appId) {
        if (!this.OperPermissionCheck(appId)) {
            throw new HussarException("\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u6743\u9650\u505a\u6b64\u64cd\u4f5c!");
        }
        return null;
    }

    private List<ApplicationManageVo> getIdAndTypeByCurrentUser() {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new HussarException("\u7528\u6237\u672a\u767b\u5f55");
        }
        List appIdList = this.sysAppDevelopTeamService.selectAppListByCurrentUser();
        ArrayList applicationManageVoList = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty((Collection)appIdList)) {
            appIdList.forEach(appId -> {
                ApplicationManageVo vo = new ApplicationManageVo();
                vo.setId(String.valueOf(appId));
                applicationManageVoList.add(vo);
            });
        }
        return applicationManageVoList;
    }

    protected List<ApplicationTreeVo> fillAppGroupInfos(List<ApplicationManageVo> apps, String groupId) {
        List groupIds = apps.stream().map(ApplicationManageVo::getAppGroupId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = LambdaQueryUtil.getMultiQueryWrapper(SysAppGroup::getId, groupIds);
        ((LambdaQueryWrapper)queryWrapper.orderByDesc(SysAppGroup::getSEQ)).orderByDesc(HussarBaseEntity::getCreateTime);
        List appGroupVos = this.sysAppGroupService.list((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)appGroupVos)) {
            return Collections.emptyList();
        }
        List<Object> result = new ArrayList<ApplicationTreeVo>();
        Map<String, List<ApplicationManageVo>> map = apps.stream().collect(Collectors.groupingBy(ApplicationManageVo::getAppGroupId));
        for (SysAppGroup sysAppGroup : appGroupVos) {
            ApplicationTreeVo applicationTreeVo = new ApplicationTreeVo();
            applicationTreeVo.setGroupId(String.valueOf(sysAppGroup.getId()));
            applicationTreeVo.setGroupName(sysAppGroup.getGroupName());
            applicationTreeVo.setId(String.valueOf(sysAppGroup.getId()));
            applicationTreeVo.setText(sysAppGroup.getGroupName());
            applicationTreeVo.setGroupType(sysAppGroup.getGroupType());
            applicationTreeVo.setGroupSeq(sysAppGroup.getSEQ());
            applicationTreeVo.setChildrenList(map.get(String.valueOf(sysAppGroup.getId())));
            result.add(applicationTreeVo);
        }
        for (ApplicationTreeVo applicationTreeVo : result) {
            applicationTreeVo.getChildrenList().forEach(app -> app.setParentName(applicationTreeVo.getGroupName()));
        }
        if (HussarUtils.isNotBlank((CharSequence)groupId)) {
            result = result.stream().filter(v -> StringUtil.equals((CharSequence)v.getGroupId(), (CharSequence)groupId)).collect(Collectors.toList());
        }
        return result;
    }

    public boolean OperPermissionCheck(Long appId) {
        ApiResponse appDevelopTeamDetail = this.sysAppDevelopTeamService.getAppDevelopTeamDetail(appId);
        if (!appDevelopTeamDetail.isSuccess()) {
            throw new HussarException("\u83b7\u53d6\u5e94\u7528\u56e2\u961f\u5931\u8d25\uff01");
        }
        if (HussarUtils.isEmpty((Object)appDevelopTeamDetail.getData())) {
            throw new HussarException("\u8be5\u5e94\u7528\u6ca1\u6709\u5e94\u7528\u5f00\u53d1\u56e2\u961f\uff01");
        }
        List userList = ((AppDevelopTeamDetailVo)appDevelopTeamDetail.getData()).getUserList();
        if (HussarUtils.isEmpty((Object)userList)) {
            throw new HussarException("\u8be5\u5e94\u7528\u5f00\u53d1\u56e2\u961f\u4e0b\u6ca1\u6709\u56e2\u961f\u6210\u5458\uff01");
        }
        Long currentLoginUser = BaseSecurityUtil.getUser().getId();
        List collectUser = userList.stream().filter(t -> currentLoginUser.equals(t.getId())).collect(Collectors.toList());
        return !CollectionUtil.isEmpty(collectUser) && 1 == ((TeamMemberVo)collectUser.get(0)).getMemberType();
    }

    public void assembleType(EaiParamsItems param, List<Object> type, Boolean isOpenFlag) {
        if (null != EaiDataType.getBaseModelType((Integer)param.getType())) {
            if (EaiDataType.DATA_TYPE_INTEGER.getType() == param.getType().intValue()) {
                type.add("int");
            } else {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
            }
        } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == EaiDataType.getEaiDataType((Integer)param.getType()).getType()) {
            if (isOpenFlag.booleanValue()) {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase() + ":open:" + param.getQuoteStructureId());
            } else {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase() + ":" + param.getQuoteStructureId());
            }
        } else {
            if (EaiDataType.DATA_TYPE_PAGE.getType() == param.getType().intValue()) {
                type.add("special:page");
                param = (EaiParamsItems)param.getItems().stream().filter(e -> EaiDataType.DATA_TYPE_LIST.getType() == e.getType().intValue()).collect(Collectors.toList()).get(0);
            } else {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
            }
            if (StringUtil.isNotEmpty((Object)param.getItemType()) && null != EaiDataType.getBaseModelType((Integer)param.getItemType())) {
                if (EaiDataType.DATA_TYPE_INTEGER.getType() == param.getItemType().intValue()) {
                    type.add("int");
                } else {
                    type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase());
                }
            } else if (StringUtil.isNotEmpty((Object)param.getItemType()) && 7 == EaiDataType.getEaiDataType((Integer)param.getItemType()).getType()) {
                type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase() + ":" + ((EaiParamsItems)param.getItems().get(0)).getQuoteStructureId());
            } else {
                ArrayList typeChild = Lists.newArrayListWithCapacity((int)10);
                if (CollectionUtil.isNotEmpty((Collection)param.getItems())) {
                    EaiParamsItems inParamC = (EaiParamsItems)param.getItems().get(0);
                    this.assembleType(inParamC, typeChild, isOpenFlag);
                    type.add(typeChild);
                }
            }
        }
    }

    public void assembleNewType(EaiParamsItems param, List<Object> type, Map<String, String> oldNewStructureMap) {
        if (null != EaiDataType.getBaseModelType((Integer)param.getType())) {
            if (EaiDataType.DATA_TYPE_INTEGER.getType() == param.getType().intValue()) {
                type.add("int");
            } else {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
            }
        } else if (7 == EaiDataType.getEaiDataType((Integer)param.getType()).getType()) {
            type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase() + ":" + oldNewStructureMap.get(param.getQuoteStructureId()));
        } else {
            if (EaiDataType.DATA_TYPE_PAGE.getType() == param.getType().intValue()) {
                type.add("special:page");
            } else {
                type.add(EaiDataType.getEaiDataType((Integer)param.getType()).getCode().toLowerCase());
            }
            if (null != EaiDataType.getBaseModelType((Integer)param.getItemType())) {
                if (EaiDataType.DATA_TYPE_INTEGER.getType() == param.getType().intValue()) {
                    type.add("int");
                } else {
                    type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase());
                }
            } else if (7 == EaiDataType.getEaiDataType((Integer)param.getItemType()).getType()) {
                type.add(EaiDataType.getEaiDataType((Integer)param.getItemType()).getCode().toLowerCase() + ":" + oldNewStructureMap.get(((EaiParamsItems)param.getItems().get(0)).getQuoteStructureId()));
            } else {
                ArrayList typeChild = Lists.newArrayListWithCapacity((int)10);
                EaiParamsItems inParamC = (EaiParamsItems)param.getItems().get(0);
                this.assembleNewType(inParamC, typeChild, oldNewStructureMap);
                type.add(typeChild);
            }
        }
    }
}

