/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.apirelease.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.apirelease.server.dao.ApiVersionMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.apirelease.server.service.impl.ApiVersionServiceImpl")
public class ApiVersionServiceImpl
extends HussarServiceImpl<ApiVersionMapper, EaiApiVersion>
implements IApiVersionService {
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    @Resource
    private ISysResourcesService sysResourcesService;

    @HussarTransactional(rollbackFor={Exception.class})
    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiVersion::getApplicationCode, (Object)appCode);
        List apiInfos = ((ApiVersionMapper)this.baseMapper).selectList((Wrapper)apiWrapper);
        ArrayList<String> urlList = new ArrayList<String>();
        for (EaiApiVersion eaiApiVersion : apiInfos) {
            urlList.add(eaiApiVersion.getApiPath());
        }
        if (ToolUtil.isNotEmpty(urlList)) {
            this.sysResourcesService.remove((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getUrlNames, urlList));
        }
        ((ApiVersionMapper)this.baseMapper).delete((Wrapper)apiWrapper);
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            List ids = apiInfos.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList());
            LambdaQueryWrapper editWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids);
            this.iEaiEditApiService.remove((Wrapper)editWrapper);
        }
        return true;
    }
}

