/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.entity.SysDatasourceConfig;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.plugin.datasource.service.DatasourceConfigService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.factory.EaiAppConnectionFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiAppConnectionExtendService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.IEaiDynamicDataSourceService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppConnectionEnum;
import com.jxdinfo.hussar.eai.datasource.rdb.util.BeanMapUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.rdbActionServiceImpl")
public class RdbActionServiceImpl
implements IEaiAppConnectionExtendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdbActionServiceImpl.class);
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private DatasourceConfigService datasourceConfigService;
    @Autowired
    private ICommonConnectionService commonConnectionService;
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private IEaiDynamicDataSourceService eaiDynamicDataSourceService;

    @HussarTransactional
    public boolean saveConnection(CommonConnectionDto commonConnectionDto) {
        CommonConnection commonConnection = new CommonConnection();
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        String flag = UUID.randomUUID().toString().replace("-", "");
        dataSourceDto.setDbName(flag);
        dataSourceDto.setConnName(flag);
        dataSourceDto.setDatasourceType("3");
        dataSourceDto.setLazyEnable(Integer.valueOf(1));
        ApiResponse sysDataSourceApiResponse = this.datasourceService.saveDataSourceWithCheck(dataSourceDto, false);
        SysDataSource data = (SysDataSource)sysDataSourceApiResponse.getData();
        BeanUtil.copy((Object)commonConnectionDto, (Object)commonConnection);
        commonConnection.setClassify("0");
        if (HussarUtils.isNotEmpty((Object)commonConnectionDto.getConnectionConfigMap())) {
            SysDatasourceConfig datasourceConfig = (SysDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDatasourceConfig::getConnName, (Object)data.getConnName()), false);
            connectionConfigMap.put("id", data.getId());
            connectionConfigMap.put("dbName", flag);
            connectionConfigMap.put("connName", flag);
            if (datasourceConfig != null) {
                connectionConfigMap.put("properties", datasourceConfig.getParameterValue());
            } else {
                connectionConfigMap.put("properties", "");
            }
            commonConnection.setConnectionConfig(JSON.toJSONString((Object)connectionConfigMap));
        }
        return this.commonConnectionService.save((Object)commonConnection);
    }

    @HussarTransactional
    public boolean updateConnection(CommonConnectionDto commonConnectionDto) {
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        Long connectionId = commonConnectionDto.getId();
        CommonConnection byId = (CommonConnection)this.commonConnectionService.getById((Serializable)connectionId);
        AssertUtil.isNotNull((Object)byId, (String)"\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f\uff01");
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        SysDataSourceDto data = this.datasourceService.updateDatasource(dataSourceDto);
        this.eaiDynamicDataSourceService.saveDynamicDatasource((SysDataSource)data);
        BeanUtil.copy((Object)commonConnectionDto, (Object)byId);
        SysDatasourceConfig datasourceConfig = (SysDatasourceConfig)this.datasourceConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDatasourceConfig::getConnName, (Object)data.getConnName()), false);
        connectionConfigMap.put("id", data.getId());
        if (datasourceConfig != null) {
            connectionConfigMap.put("properties", datasourceConfig.getParameterValue());
        } else {
            connectionConfigMap.put("properties", "");
        }
        byId.setConnectionConfig(JSON.toJSONString((Object)connectionConfigMap));
        return this.commonConnectionService.updateById((Object)byId);
    }

    public CommonConnectionVo getConnectionById(CommonConnection commonConnection) {
        CommonConnectionVo connectionVo = new CommonConnectionVo();
        if (HussarUtils.isNotEmpty((Object)commonConnection)) {
            BeanUtil.copy((Object)commonConnection, (Object)connectionVo);
            if (HussarUtils.isNotEmpty((Object)commonConnection.getConnectionConfig())) {
                connectionVo.setConnectionConfigMap((Map)JSONObject.parseObject((String)commonConnection.getConnectionConfig(), Map.class));
            }
            connectionVo.setName(connectionVo.getConnectionNameEn());
            connectionVo.setDesc(connectionVo.getConnectionName());
        }
        return connectionVo;
    }

    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        Map connectionConfigMap = commonConnectionDto.getConnectionConfigMap();
        SysDataSourceDto dataSourceDto = new SysDataSourceDto();
        BeanMapUtil.fillBeanWithMapIgnoreCase((Map)connectionConfigMap, (Object)dataSourceDto, (boolean)false);
        this.tryConnection(dataSourceDto);
        return true;
    }

    private Connection getConnection(String url, String username, String password) throws SQLException {
        if (url.startsWith("jdbc:oscar")) {
            try {
                Class.forName("com.oscar.Driver");
            }
            catch (ClassNotFoundException var5) {
                LOGGER.error("ClassNotFoundException", (Throwable)var5);
            }
        }
        DriverManager.setLoginTimeout(10);
        return DriverManager.getConnection(url.replace("autoReconnect=true", "autoReconnect=false"), username, password);
    }

    private ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        if (!(HussarUtils.isEmpty((Object)sysDataSourceDto) || HussarUtils.isEmpty((Object)sysDataSourceDto.getJdbcUrl()) || HussarUtils.isEmpty((Object)sysDataSourceDto.getUserName()))) {
            ApiResponse var4;
            Connection conn = null;
            try {
                conn = this.getConnection(sysDataSourceDto.getJdbcUrl(), sysDataSourceDto.getUserName(), sysDataSourceDto.getPassword());
                String driverName = conn.getMetaData().getDriverName();
                var4 = ApiResponse.success((String)driverName.toUpperCase());
            }
            catch (Exception var13) {
                LOGGER.error("errorMessage:{}", (Object)var13.getMessage(), (Object)var13);
                throw new HussarException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff01");
            }
            finally {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException var12) {
                    LOGGER.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)var12);
                }
            }
            return var4;
        }
        throw new HussarException("\u53c2\u6570\u4f20\u9012\u4e3a\u7a7a\uff01");
    }

    @HussarTransactional
    public Boolean deleteConnection(CommonConnection commonConnection) {
        String connectionConfig = commonConnection.getConnectionConfig();
        if (HussarUtils.isNotBlank((CharSequence)connectionConfig)) {
            SysDataSource data = (SysDataSource)JSON.parseObject((String)connectionConfig, SysDataSource.class);
            this.datasourceService.deleteDataSource((List)Lists.newArrayList((Object[])new String[]{data.getId() + ""}));
        }
        return this.commonConnectionService.deleteConnection(commonConnection.getId());
    }

    public void afterPropertiesSet() throws Exception {
        EaiAppConnectionFactory.registerAppConnection((String)(EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify() + "_" + EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassifyChild()), (IEaiAppConnectionExtendService)this);
    }
}

