/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.df.data.set.api.app.dto.SysDataSetInfoDto;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetInfoService;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.customsql.service.CustomSqlQueryService;
import com.jxdinfo.hussar.df.data.set.api.customsql.vo.TestDfCustomSqlVo;
import com.jxdinfo.hussar.df.data.set.api.dataset.service.DataSetPushService;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.model.api.ApiModelInfo;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddCommonStructureDto;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.ApiCanvasInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.GenerateCanvasCommonInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.IEaiGenerateCanvasTemplateService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiDataCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.common.vo.PageVo;
import com.jxdinfo.hussar.eai.datasource.rdb.dao.EaiQuerySqlBaseMapper;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.AddSqlApiDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.CheckInParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.EditSqlApiDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.LogicMappingOutParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.MappingOutParamDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.OutCheckDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.QuerySqlInParam;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.RunCustomSqlDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.SaveDatasetDto;
import com.jxdinfo.hussar.eai.datasource.rdb.dto.SqlGenerateCanvasInfoDto;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.CheckParamItem;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.SqlResponseMapping;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiDatasetRelation;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiQuerySqlConf;
import com.jxdinfo.hussar.eai.datasource.rdb.model.SqlSelect;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiDatasetRelationService;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiQuerySqlConfService;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IQuerySqlService;
import com.jxdinfo.hussar.eai.datasource.rdb.service.ISqlParseService;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SQLUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.util.SqlParamUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.LogicQuerySqlOutParamVo;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.QuerySqlApiInfoVo;
import com.jxdinfo.hussar.eai.datasource.rdb.vo.ScriptLabelVo;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.datasource.rdb.service.impl.querySqlServiceImpl")
public class QuerySqlServiceImpl
implements IQuerySqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuerySqlServiceImpl.class);
    @Autowired
    private IEaiApiInfoService apiInfoService;
    @Autowired
    private IEaiDatasetRelationService eaiDatasetRelationService;
    @Autowired
    private CustomSqlQueryService customSqlQueryService;
    @Autowired
    private IEaiQuerySqlConfService eaiQuerySqlConfService;
    @Autowired
    private ICommonStructureService commonStructureService;
    @Resource
    protected EaiConvertService eaiConvertService;
    @Autowired
    protected EaiApiProperties eaiApiProperties;
    @Autowired
    protected ICanvasInfoService canvasInfoService;
    @Autowired
    protected EaiCanvasInfoService eaiCanvasInfoService;
    private static final String INPUT_REMARK = "\u5916\u5c42\u5165\u53c2";
    private static final String ERROR = "\u4fdd\u5b58\u5931\u8d25";
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    private DatasourceService datasourceService;
    @Autowired
    private DynamicDatasourceService dynamicDataSourceService;
    @Autowired
    private ISqlParseService sqlParseService;
    @Autowired
    private ISysDataSetInfoService sysDataSetInfoService;
    @Autowired
    private EaiCommonStructureService eaiCommonStructureService;
    @Autowired
    private DataSetPushService dataSetPushService;
    @Resource
    private EaiQuerySqlBaseMapper eaiQuerySqlBaseMapper;
    @Autowired
    protected IEaiEditApiService iEaiEditApiService;
    @Autowired
    private IReleaseApiService releaseApiService;
    @Resource
    private IEaiCanvaParamsConvertService canvaParamsConvertService;
    @Autowired
    private HussarDdlService hussarDdlService;
    @Autowired
    private IEaiGenerateCanvasTemplateService generateCanvasTemplateService;

    @HussarTransactional
    public ApiResponse<String> saveApiInfo(AddSqlApiDto addSqlApiDto) {
        String validateMsg = this.validateService.validate((Object)addSqlApiDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        boolean checkIn = this.isCheckIn(addSqlApiDto);
        boolean checkOut = this.isCheckOut(addSqlApiDto);
        if (!checkIn || !checkOut) {
            LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
            map.put("in", checkIn);
            map.put("out", checkOut);
            ApiResponse fail = new ApiResponse();
            fail.setData((Object)JSON.toJSONString(map));
            fail.setCode(ResultCode.FAILURE.getCode());
            fail.setMsg("");
            return fail;
        }
        List addCommonStructureList = addSqlApiDto.getAddCommonStructureList();
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)addCommonStructureList)) {
            for (AddCommonStructureDto addCommonStructureDto : addCommonStructureList) {
                String structureCode = addCommonStructureDto.getStructureCode();
                addCommonStructureDto.setId(EngineUtil.getId() + "");
                map.put(structureCode, addCommonStructureDto.getId());
            }
            for (AddCommonStructureDto addCommonStructureDto : addCommonStructureList) {
                this.fillStructureItemsStructureId(addCommonStructureDto.getStructureValues(), map);
            }
            this.eaiCommonStructureService.saveBatchStructure(addCommonStructureList);
            EaiParamsItems body = addSqlApiDto.getOutParams().getBody();
            this.fillStructureId(body, map);
        }
        this.saveBaseApiInfo(addSqlApiDto);
        this.saveSqlInfo(addSqlApiDto);
        return ApiResponse.success((String)"\u4fdd\u5b58SQL API\u6210\u529f\uff01");
    }

    private boolean isCheckOut(AddSqlApiDto addSqlApiDto) {
        EaiParamsItems outbody = addSqlApiDto.getOutParams().getBody();
        if (HussarUtils.isEmpty((Object)outbody)) {
            return false;
        }
        List items = outbody.getItems();
        if (HussarUtils.isEmpty((Object)items)) {
            return false;
        }
        boolean checkOut = true;
        OutCheckDto outCheckDto = new OutCheckDto();
        outCheckDto.setDsId(addSqlApiDto.getDsId());
        outCheckDto.setCustomSql(addSqlApiDto.getCustomSql());
        EaiParamsItems eaiParamsItems = (EaiParamsItems)items.get(0);
        if (addSqlApiDto.getPageFlag()) {
            if (eaiParamsItems.getName().equalsIgnoreCase("records")) {
                outCheckDto.setOutNameList(((EaiParamsItems)eaiParamsItems.getItems().get(0)).getItems().stream().map(item -> new CheckParamItem(item.getName(), item.getType())).collect(Collectors.toList()));
            } else {
                outCheckDto.setOutNameList(new ArrayList());
            }
        } else if (eaiParamsItems.getName().equalsIgnoreCase("items")) {
            outCheckDto.setOutNameList(eaiParamsItems.getItems().stream().map(item -> new CheckParamItem(item.getName(), item.getType())).collect(Collectors.toList()));
        }
        checkOut = this.checkOutRight(outCheckDto);
        return checkOut;
    }

    private boolean isCheckIn(AddSqlApiDto addSqlApiDto) {
        boolean checkIn = true;
        if (HussarUtils.isNotEmpty((Object)addSqlApiDto.getInParams())) {
            List body = addSqlApiDto.getInParams().getBody();
            CheckInParamDto checkInParamDto = new CheckInParamDto();
            checkInParamDto.setCustomSql(addSqlApiDto.getCustomSql());
            List<Object> inParamList = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)body)) {
                inParamList = body.stream().filter(item -> !item.getName().equalsIgnoreCase("size") && !item.getName().equalsIgnoreCase("current")).map(EaiParamsItems::getName).collect(Collectors.toList());
            }
            checkInParamDto.setInParamList(inParamList);
            checkIn = this.checkInParam(checkInParamDto);
        }
        return checkIn;
    }

    private void fillStructureItemsStructureId(List<StructureItems> structureValues, Map<String, String> map) {
        for (StructureItems item : structureValues) {
            Integer type = item.getType();
            String value = item.getValue();
            if (type.equals(EaiDataType.DATA_TYPE_STRUCTURE.getType()) && map.get(value) != null) {
                item.setQuoteStructureId(map.get(value));
            }
            this.fillStructureItemsStructureId(item.getItems(), map);
        }
    }

    private void fillStructureId(EaiParamsItems items, Map<String, String> map) {
        List child;
        String value = items.getValue();
        if (StringUtils.isNotBlank((CharSequence)value) && map.get(value) != null) {
            items.setQuoteStructureId(map.get(value));
        }
        if (HussarUtils.isNotEmpty((Object)(child = items.getItems()))) {
            for (EaiParamsItems item : child) {
                this.fillStructureId(item, map);
            }
        }
    }

    @HussarTransactional
    private void saveBaseApiInfo(AddSqlApiDto addSqlApiDto) {
        ApiInfo apiInfo = new ApiInfo();
        BeanUtil.copyProperties((Object)addSqlApiDto, (Object)apiInfo);
        Long id = EngineUtil.getId();
        apiInfo.setId(id);
        QuerySqlInParam inParams = addSqlApiDto.getInParams();
        EaiParamsConvertDto outParams = addSqlApiDto.getOutParams();
        if (HussarUtils.isNotEmpty((Object)inParams) && HussarUtils.isNotEmpty((Object)inParams.getBody())) {
            List items = inParams.getBody();
            for (EaiParamsItems item : items) {
                item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
            }
            String s = this.canvaParamsConvertService.convertInParamsStr(addSqlApiDto.getApplicationCode(), addSqlApiDto.getApiCode(), inParams.getBody());
            apiInfo.setInParams(s);
        }
        if (HussarUtils.isNotEmpty((Object)outParams) && HussarUtils.isNotEmpty((Object)outParams.getBody())) {
            apiInfo.setOutParams(ParamsConvertUtil.toEaiParamsItemsStr((EaiParamsConvertDto)outParams, (Integer)0, (boolean)false));
        }
        addSqlApiDto.setId(id + "");
        if (HussarUtils.isBlank((CharSequence)apiInfo.getDataFormat())) {
            apiInfo.setDataFormat(EaiDataCategoryEnum.JSON.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getEncodingType())) {
            apiInfo.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getRequestType())) {
            apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getTestState())) {
            apiInfo.setTestState("0");
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getPublicState())) {
            apiInfo.setPublicState("0");
        }
        apiInfo.setApiState("0");
        apiInfo.setDraftState("0");
        this.apiInfoService.save((Object)apiInfo);
    }

    @HussarTransactional
    private void saveSqlInfo(AddSqlApiDto addSqlApiDto) {
        String dsId = addSqlApiDto.getDsId();
        String customSql = addSqlApiDto.getCustomSql();
        boolean pageFlag = addSqlApiDto.getPageFlag();
        String applicationCode = addSqlApiDto.getApplicationCode();
        SysDataSetInfoDto sysDataSetInfoDto = new SysDataSetInfoDto();
        sysDataSetInfoDto.setDataSourceId(Long.valueOf(Long.parseLong(dsId)));
        EaiQuerySqlConf sqlConf = new EaiQuerySqlConf();
        sqlConf.setApiId(Long.valueOf(Long.parseLong(addSqlApiDto.getId())));
        sqlConf.setId(EngineUtil.getId());
        sqlConf.setApplicationCode(applicationCode);
        SysDataSourceDto searchSysDataSource = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dsId)));
        sqlConf.setDataSourceId(Long.valueOf(Long.parseLong(dsId)));
        sqlConf.setDataSourceName(searchSysDataSource.getConnName());
        sqlConf.setMpSql(customSql);
        sqlConf.setPageFlag(pageFlag ? "Y" : "N");
        Long canvasId = EngineUtil.getId();
        sqlConf.setCanvasId(canvasId);
        this.eaiQuerySqlConfService.save((Object)sqlConf);
        SaveDatasetDto saveDatasetDto = new SaveDatasetDto();
        saveDatasetDto.setApiPath(addSqlApiDto.getApiPath());
        saveDatasetDto.setApplicationCode(applicationCode);
        saveDatasetDto.setDsId(dsId);
        saveDatasetDto.setCustomSql(customSql);
        saveDatasetDto.setPageFlag(pageFlag);
        if (HussarUtils.isNotEmpty((Object)addSqlApiDto.getInParams()) && HussarUtils.isNotEmpty((Object)addSqlApiDto.getInParams().getBody())) {
            saveDatasetDto.setInParams(addSqlApiDto.getInParams().getBody());
        }
        this.saveDataSetInfo(saveDatasetDto);
        EditApi editApi = new EditApi();
        editApi.setCanvasId(canvasId);
        if (HussarUtils.isNotEmpty((Object)addSqlApiDto.getId())) {
            editApi.setApiId(Long.valueOf(addSqlApiDto.getId()));
        }
        editApi.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        if (HussarUtils.isNotEmpty((Object)addSqlApiDto.getInParams()) && HussarUtils.isNotEmpty((Object)addSqlApiDto.getInParams().getBody())) {
            for (EaiParamsItems item : addSqlApiDto.getInParams().getBody()) {
                item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
            }
            String s = this.canvaParamsConvertService.convertInParamsStr(addSqlApiDto.getApplicationCode(), addSqlApiDto.getApiCode(), addSqlApiDto.getInParams().getBody());
            s = this.canvaParamsConvertService.convertEditInBodyParamsStr(s);
            editApi.setInParams(s);
        }
        if (HussarUtils.isNotEmpty((Object)addSqlApiDto.getOutParams())) {
            editApi.setOutParams(JSONObject.toJSONString((Object)addSqlApiDto.getOutParams()));
        }
        this.iEaiEditApiService.save((Object)editApi);
        this.saveCanvas(canvasId, addSqlApiDto);
    }

    private void saveCanvas(Long canvasId, AddSqlApiDto addSqlApiDto) {
        boolean canvas;
        if (0 == this.eaiApiProperties.getLogicType()) {
            return;
        }
        SqlGenerateCanvasInfoDto sqlGenerateCanvasInfoDto = new SqlGenerateCanvasInfoDto();
        BeanUtil.copy((Object)addSqlApiDto, (Object)((Object)sqlGenerateCanvasInfoDto));
        ApiCanvasInfo apiCanvasInfo = this.generateCanvasTemplateService.convertCanvasInfo((GenerateCanvasCommonInfoDto)sqlGenerateCanvasInfoDto, "2");
        this.canvasInfoService.removeById((Serializable)canvasId);
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setId(canvasId);
        if (HussarUtils.isNotEmpty((Object)apiCanvasInfo)) {
            canvasInfo.setCanvasContent(JSON.toJSONString((Object)apiCanvasInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.DisableCircularReferenceDetect}));
            canvasInfo.setCanvasResources(JSON.toJSONString((Object)apiCanvasInfo.getRelateFiles()));
        }
        if (!(canvas = this.canvasInfoService.save((Object)canvasInfo))) {
            throw new BaseException(ERROR);
        }
    }

    public Object runTest(RunCustomSqlDto runCustomSqlDto) {
        this.checkSql(runCustomSqlDto.getCustomSql());
        TestDfCustomSqlVo testDfCustomSqlVo = this.preivewDataBySql(runCustomSqlDto);
        if (runCustomSqlDto.getPageFlag()) {
            PageVo pageVo = new PageVo();
            pageVo.setRecords(testDfCustomSqlVo.getQueryResult());
            pageVo.setTotal(testDfCustomSqlVo.getTotal().longValue());
            return pageVo;
        }
        return testDfCustomSqlVo.getQueryResult();
    }

    private List<ProjectionField> getProjection(RunCustomSqlDto runCustomSqlDto) {
        String dsIs = runCustomSqlDto.getDsId();
        String customSql = SQLUtil.getStaticQuerySql((String)runCustomSqlDto.getCustomSql());
        com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto customSqlDto = new com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto();
        customSqlDto.setDataSourceId(dsIs);
        customSqlDto.setCurrent(Integer.valueOf(1));
        customSqlDto.setSize(Integer.valueOf(1));
        customSqlDto.setParameterValues(new ArrayList());
        customSqlDto.setPagination(runCustomSqlDto.getPageFlag());
        customSqlDto.setCustomSql(SQLUtil.escEscapeSql((String)customSql));
        return this.customSqlQueryService.preivewDataBySql(customSqlDto).getProjectionFields();
    }

    private TestDfCustomSqlVo preivewDataBySql(RunCustomSqlDto runCustomSqlDto) {
        String dsId = runCustomSqlDto.getDsId();
        boolean pageFlag = runCustomSqlDto.getPageFlag();
        String customSql = runCustomSqlDto.getCustomSql();
        Integer limit = runCustomSqlDto.getLimit();
        if (limit == null) {
            limit = this.eaiApiProperties.getQuerySqlTestLimit();
        }
        List inParams = runCustomSqlDto.getInParams();
        Map outurlRequestParams = SqlParamUtil.getQuerySqlRealParams((List)inParams, (Object)runCustomSqlDto.getBody());
        ArrayList<DfColumnValue> parameterValues = new ArrayList<DfColumnValue>();
        if (HussarUtils.isNotEmpty((Object)outurlRequestParams)) {
            for (String name : outurlRequestParams.keySet()) {
                DfColumnValue dfColumnValue = new DfColumnValue();
                dfColumnValue.setCode(name);
                dfColumnValue.setValue(outurlRequestParams.get(name));
                parameterValues.add(dfColumnValue);
            }
        }
        com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto customSqlDto = new com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto();
        customSqlDto.setDataSourceId(dsId);
        customSqlDto.setParameterValues(parameterValues);
        customSqlDto.setPagination(pageFlag);
        customSqlDto.setCustomSql(SQLUtil.escEscapeSql((String)customSql));
        if (pageFlag) {
            Integer size;
            Integer current = outurlRequestParams.get("current") != null ? (Integer)outurlRequestParams.get("current") : 1;
            if (current < 1) {
                current = 1;
            }
            if ((size = Integer.valueOf(outurlRequestParams.get("size") != null ? (Integer)outurlRequestParams.get("size") : 10)) > limit) {
                throw new BaseException("\u8d85\u51fa\u67e5\u8be2\u5206\u9875\u9650\u5236\u3010" + limit + "\u3011");
            }
            customSqlDto.setCurrent(current);
            customSqlDto.setSize(size);
        } else {
            HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
            SysDataSourceDto sysDataSource = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dsId)));
            CustomSqlDto countDto = new CustomSqlDto();
            countDto.setSql(customSqlDto.getCustomSql());
            countDto.setPollName(sysDataSource.getDbName());
            countDto.setParams(outurlRequestParams);
            Long cnt = (Long)hussarDdlService.selectCount(countDto);
            if (cnt > (long)limit.intValue()) {
                throw new BaseException("\u8d85\u51fa\u67e5\u8be2\u9650\u5236\u3010" + limit + "\u3011,\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
            }
        }
        TestDfCustomSqlVo testDfCustomSqlVo = null;
        try {
            testDfCustomSqlVo = this.customSqlQueryService.preivewDataBySql(customSqlDto);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cSQL\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u6267\u884cSQL\u5f02\u5e38:" + e.getMessage());
        }
        return testDfCustomSqlVo;
    }

    public List<EaiParamsItems> mapOut(MappingOutParamDto mappingOutParamDto) {
        String script = mappingOutParamDto.getCustomSql();
        List sqlSelectList = SQLUtil.parseSql((String)script);
        this.checkSql(script, sqlSelectList);
        String validateMsg = this.validateService.validate((Object)mappingOutParamDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String dsId = mappingOutParamDto.getDsId();
        String customSql = mappingOutParamDto.getCustomSql();
        SysDataSourceDto dataSourceById = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dsId)));
        ItemDataSource itemDataSource = this.dynamicDataSourceService.getDatasourceByPoolName(dataSourceById.getConnName());
        try {
            Connection connection = itemDataSource.getConnection();
            List list = SQLUtil.parseSqlResponseMapping((Connection)connection, (String)customSql, (List)sqlSelectList);
            if (HussarUtils.isNotEmpty((Object)list)) {
                ArrayList<EaiParamsItems> items = new ArrayList<EaiParamsItems>();
                for (SqlResponseMapping mapping : list) {
                    EaiParamsItems item = new EaiParamsItems();
                    item.setName(mapping.getColumnLabel());
                    item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
                    item.setMappingName(mapping.getColumnLabel());
                    item.setType(SqlParamUtil.getEaiDataType((String)mapping.getColumnClassName()));
                    item.setValue(item.getType() + "");
                    items.add(item);
                }
                return items;
            }
            return null;
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884cSQL\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u6267\u884cSQL\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u51fa\u53c2\u6620\u5c04\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u83b7\u53d6\u51fa\u53c2\u6620\u5c04\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkInParam(CheckInParamDto checkInParamDto) {
        String validateMsg = this.validateService.validate((Object)checkInParamDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String customSql = checkInParamDto.getCustomSql();
        List inParamList = checkInParamDto.getInParamList();
        List inParams = null;
        try {
            inParams = this.sqlParseService.parseSql(customSql);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790SQL\u5165\u53c2\u5931\u8d25\u6620\u5c04\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u89e3\u6790SQL\u5165\u53c2\u5931\u8d25\u6620\u5c04\u5931\u8d25:" + e.getMessage());
        }
        if (HussarUtils.isEmpty((Object)inParamList) && HussarUtils.isEmpty((Object)inParams)) {
            return true;
        }
        if (HussarUtils.isNotEmpty((Object)inParamList) && HussarUtils.isNotEmpty((Object)inParams)) {
            return inParamList.containsAll(inParams) && inParams.containsAll(inParamList);
        }
        return false;
    }

    public EaiParamsConvertDto assembleInParam(String sql) {
        AssertUtil.isNotEmpty((String)sql, (String)"SQL\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Map namesMap = null;
        try {
            namesMap = this.sqlParseService.parseSqlWithType(sql);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790SQL\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException("\u89e3\u6790SQL\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        Set inParamNames = namesMap.keySet();
        EaiParamsConvertDto inParams = new EaiParamsConvertDto();
        EaiParamsItems body = new EaiParamsItems();
        body.setName("body");
        body.setMappingName("body");
        body.setMapping(Integer.valueOf(1));
        body.setRemark(INPUT_REMARK);
        inParams.setBody(body);
        if (HussarUtils.isNotEmpty((Object)namesMap)) {
            ArrayList<EaiParamsItems> items = new ArrayList<EaiParamsItems>();
            for (String inParamName : inParamNames) {
                EaiParamsItems item = new EaiParamsItems();
                item.setMapping(Integer.valueOf(EaiApiParamMappingEnum.BODY.getCode()));
                item.setName(inParamName);
                item.setMappingName(inParamName);
                String javaType = (String)namesMap.get(inParamName);
                Integer eaiDataType = SqlParamUtil.getEaiDataType((String)javaType);
                item.setType(eaiDataType);
                item.setValue(item.getType() + "");
                if (eaiDataType.equals(EaiDataType.DATA_TYPE_LIST.getType())) {
                    item.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                    EaiParamsItems child = new EaiParamsItems();
                    child.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                    child.setName("items");
                    child.setMappingName("items");
                    child.setMapping(Integer.valueOf(1));
                    child.setValue(child.getType() + "");
                    item.setItems((List)Lists.newArrayList((Object[])new EaiParamsItems[]{child}));
                }
                items.add(item);
            }
            body.setItems(items);
        }
        return inParams;
    }

    public ApiResponse<Boolean> saveDataSetInfo(SaveDatasetDto saveDatasetDto) {
        List inParams = saveDatasetDto.getInParams();
        boolean pageFlag = saveDatasetDto.getPageFlag();
        String customSql = saveDatasetDto.getCustomSql();
        String dsId = saveDatasetDto.getDsId();
        String apiPath = saveDatasetDto.getApiPath();
        String applicationCode = saveDatasetDto.getApplicationCode();
        List list = this.apiInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApiPath, (Object)apiPath)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (HussarUtils.isEmpty((Object)list)) {
            throw new BaseException("\u672a\u627e\u5230\u8def\u5f84\u4e3a\u3010" + apiPath + "\u3011\u7684api\u57fa\u672c\u4fe1\u606f");
        }
        ApiInfo apiInfo = (ApiInfo)list.get(0);
        Long apiId = apiInfo.getId();
        EaiDatasetRelation one = (EaiDatasetRelation)this.eaiDatasetRelationService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiDatasetRelation::getApiId, (Object)apiId));
        SysDataSetInfoDto sysDataSetInfoDto = new SysDataSetInfoDto();
        if (HussarUtils.isEmpty((Object)one)) {
            RunCustomSqlDto runCustomSqlDto = new RunCustomSqlDto();
            runCustomSqlDto.setCustomSql(customSql);
            runCustomSqlDto.setPageFlag(pageFlag);
            runCustomSqlDto.setInParams(inParams);
            runCustomSqlDto.setDsId(dsId);
            List<ProjectionField> projection = this.getProjection(runCustomSqlDto);
            ApiModelInfo apiModelInfo = new ApiModelInfo();
            apiModelInfo.setApiurl(apiPath);
            apiModelInfo.setIsPage(Boolean.valueOf(pageFlag));
            apiModelInfo.setRequestMethod("post");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sql", customSql);
            map.put("projection", projection);
            map.put("fuction", Lists.newArrayList((Object[])new ApiModelInfo[]{apiModelInfo}));
            sysDataSetInfoDto.setData(JSON.toJSONString(map));
            Long datasetId = EngineUtil.getId();
            sysDataSetInfoDto.setDataSetId(datasetId);
            sysDataSetInfoDto.setDataSetType("1");
            sysDataSetInfoDto.setDataSourceId(Long.valueOf(Long.parseLong(dsId)));
            this.sysDataSetInfoService.addDataSetInfo(sysDataSetInfoDto);
            EaiDatasetRelation eaiDatesetRelation = new EaiDatasetRelation();
            eaiDatesetRelation.setId(EngineUtil.getId());
            eaiDatesetRelation.setApiId(apiId);
            eaiDatesetRelation.setApplicationCode(applicationCode);
            eaiDatesetRelation.setDatasetId(datasetId);
            this.eaiDatasetRelationService.save((Object)eaiDatesetRelation);
        } else {
            Long datasetId = one.getDatasetId();
            RunCustomSqlDto runCustomSqlDto = new RunCustomSqlDto();
            runCustomSqlDto.setCustomSql(customSql);
            runCustomSqlDto.setPageFlag(pageFlag);
            runCustomSqlDto.setInParams(inParams);
            runCustomSqlDto.setDsId(dsId);
            List<ProjectionField> projection = this.getProjection(runCustomSqlDto);
            ApiModelInfo apiModelInfo = new ApiModelInfo();
            apiModelInfo.setApiurl(apiInfo.getApiPath());
            apiModelInfo.setIsPage(Boolean.valueOf(pageFlag));
            apiModelInfo.setRequestMethod("post");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sql", customSql);
            map.put("projection", projection);
            map.put("fuction", Lists.newArrayList((Object[])new ApiModelInfo[]{apiModelInfo}));
            sysDataSetInfoDto.setData(JSON.toJSONString(map));
            sysDataSetInfoDto.setDataSetId(datasetId);
            sysDataSetInfoDto.setData(JSON.toJSONString(map));
            this.sysDataSetInfoService.editDataSetInfo(sysDataSetInfoDto);
        }
        return ApiResponse.success((Object)Boolean.TRUE);
    }

    public ApiResponse<Boolean> publishDataSet(Long datasetId) {
        try {
            return this.dataSetPushService.publishDataSet(datasetId);
        }
        catch (Exception e) {
            throw new BaseException("\u53d1\u5e03\u6570\u636e\u96c6 id={" + datasetId + "}\u5931\u8d25", (Throwable)e);
        }
    }

    @HussarTransactional
    public Boolean deleteApi(String id) {
        Long apiId = Long.parseLong(id);
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)apiId);
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (HussarUtils.equals((Object)apiInfo.getApiState(), (Object)"1")) {
            throw new HussarException("\u5df2\u4e0a\u67b6\u63a5\u53e3\u4e0d\u80fd\u5220\u9664");
        }
        String apiType = apiInfo.getApiType();
        if (StringUtil.isNotBlank((CharSequence)apiType) && apiType.equalsIgnoreCase("3")) {
            this.eaiQuerySqlConfService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiQuerySqlConf::getApiId, (Object)apiId));
            this.eaiDatasetRelationService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiDatasetRelation::getApiId, (Object)apiId));
            this.iEaiEditApiService.remove((Wrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiId));
        }
        this.releaseApiService.deleteById(id);
        return true;
    }

    public ApiResponse<String> editApiInfo(EditSqlApiDto editSqlApiDto) {
        String apiId = editSqlApiDto.getId();
        List addCommonStructureList = editSqlApiDto.getAddCommonStructureList();
        String dsId = editSqlApiDto.getDsId();
        String customSql = editSqlApiDto.getCustomSql();
        boolean pageFlag = editSqlApiDto.getPageFlag();
        List inParams = editSqlApiDto.getInParams();
        ApiInfo apiInfo = new ApiInfo();
        BeanUtil.copyProperties((Object)editSqlApiDto, (Object)apiInfo);
        this.apiInfoService.updateById((Object)apiInfo);
        this.eaiCommonStructureService.saveBatchStructure(addCommonStructureList);
        EaiQuerySqlConf eaiQuerySqlConf = (EaiQuerySqlConf)this.eaiQuerySqlConfService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiQuerySqlConf::getApiId, (Object)apiId));
        eaiQuerySqlConf.setDataSourceId(Long.valueOf(Long.parseLong(dsId)));
        eaiQuerySqlConf.setPageFlag(pageFlag ? "Y" : "N");
        eaiQuerySqlConf.setMpSql(customSql);
        this.eaiQuerySqlConfService.updateById((Object)eaiQuerySqlConf);
        SaveDatasetDto saveDatasetDto = new SaveDatasetDto();
        saveDatasetDto.setApiPath(apiInfo.getApiPath());
        saveDatasetDto.setDsId(dsId);
        saveDatasetDto.setCustomSql(customSql);
        saveDatasetDto.setPageFlag(pageFlag);
        saveDatasetDto.setInParams(inParams);
        this.saveDataSetInfo(saveDatasetDto);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public QuerySqlApiInfoVo getQuerySqlApiInfo(Long id) {
        QuerySqlApiInfoVo querySqlApiInfoVo = this.eaiQuerySqlBaseMapper.getById(id);
        if (querySqlApiInfoVo != null) {
            String inParamsStr = querySqlApiInfoVo.getInParamsStr();
            String outParamsStr = querySqlApiInfoVo.getOutParamsStr();
            if (HussarUtils.isNotBlank((CharSequence)inParamsStr)) {
                EaiParamsConvertDto inParams = this.eaiConvertService.toEaiParamsConvertDto(inParamsStr);
                querySqlApiInfoVo.setInParams(inParams);
            } else {
                querySqlApiInfoVo.setInParams(new EaiParamsConvertDto());
            }
            if (HussarUtils.isNotBlank((CharSequence)outParamsStr)) {
                EaiParamsConvertDto outParams = this.eaiConvertService.toEaiParamsConvertDto(outParamsStr);
                querySqlApiInfoVo.setOutParams(outParams);
            } else {
                querySqlApiInfoVo.setOutParams(new EaiParamsConvertDto());
            }
        }
        return querySqlApiInfoVo;
    }

    @HussarTransactional
    public LogicQuerySqlOutParamVo mapOutAndCreateStructure(LogicMappingOutParamDto mappingOutParamDto) {
        this.checkSql(mappingOutParamDto.getCustomSql());
        MappingOutParamDto mop = new MappingOutParamDto();
        BeanUtils.copyProperties((Object)mappingOutParamDto, (Object)mop);
        List<EaiParamsItems> eaiParamsItems = this.mapOut(mop);
        LogicQuerySqlOutParamVo vo = new LogicQuerySqlOutParamVo();
        vo.setOutColumnInfo(eaiParamsItems);
        String structureId = mappingOutParamDto.getStructureId();
        Long inId = null;
        inId = StringUtils.isNotBlank((CharSequence)structureId) ? Long.valueOf(Long.parseLong(structureId)) : EngineUtil.getId();
        CommonStructure commonStructure = new CommonStructure();
        commonStructure.setApplicationCode(mappingOutParamDto.getApplicationCode());
        commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
        commonStructure.setId(inId);
        commonStructure.setStructureCode("canvas_out_" + inId);
        ArrayList<StructureItems> list = new ArrayList<StructureItems>();
        for (EaiParamsItems item : eaiParamsItems) {
            String name = item.getName();
            Integer type = item.getType();
            StructureItems structureItem = new StructureItems();
            structureItem.setNickName(name);
            structureItem.setName(name);
            structureItem.setType(type);
            structureItem.setValue(type + "");
            list.add(structureItem);
        }
        commonStructure.setStructureValues(JSON.toJSONString(list));
        commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getType() + "");
        commonStructure.setStructureName("canvas_out_" + inId);
        if (StringUtils.isNotBlank((CharSequence)structureId)) {
            this.commonStructureService.updateById((Object)commonStructure);
        } else {
            this.commonStructureService.save((Object)commonStructure);
        }
        vo.setStructureId(inId + "");
        return vo;
    }

    public boolean checkOutRight(OutCheckDto outCheckDto) {
        String validateMsg = this.validateService.validate((Object)outCheckDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String dsId = outCheckDto.getDsId();
        String customSql = outCheckDto.getCustomSql();
        List outNameList = outCheckDto.getOutNameList();
        ArrayList<CheckParamItem> executeList = new ArrayList<CheckParamItem>();
        if (HussarUtils.isEmpty((Object)outNameList)) {
            return false;
        }
        SysDataSourceDto dataSourceById = this.datasourceService.getDataSourceById(Long.valueOf(Long.parseLong(dsId)));
        ItemDataSource itemDataSource = this.dynamicDataSourceService.getDatasourceByPoolName(dataSourceById.getConnName());
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = itemDataSource.getConnection();
            String staticSql = SQLUtil.getStaticQuerySql((String)customSql);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(staticSql);
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                String columnLabel = data.getColumnLabel(i);
                String columnClassName = data.getColumnClassName(i);
                Integer eaiDataType = SqlParamUtil.getEaiDataType((String)columnClassName);
                CheckParamItem outParamItem = new CheckParamItem(columnLabel, eaiDataType);
                executeList.add(outParamItem);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884cSQL\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOGGER.error("resultSet close:{}", (Object)e.getMessage());
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("statement close:{}", (Object)e.getMessage());
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOGGER.error("connection close:{}", (Object)ex.getMessage());
                    throw new BaseException(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return outNameList.containsAll(executeList) && executeList.containsAll(outNameList);
    }

    public ScriptLabelVo quickFill(String label) {
        ScriptLabelVo vo = new ScriptLabelVo();
        vo.setFragment("");
        vo.setLabel("");
        if (StringUtils.isNotBlank((CharSequence)label)) {
            if (label.equalsIgnoreCase("foreach")) {
                vo.setLabel("foreach");
                vo.setFragment("<foreach item='item' collection='\u96c6\u5408\u53c2\u6570\u540d\u79f0' open='(' separator=',' close=')'> \n #{item} \n</foreach>");
            } else if (label.equalsIgnoreCase("if")) {
                vo.setLabel("if");
                vo.setFragment("<if test=\"\u53c2\u6570\u540d\u79f0 != null and \u53c2\u6570\u540d\u79f0 !=''\"> \n and \u6570\u636e\u5e93\u5b57\u6bb5 = #{\u53c2\u6570\u540d\u79f0} \n</if>");
            } else if (label.equalsIgnoreCase("where")) {
                vo.setLabel("where");
                vo.setFragment("<where>\n \n</where>");
            } else if (label.equalsIgnoreCase("like")) {
                vo.setLabel("like");
                vo.setFragment("<if test=\"\u53c2\u6570\u540d\u79f0 != null\">\n    <bind name=\"\u53c2\u6570\u522b\u540d\" value=\"'%'+\u53c2\u6570\u540d\u79f0+'%'\"/>\n    AND \u6570\u636e\u5e93\u5b57\u6bb5 LIKE #{\u53c2\u6570\u522b\u540d} ESCAPE '|'\n</if>");
            }
        }
        return vo;
    }

    public boolean checkSql(String script) {
        List sqlList = SQLUtil.parseSql((String)script);
        if (HussarUtils.isEmpty((Object)sqlList)) {
            this.checkOneSql(script);
        } else {
            for (SqlSelect sqlSelect : sqlList) {
                if (!HussarUtils.isNotBlank((CharSequence)sqlSelect.getSql())) continue;
                this.checkOneSql(sqlSelect.getSql());
            }
        }
        return true;
    }

    public boolean checkSql(String script, List<SqlSelect> sqlList) {
        if (HussarUtils.isEmpty(sqlList)) {
            this.checkOneSql(script);
        } else {
            for (SqlSelect sqlSelect : sqlList) {
                if (!HussarUtils.isNotBlank((CharSequence)sqlSelect.getSql())) continue;
                this.checkOneSql(sqlSelect.getSql());
            }
        }
        return true;
    }

    private void checkOneSql(String script) {
        if (StringUtils.isBlank((CharSequence)script)) {
            throw new BaseException("sql\u4e0d\u80fd\u4e3a\u7a7a");
        }
        script = SQLUtil.getStaticQuerySql((String)script);
        script = SQLUtil.filterComments((String)script);
        try {
            Select select = (Select)CCJSqlParserUtil.parse((String)script, null);
            if (select.getSelectBody() instanceof PlainSelect) {
                for (SelectItem si : ((PlainSelect)select.getSelectBody()).getSelectItems()) {
                    if (!(si instanceof SelectExpressionItem)) continue;
                    Expression expressionObj = ((SelectExpressionItem)si).getExpression();
                    String expression = null;
                    if (HussarUtils.isNotEmpty((Object)expressionObj)) {
                        expression = expressionObj.toString();
                    }
                    Alias alias = ((SelectExpressionItem)si).getAlias();
                    if (!HussarUtils.isNotBlank((CharSequence)expression) || !expression.contains("(") || !expression.contains(")") || !HussarUtils.isEmpty((Object)alias)) continue;
                    throw new BaseException(expression + "\u9700\u8981\u6dfb\u52a0\u522b\u540d");
                }
            }
        }
        catch (JSQLParserException e) {
            throw new BaseException("sql\u89e3\u6790\u51fa\u9519", (Throwable)e);
        }
    }
}

