/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.DfParamEntiy;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class SqlParamUtil {
    private static Map<Integer, String> javaTypeMap = new HashMap<Integer, String>();

    private SqlParamUtil() {
    }

    public static String getJavaType(Integer type) {
        if (type == null) {
            throw new BaseException("\u975e\u6cd5\u7c7b\u578b");
        }
        String javaType = javaTypeMap.get(type);
        if (StringUtils.isBlank((CharSequence)javaType)) {
            throw new BaseException("\u975e\u6cd5\u7c7b\u578b");
        }
        return javaType;
    }

    public static Object getValueByEaiType(EaiParamsItems items, Object inputValue) {
        Integer type = items.getType();
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_BOOLEAN.getType())) {
            throw new BaseException("\u4e0d\u652f\u6301\u5e03\u5c14\u7c7b\u578b\uff01");
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_LIST.getType()) && HussarUtils.isNotEmpty((Object)inputValue)) {
            String s = JSON.toJSONString((Object)inputValue);
            Integer itemType = items.getItemType();
            String javaType = SqlParamUtil.getJavaType(itemType);
            try {
                Class<?> aClass = Class.forName(javaType);
                return JSON.parseArray((String)s, aClass);
            }
            catch (ClassNotFoundException e) {
                throw new BaseException("\u52a0\u8f7d" + javaType + "\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return ParamsConvertUtil.parseDataType((Object)inputValue, (Integer)type, (boolean)true);
    }

    public static Integer getEaiDataType(String columnClassName) {
        if (columnClassName.equalsIgnoreCase("java.sql.Date") || columnClassName.equalsIgnoreCase("java.sql.Time") || columnClassName.equalsIgnoreCase("java.sql.Timestamp")) {
            return EaiDataType.DATA_TYPE_DATE.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Long")) {
            return EaiDataType.DATA_TYPE_LONG.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Integer")) {
            return EaiDataType.DATA_TYPE_INTEGER.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Double")) {
            return EaiDataType.DATA_TYPE_DOUBLE.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.util.List")) {
            return EaiDataType.DATA_TYPE_LIST.getType();
        }
        if (columnClassName.equalsIgnoreCase("com.jxdinfo.hussar.eai.common.vo.PageVo")) {
            return EaiDataType.DATA_TYPE_PAGE.getType();
        }
        return EaiDataType.DATA_TYPE_STRING.getType();
    }

    public static EaiParamsConvertDto fillInputValueInParam(EaiParamsConvertDto inParams, Object body) {
        List items = inParams.getBody().getItems();
        if (body == null) {
            return inParams;
        }
        Map inputValueMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)body), Map.class);
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(inputValueMap);
        for (EaiParamsItems item : items) {
            String name = item.getName();
            Object value = caseInsensitiveMap.get(name);
            if (!HussarUtils.isNotEmpty(value)) continue;
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                JSONArray newArray = SqlParamUtil.filterBlank(array);
                if (!HussarUtils.isNotEmpty((Object)newArray)) continue;
                item.setInputValue((Object)newArray);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)value.toString())) continue;
            item.setInputValue(value);
        }
        return inParams;
    }

    public static JSONArray filterBlank(JSONArray array) {
        if (HussarUtils.isEmpty((Object)array)) {
            return null;
        }
        JSONArray newArray = new JSONArray();
        for (Object obj : array) {
            if (!HussarUtils.isNotEmpty(obj)) continue;
            newArray.add(obj);
        }
        return newArray;
    }

    public static Map<String, Object> getQuerySqlRealParams(List<EaiParamsItems> inParams, Object body) {
        LinkedHashMap<String, Object> outurlRequestParams = new LinkedHashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)body)) {
            Map bodyMap = (Map)body;
            Map inputValueMap = null;
            String k = (String)bodyMap.keySet().iterator().next();
            inputValueMap = k.equalsIgnoreCase("params") ? (Map)JSON.parseObject((String)JSON.toJSONString(bodyMap.get(k)), Map.class) : (Map)JSON.parseObject((String)JSON.toJSONString((Object)body), Map.class);
            CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(inputValueMap);
            for (EaiParamsItems item : inParams) {
                SqlParamUtil.extracted(item, (Map<String, Object>)caseInsensitiveMap, outurlRequestParams);
            }
        }
        return outurlRequestParams;
    }

    private static void extracted(EaiParamsItems item, Map<String, Object> caseInsensitiveMap, Map<String, Object> outurlRequestParams) {
        String name = item.getName();
        Object value = caseInsensitiveMap.get(name);
        if (HussarUtils.isNotEmpty((Object)value)) {
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                JSONArray newArray = SqlParamUtil.filterBlank(array);
                if (HussarUtils.isNotEmpty((Object)newArray)) {
                    item.setInputValue((Object)newArray);
                    outurlRequestParams.put(name, SqlParamUtil.getValueByEaiType(item, value));
                }
            } else if (StringUtils.isNotBlank((CharSequence)value.toString())) {
                item.setInputValue(value);
                outurlRequestParams.put(name, SqlParamUtil.getValueByEaiType(item, value));
            }
        }
    }

    @NotNull
    public static Map<String, Object> getDfRealRequestParams(Map<String, Object> requestParams) {
        if (HussarUtils.isEmpty(requestParams)) {
            return new LinkedHashMap<String, Object>();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String name : requestParams.keySet()) {
            boolean isCollection;
            Object obj = requestParams.get(name);
            DfParamEntiy dfParamEntiy = new DfParamEntiy();
            dfParamEntiy.setObj(obj);
            if (HussarUtils.isEmpty((Object)obj)) continue;
            boolean isString = obj instanceof CharSequence && StringUtils.isNotBlank((CharSequence)obj.toString());
            boolean isArray = obj.getClass().isArray() && HussarUtils.isNotEmpty((Object)obj);
            boolean bl = isCollection = obj instanceof Collection && HussarUtils.isNotEmpty((Object)obj);
            if (isString) {
                dfParamEntiy.setFlag(true);
                dfParamEntiy.setValue(obj.toString());
            } else if (isArray) {
                SqlParamUtil.dealArray(dfParamEntiy);
            } else if (isCollection) {
                SqlParamUtil.dealCollection(dfParamEntiy);
            } else if (StringUtils.isNotBlank((CharSequence)obj.toString())) {
                dfParamEntiy.setFlag(true);
                dfParamEntiy.setValue(obj);
            }
            if (!dfParamEntiy.getFlag().booleanValue()) continue;
            result.put(name, dfParamEntiy.getValue());
        }
        return result;
    }

    private static void dealArray(DfParamEntiy dfParamEntiy) {
        Object[] arr = (Object[])dfParamEntiy.getObj();
        Object[] newArr = new Object[]{};
        int i = 0;
        for (Object temp : arr) {
            if (!HussarUtils.isNotEmpty((Object)temp)) continue;
            newArr[i++] = temp;
        }
        dfParamEntiy.setFlag(HussarUtils.isNotEmpty((Object[])newArr));
        dfParamEntiy.setValue(newArr);
    }

    private static void dealCollection(DfParamEntiy dfParamEntiy) {
        Collection collection = (Collection)dfParamEntiy.getObj();
        Iterator iterator = collection.iterator();
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!HussarUtils.isNotEmpty(next)) continue;
            list.add(next);
        }
        dfParamEntiy.setFlag(HussarUtils.isNotEmpty(list));
        dfParamEntiy.setValue(list);
    }

    static {
        javaTypeMap.put(0, "java.lang.Boolean");
        javaTypeMap.put(1, "java.lang.Integer");
        javaTypeMap.put(2, "java.lang.Long");
        javaTypeMap.put(3, "java.lang.Double");
        javaTypeMap.put(4, "java.lang.String");
        javaTypeMap.put(5, "java.time.LocalDateTime");
        javaTypeMap.put(6, "java.util.List");
    }
}

