/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.SqlResponseMapping;
import com.jxdinfo.hussar.eai.datasource.rdb.model.SqlSelect;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.formatter.Formatter;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLUtil.class);
    private static final Pattern where = Pattern.compile("\\bwhere\\b");
    private static final Pattern groupby = Pattern.compile("\\bgroup\\s+by\\b", 32);
    private static final Pattern orderby = Pattern.compile("\\border\\s+by\\b", 32);
    private static final Pattern union = Pattern.compile("\\bunion\\b", 32);
    private static final Pattern unionAll = Pattern.compile("\\bunion\\s+all\\b", 32);
    private static Map<String, String> map1 = new LinkedHashMap<String, String>();
    private static Map<String, String> map2 = new LinkedHashMap<String, String>();

    private SQLUtil() {
    }

    public static List<SqlSelect> parseSql(String script) {
        SqlSelect sqlSelect;
        Matcher matcherUnionAll = unionAll.matcher(script.toLowerCase());
        ArrayList<SqlSelect> sqlList = new ArrayList<SqlSelect>();
        String temp = script;
        while (matcherUnionAll.find()) {
            sqlSelect = new SqlSelect();
            int start = matcherUnionAll.start();
            int end = matcherUnionAll.end();
            sqlSelect.setSql(script.substring(0, start));
            sqlSelect.setJoinStr(script.substring(start, end));
            sqlList.add(sqlSelect);
            temp = script.substring(end, script.length());
        }
        if (HussarUtils.isNotEmpty(sqlList) && StringUtils.isNotBlank((CharSequence)temp)) {
            sqlSelect = new SqlSelect();
            sqlSelect.setSql(temp);
            sqlSelect.setJoinStr("UNION ALL");
            sqlList.add(sqlSelect);
        }
        if (HussarUtils.isEmpty(sqlList)) {
            Matcher matcherUnion = union.matcher(script.toLowerCase());
            while (matcherUnion.find()) {
                SqlSelect sqlSelect2 = new SqlSelect();
                int start = matcherUnion.start();
                int end = matcherUnion.end();
                sqlSelect2.setSql(script.substring(0, start));
                sqlSelect2.setJoinStr(script.substring(start, end));
                sqlList.add(sqlSelect2);
                temp = script.substring(end, script.length());
            }
        }
        if (HussarUtils.isNotEmpty(sqlList) && StringUtils.isNotBlank((CharSequence)temp)) {
            sqlSelect = new SqlSelect();
            sqlSelect.setSql(temp);
            sqlSelect.setJoinStr("UNION");
            sqlList.add(sqlSelect);
        }
        return sqlList;
    }

    public static String getStaticQuerySql(String script) {
        script = SQLUtil.filterComments(script);
        List<SqlSelect> sqlList = SQLUtil.parseSql(script);
        String result = "";
        if (HussarUtils.isNotEmpty(sqlList)) {
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                SqlSelect sqlSelect = sqlList.get(i);
                String sql = sqlSelect.getSql();
                result = result + SQLUtil.getStaticQuerySqlOne(sql);
                if (i == size - 1) continue;
                result = result + " " + sqlSelect.getJoinStr() + " ";
            }
            return result;
        }
        return SQLUtil.getStaticQuerySqlOne(script);
    }

    public static String getStaticQuerySql(String script, List<SqlSelect> sqlList) {
        script = SQLUtil.filterComments(script);
        String result = "";
        if (HussarUtils.isNotEmpty(sqlList)) {
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                SqlSelect sqlSelect = sqlList.get(i);
                String sql = sqlSelect.getSql();
                result = result + SQLUtil.getStaticQuerySqlOne(sql);
                if (i == size - 1) continue;
                result = result + " " + sqlSelect.getJoinStr() + " ";
            }
            return result;
        }
        return SQLUtil.getStaticQuerySqlOne(script);
    }

    private static String wrapSql(String originalSql) {
        if (originalSql.trim().endsWith("WHERE 1 < 0")) {
            return String.format("SELECT * FROM (%s) hussar_table WHERE 1 < 0 ", originalSql.substring(0, originalSql.lastIndexOf("WHERE 1 < 0")));
        }
        return originalSql;
    }

    public static String getStaticQuerySqlOne(String sql) {
        String result = sql;
        if (sql.toLowerCase().contains("<where>")) {
            result = sql.substring(0, sql.toLowerCase().indexOf("<where>")) + sql.substring(sql.toLowerCase().indexOf("</where>") + 8, sql.length());
        }
        Matcher matcherGroupby = groupby.matcher(result.toLowerCase());
        Matcher matcherOrderby = orderby.matcher(result.toLowerCase());
        Matcher matcherWhere = where.matcher(result.toLowerCase());
        int groupByStart = 0;
        int orderByStart = 0;
        boolean hasGroup = matcherGroupby.find();
        boolean hasWhere = matcherWhere.find();
        boolean hasOrderby = matcherOrderby.find();
        if (hasGroup) {
            groupByStart = matcherGroupby.start();
        }
        if (hasOrderby) {
            orderByStart = matcherOrderby.start();
        }
        if (hasWhere) {
            int start = matcherWhere.start();
            if (groupByStart == 0 && orderByStart == 0) {
                result = sql.substring(0, start);
            }
            if (groupByStart > 0 && orderByStart > 0 && orderByStart > groupByStart) {
                result = sql.substring(0, start) + sql.substring(groupByStart - 1, orderByStart);
            }
            if (groupByStart == 0 && orderByStart > 0) {
                result = sql.substring(0, start);
            }
            if (groupByStart > 0 && orderByStart == 0) {
                result = sql.substring(0, start) + sql.substring(groupByStart - 1);
            }
        }
        return SQLUtil.wrapSql(result);
    }

    public static List<SqlResponseMapping> parseSqlResponseMapping(Connection connection, String sql, List<SqlSelect> sqlSelectList) throws Exception {
        ArrayList<SqlResponseMapping> list = new ArrayList<SqlResponseMapping>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String staticSql = SQLUtil.getStaticQuerySql(sql, sqlSelectList);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(staticSql);
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                SqlResponseMapping sqlResponseMapping = new SqlResponseMapping();
                String columnClassName = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnLabel = data.getColumnLabel(i);
                sqlResponseMapping.setColumnName(columnName);
                sqlResponseMapping.setColumnTypeName(columnTypeName);
                sqlResponseMapping.setColumnClassName(columnClassName);
                sqlResponseMapping.setColumnLabel(columnLabel);
                list.add(sqlResponseMapping);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SqlResponseMapping> parseSqlResponseMapping(Connection connection, String sql) throws Exception {
        ArrayList<SqlResponseMapping> list = new ArrayList<SqlResponseMapping>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String staticSql = SQLUtil.getStaticQuerySql(sql);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(staticSql);
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                SqlResponseMapping sqlResponseMapping = new SqlResponseMapping();
                String columnClassName = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnLabel = data.getColumnLabel(i);
                sqlResponseMapping.setColumnName(columnName);
                sqlResponseMapping.setColumnTypeName(columnTypeName);
                sqlResponseMapping.setColumnClassName(columnClassName);
                sqlResponseMapping.setColumnLabel(columnLabel);
                list.add(sqlResponseMapping);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            LOGGER.error("\u6267\u884csql\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return list;
    }

    public static String prettyFormat(String sql) {
        return new Formatter().format(sql);
    }

    public static String escEscapeSql(String sql) {
        sql = SQLUtil.filterComments(sql);
        Set<String> strings = map2.keySet();
        String first = new String(sql);
        for (String s : strings) {
            first = first.replace(s, map2.get(s));
        }
        first = first.replace("<", "&lt;");
        Set<String> strings1 = map1.keySet();
        for (String s : strings1) {
            first = first.replace(s, map1.get(s));
        }
        return first;
    }

    public static String filterComments(String sqlScript) {
        String[] escapeSql;
        String pattern = "(/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/)|(--.*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(sqlScript);
        sqlScript = m.replaceAll("");
        for (String eStr : escapeSql = sqlScript.split(SQLUtil.escapePattern())) {
            if (eStr.lastIndexOf(";") == -1) continue;
            while (eStr.lastIndexOf(";") != -1) {
                eStr = eStr.substring(0, eStr.lastIndexOf(";"));
            }
            return sqlScript.substring(0, sqlScript.lastIndexOf(eStr) + eStr.length());
        }
        return sqlScript;
    }

    private static String escapePattern() {
        StringBuilder sb = new StringBuilder("&lt;").append("|").append("&#60;").append("|").append("&gt;").append("|").append("&#62;").append("|").append("&quot;").append("|").append("&#34;").append("|").append("&amp;").append("|").append("&#38;").append("|").append("&nbsp;").append("|").append("&#160;").append("|").append("&apos;").append("|").append("&#39;");
        return sb.toString();
    }

    static {
        map1.put("\u4e09", "<where>");
        map2.put("<where>", "\u4e09");
        map1.put("\u56db", "</where>");
        map2.put("</where>", "\u56db");
        map1.put("\u520a", "<if ");
        map2.put("<if ", "\u520a");
        map1.put("\u4e15", "</if>");
        map2.put("</if>", "\u4e15");
        map1.put("\u74dc", "<foreach ");
        map2.put("<foreach ", "\u74dc");
        map1.put("\u4e18", "</foreach>");
        map2.put("</foreach>", "\u4e18");
        map1.put("\u592e", "<bind ");
        map2.put("<bind ", "\u592e");
        map1.put("\u5e03", "</bind>");
        map2.put("</bind>", "\u5e03");
        map1.put("\u53eb", "<choose>");
        map2.put("<choose>", "\u53eb");
        map1.put("\u53ed", "</choose>");
        map2.put("</choose>", "\u53ed");
        map1.put("\u77f3", "<when ");
        map2.put("<when ", "\u77f3");
        map1.put("\u5c3c", "</when>");
        map2.put("</when> ", "\u5c3c");
        map1.put("\u4ed4", "<otherwise>");
        map2.put("<otherwise> ", "\u4ed4");
        map1.put("\u7531", "</otherwise>");
        map2.put("</otherwise> ", "\u7531");
        map1.put("\u4e0b", "<trim ");
        map2.put("<trim ", "\u4e0b");
        map1.put("\u4e0a", "</trim>");
        map2.put("</trim> ", "\u4e0a");
        map1.put("\u5de6", "<![CDATA[");
        map2.put("<![CDATA[ ", "\u5de6");
        map1.put("\u53f3", "]]>");
        map2.put("]]>", "\u53f3");
        map1.put("\u672c", "/>");
        map2.put("/>", "\u672c");
    }
}

