/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public final class MybatisXmlFormater {
    private MybatisXmlFormater() {
    }

    public static String formatXml(String xmlStr, boolean suppressDeclaration) throws Exception {
        SAXReader reader = new SAXReader();
        StringReader in = new StringReader(xmlStr);
        Document doc = reader.read((Reader)in);
        OutputFormat formater = OutputFormat.createPrettyPrint();
        formater.setSuppressDeclaration(suppressDeclaration);
        formater.setNewLineAfterDeclaration(false);
        formater.setPadText(true);
        formater.setIndent(true);
        formater.setIndentSize(2);
        formater.setTrimText(false);
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, formater);
        writer.write(doc);
        String result = out.toString().trim();
        return result;
    }

    public static String trim(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return str.replaceAll("^[\u3000 ]+|[\u3000 ]+$", "");
    }

    public static String leftTrim(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return str.replaceAll("^[\u3000 ]+", "");
    }

    public static String rightTrim(String str) {
        if (str == null || str.equals("")) {
            return str;
        }
        return str.replaceAll("[\u3000 ]+$", "");
    }

    public static String getLeftBlank(String str) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            char[] chars;
            for (char c : chars = str.toCharArray()) {
                boolean isLetter;
                boolean bl = isLetter = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
                if (isLetter) break;
                if (!Character.isSpaceChar(c)) continue;
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }
}

