/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.eai.datasource.rdb.enums.DbType;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUtils {
    private static Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static DbType getDbType(String jdbcUrl) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            throw new RuntimeException("Error: The jdbcUrl is Null, Cannot read database type\uff01");
        }
        String url = jdbcUrl.toLowerCase();
        if (!url.contains(":mysql:") && !url.contains(":cobar:")) {
            if (url.contains(":mariadb:")) {
                return DbType.MARIADB;
            }
            if (url.contains(":oracle:")) {
                return DbType.ORACLE;
            }
            if (!url.contains(":sqlserver:") && !url.contains(":microsoft:")) {
                return JdbcUtils.getDbType(jdbcUrl, url);
            }
            return DbType.SQL_SERVER2005;
        }
        return DbType.MYSQL;
    }

    @NotNull
    private static DbType getDbType(String jdbcUrl, String url) {
        if (url.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (url.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (url.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (url.contains(":db2:")) {
            return DbType.DB2;
        }
        if (url.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (url.contains(":h2:")) {
            return DbType.H2;
        }
        if (JdbcUtils.regexFind(":dm\\d*:", url)) {
            return DbType.DM;
        }
        if (url.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (JdbcUtils.regexFind(":kingbase\\d*:", url)) {
            return DbType.KINGBASE_ES;
        }
        if (url.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (jdbcUrl.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (jdbcUrl.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (jdbcUrl.contains(":gbasedbt-sqli:")) {
            return DbType.GBASEDBT;
        }
        if (jdbcUrl.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (jdbcUrl.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (jdbcUrl.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (jdbcUrl.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (url.contains(":highgo:")) {
            return DbType.HIGH_GO;
        }
        if (url.contains(":cubrid:")) {
            return DbType.CUBRID;
        }
        if (url.contains(":goldilocks:")) {
            return DbType.GOLDILOCKS;
        }
        if (url.contains(":csiidb:")) {
            return DbType.CSIIDB;
        }
        logger.warn("The jdbcUrl is " + jdbcUrl + ", Cannot Read Database type or The Database's Not Supported!");
        return DbType.OTHER;
    }

    public static boolean regexFind(String regex, CharSequence input) {
        return null == input ? false : Pattern.compile(regex).matcher(input).find();
    }
}

