/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.eai.datasource.rdb.entity.Column;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.PrimaryKey;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.Table;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class DbUtil {
    private DbUtil() {
    }

    public static List<Table> getTablesByKeyword(Connection connection, String keyword) throws SQLException {
        ArrayList<Table> result = new ArrayList<Table>();
        LinkedHashMap<String, Table> tableInfoMap = new LinkedHashMap<String, Table>();
        if (connection != null && !connection.isClosed()) {
            DatabaseMetaData dbmd = connection.getMetaData();
            ResultSet tableResult = dbmd.getTables(connection.getCatalog(), connection.getSchema(), null, new String[]{"TABLE"});
            while (tableResult.next()) {
                String tableName = tableResult.getString("TABLE_NAME").toUpperCase();
                if ((!StringUtils.isNotBlank((CharSequence)keyword) || !tableName.contains(keyword.toLowerCase())) && !StringUtils.isBlank((CharSequence)keyword)) continue;
                String remarks = tableResult.getString("REMARKS");
                Table tableInfo = new Table();
                tableInfo.setTableName(tableName);
                tableInfo.setTableComment(remarks);
                tableInfoMap.put(tableName, tableInfo);
            }
            DbUtil.extracted(connection, tableInfoMap, dbmd);
        }
        return result;
    }

    private static void extracted(Connection connection, Map<String, Table> tableInfoMap, DatabaseMetaData dbmd) throws SQLException {
        if (HussarUtils.isEmpty(tableInfoMap)) {
            return;
        }
        for (String tableName : tableInfoMap.keySet()) {
            ResultSet columnsResult = dbmd.getColumns(connection.getCatalog(), connection.getSchema(), tableName, null);
            while (columnsResult.next()) {
                Table tableInfo = tableInfoMap.get(tableName);
                if (tableInfo == null) continue;
                String columnName = columnsResult.getString("COLUMN_NAME").toUpperCase();
                String dataType = columnsResult.getString("TYPE_NAME");
                int columnSize = columnsResult.getInt("COLUMN_SIZE");
                int decimalDigits = columnsResult.getInt("DECIMAL_DIGITS");
                String remarks = columnsResult.getString("REMARKS");
                String columnDef = columnsResult.getString("COLUMN_DEF");
                int ordinalPosition = columnsResult.getInt("ORDINAL_POSITION");
                String isNullAble = columnsResult.getString("IS_NULLABLE");
                Column columnInfo = new Column();
                columnInfo.setColumnName(columnName);
                columnInfo.setColumnComment(remarks);
                columnInfo.setColumnPosition(ordinalPosition);
                columnInfo.setColumnDefaultValue(columnDef);
                columnInfo.setColumnSize(columnSize);
                columnInfo.setDataType(dataType);
                columnInfo.setNullAble(isNullAble);
                columnInfo.setDecimalDigits(decimalDigits);
                tableInfo.getColumnList().add(columnInfo);
            }
            if (columnsResult != null) {
                columnsResult.close();
            }
            ResultSet primaryKeysResult = dbmd.getPrimaryKeys(connection.getCatalog(), connection.getSchema(), tableName);
            while (primaryKeysResult.next()) {
                Table tableInfo = tableInfoMap.get(tableName);
                String columnName = primaryKeysResult.getString("COLUMN_NAME").toUpperCase();
                short keySeq = primaryKeysResult.getShort("KEY_SEQ");
                String pkName = primaryKeysResult.getString("PK_NAME");
                PrimaryKey primaryKeyInfo = new PrimaryKey();
                primaryKeyInfo.setColumnName(columnName);
                primaryKeyInfo.setKeySeq(keySeq);
                primaryKeyInfo.setPkName(pkName);
                tableInfo.getPrimaryKeyList().add(primaryKeyInfo);
            }
            if (primaryKeysResult == null) continue;
            primaryKeysResult.close();
        }
    }

    public static List<Table> getAllTable(Connection connection) throws SQLException {
        return DbUtil.getTablesByKeyword(connection, null);
    }
}

