/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class DateUtil {
    private static final String DATE = "yyyy-MM-dd";
    private static final String DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final String DATETIME_MM = "yyyy-MM-dd HH:mm";
    private static final String DATETIME_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String TIME = "HH:mm";
    private static final String TIME_SS = "HH:mm:ss";
    private static final String SYS_DATE = "yyyy/MM/dd";
    private static final String SYS_DATETIME = "yyyy/MM/dd HH:mm:ss";
    private static final String SYS_DATETIME_MM = "yyyy/MM/dd HH:mm";
    private static final String SYS_DATETIME_SSS = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String NONE_DATE = "yyyyMMdd";
    private static final String NONE_DATETIME = "yyyyMMddHHmmss";
    private static final String NONE_DATETIME_MM = "yyyyMMddHHmm";
    private static final String NONE_DATETIME_SSS = "yyyyMMddHHmmssSSS";
    private static final String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH:mm:ss.SSS", "HH:mm", "HH:mm:ss", "yyyyMMdd", "yyyyMMddHHmmss", "yyyyMMddHHmm", "yyyyMMddHHmmssSSS"};

    private DateUtil() {
    }

    public static Date parseDate(String dateStr) {
        try {
            return DateUtils.parseDate((String)dateStr, (String[])PARSE_PATTERNS);
        }
        catch (ParseException e) {
            throw new BaseException(dateStr + "\u8f6c\u6362\u65e5\u671f\u51fa\u9519 \uff01", (Throwable)e);
        }
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        try {
            Date date = DateUtil.parseDate(dateStr);
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        catch (Exception e) {
            throw new BaseException(dateStr + "\u8f6c\u6362\u65e5\u671f\u51fa\u9519 \uff01", (Throwable)e);
        }
    }
}

