/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer;

import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.Token;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.TokenTypeDeterminer;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.TokenizerAction;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Tokenizer {
    private String input;
    private int head = 0;
    private String consume;
    private Token rootToken;
    private boolean inXmlTag;
    private boolean inXmlComment;
    private boolean inDoubleString;
    private boolean inSingleString;
    private boolean inMyBatisReference;
    private boolean inCharacterData;
    private boolean inSqlComment;

    public Tokenizer(String input) {
        this.input = input;
        this.rootToken = new Token();
    }

    public void tokenize() {
        this.addSubtokens(this.rootToken, false);
        TokenTypeDeterminer.determineTokenTypes(this.rootToken);
    }

    public List<Token> getTokenList() {
        return this.rootToken.getTokenList();
    }

    public String toString() {
        return this.rootToken.toString("");
    }

    private void addSubtokens(Token token, boolean stopOnTerminatingToken) {
        boolean done = false;
        while (!done) {
            Token subtoken = this.nextToken();
            if (subtoken.isEmpty()) {
                done = true;
                continue;
            }
            if (stopOnTerminatingToken && subtoken.isTerminating()) {
                done = true;
                if (!subtoken.endsWith("-->")) {
                    token.stripEnd();
                }
                token.append(subtoken.getValue());
                continue;
            }
            if (subtoken.isWhitespace()) {
                if (token.endsWith(" ")) continue;
                token.append(" ");
                continue;
            }
            token.add(subtoken);
        }
    }

    private Token nextToken() {
        Token token = new Token();
        while (this.head < this.input.length()) {
            this.consume = this.input.substring(this.head, this.head + 1);
            switch (this.deriveAction(token)) {
                case CONSUME: {
                    this.consume(token);
                    break;
                }
                case CONSUME_AND_RECURSE_AND_RETURN_TOKEN: {
                    this.consume(token);
                    this.addSubtokens(token, true);
                    return token;
                }
                case CONSUME_AND_RETURN_TOKEN: {
                    this.consume(token);
                    return token;
                }
                case RETURN_PREVIOUS_TOKEN: {
                    return token;
                }
            }
        }
        return token;
    }

    private void consume(Token token) {
        token.append(this.consume);
        this.head += this.consume.length();
    }

    private TokenizerAction deriveAction(Token token) {
        if (this.inCharacterData) {
            if (this.upcomingStartsWith("]]>")) {
                this.inCharacterData = false;
                this.consume = "]]>";
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else if (this.inDoubleString) {
            if (this.upcomingStartsWith("\"")) {
                this.inDoubleString = false;
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else if (this.inSingleString) {
            if (this.upcomingStartsWith("'")) {
                this.inSingleString = false;
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else if (this.inMyBatisReference) {
            if (this.upcomingStartsWith("}")) {
                this.inMyBatisReference = false;
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else if (this.inSqlComment) {
            if (this.upcomingStartsWithLinebreak()) {
                this.inSqlComment = false;
                return TokenizerAction.RETURN_PREVIOUS_TOKEN;
            }
        } else if (this.upcomingStartsWith("\"")) {
            if (!token.isEmpty()) {
                return TokenizerAction.RETURN_PREVIOUS_TOKEN;
            }
            this.inDoubleString = true;
        } else if (this.upcomingStartsWith("'")) {
            if (!token.isEmpty()) {
                return TokenizerAction.RETURN_PREVIOUS_TOKEN;
            }
            this.inSingleString = true;
        } else if (this.upcomingStartsWith("${") || this.upcomingStartsWith("#{")) {
            if (!token.isEmpty()) {
                return TokenizerAction.RETURN_PREVIOUS_TOKEN;
            }
            this.inMyBatisReference = true;
        } else if (this.inXmlComment) {
            if (this.upcomingStartsWith("-->")) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                token.setTerminating(true);
                this.inXmlComment = false;
                this.consume = "-->";
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
            if (StringUtils.isWhitespace((CharSequence)this.consume)) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else if (this.inXmlTag) {
            if (this.upcomingStartsWith(">")) {
                if (!token.isEmpty() && !token.wereXmlTagSuffix(">")) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                token.setTerminating(true);
                this.inXmlTag = false;
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
            if (StringUtils.isWhitespace((CharSequence)this.consume)) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        } else {
            if (this.upcomingStartsWith("<")) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                if (this.upcomingStartsWith("<!--")) {
                    this.inXmlComment = true;
                    this.consume = "<!--";
                } else if (this.upcomingStartsWith("</")) {
                    this.inXmlTag = true;
                    this.consume = "</";
                } else if (this.upcomingStartsWith("<?")) {
                    this.inXmlTag = true;
                    this.consume = "<?";
                } else {
                    if (this.upcomingStartsWith("<![CDATA[")) {
                        this.inCharacterData = true;
                        this.consume = "<![CDATA[";
                        return TokenizerAction.CONSUME;
                    }
                    if (this.upcomingStartsWith("<!")) {
                        this.inXmlTag = true;
                        this.consume = "<!";
                    } else {
                        this.inXmlTag = true;
                    }
                }
                return TokenizerAction.CONSUME_AND_RECURSE_AND_RETURN_TOKEN;
            }
            if (this.upcomingStartsWith(",") || this.upcomingStartsWith(".")) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
            if (this.upcomingStartsWith("--")) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                this.inSqlComment = true;
            } else if (this.upcomingStartsWithWhitespace()) {
                if (!token.isEmpty()) {
                    return TokenizerAction.RETURN_PREVIOUS_TOKEN;
                }
                return TokenizerAction.CONSUME_AND_RETURN_TOKEN;
            }
        }
        return TokenizerAction.CONSUME;
    }

    boolean upcomingStartsWith(String prefix) {
        for (int i = 0; i < prefix.length(); ++i) {
            int peek = this.head + i;
            if (peek >= this.input.length()) {
                return false;
            }
            if (this.input.charAt(peek) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    boolean upcomingStartsWithLinebreak() {
        char characterAtHead = this.input.charAt(this.head);
        return !String.valueOf(characterAtHead).matches(".");
    }

    boolean upcomingStartsWithWhitespace() {
        char characterAtHead = this.input.charAt(this.head);
        return Character.isWhitespace(characterAtHead);
    }
}

