/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public enum TokenType {
    ROOT,
    CHARACTER_DATA,
    DOCUMENT_DECLARATION,
    PROCESSING_INSTRUCTION,
    XML_COMMENT,
    STRING,
    SQL_COMMENT,
    COMMA,
    DOT,
    OPENING_PARENTHESIS,
    CLOSING_PARENTHESIS,
    TERM,
    XML_TAG,
    CLOSING_XML_TAG,
    SELFCLOSING_XML_TAG,
    ENCLOSING_XML_TAG(XML_TAG, "mapper"),
    CLOSING_ENCLOSING_XML_TAG(CLOSING_XML_TAG, ENCLOSING_XML_TAG.getTokenNameList()),
    SELFCLOSING_ENCLOSING_XML_TAG(SELFCLOSING_XML_TAG, ENCLOSING_XML_TAG.getTokenNameList()),
    PRIMARY_XML_TAG(XML_TAG, "cache", "resultmap", "select", "insert", "update", "delete", "sql"),
    CLOSING_PRIMARY_XML_TAG(CLOSING_XML_TAG, PRIMARY_XML_TAG.getTokenNameList()),
    SELFCLOSING_PRIMARY_XML_TAG(SELFCLOSING_XML_TAG, PRIMARY_XML_TAG.getTokenNameList()),
    MYBATIS_REFERENCE(TERM, new String[0]),
    SQL_STATEMENT(TERM, "select", "update", "insert", "delete"),
    SQL_SUB_STATEMENT(TERM, "from", "group", "having", "join", "on", "order", "set", "values", "where", "with"),
    SQL_DYADIC_OPERATOR(TERM, "and", "or"),
    SQL_AND_IN_BETWEEN(TERM, "and"),
    SQL_COMBINING_STATEMENT(TERM, "union"),
    SQL_STATEMENT_SUFFIX(TERM, "all", "distinct", "from", "into"),
    SQL_SUB_STATEMENT_PREFIX(TERM, "left", "right", "outer", "inner"),
    SQL_SUB_STATEMENT_SUFFIX(TERM, "by", "cs", "rr", "rs", "ur");

    private TokenType parentTokenType;
    private List<String> tokenNameList;

    private TokenType() {
        this(null, new String[0]);
    }

    private TokenType(TokenType parentTokenType, String ... tokenNameArray) {
        this(parentTokenType, Arrays.asList(tokenNameArray));
    }

    private TokenType(TokenType parentTokenType, List<String> tokenNameList) {
        this.parentTokenType = parentTokenType;
        this.tokenNameList = tokenNameList;
    }

    public boolean isParentTokenType() {
        return this.parentTokenType == null;
    }

    public boolean isAmbiguousTokenType(String tokenName) {
        if (CollectionUtils.isNotEmpty(this.tokenNameList) && this.tokenNameList.contains(tokenName)) {
            for (TokenType other : TokenType.values()) {
                if (this == other || this.parentTokenType != other.parentTokenType || !CollectionUtils.isNotEmpty(other.tokenNameList) || !other.tokenNameList.contains(tokenName)) continue;
                return true;
            }
        }
        return false;
    }

    public TokenType getParentTokenType() {
        return this.parentTokenType;
    }

    public List<String> getTokenNameList() {
        return this.tokenNameList;
    }
}

