/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.datasource.rdb.constant.RdbConstant;
import com.jxdinfo.hussar.eai.datasource.rdb.util.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

public final class SqlParamUtil {
    private static Map<Integer, String> javaTypeMap = new HashMap<Integer, String>();

    private SqlParamUtil() {
    }

    public static String getJavaType(Integer type) {
        if (type == null) {
            throw new BaseException("\u975e\u6cd5\u7c7b\u578b");
        }
        String javaType = javaTypeMap.get(type);
        if (StringUtils.isBlank((CharSequence)javaType)) {
            throw new BaseException("\u975e\u6cd5\u7c7b\u578b");
        }
        return javaType;
    }

    public static Object getValueByEaiType(EaiParamsItems items, Object inputValue) {
        LocalDateTime localDateTime;
        Integer type = items.getType();
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_BOOLEAN.getType())) {
            throw new BaseException("\u4e0d\u652f\u6301\u5e03\u5c14\u7c7b\u578b\uff01");
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_INTEGER.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString())) {
            return Integer.parseInt(inputValue.toString().trim());
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_LONG.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString())) {
            return Long.parseLong(inputValue.toString().trim());
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_DOUBLE.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString())) {
            return Double.parseDouble(inputValue.toString().trim());
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_DOUBLE.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString())) {
            return Double.parseDouble(inputValue.toString().trim());
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_STRING.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString())) {
            return inputValue.toString().trim();
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_DATE.getType()) && StringUtils.isNotBlank((CharSequence)inputValue.toString()) && (localDateTime = DateUtil.parseLocalDateTime(inputValue.toString().trim())) != null) {
            return localDateTime;
        }
        if (type != null && Objects.equals(type, EaiDataType.DATA_TYPE_LIST.getType()) && HussarUtils.isNotEmpty((Object)inputValue)) {
            String s = JSON.toJSONString((Object)inputValue);
            Integer itemType = items.getItemType();
            String javaType = SqlParamUtil.getJavaType(itemType);
            try {
                Class<?> aClass = Class.forName(javaType);
                return JSON.parseArray((String)s, aClass);
            }
            catch (ClassNotFoundException e) {
                throw new BaseException("\u52a0\u8f7d" + javaType + "\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return null;
    }

    public static Integer getEaiDataType(String columnClassName) {
        if (columnClassName.equalsIgnoreCase("java.sql.Date") || columnClassName.equalsIgnoreCase("java.sql.Time") || columnClassName.equalsIgnoreCase("java.sql.Timestamp")) {
            return EaiDataType.DATA_TYPE_DATE.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Long")) {
            return EaiDataType.DATA_TYPE_LONG.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Integer")) {
            return EaiDataType.DATA_TYPE_INTEGER.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.lang.Double")) {
            return EaiDataType.DATA_TYPE_DOUBLE.getType();
        }
        if (columnClassName.equalsIgnoreCase("java.util.List")) {
            return EaiDataType.DATA_TYPE_LIST.getType();
        }
        if (columnClassName.equalsIgnoreCase("com.jxdinfo.hussar.eai.common.vo.PageVo")) {
            return EaiDataType.DATA_TYPE_PAGE.getType();
        }
        return EaiDataType.DATA_TYPE_STRING.getType();
    }

    public static EaiParamsConvertDto fillInputValueInParam(EaiParamsConvertDto inParams, Object body) {
        List items = inParams.getBody().getItems();
        if (body == null) {
            return inParams;
        }
        Map inputValueMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)body), Map.class);
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(inputValueMap);
        for (EaiParamsItems item : items) {
            String name = item.getName();
            Object value = caseInsensitiveMap.get(name);
            if (!HussarUtils.isNotEmpty(value)) continue;
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                JSONArray newArray = SqlParamUtil.filterBlank(array);
                if (!HussarUtils.isNotEmpty((Object)newArray)) continue;
                item.setInputValue((Object)newArray);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)value.toString())) continue;
            item.setInputValue(value);
        }
        return inParams;
    }

    public static JSONArray filterBlank(JSONArray array) {
        if (HussarUtils.isEmpty((Object)array)) {
            return null;
        }
        JSONArray newArray = new JSONArray();
        for (Object obj : array) {
            if (!HussarUtils.isNotEmpty(obj)) continue;
            newArray.add(obj);
        }
        return newArray;
    }

    public static Map<String, Object> getQuerySqlRealParams(List<EaiParamsItems> inParams, Object body) {
        LinkedHashMap<String, Object> outurlRequestParams = new LinkedHashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)body)) {
            Map bodyMap = (Map)body;
            Map inputValueMap = null;
            String k = (String)bodyMap.keySet().iterator().next();
            inputValueMap = k.equalsIgnoreCase(RdbConstant.SQL_IN_PARAMS) ? (Map)JSON.parseObject((String)JSON.toJSONString(bodyMap.get(k)), Map.class) : (Map)JSON.parseObject((String)JSON.toJSONString((Object)body), Map.class);
            CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(inputValueMap);
            for (EaiParamsItems item : inParams) {
                String name = item.getName();
                Object value = caseInsensitiveMap.get(name);
                if (!HussarUtils.isNotEmpty(value)) continue;
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    JSONArray newArray = SqlParamUtil.filterBlank(array);
                    if (!HussarUtils.isNotEmpty((Object)newArray)) continue;
                    item.setInputValue((Object)newArray);
                    outurlRequestParams.put(name, SqlParamUtil.getValueByEaiType(item, value));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)value.toString())) continue;
                item.setInputValue(value);
                outurlRequestParams.put(name, SqlParamUtil.getValueByEaiType(item, value));
            }
        }
        return outurlRequestParams;
    }

    static {
        javaTypeMap.put(0, "java.lang.Boolean");
        javaTypeMap.put(1, "java.lang.Integer");
        javaTypeMap.put(2, "java.lang.Long");
        javaTypeMap.put(3, "java.lang.Double");
        javaTypeMap.put(4, "java.lang.String");
        javaTypeMap.put(5, "java.time.LocalDateTime");
        javaTypeMap.put(6, "java.util.List");
    }
}

