/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.datasource.rdb.entity.SqlResponseMapping;
import com.jxdinfo.hussar.eai.datasource.rdb.model.SqlSelect;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.formatter.Formatter;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class SQLUtil {
    private static Pattern where = Pattern.compile("\\bwhere\\b");
    private static Pattern groupby = Pattern.compile("\\bgroup\\s+by\\b", 32);
    private static Pattern orderby = Pattern.compile("\\border\\s+by\\b", 32);
    private static Pattern union = Pattern.compile("\\bunion\\b", 32);
    private static Pattern unionAll = Pattern.compile("\\bunion\\s+all\\b", 32);
    private static Map<String, String> map1 = new LinkedHashMap<String, String>();
    private static Map<String, String> map2 = new LinkedHashMap<String, String>();

    private SQLUtil() {
    }

    public static List<SqlSelect> parseSql(String script) {
        SqlSelect sqlSelect;
        Matcher matcherUnionAll = unionAll.matcher(script.toLowerCase());
        ArrayList<SqlSelect> sqlList = new ArrayList<SqlSelect>();
        String temp = script;
        while (matcherUnionAll.find()) {
            sqlSelect = new SqlSelect();
            int start = matcherUnionAll.start();
            int end = matcherUnionAll.end();
            sqlSelect.setSql(script.substring(0, start));
            sqlSelect.setJoinStr(script.substring(start, end));
            sqlList.add(sqlSelect);
            temp = script.substring(end, script.length());
        }
        if (HussarUtils.isNotEmpty(sqlList) && StringUtils.isNotBlank((CharSequence)temp)) {
            sqlSelect = new SqlSelect();
            sqlSelect.setSql(temp);
            sqlSelect.setJoinStr("UNION ALL");
            sqlList.add(sqlSelect);
        }
        if (HussarUtils.isEmpty(sqlList)) {
            Matcher matcherUnion = union.matcher(script.toLowerCase());
            while (matcherUnion.find()) {
                SqlSelect sqlSelect2 = new SqlSelect();
                int start = matcherUnion.start();
                int end = matcherUnion.end();
                sqlSelect2.setSql(script.substring(0, start));
                sqlSelect2.setJoinStr(script.substring(start, end));
                sqlList.add(sqlSelect2);
                temp = script.substring(end, script.length());
            }
        }
        if (HussarUtils.isNotEmpty(sqlList) && StringUtils.isNotBlank((CharSequence)temp)) {
            sqlSelect = new SqlSelect();
            sqlSelect.setSql(temp);
            sqlSelect.setJoinStr("UNION");
            sqlList.add(sqlSelect);
        }
        return sqlList;
    }

    public static String getStaticQuerySql(String script) {
        script = SQLUtil.filterComments(script);
        List<SqlSelect> sqlList = SQLUtil.parseSql(script);
        String result = "";
        if (HussarUtils.isNotEmpty(sqlList)) {
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                SqlSelect sqlSelect = sqlList.get(i);
                String sql = sqlSelect.getSql();
                result = result + SQLUtil.getStaticQuerySqlOne(sql);
                if (i == size - 1) continue;
                result = result + " " + sqlSelect.getJoinStr() + " ";
            }
            return result;
        }
        return SQLUtil.getStaticQuerySqlOne(script);
    }

    public static String getStaticQuerySql(String script, List<SqlSelect> sqlList) {
        script = SQLUtil.filterComments(script);
        String result = "";
        if (HussarUtils.isNotEmpty(sqlList)) {
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                SqlSelect sqlSelect = sqlList.get(i);
                String sql = sqlSelect.getSql();
                result = result + SQLUtil.getStaticQuerySqlOne(sql);
                if (i == size - 1) continue;
                result = result + " " + sqlSelect.getJoinStr() + " ";
            }
            return result;
        }
        return SQLUtil.getStaticQuerySqlOne(script);
    }

    public static String getStaticQuerySqlOne(String sql) {
        int start;
        String result = sql;
        if (sql.toLowerCase().contains("<where>")) {
            result = sql.substring(0, sql.toLowerCase().indexOf("<where>")) + sql.substring(sql.toLowerCase().indexOf("</where>") + 8, sql.length());
        } else {
            Matcher matcherWhere = where.matcher(sql.toLowerCase());
            while (matcherWhere.find()) {
                start = matcherWhere.start();
                result = sql.substring(0, start);
            }
        }
        Matcher matcherGroupby = groupby.matcher(result.toLowerCase());
        if (matcherGroupby.find()) {
            start = matcherGroupby.start();
            int end = result.length();
            result = result.substring(0, start) + " WHERE 1 < 0 " + result.substring(start, end);
        } else {
            Matcher matcherOrderby = orderby.matcher(result.toLowerCase());
            if (matcherOrderby.find()) {
                int start2 = matcherOrderby.start();
                int end = result.length();
                result = result.substring(0, start2) + " WHERE 1 < 0 " + result.substring(start2, end);
            } else {
                result = result + " WHERE 1 < 0";
            }
        }
        return result;
    }

    public static List<SqlResponseMapping> parseSqlResponseMapping(Connection connection, String sql, List<SqlSelect> sqlSelectList) throws Exception {
        ArrayList<SqlResponseMapping> list = new ArrayList<SqlResponseMapping>();
        try {
            String staticSql = SQLUtil.getStaticQuerySql(sql, sqlSelectList);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(staticSql);
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                SqlResponseMapping sqlResponseMapping = new SqlResponseMapping();
                String columnClassName = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnLabel = data.getColumnLabel(i);
                sqlResponseMapping.setColumnName(columnName);
                sqlResponseMapping.setColumnTypeName(columnTypeName);
                sqlResponseMapping.setColumnClassName(columnClassName);
                sqlResponseMapping.setColumnLabel(columnLabel);
                list.add(sqlResponseMapping);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SqlResponseMapping> parseSqlResponseMapping(Connection connection, String sql) throws Exception {
        ArrayList<SqlResponseMapping> list = new ArrayList<SqlResponseMapping>();
        try {
            String staticSql = SQLUtil.getStaticQuerySql(sql);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(staticSql);
            ResultSetMetaData data = resultSet.getMetaData();
            for (int i = 1; i <= data.getColumnCount(); ++i) {
                SqlResponseMapping sqlResponseMapping = new SqlResponseMapping();
                String columnClassName = data.getColumnClassName(i);
                String columnName = data.getColumnName(i);
                String columnTypeName = data.getColumnTypeName(i);
                String columnLabel = data.getColumnLabel(i);
                sqlResponseMapping.setColumnName(columnName);
                sqlResponseMapping.setColumnTypeName(columnTypeName);
                sqlResponseMapping.setColumnClassName(columnClassName);
                sqlResponseMapping.setColumnLabel(columnLabel);
                list.add(sqlResponseMapping);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return list;
    }

    public static String prettyFormat(String sql) {
        return new Formatter().format(sql);
    }

    public static String escEscapeSql(String sql) {
        sql = SQLUtil.filterComments(sql);
        Set<String> strings = map2.keySet();
        String first = new String(sql);
        for (String s : strings) {
            first = first.replace(s, map2.get(s));
        }
        first = first.replace("<", "&lt;");
        Set<String> strings1 = map1.keySet();
        for (String s : strings1) {
            first = first.replace(s, map1.get(s));
        }
        return first;
    }

    public static String filterComments(String sqlScript) {
        String pattern = "(/\\*([^*]|[\\r\\n]|(\\*+([^*/]|[\\r\\n])))*\\*+/)|(--.*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(sqlScript);
        sqlScript = m.replaceAll("");
        if (sqlScript.lastIndexOf(";") != -1) {
            return sqlScript.substring(0, sqlScript.lastIndexOf(";"));
        }
        return sqlScript;
    }

    static {
        map1.put("\u4e09", "<where>");
        map2.put("<where>", "\u4e09");
        map1.put("\u56db", "</where>");
        map2.put("</where>", "\u56db");
        map1.put("\u520a", "<if ");
        map2.put("<if ", "\u520a");
        map1.put("\u4e15", "</if>");
        map2.put("</if>", "\u4e15");
        map1.put("\u74dc", "<foreach ");
        map2.put("<foreach ", "\u74dc");
        map1.put("\u4e18", "</foreach>");
        map2.put("</foreach>", "\u4e18");
        map1.put("\u592e", "<bind ");
        map2.put("<bind ", "\u592e");
        map1.put("\u5e03", "</bind>");
        map2.put("</bind>", "\u5e03");
        map1.put("\u53eb", "<choose>");
        map2.put("<choose>", "\u53eb");
        map1.put("\u53ed", "</choose>");
        map2.put("</choose>", "\u53ed");
        map1.put("\u77f3", "<when ");
        map2.put("<when ", "\u77f3");
        map1.put("\u5c3c", "</when>");
        map2.put("</when> ", "\u5c3c");
        map1.put("\u4ed4", "<otherwise>");
        map2.put("<otherwise> ", "\u4ed4");
        map1.put("\u7531", "</otherwise>");
        map2.put("</otherwise> ", "\u7531");
        map1.put("\u4e0b", "<trim ");
        map2.put("<trim ", "\u4e0b");
        map1.put("\u4e0a", "</trim>");
        map2.put("</trim> ", "\u4e0a");
        map1.put("\u5de6", "<![CDATA[");
        map2.put("<![CDATA[ ", "\u5de6");
        map1.put("\u53f3", "]]>");
        map2.put("]]>", "\u53f3");
        map1.put("\u672c", "/>");
        map2.put("/>", "\u672c");
    }
}

