/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.util;

import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.platform.core.utils.beans.BeanCopier;
import com.jxdinfo.hussar.platform.core.utils.beans.CopyOptions;
import com.jxdinfo.hussar.platform.core.utils.map.MapUtil;
import java.util.Map;

public class BeanMapUtil {
    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanMapUtil.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanMapUtil.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapUtil.toCamelCaseMap(map);
        }
        BeanMapUtil.copyProperties(map, bean, copyOptions);
        return bean;
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create((Object)source, (Object)target, (CopyOptions)copyOptions).copy();
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanMapUtil.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        Object target = ReflectUtil.newInstanceIfPossible(clazz);
        BeanMapUtil.copyProperties(source, target, options);
        return (T)target;
    }

    public static <T> T toBeanIgnoreError(Object source, Class<T> clazz) {
        return BeanMapUtil.toBean(source, clazz, CopyOptions.create().setIgnoreError(true));
    }

    public static <T> T toBeanIgnoreCase(Object source, Class<T> clazz, boolean ignoreError) {
        return BeanMapUtil.toBean(source, clazz, CopyOptions.create().setIgnoreCase(true).setIgnoreError(ignoreError));
    }
}

