/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.Token;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.TokenType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class TokenTypeDeterminer {
    static List<String> MP_LABLES = Lists.newArrayList((Object[])new String[]{"<where>", "<bind ", "<if ", "<when ", "<trim ", "<foreach "});
    static final Map<String, AmbiguousTokenTypeResolver> RESOLVER_MAP = new HashMap<String, AmbiguousTokenTypeResolver>();

    public static void determineTokenTypes(Token rootToken) {
        TokenTypeDeterminer tokenTypeDeterminer = new TokenTypeDeterminer();
        tokenTypeDeterminer.determineTokenTypeFromValueRecursively(rootToken.getTokenList());
        tokenTypeDeterminer.determineTokenTypeFromContext(rootToken.getTokenList());
        rootToken.setTokenType(TokenType.ROOT);
    }

    TokenTypeDeterminer() {
    }

    private void determineTokenTypeFromValueRecursively(List<Token> tokenList) {
        if (CollectionUtils.isNotEmpty(tokenList)) {
            for (Token token : tokenList) {
                this.determineTokenTypeFromValue(token);
                this.determineTokenTypeFromValueRecursively(token.getTokenList());
            }
        }
    }

    void determineTokenTypeFromValue(Token token) {
        this.determineTokenTypeFromValueBasically(token);
        String tokenName = token.tokenName();
        for (TokenType potentialTokenType : TokenType.values()) {
            if (potentialTokenType.getParentTokenType() != token.getTokenType() || !potentialTokenType.getTokenNameList().contains(tokenName)) continue;
            token.setTokenType(potentialTokenType);
        }
    }

    private void determineTokenTypeFromValueBasically(Token token) {
        TokenType tokenType;
        String value = token.getValue();
        if (value.startsWith("<![CDATA[")) {
            tokenType = TokenType.CHARACTER_DATA;
        } else if (value.startsWith("<!--")) {
            tokenType = TokenType.XML_COMMENT;
        } else if (value.startsWith("<!")) {
            tokenType = TokenType.DOCUMENT_DECLARATION;
        } else if (value.startsWith("<?")) {
            tokenType = TokenType.PROCESSING_INSTRUCTION;
        } else if (value.startsWith("</")) {
            tokenType = TokenType.CLOSING_XML_TAG;
        } else if (value.startsWith("<")) {
            if (value.endsWith("/>")) {
                tokenType = TokenType.SELFCLOSING_XML_TAG;
            } else {
                boolean f = false;
                for (String s : MP_LABLES) {
                    if (!value.contains(s)) continue;
                    f = true;
                    break;
                }
                tokenType = f ? TokenType.XML_TAG : TokenType.TERM;
            }
        } else {
            tokenType = value.startsWith("'") ? TokenType.STRING : (value.startsWith("\"") ? TokenType.STRING : (value.startsWith("${") || value.startsWith("#{") ? TokenType.MYBATIS_REFERENCE : (value.startsWith("--") ? TokenType.SQL_COMMENT : (value.equals(",") ? TokenType.COMMA : (value.equals(".") ? TokenType.DOT : (value.equals("(") ? TokenType.OPENING_PARENTHESIS : (value.equals(")") ? TokenType.CLOSING_PARENTHESIS : TokenType.TERM)))))));
        }
        token.setTokenType(tokenType);
    }

    private void determineTokenTypeFromContext(List<Token> tokenList) {
        if (CollectionUtils.isNotEmpty(tokenList)) {
            for (int i = 0; i < tokenList.size(); ++i) {
                Token token = tokenList.get(i);
                String tokenName = token.tokenName();
                if (!token.getTokenType().isAmbiguousTokenType(tokenName)) continue;
                List<Token> beforeTokenList = tokenList.subList(0, i);
                List<Token> afterTokenList = tokenList.subList(i, tokenList.size());
                RESOLVER_MAP.get(tokenName).resolve(token, beforeTokenList, afterTokenList);
            }
        }
    }

    static {
        RESOLVER_MAP.put("and", new AmbiguousTokenTypeResolver(){

            @Override
            public void resolve(Token token, List<Token> beforeTokenList, List<Token> afterTokenList) {
                for (int i = beforeTokenList.size() - 1; i >= 0; --i) {
                    Token previousToken = beforeTokenList.get(i);
                    switch (previousToken.getTokenType()) {
                        case TERM: {
                            if (previousToken.tokenName().equals("between")) {
                                token.setTokenType(TokenType.SQL_AND_IN_BETWEEN);
                                return;
                            }
                        }
                        case SQL_SUB_STATEMENT: 
                        case SQL_STATEMENT: 
                        case PRIMARY_XML_TAG: {
                            return;
                        }
                    }
                }
            }
        });
        RESOLVER_MAP.put("from", new AmbiguousTokenTypeResolver(){

            @Override
            public void resolve(Token token, List<Token> beforeTokenList, List<Token> afterTokenList) {
                for (int i = beforeTokenList.size() - 1; i >= 0; --i) {
                    Token previousToken = beforeTokenList.get(i);
                    switch (previousToken.getTokenType()) {
                        case SQL_STATEMENT: {
                            if (previousToken.tokenName().equals("delete")) {
                                token.setTokenType(TokenType.SQL_STATEMENT_SUFFIX);
                                return;
                            }
                        }
                        case PRIMARY_XML_TAG: {
                            return;
                        }
                    }
                }
            }
        });
    }

    @FunctionalInterface
    static interface AmbiguousTokenTypeResolver {
        public void resolve(Token var1, List<Token> var2, List<Token> var3);
    }
}

