/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer;

import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.TokenType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Token {
    static final String PREFIX_CHARACTER_DATA = "<![CDATA[";
    static final String SUFFIX_CHARACTER_DATA = "]]>";
    static final String PREFIX_DOCUMENT_DECLARATION = "<!";
    static final String PREFIX_PROCESSING_INSTRUCTION = "<?";
    static final String SUFFIX_PROCESSING_INSTRUCTION = "?>";
    static final String PREFIX_XML_TAG = "<";
    static final String SUFFIX_XML_TAG = ">";
    static final String PREFIX_XML_COMMENT = "<!--";
    static final String SUFFIX_XML_COMMENT = "-->";
    static final String PREFIX_SINGLE_STRING = "'";
    static final String SUFFIX_SINGLE_STRING = "'";
    static final String PREFIX_DOUBLE_STRING = "\"";
    static final String SUFFIX_DOUBLE_STRING = "\"";
    static final String PREFIX_MYBATIS_VALUE_REFERENCE = "${";
    static final String PREFIX_MYBATIS_VARIABLE_REFERENCE = "#{";
    static final String SUFFIX_MYBATIS_REFERENCE = "}";
    static final String PREFIX_CLOSING_XML_TAG = "</";
    static final String SUFFIX_SELFCLOSING_XML_TAG = "/>";
    static final String PREFIX_SQL_COMMENT = "--";
    static final String VALUE_COMMA = ",";
    static final String VALUE_DOT = ".";
    static final String VALUE_SPACE = " ";
    static final String VALUE_OPENING_PARENTHESIS = "(";
    static final String VALUE_CLOSING_PARENTHESIS = ")";
    private List<Token> tokenList = new ArrayList<Token>();
    private String value = "";
    private boolean terminating;
    private TokenType tokenType;

    public void append(char c) {
        this.value = this.value + c;
    }

    public void append(String s) {
        this.value = this.value + s;
    }

    public void add(Token t) {
        this.tokenList.add(t);
        this.value = this.value + t.value;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("|").append(this.tokenType == TokenType.ROOT ? "..." : this.value).append("|").append((Object)this.tokenType);
        if (CollectionUtils.isNotEmpty(this.tokenList)) {
            for (Token subtoken : this.tokenList) {
                sb.append("\n").append(subtoken.toString(indent + "  "));
            }
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean isWhitespace() {
        return StringUtils.isWhitespace((CharSequence)this.value);
    }

    public boolean endsWith(String suffix) {
        return this.value.endsWith(suffix);
    }

    public boolean wereXmlTagSuffix(String ending) {
        String potential = this.value + ending;
        return potential.endsWith(SUFFIX_PROCESSING_INSTRUCTION) || potential.endsWith(SUFFIX_SELFCLOSING_XML_TAG);
    }

    public void stripEnd() {
        this.value = StringUtils.stripEnd((String)this.value, null);
    }

    public String tokenName() {
        String tokenName = CollectionUtils.isEmpty(this.tokenList) ? this.value : this.tokenList.get(0).getValue();
        return tokenName.toLowerCase();
    }

    public boolean isTerminating() {
        return this.terminating;
    }

    public void setTerminating(boolean terminating) {
        this.terminating = terminating;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public List<Token> getTokenList() {
        return this.tokenList;
    }

    public String getValue() {
        return this.value;
    }
}

