/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.datasource.rdb.mybatis.formatter;

import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.formatter.Format;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.Token;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.TokenType;
import com.jxdinfo.hussar.eai.datasource.rdb.mybatis.tokenizer.Tokenizer;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Formatter {
    static final String VALUE_SPACE = " ";
    private static final Map<TokenType, Format> BEFORE_FORMAT_MAP = new HashMap<TokenType, Format>();
    private static final Map<TokenType, Format> AFTER_FORMAT_MAP = new HashMap<TokenType, Format>();
    private final int maxLineLength;
    private final int indentionSize;
    private StringWriter output = new StringWriter();
    private int lineLength;
    private int indention;
    private int blankCount;
    private Deque<Integer> indentionStack = new ArrayDeque<Integer>();

    private static void addFormats(TokenType tokenType, Format beforeFormat, Format afterFormat) {
        BEFORE_FORMAT_MAP.put(tokenType, beforeFormat);
        AFTER_FORMAT_MAP.put(tokenType, afterFormat);
    }

    public Formatter() {
        this(80, 4);
    }

    public Formatter(int maxLineLength, int indentionSize) {
        this.maxLineLength = maxLineLength;
        this.indentionSize = indentionSize;
    }

    public String format(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        Tokenizer tokenizer = new Tokenizer(input);
        tokenizer.tokenize();
        List<Token> tokenList = tokenizer.getTokenList();
        Token previousToken = null;
        for (Token token : tokenList) {
            this.write(this.deriveEffectiveBeforeFormat(token, previousToken));
            this.write(token);
            previousToken = token;
        }
        return this.output.toString();
    }

    private Format deriveEffectiveBeforeFormat(Token token, Token previousToken) {
        TokenType tokenType = token.getTokenType();
        Format beforeFormat = Formatter.retrieveBeforeFormat(tokenType);
        if (previousToken != null) {
            TokenType previousTokenType = previousToken.getTokenType();
            Format previousAfterFormat = Formatter.retrieveAfterFormat(previousTokenType);
            beforeFormat = tokenType == TokenType.SQL_COMMENT && Formatter.allowSqlCommentOnSameLine(previousTokenType) ? Format.SPACE : (tokenType == TokenType.SQL_STATEMENT_SUFFIX || tokenType == TokenType.SQL_SUB_STATEMENT_SUFFIX ? Format.SPACE : (previousTokenType == TokenType.SQL_SUB_STATEMENT_PREFIX ? Format.SPACE : this.joinFormats(previousAfterFormat, beforeFormat)));
        }
        return beforeFormat;
    }

    private static boolean allowSqlCommentOnSameLine(TokenType tokenType) {
        if (!tokenType.isParentTokenType()) {
            return Formatter.allowSqlCommentOnSameLine(tokenType.getParentTokenType());
        }
        return tokenType == TokenType.STRING || tokenType == TokenType.SQL_COMMENT || tokenType == TokenType.COMMA || tokenType == TokenType.OPENING_PARENTHESIS || tokenType == TokenType.CLOSING_PARENTHESIS || tokenType == TokenType.TERM;
    }

    static Format retrieveBeforeFormat(TokenType tokenType) {
        return BEFORE_FORMAT_MAP.get((Object)tokenType);
    }

    static Format retrieveAfterFormat(TokenType tokenType) {
        return AFTER_FORMAT_MAP.get((Object)tokenType);
    }

    private Format joinFormats(Format first, Format second) {
        boolean stackIndention;
        int indentionDelta;
        int linefeedCount = Math.max(first.getNewlineCount(), second.getNewlineCount());
        if (first.isStackIndention() && !second.isStackIndention()) {
            indentionDelta = first.getIndentionDelta();
            stackIndention = true;
        } else if (second.isStackIndention() && !first.isStackIndention()) {
            indentionDelta = second.getIndentionDelta();
            stackIndention = true;
        } else {
            indentionDelta = first.getIndentionDelta() + second.getIndentionDelta();
            stackIndention = false;
        }
        int blankCount = Math.min(first.getBlankCount(), second.getBlankCount());
        return new Format(linefeedCount, indentionDelta, blankCount, stackIndention);
    }

    private void write(Format format) {
        for (int i = 0; i < format.getNewlineCount(); ++i) {
            this.newline();
        }
        if (format.isStackIndention() && format.getIndentionDelta() < 0) {
            this.indention = this.indentionStack.isEmpty() ? 0 : this.indentionStack.pop();
        }
        this.indention += format.getIndentionDelta();
        if (format.isStackIndention() && format.getIndentionDelta() > 0) {
            this.indentionStack.push(this.indention);
        }
        this.blankCount += format.getBlankCount();
    }

    private void write(Token token) {
        if (this.lineLength == 0) {
            this.write(StringUtils.repeat((String)VALUE_SPACE, (int)(this.indention * this.indentionSize)));
        } else {
            this.write(StringUtils.repeat((String)VALUE_SPACE, (int)this.blankCount));
        }
        this.blankCount = 0;
        this.write(token.getValue());
    }

    public void write(String string) {
        this.output.write(string);
        this.lineLength += string.length();
    }

    public void newline() {
        if (this.output.getBuffer().length() == 0) {
            return;
        }
        this.blankCount = 0;
        this.output.write(10);
        this.lineLength = 0;
    }

    static {
        Formatter.addFormats(TokenType.ROOT, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.CHARACTER_DATA, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.DOCUMENT_DECLARATION, new Format(1, 0, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.PROCESSING_INSTRUCTION, new Format(1, 0, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.XML_COMMENT, new Format(2, 0, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.STRING, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.SQL_COMMENT, new Format(0, 0, 1), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.COMMA, new Format(0, 0, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.DOT, Format.CLOSE_BY, Format.CLOSE_BY);
        Formatter.addFormats(TokenType.OPENING_PARENTHESIS, new Format(0, 0, 1), new Format(1, 1, 0));
        Formatter.addFormats(TokenType.CLOSING_PARENTHESIS, new Format(1, -1, 0), new Format(1, 0, 1));
        Formatter.addFormats(TokenType.TERM, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.XML_TAG, new Format(1, 0, 0), new Format(1, 1, 0));
        Formatter.addFormats(TokenType.CLOSING_XML_TAG, new Format(1, -1, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.SELFCLOSING_XML_TAG, new Format(1, 0, 0), new Format(1, 0, 0));
        Formatter.addFormats(TokenType.PRIMARY_XML_TAG, new Format(1, 0, 0), new Format(1, 1, 0, true));
        Formatter.addFormats(TokenType.CLOSING_PRIMARY_XML_TAG, new Format(1, -1, 0, true), new Format(2, 0, 0));
        Formatter.addFormats(TokenType.SELFCLOSING_PRIMARY_XML_TAG, new Format(1, 0, 0), new Format(2, 0, 0));
        Formatter.addFormats(TokenType.ENCLOSING_XML_TAG, new Format(1, 0, 0), new Format(2, 1, 0));
        Formatter.addFormats(TokenType.CLOSING_ENCLOSING_XML_TAG, new Format(1, -1, 0), new Format(2, 0, 0));
        Formatter.addFormats(TokenType.SELFCLOSING_ENCLOSING_XML_TAG, new Format(1, 0, 0), new Format(2, 0, 0));
        Formatter.addFormats(TokenType.MYBATIS_REFERENCE, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.SQL_STATEMENT, new Format(1, 0, 0), new Format(1, 1, 0));
        Formatter.addFormats(TokenType.SQL_SUB_STATEMENT, new Format(1, -1, 0), new Format(1, 1, 0));
        Formatter.addFormats(TokenType.SQL_DYADIC_OPERATOR, new Format(1, 0, 0), new Format(0, 0, 1));
        Formatter.addFormats(TokenType.SQL_AND_IN_BETWEEN, Format.SPACE, Format.SPACE);
        Formatter.addFormats(TokenType.SQL_COMBINING_STATEMENT, new Format(2, -1, 0), new Format(2, 0, 0));
        Formatter.addFormats(TokenType.SQL_STATEMENT_SUFFIX, Format.SPACE, Formatter.retrieveAfterFormat(TokenType.SQL_STATEMENT));
        Formatter.addFormats(TokenType.SQL_SUB_STATEMENT_PREFIX, Formatter.retrieveBeforeFormat(TokenType.SQL_SUB_STATEMENT), Format.SPACE);
        Formatter.addFormats(TokenType.SQL_SUB_STATEMENT_SUFFIX, Format.SPACE, Formatter.retrieveAfterFormat(TokenType.SQL_SUB_STATEMENT));
    }
}

