/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.EaiOutParamDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ParamsConvertUtil {
    public static final int CONVERT_LIST = 0;
    public static final int CONVERT_DTO = 2;
    public static final boolean AUTO_TRANS_FORM = false;
    public static final int HEADER = 0;
    public static final int BODY = 1;
    public static final int QUERY = 2;
    public static final String HEADER_STR = "header";
    public static final String BODY_STR = "body";
    public static final String QUERY_STR = "query";
    private static final String ERROR_MSG = "\u5b58\u5728\u91cd\u590d\u4fe1\u606f";
    private static final String TRANS_ERROR_MSG = "\u6570\u636e\u7ed3\u6784\u8f6c\u6362\u5931\u8d25";
    private static final String DOUBLE_MARK = "\"";
    private static final String ITEMS = "items";
    private static final String TYPE = "type";
    private static final String COLON = ":";
    private static final String BRACE = "{";
    private static final String BRACE_OPPOSITE = "}";
    private static final String MID = "[";
    private static final String MID_OPPOSITE = "]";
    private static final String COMMA = ",";
    private static final String SCHEMA_START = "{\"$schema\":\"http://json-schema.org/draft-04/schema#\",\"type\":\"object\",\"properties\":{";
    private static final String PARAMS_MAPPING_NAME = "mappingName";

    public static List<EaiParamsItems> toEaiParamsItems(EaiParamsConvertDto paramsConvertDtoV, boolean autoTransForm) {
        if (HussarUtils.isNull((Object)paramsConvertDtoV)) {
            return null;
        }
        EaiParamsConvertDto paramsConvertDto = new EaiParamsConvertDto(paramsConvertDtoV);
        List<EaiParamsItems> header = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 0);
        List<EaiParamsItems> query = ParamsConvertUtil.formatEaiParamsItems(paramsConvertDto, 2);
        EaiParamsItems body = paramsConvertDto.getBody();
        return ParamsConvertUtil.transForm(header, query, body, autoTransForm);
    }

    private static List<EaiParamsItems> transForm(List<EaiParamsItems> header, List<EaiParamsItems> query, EaiParamsItems body, boolean autoTransForm) {
        if (ParamsConvertUtil.isNotDistinct(header) || ParamsConvertUtil.isNotDistinct(query) || HussarUtils.isNotEmpty((Object)body) && ParamsConvertUtil.isNotDistinct(body.getItems())) {
            throw new BaseException(ERROR_MSG);
        }
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        if (header != null) {
            result.addAll(header);
        }
        if (query != null) {
            result.addAll(query);
        }
        if (autoTransForm) {
            ArrayList keys = new ArrayList();
            result.forEach(eaiParamsItems -> {
                String name = eaiParamsItems.getName();
                if (keys.contains(name)) {
                    String newName = name + eaiParamsItems.getMapping();
                    eaiParamsItems.setMappingName(name + eaiParamsItems.getMapping());
                    keys.add(newName);
                } else {
                    eaiParamsItems.setMappingName(name);
                    keys.add(name);
                }
            });
            keys.clear();
        }
        if (body != null) {
            body.setMapping(1);
            result.add(body);
        }
        return result;
    }

    public static boolean isNotDistinct(List<EaiParamsItems> paramsItems) {
        return !ParamsConvertUtil.isDistinct(paramsItems);
    }

    public static boolean isDistinct(List<EaiParamsItems> paramsItems) {
        List newParams;
        return !HussarUtils.isNotEmpty(paramsItems) || (newParams = paramsItems.stream().distinct().collect(Collectors.toList())).size() == paramsItems.size();
    }

    public static String toEaiParamsItemsStr(EaiParamsConvertDto paramsConvertDto, Integer type, boolean autoTransForm) {
        switch (type) {
            case 0: {
                return ParamsConvertUtil.toJSONString(ParamsConvertUtil.toEaiParamsItems(paramsConvertDto, autoTransForm));
            }
            case 2: {
                return ParamsConvertUtil.toJSONString(paramsConvertDto);
            }
        }
        return null;
    }

    public static List<EaiParamsItems> toEaiParamsItems(String eaiParamsItems) {
        EaiParamsConvertDto eaiParamsConvertDto = ParamsConvertUtil.toEaiParamsConvertDto(eaiParamsItems);
        return ParamsConvertUtil.toEaiParamsItems(eaiParamsConvertDto, false);
    }

    public static Map<String, Object> convertEaiApiParams(EaiApiParams eaiApiParams) {
        if (HussarUtils.isEmpty((Object)eaiApiParams)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HEADER_STR, eaiApiParams.getHeader());
        map.put(QUERY_STR, eaiApiParams.getQuery());
        map.put(BODY_STR, eaiApiParams.getBody());
        return map;
    }

    private static String convertSchemaType(Integer type) {
        return EaiDataType.getEaiDataType(type).getCode().toLowerCase();
    }

    private static void stringRecursion(List<EaiParamsItems> paramsItems, StringBuffer sb, boolean chideren) {
        paramsItems.forEach(param -> {
            if (chideren) {
                sb.append(BRACE);
            }
            sb.append(DOUBLE_MARK).append(param.getMappingName()).append(DOUBLE_MARK).append(COLON).append(BRACE).append(DOUBLE_MARK).append(TYPE).append(DOUBLE_MARK).append(COLON).append(DOUBLE_MARK).append(ParamsConvertUtil.convertSchemaType(param.getType())).append(DOUBLE_MARK);
            List<EaiParamsItems> list = param.getItems();
            if (HussarUtils.isNotEmpty(list)) {
                sb.append(DOUBLE_MARK).append(ITEMS).append(DOUBLE_MARK).append(COLON).append(MID);
                ParamsConvertUtil.stringRecursion(list, sb, true);
                if (COMMA.equals(String.valueOf(sb.charAt(sb.length() - 1)))) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append(MID_OPPOSITE);
            }
            if (chideren) {
                sb.append(BRACE_OPPOSITE);
            }
            sb.append(BRACE_OPPOSITE).append(COMMA);
        });
    }

    public static String toJsonSchemaStr(String str) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(SCHEMA_START);
        EaiParamsConvertDto eaiParamsConvertDto = ParamsConvertUtil.toEaiParamsConvertDto(str);
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            EaiParamsItems body;
            List<EaiParamsItems> query;
            List<EaiParamsItems> headers = eaiParamsConvertDto.getHeader();
            if (HussarUtils.isNotEmpty(headers)) {
                ParamsConvertUtil.stringRecursion(headers, sb, false);
            }
            if (HussarUtils.isNotEmpty(query = eaiParamsConvertDto.getQuery())) {
                ParamsConvertUtil.stringRecursion(query, sb, false);
            }
            if (HussarUtils.isNotEmpty((Object)(body = eaiParamsConvertDto.getBody()))) {
                sb.append(DOUBLE_MARK).append(body.getMappingName()).append(DOUBLE_MARK).append(COLON).append(BRACE).append(DOUBLE_MARK).append(TYPE).append(DOUBLE_MARK).append(COLON).append(DOUBLE_MARK).append(ParamsConvertUtil.convertSchemaType(body.getType())).append(DOUBLE_MARK);
                List<EaiParamsItems> bodyItems = body.getItems();
                if (HussarUtils.isNotEmpty(bodyItems)) {
                    sb.append(COMMA).append(DOUBLE_MARK).append(ITEMS).append(DOUBLE_MARK).append(COLON).append(MID);
                    ParamsConvertUtil.stringRecursion(bodyItems, sb, true);
                    if (COMMA.equals(String.valueOf(sb.charAt(sb.length() - 1)))) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append(MID_OPPOSITE);
                }
                sb.append(BRACE_OPPOSITE);
            }
        }
        sb.append(BRACE_OPPOSITE).append(BRACE_OPPOSITE);
        return sb.toString();
    }

    public static Object parseResult(Object params, String mappings) {
        if (HussarUtils.isEmpty((Object)params)) {
            return params;
        }
        try {
            JSONObject mappingParams = JSON.parseArray((String)mappings).getJSONObject(0);
            if (EaiDataType.DATA_TYPE_LIST.getType() == mappingParams.getIntValue(TYPE)) {
                JSONArray array = JSONObject.parseArray((String)JSON.toJSONString((Object)params));
                ArrayList result = new ArrayList(array.size());
                array.forEach(arr -> {
                    JSONObject item = mappingParams.getJSONArray(ITEMS).getJSONObject(0);
                    if (EaiDataType.DATA_TYPE_LIST.getType() != item.getIntValue(TYPE) && EaiDataType.DATA_TYPE_STRUCTURE.getType() != item.getIntValue(TYPE)) {
                        result.add(arr);
                    } else {
                        result.add(ParamsConvertUtil.formartBodyResult(arr, item.getString(ITEMS)));
                    }
                });
                return result;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == mappingParams.getIntValue(TYPE)) {
                Object obj = ParamsConvertUtil.formartBodyResult(params, mappingParams.getString(ITEMS));
                return obj;
            }
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                throw new BaseException(HussarUtils.isEmpty((Object)e.getMessage()) ? "\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25" : e.getMessage());
            }
            throw new BaseException("\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25");
        }
        throw new BaseException("\u65e0\u6cd5\u89e3\u6790\u51fa\u53c2\u7ed3\u6784\u7c7b\u578b,\u51fa\u53c2\u7ed3\u6784\u53ea\u80fd\u662fLIST\u6216STRUCTURE");
    }

    public static Object formartBodyResult(Object params, String mappingParams) {
        if (HussarUtils.isEmpty((Object)params)) {
            return new EaiApiParams();
        }
        List realParams = JSON.parseArray((String)mappingParams, EaiParamsItems.class);
        String paramsStr = null;
        try {
            paramsStr = params instanceof CharSequence ? String.valueOf(params) : JSON.toJSONString((Object)params);
        }
        catch (Exception e) {
            throw new BaseException("\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u683c\u5f0f");
        }
        return ParamsConvertUtil.filResult(realParams, paramsStr);
    }

    private static Object filResult(List<EaiParamsItems> realParams, String paramsStr) {
        JSONObject jsonObject = JSON.parseObject((String)paramsStr);
        Iterator keys = jsonObject.keySet().iterator();
        HashMap<String, Object> map = new HashMap<String, Object>();
        block0: while (keys.hasNext()) {
            Object[] body = new Object[1];
            String key = (String)keys.next();
            ParamsConvertUtil.filObj(key, jsonObject, realParams, body);
            if (!HussarUtils.isNotEmpty((Object)body[0])) continue;
            for (EaiParamsItems realParam : realParams) {
                if (!key.equals(realParam.getName())) continue;
                map.put(realParam.getMappingName(), body[0]);
                continue block0;
            }
        }
        return map;
    }

    private static void filObj(String key, JSONObject jsonObject, List<EaiParamsItems> realParams, Object[] body) {
        for (EaiParamsItems paramsItem : realParams) {
            if (!paramsItem.getName().equals(key)) continue;
            if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) break;
            List<EaiParamsItems> bodyList = paramsItem.getItems();
            if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                bodyList = bodyList.get(0).getItems();
                JSONArray obj = jsonObject.getJSONArray(key);
                if (HussarUtils.isNotEmpty((Object)obj) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(obj.size());
                    ParamsConvertUtil.bodyListArray(obj, bodyList, list, true);
                    body[0] = list;
                    break;
                }
                body[0] = obj;
                break;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue()) {
                JSONObject obj = jsonObject.getJSONObject(key);
                if (!HussarUtils.isNotEmpty((Object)obj)) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                ParamsConvertUtil.bodyListMap(obj, bodyList, map, true);
                body[0] = map;
                break;
            }
            body[0] = jsonObject.get((Object)key);
            break;
        }
    }

    public static EaiApiParams oEaiParamsItems(Object params, String mappingParams) {
        if (HussarUtils.isEmpty((Object)params)) {
            return new EaiApiParams();
        }
        String paramsStr = null;
        paramsStr = params instanceof CharSequence ? String.valueOf(params) : JSON.toJSONString((Object)params);
        EaiApiParams eaiApiParams = new EaiApiParams();
        JSONObject jsonObject = JSON.parseObject((String)paramsStr);
        Iterator keys = jsonObject.keySet().iterator();
        List<EaiParamsItems> realParams = ParamsConvertUtil.toEaiParamsItems(mappingParams);
        HashMap<String, Object> header = new HashMap<String, Object>();
        HashMap<String, Object> query = new HashMap<String, Object>();
        Object[] body = new Object[1];
        block5: while (keys.hasNext()) {
            String key = (String)keys.next();
            for (EaiParamsItems paramsItem : realParams) {
                boolean finished = false;
                Integer mapKey = paramsItem.getMapping();
                if (paramsItem.getMappingName().equals(key)) {
                    switch (mapKey) {
                        case 0: {
                            if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) break;
                            header.put(paramsItem.getName(), jsonObject.get((Object)key));
                            break;
                        }
                        case 2: {
                            if (!HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) break;
                            query.put(paramsItem.getName(), jsonObject.get((Object)key));
                            break;
                        }
                        case 1: {
                            if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)key))) {
                                JSONArray obj;
                                List<EaiParamsItems> bodyList = paramsItem.getItems();
                                if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItem.getType().intValue()) {
                                    bodyList = bodyList.get(0).getItems();
                                    obj = jsonObject.getJSONArray(key);
                                    if (HussarUtils.isNotEmpty((Object)obj) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getItemType().intValue()) {
                                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(obj.size());
                                        ParamsConvertUtil.bodyListArray(obj, bodyList, list, false);
                                        body[0] = list;
                                        break;
                                    }
                                    body[0] = obj;
                                }
                                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItem.getType().intValue() && HussarUtils.isNotEmpty((Object)(obj = jsonObject.getJSONObject(key)))) {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    ParamsConvertUtil.bodyListMap((JSONObject)obj, bodyList, map, false);
                                    body[0] = map;
                                    break;
                                }
                            }
                            body[0] = jsonObject.get((Object)key);
                            break;
                        }
                    }
                    finished = true;
                }
                if (!finished) continue;
                continue block5;
            }
        }
        eaiApiParams.setHeader(header);
        eaiApiParams.setQuery(query);
        eaiApiParams.setBody(body[0]);
        return eaiApiParams;
    }

    private static void bodyListMap(JSONObject obj, List<EaiParamsItems> bodyList, Map<String, Object> map, boolean result) {
        obj.forEach((k, v) -> {
            for (EaiParamsItems paramsItems : bodyList) {
                String name = paramsItems.getMappingName();
                if (result) {
                    name = paramsItems.getName();
                }
                if (!k.equals(name)) continue;
                ParamsConvertUtil.bodyCommon(k, v, paramsItems, map, result);
            }
        });
    }

    private static void bodyCommon(String k, Object v, EaiParamsItems paramsItems, Map<String, Object> map, boolean result) {
        if (EaiDataType.DATA_TYPE_LIST.getType() == paramsItems.getType().intValue()) {
            if (HussarUtils.isNotEmpty((Object)v)) {
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue()) {
                    ArrayList<Map<String, Object>> child = new ArrayList<Map<String, Object>>();
                    List<EaiParamsItems> bodyList = paramsItems.getItems().get(0).getItems();
                    ParamsConvertUtil.bodyListArray(JSONObject.parseArray((String)JSON.toJSONString((Object)v)), bodyList, child, result);
                    if (!result) {
                        map.put(paramsItems.getName(), child);
                    } else {
                        map.put(paramsItems.getMappingName(), child);
                    }
                } else if (!result) {
                    map.put(paramsItems.getName(), v);
                } else {
                    map.put(paramsItems.getMappingName(), v);
                }
                return;
            }
        } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue() && HussarUtils.isNotEmpty((Object)v)) {
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            if (v instanceof JSONArray) {
                ((JSONArray)v).forEach(item -> ParamsConvertUtil.bodyListMap(JSONObject.parseObject((String)JSON.toJSONString((Object)item)), paramsItems.getItems(), childMap, result));
            } else {
                ParamsConvertUtil.bodyListMap(JSONObject.parseObject((String)JSON.toJSONString((Object)v)), paramsItems.getItems(), childMap, result);
            }
            if (!result) {
                map.put(paramsItems.getName(), childMap);
            } else {
                map.put(paramsItems.getMappingName(), childMap);
            }
            return;
        }
        if (!result) {
            map.put(paramsItems.getName(), v);
        } else {
            map.put(paramsItems.getMappingName(), v);
        }
    }

    private static void bodyListArray(JSONArray obj, List<EaiParamsItems> bodyList, List<Map<String, Object>> list, boolean result) {
        for (Object object : obj) {
            HashMap map = new HashMap();
            JSONObject realChild = JSONObject.parseObject((String)JSON.toJSONString(object));
            realChild.forEach((k, v) -> {
                for (EaiParamsItems paramsItems : bodyList) {
                    String name = paramsItems.getMappingName();
                    if (result) {
                        name = paramsItems.getName();
                    }
                    if (!k.equals(name)) continue;
                    ParamsConvertUtil.bodyCommon(k, v, paramsItems, map, result);
                }
            });
            list.add(map);
        }
    }

    public static EaiParamsConvertDto toEaiParamsConvertDto(String eaiParamsItems) {
        if (HussarUtils.isEmpty((Object)eaiParamsItems)) {
            return null;
        }
        if (eaiParamsItems.startsWith(BRACE)) {
            try {
                return (EaiParamsConvertDto)JSON.parseObject((String)eaiParamsItems, EaiParamsConvertDto.class);
            }
            catch (Exception e) {
                throw new BaseException(TRANS_ERROR_MSG);
            }
        }
        JSONArray array = JSON.parseArray((String)eaiParamsItems);
        ArrayList<EaiParamsItems> header = new ArrayList<EaiParamsItems>();
        ArrayList<EaiParamsItems> query = new ArrayList<EaiParamsItems>();
        EaiParamsConvertDto result = new EaiParamsConvertDto();
        array.forEach(obj -> {
            EaiParamsItems paramsItems = (EaiParamsItems)JSON.parseObject((String)JSONObject.toJSONString((Object)obj), EaiParamsItems.class);
            Integer map = paramsItems.getMapping();
            if (!HussarUtils.isEmpty((Object)map)) {
                switch (map) {
                    case 0: {
                        header.add(paramsItems);
                        break;
                    }
                    case 2: {
                        query.add(paramsItems);
                        break;
                    }
                    case 1: {
                        result.setBody(paramsItems);
                        break;
                    }
                }
            }
        });
        if (HussarUtils.isNotEmpty(header)) {
            result.setHeader(header);
        }
        if (HussarUtils.isNotEmpty(query)) {
            result.setQuery(query);
        }
        return result;
    }

    public static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    private static List<EaiParamsItems> formatEaiParamsItems(EaiParamsConvertDto eaiParamsConvertDto, int pos) {
        if (HussarUtils.isNotEmpty((Object)eaiParamsConvertDto)) {
            switch (pos) {
                case 0: {
                    List<EaiParamsItems> header = eaiParamsConvertDto.getHeader();
                    return ParamsConvertUtil.geEaiParamsItemsList(header, 0);
                }
                case 2: {
                    List<EaiParamsItems> query = eaiParamsConvertDto.getQuery();
                    return ParamsConvertUtil.geEaiParamsItemsList(query, 2);
                }
            }
        }
        return null;
    }

    private static List<EaiParamsItems> geEaiParamsItemsList(List<EaiParamsItems> list, int mapping) {
        if (HussarUtils.isNotEmpty(list)) {
            list.forEach(eaiParamsItems -> eaiParamsItems.setMapping(mapping));
            return list;
        }
        return null;
    }

    public static EaiOutParamDto toEaiOutParamDtoDto(String eaiParamsItems) {
        if (HussarUtils.isEmpty((Object)eaiParamsItems)) {
            return null;
        }
        if (eaiParamsItems.startsWith(BRACE)) {
            try {
                return (EaiOutParamDto)JSON.parseObject((String)eaiParamsItems, EaiOutParamDto.class);
            }
            catch (Exception e) {
                throw new BaseException(TRANS_ERROR_MSG);
            }
        }
        JSONArray array = JSON.parseArray((String)eaiParamsItems);
        ArrayList<EaiParamsItems> body = new ArrayList<EaiParamsItems>();
        EaiOutParamDto result = new EaiOutParamDto();
        array.forEach(obj -> {
            EaiParamsItems paramsItems = (EaiParamsItems)JSON.parseObject((String)JSONObject.toJSONString((Object)obj), EaiParamsItems.class);
            body.add(paramsItems);
        });
        if (HussarUtils.isNotEmpty(body)) {
            result.setBody(body);
        }
        return result;
    }
}

