/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.common.constant.logic;

import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class EaiLogicConstant {
    public static final String PACKAGE_PREFIX = "com.jxdinfo.hussar.eai.generated";
    public static final String APP_PREFIX = "app_";
    public static final String TYPE_OPEN = "open";
    public static final String TYPE_INTEGRATION = "integration";
    public static final String DEBUG = "debug";
    public static final String CACHE_NAME = "eai:logic:generate";

    public static final String getOpenPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code) {
        return EaiLogicConstant.getOpenPackageName(appCode, resourcesEnum, code, null);
    }

    public static final String getOpenPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code, String version) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(code.charAt(0))).append(code.substring(1));
        if (HussarUtils.isEmpty((Object)version)) {
            return String.format("%s.%s.%s%s.%s.%s", PACKAGE_PREFIX, TYPE_OPEN, APP_PREFIX, appCode, resourcesEnum.getType(), builder.toString());
        }
        return String.format("%s.%s.%s%s.%s.%s.%s", PACKAGE_PREFIX, TYPE_OPEN, APP_PREFIX, appCode, version, resourcesEnum.getType(), builder.toString());
    }

    public static final String getIntegrationPackageName(String appCode, EaiResourcesEnum resourcesEnum, String code) {
        StringBuilder builder = new StringBuilder();
        builder.append(Character.toUpperCase(code.charAt(0))).append(code.substring(1));
        return String.format("%s.%s.%s%s.%s.%s", PACKAGE_PREFIX, TYPE_INTEGRATION, APP_PREFIX, appCode, resourcesEnum.getType(), builder.toString());
    }

    public static final String getAppName(String appCode) {
        return String.format("%s%s", APP_PREFIX, appCode);
    }

    public static final String getNameSpace(String className) {
        className = className.substring(0, className.lastIndexOf("."));
        return className.substring(0, className.lastIndexOf("."));
    }

    public static String getType(String className) {
        return className.substring(PACKAGE_PREFIX.length() + 1).split("\\.")[2];
    }

    public static String getCategory(String className) {
        return className.substring(PACKAGE_PREFIX.length() + 1).split("\\.")[0];
    }

    public static String getCategoryByClassify(String classify) {
        if ("0".equals(classify)) {
            return TYPE_OPEN;
        }
        return TYPE_INTEGRATION;
    }
}

